
#define PATH_MAX 256
#define COMPANY_NAME "GCS ZIP module by Info-ZIP\0"

#define WINDLL 1
#include "zip\api.h"
#include "unzip\unzip.h"

extern "C" {
	// UNZIP DLL Exports
	typedef int (WINAPI * _DLL_UNZIP)(int, char **, int, char **, LPDCL, LPUSERFUNCTIONS);
	typedef int (WINAPI * _USER_FUNCTIONS)(LPUSERFUNCTIONS);
	typedef BOOL (WINAPI * _DLL_UNZVAL)(char *, int);

	// ZIP DLL Exports
	typedef int (WINAPI * _ZIP_USER_FUNCTIONS)(LPZIPUSERFUNCTIONS);
	typedef int (WINAPI * _DLL_ZIP)(LPZCL);
	typedef BOOL (WINAPI * ZIPSETOPTIONS)(LPZPOPT);
	typedef LPZPOPT (WINAPI * ZIPGETOPTIONS)(void);


	extern _DLL_UNZVAL Unz_Validate;
	extern _DLL_UNZIP Unz_SingleEntryPoint;
	extern _DLL_UNZIP windll_unzip;
	extern _USER_FUNCTIONS UzInit;
	extern HINSTANCE hUnzipDll;

	extern _ZIP_USER_FUNCTIONS ZipInit;
	extern _DLL_ZIP ZipArchive;
	extern ZIPSETOPTIONS ZipSetOptions;
	extern ZIPGETOPTIONS ZipGetOptions;
	extern HINSTANCE hZipDll;
	extern LPZIPUSERFUNCTIONS lpZipUserFunctions;
	extern LPUSERFUNCTIONS lpUserFunctions;
	extern HANDLE hZUF;
	extern HANDLE hUF;

	extern char zipPassword[64];
	extern char unzipPassword[64];
	extern LPSTR pPassword;
	extern vector<ArchiveEntry> *vecIntArchiveEntry;


}

BOOL GCS_CLASS_DECL LoadZipDLL(BOOL bUnzip, LPCSTR lpcstrPath);
