
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>

/* defined here so can be included in y.tab.h (for bison) */
#define YYSTYPE id

#define FAB_FILENAME_MAX 1024

#include <Object.h>
#include <ordcltn.h>

#include <octext.h>
#include <ocstring.h>
#include <txtattr.h>
#include <txtstyle.h>
#include <paragrph.h>

void writehtml(id paragraphs);
void writenroff(id paragraphs);
void writeascii(id paragraphs);
void writertf(id paragraphs);

/******************************************************************************
 *
 * Global Variables
 * 
 *****************************************************************************/

extern id    fab;
extern id    substitutions;
extern STR   doSubs(STR value,int *len);
extern id    fabmethodsummary;
extern id    fabMethodType;
extern BOOL  fabtestmode;
extern FILE *fabfopen(const char *name,const char *type);
extern FILE *fabfreopen(const char *name,const char *type,FILE *s);

/******************************************************************************
 *
 * fab
 * 
 *****************************************************************************/

@interface Fabricator : Object
{
    id		filenames;
    id		rootnames;
    id		searchpath;
    STR		headerdir;
    STR		sourcedir;
    STR		publicheaderdir;
    STR		publicsourcedir;
    STR		mandir;
    STR		htmldir;
    STR		asciidir;
    STR		rtfdir;
}

+ new;
- addfile:(STR)string;
- addsearchpath:(STR)dir;
- setheaderdir:(STR)string;
- setsourcedir:(STR)string;
- setpublicheaderdir:(STR)string;
- setpublicsourcedir:(STR)string;
- sethtmldir:(STR)string;
- setrtfdir:(STR)string;
- setasciidir:(STR)string;
- setmandir:(STR)string;
- run;

- (STR)searchfile:(STR)string;

@end

/******************************************************************************
 *
 * Fabobject : Root Object of Fab
 * 
 *****************************************************************************/

@interface Fabobject : Object
{
    id object;
    struct { BOOL public;BOOL test; } flags;
}
+ object:anObject;
- settest:(BOOL)flag;
- setpublic:(BOOL)flag;
- dumpheader:(FILE *)f;
- dumpsource:(FILE *)f;
- dumppublicheader:(FILE *)f;
- dumppublicsource:(FILE *)f;
- dumpdepend:(FILE *)f;

- include;
- makepublicsummary;

@end

@interface Fablist : OrdCltn
{
}

- dumpheader:(FILE *)f;
- dumpsource:(FILE *)f;
- dumpdepend:(FILE *)f;

- paragraphs:aCltn;
- allparagraphs:aCltn;
- summaryparagraphs:aCltn;
- asText;
- nameAsText;
- asText:text;
- nameAsText:text;
- asSummaryText;

@end

/******************************************************************************
 *
 * Fabstring : private String object for portability
 * 
 *****************************************************************************/

typedef enum { ROMAN=0,BOLD,ITALIC,COURIER,SWISS } TYPEFACE;

@interface Fabstring : Fabobject
{
    STR			value;
    STR			filename;
    int			lineno;
    TYPEFACE		attribute;
}

+ str:(STR)string;
+ chars:(STR)chars count:(int)numChars;
+ chars:(STR)chars count:(int)numChars filename:(STR)string lineno:(int)no;
- (BOOL)isEqual:b;
- (STR)str;
- settypeface:(TYPEFACE)anAttribute;
- print:(FILE *)f;
- dumpsource:(FILE *)f;
- dumppublicsource:(FILE *)f;
- asText;
- asText:text;
@end

/******************************************************************************
 *
 * Prettystring : list of strings with typefaces
 * 
 *****************************************************************************/

@interface Prettystring : Fablist {}
@end

/******************************************************************************
 *
 * Test : control test mode
 * 
 *****************************************************************************/

@interface Test : Fabobject { BOOL start; }
+ start;
+ end;
- dumpheader:(FILE *)f;
- dumpsource:(FILE *)f;
@end

/******************************************************************************
 *
 * Copyright : prints a copyright message
 * 
 *****************************************************************************/

@interface Copyright : Fabobject {}
- dumpheader:(FILE *)f;
- dumpsource:(FILE *)f;
@end

/******************************************************************************
 *
 * Source : piece of literal source file
 * 
 *****************************************************************************/

@interface Source : Fabobject {}
- dumpsource:(FILE *)f;
@end

/******************************************************************************
 *
 * Header : piece of literal header
 * 
 *****************************************************************************/

@interface Header : Fabobject {}
- dumpheader:(FILE *)f;
@end

/******************************************************************************
 *
 * All : piece of literal header & source
 * 
 *****************************************************************************/

@interface All : Fabobject {}
- dumpsource:(FILE *)f;
- dumpheader:(FILE *)f;
@end

/******************************************************************************
 *
 * Example : example for documentation
 * 
 *****************************************************************************/

@interface Example : Fabobject {}
@end

/******************************************************************************
 *
 * Doc : paragraph of documentation
 * 
 *****************************************************************************/

@interface Doc : Fabobject {}
@end

/******************************************************************************
 *
 * Doc : paragraph of documentation
 * 
 *****************************************************************************/

@interface Dotlist : Fabobject { id dots; }
+ object:anObject;
- add:anObject;
@end

/******************************************************************************
 *
 * SubTitle : subtitle in documentation
 * 
 *****************************************************************************/

@interface Subtitle : Fabobject {}
@end

/******************************************************************************
 *
 * Note : note in documentation
 * 
 *****************************************************************************/

@interface Note : Fabobject {}
@end

/******************************************************************************
 *
 * MaturityIndex : maturity index of object
 * 
 *****************************************************************************/

@interface MaturityIndex : Fabobject {}
@end

/******************************************************************************
 *
 * Seealso : see also reference in documentation
 * 
 *****************************************************************************/

@interface Seealso : Fabobject {}
@end

/******************************************************************************
 *
 * Fabclass : name of class, of superclass and block of ivar declaration
 * 
 *****************************************************************************/

@interface Fabclass : Fabobject
{
    id	cname,sname,ivars,maturity;
}
+ name:aname supername:bname ivars:block maturity:mindex;
- dumpsource:(FILE *)f;
- dumpheader:(FILE *)f;
@end

/******************************************************************************
 *
 * Summary : Summary of methods; MethodType : list of methods
 * 
 *****************************************************************************/

@interface Methodsummary : Fabobject
{
    id	types;
}
+ new;
- add:anObject;
@end

@interface Methodtype : Fabobject
{
    id	methods;
}
+ object:anObject;
- add:anObject;
@end

/******************************************************************************
 *
 * Methodatom
 * 
 *****************************************************************************/

@interface Methodatom : Fabobject
{
    id	name;		/* can be nil */
    id	type;		/* can be nil */
    id	var;
}

+ name:n type:t var:v;
- print:(FILE *)f;

@end

/******************************************************************************
 *
 * Method
 * 
 *****************************************************************************/

@interface Method : Fabobject
{
    id type;	/* can be nil */
    id atoms;
    BOOL isclass;
    int anchor;
}

+ type:t atoms:list;
- setisclass:(BOOL)flag;

- dumpsource:(FILE *)f;
- dumpheader:(FILE *)f;

@end

/******************************************************************************
 *
 * Unit : the entire file
 * 
 *****************************************************************************/

@interface Unit : Fabobject
{
    STR		filename;
    STR		rootname;
    id		list;
}

+ name:(STR)filename:(STR)rootname;

@end

/******************************************************************************
 *
 * Include
 * 
 *****************************************************************************/

@interface Definition : Fabobject
{
    id key,value;
}

+ new:aKey as:aValue;
- value;
- key;
- substitute;

@end

@interface Include : Fabobject
{
    id  deflist;
    id	list;
    id  subs;
}

+ object:anObject deflist:dList;
- include;
- dumpdepend:(FILE *)f;

@end

