/************************************************************

	class CISImage

	For ImgSource v2.x !!!

	This is a wrapper class for the ISrc(ISource functions. As only
	a few of the ISrc(ISource functions are used, it is intended 
	to be used as a starting point for more complex classes.

	Sample use (load a BMP, reduce by 1/2, save as JPG) :

		CISImage image;
		image.LoadFromFile("C:\\input.bmp");

		CSize csSize = image.GetSize();
		csSize.cx/=2; csSize.cy/=2;
		image.Resize(csSize);

		image.SaveToFile("C:\\output.jpg", eFmtJPG);


	This class may be used without restriction.

	ISource and CISImage are copyright 2000, Smaller Animals Software.

	All questions to : smallest@smalleranimals.com

************************************************************/

// ISImage.h: interface for the CISImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ISIMAGE_H__6B6EFAD2_FC02_11D2_A085_00500402F30B__INCLUDED_)
#define AFX_ISIMAGE_H__6B6EFAD2_FC02_11D2_A085_00500402F30B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// to use this with the static library version of ISource,
// comment out this line :
#define _ISDLL

// get the right #include
#ifdef _ISDLL
#include "_ISource.h"
#else
#include "ISource.h"
#endif

/*-------------------------------------------------------------
   define our little preprocessor trick.
   this will fix up the ISource function names so that 
   we can easily use this class with the ImgSource DLL or the
   ImgSource static libraries.

   ex.
   when you see this : 
   UINT32 uType = ISrc(ISGuessFileType)(hSource);

   the actual code that your compiler will see is either :

   UINT32 uType = _ISGuessFileType(hSource);

    or

   UINT32 uType = ISGuessFileType(hSource);

-------------------------------------------------------------*/
#ifdef _ISDLL
// the expression _##fn is translated to _fn by the preprocessor
#define ISrc(fn) _##fn      
#else
#define ISrc(fn) fn
#endif


// these definitions simplify the demo app. 
// you should change these to fit what your users will want
// ie. make them into variables and let your users adjust them.
#define DEF_METAFILE_WIDTH    100
#define DEF_METAFILE_HEIGHT   100
#define DEF_METAFILE_BACKGROUND  RGB(128,128,128)  // gray

#define DEF_JPG_QUALITY       75    // decent quality

#define DEF_PNG_GAMMA         0.0

#define DEF_DPIX              96
#define DEF_DPIY              96

#define CMTOINCH( x ) ( (int)((double)(x) * 0.39370079) )

///////////////////////////////////////////////////////////////
// here's the interface

class CISImage  
{

public:
   typedef enum eFormat {
               eFmtNone,
					eFmtJPG,
					eFmtJPGGray,
					eFmtPNG,
					eFmtPNG8,
					eFmtPNG8Gray,
					eFmtBMP,
					eFmtBMP8,
					eFmtBMP8Gray,
					eFmtPCX,
					eFmtPCX8,
					eFmtPCX8Gray,
					eFmtTIF,
					eFmtTIF8,
					eFmtTIF8Gray,
					eFmtGIF,
					eFmtTGA,
					eFmtTGA8,
					eFmtTGA8Gray,
					eFmtWMF,
					eFmtPSD,
					eFmtPSD8,
					eFmtPSD8Gray,
					eFmtEMF,
					eFmtWBMP

				};
 
public:

	CISImage();
	virtual ~CISImage();

   // get an error string from the ISource error code
   static   CString     ErrorString(UINT32 uRes);

   // guess file type from header bytes
   static   eFormat     GuessFileTypeFile(const char *pFileName);
   static   eFormat     GuessFileTypeMemory(const BYTE *pMem, const UINT32 uBufLen);
   static   eFormat     GuessFileTypeFromExtension(const char *pFileName);

   // clear the image
   UINT32      Clear();

   // create a blank (black) image
   UINT32      AllocateBlank(const CSize &czPix);

   // copy a CISImage to this
   UINT32      Copy(CISImage &imgSource);

   // copy a resized version of a CISImage to this
   UINT32      CopyResized(const CSize &czPix, CISImage &imgSource);

   // create an HBITMAP and attach it to the input CBitmap
   UINT32      CopyToCBitmap(CBitmap &cBmp, HPALETTE hPal);

   // load files
   UINT32      LoadFromFile(const char *pFileName);
   UINT32      LoadFromFile(const char *pFileName, eFormat eFmt);
   UINT32      LoadFromMemory(const BYTE *pMem, const UINT32 uBufLen, eFormat eFmt);
   UINT32      LoadFromMemory(const BYTE *pMem, const UINT32 uBufLen);

   // save files
   UINT32      SaveToFile(const char *pFileName, const eFormat eFmt);
   UINT32      SaveToMemory(BYTE *pMem, const UINT32 uBufLen, const eFormat eFmt);

   // if you need to get to the RGB data
   BYTE *      GetImagePointer();

   // call this when you're done with the pointer from GetImagePointer
   UINT32      ReleaseImagePointer();

   // various drawing functions
   UINT32      DrawCrop(const CDC *pDC, const CPoint &ptTopLeft, const CRect &displayRect, const HPALETTE hPal);
   UINT32      Draw(const CDC *pDC, const CPoint &ptTopLeft, const HPALETTE hPal);
   UINT32      StretchDraw(const CDC *pDC, const CRect & outRect);

   // resize this
   UINT32      Resize(const CSize &czPix);
   
   // flip this
   UINT32      VerticalFlip();
   UINT32      HorizontalFlip();

   // image size in pixels
   _inline CSize        GetSize() const            {return m_czPix;}    

   // DPI this image was saved at
   _inline CSize        GetDPI() const             {return m_czDPI;}

   // get a handle to the image's CPalette
   _inline CPalette *   GetImagePalette()    		{return &m_imagePal;}

   // does this have any image data?
   _inline BOOL         IsValid()                  {return m_hRGB!=NULL;};

   // generate a palette of 256 RGBQUADs
   UINT32      GetPalette(RGBQUAD *pPal);

protected:
   UINT32      LoadFile(const HISSRC hSource, const eFormat eFmt);
   UINT32      SaveImage(HISDEST hDest, eFormat eFmt);
   UINT32      Save8Bit(HISDEST hDest, eFormat eFmt);

   void        CalcDPI(eFormat eFmt, UINT32 dx, UINT32 dy, UINT32 u);

   void        MakeImagePalette();

   CString     HexString(BYTE *pData, UINT32 uDataLen);

protected:
   CSize       m_czPix;
   CSize       m_czDPI;
   HGLOBAL     m_hRGB;
	UINT32      m_uReferenceCount;

  	CPalette		m_imagePal;
};

#endif // !defined(AFX_ISIMAGE_H__6B6EFAD2_FC02_11D2_A085_00500402F30B__INCLUDED_)
