/*
 *    File sform.cpp
 *      Demonstrates the use of the SCROLLEDFORM Object
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

class CaSForm : public CmCallback {
	CmShell *shell;
	CmPixmap *pixmap;
public:
	CaSForm(void);
	virtual ~CaSForm(void) { delete shell;}
	void closeDialog(void) { delete this; };
	void newImage(void);
	void printImage(void);
};

#ifdef WIN_MGUI

void CaSForm::printImage(void)
{
    MPRINT_OPTIONS po;
    DOC_ID did;

    did = MOpenPrintDoc("Print Test", False, PO_PORTRAIT, NULL);
    if (did == NULL)
    {
	MMessageDialog("Error", "Cannot create\na print document", "Ok", NULL);
	return;
    }
    po.mode = PM_PERC;
    po.x = -1;
    po.y = -1;
    po.w = 50;
    po.h = -1;
    shell->print(did, &po);
    po.y += 300;
    MClosePrintDoc(did);
}

#endif

/**********************************************************
 *	This callback changes the image viewed
 **********************************************************/
void CaSForm::newImage(void)
{
    char fname[128], dirname[128], filter[32];

    strcpy(dirname, MGetSysDir());
    fname[0] = '\0';
    strcpy(filter, "*.bmp");
    if (MFileSelection("Select New Image", filter, fname, dirname, True))
    {
	strcat(dirname, fname);
	pixmap->setImage(dirname);
    }
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
CaSForm::CaSForm(void)
{
    CmForm *form, *sform;
    CmSFile *sfile;
    CmPushButton *pb;

    shell = new CmShell("Test Scrolled Form", SF_NO_CLOSE | SF_NO_MAXIMIZE);

    form = new CmColForm(shell);
	form->setBackgroundImageFile("tile1.bmp", BI_TILED);

    sform = new CmScrolledRowForm(form, 200, 250);
	sform->setBackgroundImageFile("tile3.bmp", BI_TILED);

    new CmLabel(sform, "Label inside the scrolled form", TIMES_MEDIUM);
    pixmap = new CmPixmap(sform, "paulina1.bmp");

    sfile = new CmSFile(form, __FILE__, FIXED_MEDIUM, 10, 50);
    sfile->setColor(darkblue, white);

    form = new CmColForm(shell);

    pb = new CmPushButton(form, "New Image", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaSForm::newImage);

#ifdef WIN_MGUI
    pb = new CmPushButton(form, "Print Image", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaSForm::printImage);
#endif
    pb = new CmPushButton(form, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaSForm::closeDialog);

    shell->realize();
}

void SFormDemo(void)
{
	new CaSForm;
}
