//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
//                 http://www.charybdis.com/products/mythos.html
//
//
//
// Created by Tim Little & Chuck Walbourn
//
//                       *** IPAS Mesh Data Exporter ***
//
// init.cpp
//
// Contains the INI startup information processing.  Uses XFile.
//
//

//
//
//                                Includes
//
//

#include <stdlib.h>
#include <string.h>

#include "xfini.hpp"

//
//
//                                 Data
//
//

extern "C" char output_path[];
extern "C" char output_name[];
extern "C" char scene_name[];

extern "C" dword  object_flags;

extern "C" int cameras_flag;
extern "C" int lights_flag;

extern "C" float  scale_3ds2esch;
extern "C" float  scale_3ds;
extern "C" float  scale_esh;

extern "C" int source_mode;
extern "C" int coord_mode;
extern "C" int extent_mode;
extern "C" int material_mode;
extern "C" int hierarchy_mode;
extern "C" int orientation_mode;
extern "C" int format_mode;
extern "C" int vertex_mode;

// Material export information

extern "C" int mtl_sizemode;                // 1=just to power of 2,
                                            // 2=force to mtl_sizex/y
                                            // 3=query
extern "C" int mtl_sizex;
extern "C" int mtl_sizey;

extern "C" int mtl_format;                  // 1=8-bit
                                            // 2=True-color (24/32-bit)

extern "C" int mtl_compress;                // 0=none
                                            // 1=rle

extern "C" int mtl_animatedtxt;             // 0=first-frame only
                                            // 1=multiframe

extern "C" int mtl_perspmode;               // 1=never
                                            // 2=^ in name
                                            // 3=always

extern "C" int query_xsize;
extern "C" int query_ysize;

extern "C" char mtl_palpath[];
extern "C" char mtl_palname[];

// Light export information

extern "C" int lgt_omnias;
extern "C" int lgt_spotas;
extern "C" int lgt_ambient;
extern "C" int lgt_atten;

// Keyframe export information

extern "C" int key_apnd;
extern "C" int key_loop;
extern "C" int key_ping;
extern "C" int key_mtyp;

//
//
//                                 Code
//
//

//Ŀ
// load_from_ini                                                            
//                                                                          
// Loads startup data from INI file                                         
//
extern "C" void load_from_ini(char *inifname)
{
    XFParseINI  ini;
    char        buff[128];

// Open INI file...
    if (ini.open(inifname,XF_OPEN_READ))
        return;

// Read startup section
    if (!ini.section("StartUp"))
    {

        // Source:  'all' or 'selected'
        if (!ini.read("Source",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"all"))
                source_mode=1;
            else if (!strcmp(buff,"selected"))
                source_mode=2;
        }

        // Scale3DS:  <float>
        if (!ini.read("Scale3DS",buff))
        {
            scale_3ds = atof(buff);
            if (scale_3ds <= 0.0)
                scale_3ds = 1.0;
        }

        // ScaleESH:  <float>
        if (!ini.read("ScaleESH",buff))
        {
            scale_esh = atof(buff);
            if (scale_esh <= 0.0)
                scale_esh = 1.0;
        }


        // ObjectLocalCoords:  'local' or 'world'
        if (!ini.read("ObjectLocalCoords",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"local"))
                coord_mode=1;
            else if (!strcmp(buff,"world"))
                coord_mode=2;
        }

        // ObjectExtents:  'quick' or 'optimal'
        if (!ini.read("ObjectExtents",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"quick"))
                extent_mode=1;
            else if (!strcmp(buff,"optimal"))
                extent_mode=2;
        }

        // ObjectHierarchy: 'none' or 'links'
        if (!ini.read("ObjectHierarchy",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"none"))
                hierarchy_mode=1;
            else if (!strcmp(buff,"links"))
                hierarchy_mode=2;
        }

        // ObjectOrientation: 'default' or 'matrix'
        if (!ini.read("ObjectOrientation",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"default"))
                orientation_mode=1;
            else if (!strcmp(buff,"matrix"))
                orientation_mode=2;
        }

        // ObjectFlags:  decimal or 0xhex
        if (!ini.read("ObjectFlags",buff))
        {

            if (buff[0] == '0' && buff[1] == 'x')
            {
                object_flags = strtoul((char *) &buff[2],NULL,16);
            }
            else
                object_flags = atoi(buff);

            object_flags &= 0xffff;
        }

        // MaterialData: 'partial' or 'complete'
        if (!ini.read("MaterialData",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"partial"))
                material_mode=1;
            else if (!strcmp(buff,"complete"))
                material_mode=2;
        }

        // Cameras: 'yes' or 'no'
        if (!ini.read("Cameras",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                cameras_flag=0;
            else if (!strcmp(buff,"yes"))
                cameras_flag=1;
        }

        // Lights: 'yes' or 'no'
        if (!ini.read("Lights",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                lights_flag=0;
            else if (!strcmp(buff,"yes"))
                lights_flag=1;
        }

        // DataFormat: 'float' or 'fixed'
        if (!ini.read("DataFormat",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"float"))
                format_mode=1;
            else if (!strcmp(buff,"fixed"))
                format_mode=2;
        }

        // Vertex mode: 'normal', 'merge'
        if (!ini.read("VertexMode",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"normal"))
                vertex_mode=1;
            else if (!strcmp(buff,"merge"))
                vertex_mode=2;
        }
    }

// Read material section
    if (!ini.section("Material"))
    {
        // Palette
        if (!ini.read("Palette",buff))
        {
            char    drive[XF_MAX_DRIVE];
            char    dir[XF_MAX_DIR];
            char    fname[XF_MAX_FNAME];
            char    ext[XF_MAX_EXT];

            strupr(buff);
            _splitpath(buff,drive,dir,fname,ext);

            strcpy(mtl_palpath,drive);
            strcat(mtl_palpath,dir);

            strcpy(mtl_palname,fname);
            strcat(mtl_palname,ext);
        }

        mtl_sizemode=1;

        // QuerySize: 'yes' or 'no' (overridden by ForceSize)
        if (!ini.read("QuerySize",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"yes"))
                mtl_sizemode=3;
        }

        // ForceSize: 'yes' or 'no'
        if (!ini.read("ForceSize",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"yes"))
                mtl_sizemode=2;
        }

        // SizeX: <number>
        if (!ini.read("SizeX",buff))
        {
            int x;
            x=atoi(buff);
            switch (x)
            {
                case 16:
                case 32:
                case 64:
                case 128:
                case 256:
                    mtl_sizex=x;
                    query_xsize=x;
                    break;
            }
        }

        // SizeY: <number>
        if (!ini.read("SizeY",buff))
        {
            int y;
            y=atoi(buff);
            switch (y)
            {
                case 16:
                case 32:
                case 64:
                case 128:
                case 256:
                    mtl_sizey=y;
                    query_ysize=y;
                    break;
            }
        }

        // Format: '8bit' or 'truecolor'
        if (!ini.read("Format",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"truecolor"))
                mtl_format=2;
            else if (!strcmp(buff,"8bit"))
                mtl_format=1;
        }

        // Compress: 'none' or 'rle'
        if (!ini.read("Compress",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"rle"))
                mtl_compress=1;
            else if (!strcmp(buff,"none"))
                mtl_compress=0;
        }

        // AnimatedTextures: '1st' or 'multiframe'
        if (!ini.read("AnimatedTextures",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"multiframe"))
                mtl_animatedtxt=1;
            else if (!strcmp(buff,"1st"))
                mtl_animatedtxt=0;
        }

        // PerspectiveCorrection: 'never', 'caret', or 'always'
        if (!ini.read("PerspectiveCorrection",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"always"))
                mtl_perspmode=3;
            else if (!strcmp(buff,"caret"))
                mtl_perspmode=2;
            else if (!strcmp(buff,"never"))
                mtl_perspmode=1;
        }
    }

// Read light section
    if (!ini.section("Light"))
    {
        // OmniAs: 'fast' or 'point'
        lgt_omnias=1;
        if (!ini.read("OmniAs",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"point"))
                lgt_omnias=2;
        }

        // SpotAs: 'fast, 'vector' or 'spot'
        lgt_spotas=1;
        if (!ini.read("SpotAs",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"spot"))
                lgt_spotas=2;
            else if (!strcmp(buff,"vector"))
                lgt_spotas=3;
        }

        // Ambient: 'yes' or 'no'
        lgt_ambient=1;
        if (!ini.read("Ambient",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                lgt_ambient=0;
        }

        // Atten: 'yes' or 'no'
        lgt_atten=1;
        if (!ini.read("Atten",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                lgt_atten=0;
        }
    }

// Read keyframe section
    if (!ini.section("Keyframe"))
    {
        key_apnd=1;
        if (!ini.read("Append",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"overwrite"))
                key_apnd=0;
        }

        key_ping=1;
        if (!ini.read("PingPong",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                key_ping=0;
        }

        key_loop=1;
        if (!ini.read("Loop",buff))
        {
            strlwr(buff);
            if (!strcmp(buff,"no"))
                key_loop=0;
        }

        if (!ini.read("MotionType",buff))
        {
            key_mtyp=atoi(buff);
        }

    }
}

// End of module - init.cpp 

