//
//                  ooo        ooooo
//                  `88.       .888'
//                   888b     d'888   .oooo.   oooo    ooo
//                   8 Y88. .P  888  `P  )88b   `88b..8P'
//                   8  `888'   888   .oP"888     Y888'
//                   8    Y     888  d8(  888   .o8"'88b
//                  o8o        o888o `Y888""8o o88'   888o
//
//                          Across the event horizon...
//
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// test.cpp
//
//  Event tester
//
//

//
//
//                                Includes
//
//

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <conio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <ivory.hpp>
#include <max.hpp>

// This file is generated by the compiler
#include "maxtest.hpp"


const ushort VMAP_SIZE = 3;
short vmap_table[VMAP_SIZE] =
{
    0,
    1025,
    4096
};

MaxValueMap vmap (VMAP_SIZE, vmap_table);

//
//
//                                 Code
//
//

void main ()
{
// Print welcome banner 
    cout << "Max Tester - (C) 1994-1999 by. D. Higdon, T. Little, and C. Walbourn\n\n";

    cout << "Load the events" << endl;

    // Allocate Ivory her, so the stream io stuff doesn't use it
    IvorySystem ivory (1024*1024);

    // Create a user event system and initialize it.
    MaxDevicesDirectX devs (HWND_DESKTOP);
    MaxEventUser evt (devs, "maxtest.iff", "maxtest");

    cout << "Collect interesting events" << endl;

    // Build up a list of the events we want to check
    MaxEventList interesting;
    interesting.add (done);
    interesting.add (up);
    interesting.add (down);
    interesting.add (left);
    interesting.add (right);
    interesting.add (mmove);
    interesting.add (hello);
    interesting.add (fire);
//    interesting.add (prompt);
//    interesting.add (scanprompt);
    interesting.add (wepselect);
    interesting.add (targselect);
    interesting.add (otherselect);

    evt.install ();

    if (devs.is_mouse_present())
        cout << "Mouse present" << endl;
    if (devs.is_keyboard_present())
        cout << "Keyboard present" << endl;
    if (devs.is_joystick_present())
        cout << "Joystick present" << endl;

//    devs.theJoystick->auto_poll (true, 20);

    cout << "Looking for:" << endl;
    cout << "   o Mouse move with button 1 down" << endl;
    cout << "   o Joystick move with button down" << endl;
    cout << "   o Arrow keys" << endl;
    cout << "   (see .CEL file for full list)" << endl;
    cout << endl << "===> Shift-ESC to exit " << endl;

    cout << "Process the events!" << endl;

    MaxEventListOneshot oneshot;
    for (;;)
    {
        devs.wm_clear();
        devs.update ();
        MaxEventList active = evt.process (interesting);

        if (active.check (mmove))
        {
            short x, y, dx, dy;

            evt.get_mouse_pos (&x, &y);
            evt.get_mouse_movement (&dx, &dy);
            cout << "Mouse: (" << x << ", " << y << ") ("
                 << dx << ", " << dy << ")" << endl;
        }

        if (active.check (fire))
        {
            if (devs.is_joystick_present())
            {
                JOYINFOEX stat;

                evt.get_joystick (&stat);
                cout << "Joystick: (" ;

                cout << int (stat.dwXpos - 32767) << ", ";
                cout << int (stat.dwYpos - 32767) << ", ";
                cout << int (stat.dwZpos - 32767) << ", ";
                cout << int (stat.dwRpos - 32767) << ", ";
                cout << int (stat.dwUpos - 32767) << ", ";
                cout << int (stat.dwVpos - 32767) << ") ";
                cout << "Hat = " << stat.dwPOV;
                cout << endl;
            }
        }

        if (active.check (up))      cout << "up"    << endl;
        if (active.check (down))    cout << "down"  << endl;
        if (active.check (left))    cout << "left"  << endl;
        if (active.check (right))   cout << "right" << endl;
        if (active.check (done))    break;

        MaxEventList ones = oneshot.process (active);
        if (ones.check (hello))
           cout << "hello" << endl;

#if 0
        if (ones.check (scanprompt))
        {
            MaxKbBuffer kbBuff (devs->theKeyboard);

            // Prompt for a key and wait for it.
            cout << "Enter a character " << endl;
            int ch = kbBuff.getscan();
            cout << "ScanCode = " << ch << endl;
        }

        if (ones.check (prompt))
        {
            MaxKbBuffer kbBuff (devs->theKeyboard);

            // Prompt for a key and wait for it.
            cout << "Enter a character " << endl;
            int ch = kbBuff.getch();
            cout << "Character = '" << char (ch) << "' = " << ch << endl;
        }
#endif

        if (ones.check (wepselect))
        {
            cout << "Weapons Select" << endl;
        }


        if (ones.check (targselect))
        {
            cout << "Target Select" << endl;
        }

        if (ones.check (otherselect))
        {
            cout << "Other Select" << endl;
        }

        // Empty the keyboard buffer
        while (kbhit()) getch();
    }
    evt.uninstall();
    cout << "All done!" << endl;
}

// Just a simple function to shut up the linker!
// This will not be needed in the full Mythos library.

extern "C" int mythos_atexit( register void ( *__func )( void ) )
{
    return atexit (__func);
}

// Make sure it uses the correct calling convention!
#ifdef __WATCOMC__
#pragma aux (_ASMSTKCALL_) mythos_atexit;
#endif

//
// _charybdis_assert
//
// Handler for failed asserts.  If msg is set to non-NULL, then an assertMyth
// was used with a comment.
//
extern "C" void _charybdis_assert(char *msg, char *exp, char *f, unsigned ln)
{
    cout.flush();
    printf("\n\n Assertion Failed \n"
           "Expr:\t%s\n"
           "File:\t%s\t\tLine %d\n",exp,f,ln);
    if (msg)
    {
        printf("Comment:\n%s\n",msg);
    }

    exit(1);
}

// End of module - test.cpp 
