
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: term.h,v 1.5 1998/06/14 12:24:06 stes Exp $
 */

#ifndef __CATERM_HEADER__
#define __CATERM_HEADER__

#include "cobject.h"

@interface Term : CAObject
{
  id scalarZero;
  id coefficient;
  id symbol;
  int exponent;
}

+ scalar:aScalar symbol:aSymbol exponent:(int)anExponent;
+ coefficient:aCoefficient symbol:aSymbol exponent:(int)anExponent;
- copy;
- deepCopy;
- clear;

- scalarZero;
- coefficient;
- symbol;
- (int) exponent;
- (int) degree;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (int) compareExponents:b;

- (int) intValue;
- intValue:(int)aValue;
- (float) floatValue;
- floatValue:(float)aValue;
- asScalar;
- asSymbol;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- inverse;
- multiplyScalar:b;
- multiplyCoefficient:b;
- multiply:b;
- divideScalar:b;
- divideCoefficient:b;
- divide:b;

- power:(int)n;
- root:(int)n;
- squareRoot;

- frobenius;
- frobeniusInverse;

- derive;
- integrate;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif				/* __CATERM_HEADER__ */

