// OzAPIDoc.cpp : implementation of the COzAPIDoc class
//

#include "stdafx.h"
#include "OzAPI.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COzAPIDoc

IMPLEMENT_DYNCREATE(COzAPIDoc, CDocument)

BEGIN_MESSAGE_MAP(COzAPIDoc, CDocument)
	//{{AFX_MSG_MAP(COzAPIDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COzAPIDoc construction/destruction

COzAPIDoc::COzAPIDoc()
{
	// TODO: add one-time construction code here

}

COzAPIDoc::~COzAPIDoc()
{
}

BOOL COzAPIDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	GKSinit (this);	 // pass to GKS system

	OZNEWDOC();		// tell Fortran callback

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// COzAPIDoc serialization

	long		storing;
	CArchive*	archive;

void COzAPIDoc::Serialize(CArchive& ar)
{
	long	numByte;
	void FAR* lpBuf;
	UINT	nMax;

	storing = ar.IsStoring();
	archive = &ar;

	OZSERIAL(&storing);
}


void DoSerialize (void FAR* lpBuf, long numByte)
{
	if (storing)
		archive ->Write(lpBuf, numByte);
	else
		archive ->Read(lpBuf, numByte);
}

// FORTRAN calls

extern "C" void ozserialstring (char* string, long* numByte)
{
	DoSerialize( (void FAR*)string, *numByte);
}

extern "C" void ozserialreal (float* real)
{
	DoSerialize( (void FAR*)real, 4);
}

extern "C" void ozserialint (long* integer)
{
	DoSerialize( (void FAR*)integer, 4);
}

extern "C" void ozserialrealarray (float* realArray, long* numReal)
{
	DoSerialize( (void FAR*)realArray, 4*(*numReal));
}

extern "C" void ozserialintarray (long* intArray, long* numInt)
{
	DoSerialize( (void FAR*)intArray, 4*(*numInt));
}


/////////////////////////////////////////////////////////////////////////////
// COzAPIDoc diagnostics

#ifdef _DEBUG
void COzAPIDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void COzAPIDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COzAPIDoc commands
