// gksCircleCursor.cpp : implementation of the gksCircleCursor class
//

#include "stdafx.h"
#include <math.h>
#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksCursor.h"
#include "gksCircleCursor.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CgksCircleCursor::CgksCircleCursor(long type, float* initialData, long handle, BOOL callback)
		: CgksCursor(type, initialData, handle, callback)
{
	float angle,step;
	float pi,fact;
	double radian;
	int iptr;

	pi = 4.0 * atan(1.0);	// calculate cos / sin once
	fact = pi / 180.0;

	step = 5.0;
	iptr=0;
	for (angle=0.0; angle<360.01; angle+=step)
		{
		radian = angle * fact;
		m_CircCos[iptr] = cos(radian);
		m_CircSin[iptr] = sin(radian);
		iptr++;
		}
} 

void CgksCircleCursor::ButtonDown(CClientDC* pDC, CPoint point)
{
	m_screenPoint.RemoveAll();
	m_screenPoint.Add(point);	// the centre
	m_radiusPoint = point;
	m_drawing = TRUE;
	this->DrawCursor(pDC);
}

void CgksCircleCursor::ButtonUp(CClientDC* pDC, CPoint point)
{
	float	centreX, centreY, circumX, circumY;
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	xdev2w (&centreX, m_screenPoint[0].x); // get radius in world coords
	ydev2w (&centreY, m_screenPoint[0].y);
	xdev2w (&circumX, m_radiusPoint.x); 
	ydev2w (&circumY, m_radiusPoint.y);
	m_extra = (centreX - circumX) * (centreX - circumX);
	m_extra += (centreY - circumY) * (centreY - circumY);
	m_extra = sqrt(m_extra);
	this->GKScallback();
	m_drawing = FALSE;
}

void CgksCircleCursor::MouseMove(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	m_radiusPoint = point;	// point on circumference
	this->DrawCursor(pDC); // new 
}

void CgksCircleCursor::DrawCursor(CClientDC* pDC)
{
	float c,s;
	int i;
	int x,y;
	int radius;
	double rdub,xs,ys;

	CPen* pOldPen = (CPen*)pDC->SelectStockObject(WHITE_PEN);
	int	oldROP = pDC->SetROP2(R2_NOT);          // Erases previous box 

	xs = m_screenPoint[0].x - m_radiusPoint.x;
	ys = m_screenPoint[0].y - m_radiusPoint.y;
	rdub = xs*xs + ys*ys;
	radius = sqrt (rdub);

	if (radius < 1)
	return;


	for (i=0; i<72; i++)
    {
		c = m_CircCos[i];  // stored cos & sin
		s = m_CircSin[i];
		if (c > 0.0)
			x = radius * c + 0.5;
		else
			x = radius * c - 0.5;
		if (s > 0.0)
			y = radius * s + 0.5;
		else
			y = radius * s - 0.5;
		x += m_screenPoint[0].x;
		y += m_screenPoint[0].y;

		if (i == 0)
		pDC->MoveTo (x, y);
		else
		pDC->LineTo (x, y);
	}

	pDC->SetROP2(oldROP);
	pDC->SelectObject(pOldPen);
}

