// View.cpp : implementation of the CPropModeView class
//

#include "stdafx.h"
#include "PropMode.h"
#include "page1.h"
#include "page2.h"
#include "sheetf.h"
#include "sheetp.h"
#include "MainFrm.h"
#include "Modeles1.h"
#include "Modeles2.h"
#include "Modeles3.h"


#include "Doc.h"
#include "View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropModeView

IMPLEMENT_DYNCREATE(CPropModeView, CView)

BEGIN_MESSAGE_MAP(CPropModeView, CView)
	//{{AFX_MSG_MAP(CPropModeView)
	ON_COMMAND(ID_MYPLAIN, OnMyPlain)
	ON_COMMAND(ID_MYFANCY, OnMyFancy)
	ON_COMMAND(ID_MODELESS, OnModeless)
	ON_COMMAND(ID_KILLMODELESS, OnKillmodeless)
	ON_UPDATE_COMMAND_UI(ID_KILLMODELESS, OnUpdateKillmodeless)
	ON_UPDATE_COMMAND_UI(ID_MODELESS, OnUpdateModeless)
	ON_COMMAND(ID_MODELESS_WITH_CLOSE, OnModelessWithClose)
	ON_UPDATE_COMMAND_UI(ID_MODELESS_WITH_CLOSE, OnUpdateModelessWithClose)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropModeView construction/destruction

CPropModeView::CPropModeView()
{
	m_pModeLessNormal = NULL; // init the pointer to NULL
	m_pModeLessNormalWithClose = NULL; // init the pointer to NULL
	m_bShowingModeLessNormalWithClose = FALSE;
}

CPropModeView::~CPropModeView()
{
	// in case user closes app while modeless dialog displayed
	if( m_pModeLessNormal != NULL )
	{
		m_pModeLessNormal->DestroyWindow();    // kill dialog
		delete m_pModeLessNormal; // delete dialog's memory on heap
	}
}

BOOL CPropModeView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CPropModeView drawing

void CPropModeView::OnDraw(CDC* pDC)
{
	CPropModeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CPropModeView printing

BOOL CPropModeView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPropModeView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPropModeView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CPropModeView diagnostics

#ifdef _DEBUG
void CPropModeView::AssertValid() const
{
	CView::AssertValid();
}

void CPropModeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPropModeDoc* CPropModeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPropModeDoc)));
	return (CPropModeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPropModeView message handlers

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnMyPlain() 
{

	CMyPlainSheet dlg("My Plain Sheet", this);

	CMyPage1 cPage1;
	CMyPage2 cPage2;

	dlg.AddPage(&cPage1);
	dlg.AddPage(&cPage2);

	dlg.DoModal(); 
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnMyFancy() 
{

	CMyFancySheet dlg("My Fancy Sheet", this);

	CMyPage1 cPage1;
	CMyPage2 cPage2;

	dlg.AddPage(&cPage1);
	dlg.AddPage(&cPage2);

	dlg.DoModal(); 
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnModeless() 
{
	m_pModeLessNormal = new CModeLessNormal;    
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	BOOL b = m_pModeLessNormal->Create(pFWnd);
	m_pModeLessNormal->ShowWindow(SW_SHOW);
	ASSERT(b);
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnKillmodeless() 
{
	m_pModeLessNormal->DestroyWindow();    // kill dialog
	delete m_pModeLessNormal; // delete dialog's memory on heap
	m_pModeLessNormal = NULL; // return it to safe state (must do - see destructor)
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnModelessWithClose() 
{
	m_pModeLessNormalWithClose = new CModeLessNormalWithClose;    
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	BOOL b = m_pModeLessNormalWithClose->Create(pFWnd);
	m_pModeLessNormalWithClose->ShowWindow(SW_SHOW);
	m_bShowingModeLessNormalWithClose = TRUE;
	ASSERT(b);	
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnUpdateModelessWithClose(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_bShowingModeLessNormalWithClose);		
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnUpdateKillmodeless(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((BOOL)m_pModeLessNormal);	
}

/////////////////////////////////////////////////////////////////////////////
void CPropModeView::OnUpdateModeless(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!(BOOL)m_pModeLessNormal);	
}


