TestKey = "SOFTWARE\Microsoft\Rexx Testing\CurrentVersion"
TestKeyP1 = "SOFTWARE\Microsoft\Rexx Testing"
TestKeyP2 = "SOFTWARE\Microsoft"
TestFileName = "C:\TEMP\TEST.REG"
UNCTestFileName = "\\NTAS\C$\TEMP\TEST.REG"
RemoteHost = "ntas"

'DEL' TestFileName '>nul 2>&1'
'DEL' UNCTestFileName '>nul 2>&1'

call testproc 'HKEY_LOCAL_MACHINE'

mhk = w32RegConnectRegistry(RemoteHost, 'HKEY_LOCAL_MACHINE')
if mhk == '' then do
	say "Oops, remote registry open failed."
end
call testproc mhk
w32RegCloseKey(mhk)

a = 'path'()
b = w32ExpandEnvironmentStrings("PATH=%PATH%")
if a \== b then do
	say "Oops, wrong info for path."
end

'DEL' TestFileName '>nul 2>&1'
'DEL' UNCTestFileName '>nul 2>&1'

exit

TestProc: procedure expose testkey testkeyp1 testkeyp2 testfilename
parse arg mainhk

hk = w32RegCreateKey(mainhk, TestKey)

if hk == '' then do
	say "Oops, key creation failed."
end

w32RegCloseKey(hk)

hk = w32RegOpenKey(mainhk, TestKey)

if hk == '' then do
	say "Oops, key open failed."
end

w32RegSetValue(hk, "DWORD Test", 'REG_DWORD', 23)
w32RegSetValue(hk, "SZ Test", 'REG_SZ', 'Test string')
w32RegSetValue(hk, "BINARY Test", 'REG_BINARY', 'ff0a000301020304fe')


w32RegSetValue(hk, "DELETE Test", 'REG_DWORD', 0)
if w32RegQueryValue(hk, "DELETE Test") ^== 0 then do
	say 'Set of DELETE Test failed.'
end
w32RegDeleteValue(hk, "DELETE Test")
signal on syntax name deletevalskip
interpret 'w32RegQueryValue(hk, "DELETE Test")'
say 'Oops, looks like deletion of DELETE Test failed.'
deletevalskip:

EveryoneSD='01000480340000004400000000000000140000000200200001000000000218003f000f000101000000000001000000000000000001020000000000052000000020020000010500000000000515000000b213bf7e431cbd69625eb14600020000'
SD = w32RegGetKeySecDesc(hk)
if SD == EveryoneSD then do
	say 'Oops, strange permissions defaulting on this key.'
end

w32RegSetKeySecDesc(hk, EveryoneSD)
if w32RegGetKeySecDesc(hk) ^== EveryoneSD then do
	say 'Failed to set security descriptor.'
end

w32RegFlushKey(hk)

w32RegSaveKey(hk, TestFileName)

w32RegCloseKey(hk)

call checkit mainhk

hk = w32RegOpenKey(mainhk, TestKeyP1)
w32RegDeleteKey(hk, "CurrentVersion")
w32RegCloseKey(hk)

hk = w32RegCreateKey(mainhk, TestKey)
w32RegRestoreKey(hk, TestFileName)
w32RegCloseKey(hk)

call checkit mainhk

hk = w32RegOpenKey(mainhk, TestKeyP1)
w32RegDeleteKey(hk, "CurrentVersion")
w32RegCloseKey(hk)


w32RegLoadKey(mainhk, "ReginaRexxTesting", TestFileName)
w32RegUnLoadKey(mainhk, "ReginaRexxTesting")

hk = w32RegOpenKey(mainhk, TestKeyP2)
w32RegDeleteKey(hk, "Rexx Testing")
w32RegCloseKey(hk)

return


checkit: procedure expose testkey testkeyp1 testkeyp2 testfilename
parse arg mainhk

hk = w32RegOpenKey(mainhk, TestKey)
if w32RegQueryValue(hk, "DWORD Test") ^== 23 then do
	say 'Set of DWORD failed.'
end

if w32RegQueryValue(hk, "SZ Test") ^== "Test string" then do
	say 'Set of SZ failed.'
end

if w32RegQueryValue(hk, "BINARY Test") ^== 'ff0a000301020304fe' then do
	say 'Set of BINARY failed.'
end

if w32RegQueryValueType(hk, "DWORD Test") ^== 'REG_DWORD' then do
	say 'Type of DWORD wrong.'
end

if w32RegQueryValueType(hk, "SZ Test") ^== "REG_SZ" then do
	say 'Type of SZ wrong.'
end

if w32RegQueryValueType(hk, "BINARY Test") ^== 'REG_BINARY' then do
	say 'Type of BINARY wrong.'
end

if w32RegQueryInfoKey(hk, 'NumValues') ^== 3 then do
	say 'Incorrect value for NumValues.'
end
if w32RegQueryInfoKey(hk, 'MaxValueName') ^== 11 then do
	say 'Incorrect value for MaxValueName.'
end
if w32RegQueryInfoKey(hk, 'MaxValueData') ^== 24 then do
	say 'Incorrect value for MaxValueData.'
end

if w32RegEnumValue(hk, 0) ^== "DWORD Test" then do
	say 'Enum of DWORD wrong.'
end

if w32RegEnumValue(hk, 1) ^== "SZ Test" then do
	say 'Enum of SZ wrong.'
end

if w32RegEnumValue(hk, 2) ^== "BINARY Test" then do
	say 'Enum of BINARY wrong.'
end
w32RegCloseKey(hk)

hk = w32RegOpenKey(mainhk, TestKeyP1)
if w32RegQueryInfoKey(hk, 'NumSubkeys') ^== 1 then do
	say 'Incorrect value for Subkeys.'
end
if w32RegQueryInfoKey(hk, 'MaxSubKeyName') ^== 14 then do
	say 'Incorrect value for MaxSubKeyName.'
end
if w32RegEnumKey(hk, 0) ^== 'CurrentVersion' then do
	say 'Failed to enum subkeys.'
end

w32RegCloseKey(hk)
return
