/*  64encode.c
**
**  Creates MIME base-64 encoded attachment.
**   
**  DOS version. Must link with 64CODER.
**  Microsoft:  cl  64encode.c 64coder.c
**    Borland:  bcc 64encode.c 64coder.c
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>

#include "64coder.h"

#define BYTE unsigned char

#define PadChar '='

static long InBytes = 0;
static long OutBytes = 0;
static BYTE ClearText[3];
static BYTE CodedText[4];
static int f1;
static int f2;

static char Quote = '"';
static char *MimeVersion = "MIME-Version: 1.0\n";
static char *MailAgent   = "X-Mail-Agent: My Mail Agent\n";
static char *ContentType = "Content-Type: application/octet-stream\n";
static char *ContentEncoding    = "Content-Transfer-Encoding: base64\n";
static char *ContentDisposition = "Content-Disposition: attachment; filename=";
static char Temp[128];
static char Buffer[256];

static char *BlankLine = "\n";

void main(int argc, char *argv[])
{int i, n;
 if(argc!=3)
   {printf("Usage: 64encode <infile> <outfile>\n");
    exit(1);
   }
 /* open files */
 f1 = open(argv[1],O_RDONLY|O_BINARY);
 if(f1==-1)
   {printf("Cannot open %s\n", argv[1] );
    exit(1);
   }
 f2 = open(argv[2],O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
 if(f2==-1)
   {printf("Cannot create %s\n", argv[2] );
    exit(1);
   }
 /* output header */
 write(f2,MimeVersion,strlen(MimeVersion));
 write(f2,MailAgent,strlen(MailAgent));
 write(f2,ContentType,strlen(ContentType));
 write(f2,ContentEncoding,strlen(ContentEncoding));
 sprintf(Buffer,"%s%c%s%c\n",ContentDisposition,Quote,argv[1],Quote);
 write(f2,Buffer,strlen(Buffer));
 write(f2,BlankLine,strlen(BlankLine));
 /* encode */
 for(i=0;;i++)
   {ClearText[1] = 0;
    ClearText[2] = 0;
    n = read(f1,ClearText,3);
    if(n<=0) break;
    InBytes += (long)n;
    OutBytes += 4L;
    Encode64(&ClearText[0],&CodedText[0]);
    write(f2,&CodedText[0],4);
    if((i%10)==9) write(f2,"\n",1);
    /* display dot for each 1024 bytes read (1024/3 = 341) */
    if((i%341)==0)printf(".");
   }
 write(f2,"=\n",2);
 printf("\n%ld bytes read, %ld bytes written\n", InBytes, OutBytes);
 close(f1);
 close(f2);
 exit(0);
}
