{******************************************************************}
{ Description:                                                     }
{   This is an interface file to the YGREP32.DLL. To use it,       }
{   simply place 'YGrepInt' in the USES clause of your program     }
{   and call the functions as they are defined below. See          }
{   YGrepTst.pas for some sample code.                             }
{                                                                  }
{ Author:                                                          }
{   Damien Lewis (louie@melbpc.org.au) - 6th August 1996           }
{ Modified:                                                        }
{   96/08/28 - Yves Roumazeilles                                   }
{              Added BLIST definitions                             }
{   96/09/15 - Yves Roumazeilles (5.03)                            }
{              Added YGrepMessages/YGrepOptions and changed	   }
{              RGERR_EMPTY_ENCL to RGERR_EMPTY_CL                  }
{   96/11/17 - Yves Roumazeilles (6.00)                            }
{              Added Soundex routines                              }
{   97/05/05 - Yves Roumazeilles (6.02)                            }
{              Corrected some ugly typos in declarations           }
{              Added missing declarations                          }
{   97/05/16 - Yves Roumazeilles (6.02)                            }
{              Removed that still ugly circf false declaration.    }
{   97/06/08 - Yves Roumazeilles (6.02b)                           }
{              Added the new parameter to SFileSetFlags.           }
{   97/06/11 - Yves Roumazeilles (6.02b)                           }
{              Added the optimizations members of RGREPINFO.       }
{   97/06/11 - Yves Roumazeilles (6.02b)                           }
{              Added the interface for the SFileBinaryXGrep().     }
{   97/08/03 - Yves Roumazeilles (6.03)                            }
{              General update for v6.03                            }
{   97/08/04 - Yves Roumazeilles (6.03)                            }
{              Correction of a bug in implementation, test         }
{   98/10/15 - Yves Roumazeilles (7.00)                            }
{              Update for the change of interface                  }
{              Added FileXxxx support                              }
{   99/08/20 - Yves Roumazeilles (7.03)                            }
{              Update for the change of A/RGREPINFO                }
{   99/08/20 - Yves Roumazeilles (7.03a)                           }
{              Update for the change of SGREPINFO                  }
{              Corrected missing declarations                      }
{******************************************************************}

unit YGrepInt;

interface

const
  { YGrep Search Engine Error Codes }
  AGERR_UNKNOWN_TYPE  = -1;
  AGERR_NO_ERROR      = 0;
  AGERR_STATE         = 1;
  AGERR_ALLOC_MEM     = 2;
  AGERR_TOO_SHORT     = 3;
  AGERR_TOO_LONG      = 4;
  AGERR_NO_PREVIOUS   = 5;
  AGERR_NO_PATTERN    = 6;
  RGERR_MUNGED_AUTO   = 20;
  RGERR_MISS_BRACKET  = 25;
  RGERR_EMPTY_CL      = 26;
  RGERR_ILLEGAL_CL    = 27;
  RGERR_TOO_MANY_PAR  = 28;
  RGERR_NULL_IN_PAR   = 29;
  RGERR_UNMATCHED     = 30;
  RGERR_NULL_IN_CRO   = 31;
  RGERR_CYCLICAL_REF  = 32;
  RGERR_UNDETERM_REF  = 33;
  RGERR_UNMATCHED_PAR = 34;
  RGERR_TOO_MANY_BRA  = 35;

  { YGrep Search Engine Error Codes }
  YO_EOLCR    = 1;
  YO_EOLLF    = 2;
  YO_EOLCRLF  = 3;
  YO_ERRMSG   = 8;


  { Misc Constants }
  MATCH       = 0;
  MISMATCH    = 1;
  EXACTMATCH  = 2;
  MAXSYM      = 256;
  WORD_SIZE   = 512;
  MAXTAG      = 10;
  MAXDFA      = 2 * WORD_SIZE + 32;
  SIZESTRING  = 1024;


type
  { AGrep Structure }
	PtagAGrepInfo = ^tagAGrepInfo;
	tagAGrepInfo = record
    iErrorCode: Integer;
    cPat: array[0..WORD_SIZE - 1] of char;
    TagStart: array[0..MAXTAG - 1] of PChar;
    TagEnd: array[0..MAXTAG - 1] of PChar;
    bMatchCase: Integer;
    uMask: array[0..19] of char;
    uOvMask: array[0..19] of char;
    uLimit: array[0..19] of char;
    blState: array[0..19] of char;
    blOverflow: array[0..19] of char;
    blTemp: array[0..19] of char;
    uTable: array[0..MAXSYM - 1] of array[0..19] of char;
    iBitsPerState: Integer;
    iWordSize: Integer;
    iType: Integer;
    cUPat: array[0..WORD_SIZE - 1] of char;
    chrtyp: array[0..MAXSYM-1] of char;
  end;

  { RGrep Structure }
	PtagRGrepInfo = ^tagRGrepInfo;
	tagRGrepInfo = record
    iErrorCode: Integer;
    cPat: array[0..WORD_SIZE - 1] of char;
    TagStart: array[0..MAXTAG - 1] of PChar;
    TagEnd: array[0..MAXTAG - 1] of PChar;
    bMatchCase: Integer;
    cDFA: array[0..MAXDFA - 1] of char;
    iBranches: Integer;
    iMinLength: Integer;
    ap: array[0..MAXTAG - 1] of PChar;
    bol: PChar;
    chrtyp: array[0..MAXSYM-1] of char;
  end;

  { SGrep Structure }
	PtagSGrepInfo = ^tagSGrepInfo;
	tagSGrepInfo = record
    iErrorCode: Integer;
    cPat: array[0..WORD_SIZE - 1] of char;
    TagStart: array[0..MAXTAG - 1] of PChar;
    TagEnd: array[0..MAXTAG - 1] of PChar;
    bMatchCase: Integer;
    cDFA: array[0..MAXDFA - 1] of char;
    chrtyp: array[0..MAXSYM-1] of char;
  end;

  { YGFile Structure }
	PtagYGFileInfo = ^tagYGFileInfo;
	tagYGFileInfo = record
    pFileDesc: PChar;
    strFileName: PChar;
    lLineNumber: LongInt;
    lMatchCount: LongInt;
    linebuf: array[0..SIZESTRING-1] of char;
    outputbuf: array[0..SIZESTRING-1] of char;
    tempbuf: array[0..SIZESTRING-1] of char;
    bPrintNameOfFile: Integer;	{print file name to output}
    bPrintBlockNumber: Integer;	{print block number to output}
    bPrintLineNumber: Integer;	{print line number to output}
    bPrintCountsOnly: Integer;	{total count matches to output}
    bNonMatchingLines: Integer;	{Print all lines except those that contain the pattern}
    bFileModeText: Integer;	{Open all files in text mode (rather than binary)}
    agiLocal: tagAGrepInfo;
    rgiLocal: tagRGrepInfo;
    sgiLocal: tagSGrepInfo;
  end;


{ Misc Function Declarations }
function YGrepVersion: Word; stdcall;
procedure YGrepMessages(bMessages: Integer); stdcall;
procedure YGrepOptions(lOptions: LongInt); stdcall;

{ AGrep Function Declarations }
function CompileAGrep(GrepString: PChar; k: Integer; MatchCase: Integer; FullWordMatch: Integer; pGI: PtagAGrepInfo): Integer; stdcall;
function AGrep(StringToSearch: PChar; pGI: PtagAGrepInfo): Integer; stdcall;
function AGrepInit(pGI: PtagAGrepInfo): Integer; stdcall;
function AGrepEmpty(pGI: PtagAGrepInfo): Integer; stdcall;
function AGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI: PtagAGrepInfo): Integer; stdcall;
function AGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI: PtagAGrepInfo): Integer; stdcall;
procedure InitAWordCharTable(pGI: PtagAGrepInfo); stdcall;
procedure ClearAWordCharTable(pGI: PtagAGrepInfo); stdcall;
procedure FillAWordCharTable(pGI: PtagAGrepInfo); stdcall;
procedure AddAWordCharTable(s: PChar; pGI: PtagAGrepInfo); stdcall;
procedure RemoveAWordCharTable(s: PChar; pGI: PtagAGrepInfo); stdcall;
function SCompileAGrep(GrepString: PChar; k: Integer; bMatchCase: Integer; FullWordMatch: Integer): Integer; stdcall;
function SAGrep(StringToSearch: PChar): Integer; stdcall;
procedure SAGrepInit; stdcall;
procedure SAGrepEmpty; stdcall;
function SAGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;
function SAGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;

{ RGrep Function Declarations }
function CompileRGrep(GrepString: PChar; MatchCase: Integer; pGI: PtagRGrepInfo): Integer; stdcall;
function RGrep(StringToSearch: PChar; pGI: PtagRGrepInfo): Integer; stdcall;
function RGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI:PtagRGrepInfo): Integer; stdcall;
function RGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI: PtagRGrepInfo): Integer; stdcall;
procedure InitRWordCharTable(pGI: PtagRGrepInfo); stdcall;
procedure ClearRWordCharTable(pGI: PtagRGrepInfo); stdcall;
procedure FillRWordCharTable(pGI: PtagRGrepInfo); stdcall;
procedure AddRWordCharTable(s: PChar; pGI: PtagRGrepInfo); stdcall;
procedure RemoveRWordCharTable(s: PChar; pGI: PtagRGrepInfo); stdcall;
function SCompileRGrep(GrepString: PChar; MatchCase: Integer): Integer; stdcall;
function SRGrep(StringToSearch: PChar): Integer; stdcall;
function SRGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;
function SRGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;

{ SGrep Function Declarations }
function CompileSGrep(GrepString: PChar; MatchCase: Integer; pGI: PtagSGrepInfo): Integer; stdcall;
function SGrep(StringToSearch: PChar; pGI: PtagSGrepInfo): Integer; stdcall;
function SGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI:PtagSGrepInfo): Integer; stdcall;
function SGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer; pGI: PtagSGrepInfo): Integer; stdcall;
procedure InitSWordCharTable(pGI: PtagSGrepInfo); stdcall;
procedure ClearSWordCharTable(pGI: PtagSGrepInfo); stdcall;
procedure FillSWordCharTable(pGI: PtagSGrepInfo); stdcall;
procedure AddSWordCharTable(s: PChar; pGI: PtagSGrepInfo); stdcall;
procedure RemoveSWordCharTable(s: PChar; pGI: PtagSGrepInfo); stdcall;
function SCompileSGrep(GrepString: PChar; MatchCase: Integer): Integer; stdcall;
function SSGrep(StringToSearch: PChar): Integer; stdcall;
function SSGrepSubsBuild(lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;
function SSGrepSubstitute(SearchedString: PChar; lpszPattern: PChar; lpszDest: PChar; iSize:Integer): Integer; stdcall;

{ SFile Function Declarations }
procedure SFileSetFlags(bPrintFileName: Integer; bPrintBlockNumber: Integer; bPrintLineNumber: Integer; bCountsOnly: Integer; bNonMatching: Integer); stdcall;
function SFileOpen(strFileName: PChar; bFileModeText: Integer): Integer; stdcall;
function SFileAGrep: PChar; stdcall;
function SFileRGrep: PChar; stdcall;
function SFileSGrep: PChar; stdcall;
function SFileTextAGrep: PChar; stdcall;
function SFileTextRGrep: PChar; stdcall;
function SFileTextSGrep: PChar; stdcall;
function SFileBinaryAGrep: PChar; stdcall;
function SFileBinaryRGrep: PChar; stdcall;
function SFileBinarySGrep: PChar; stdcall;
function SFileClose: LongInt; stdcall;

{ File Function Declarations }
procedure FileSetFlags(bPrintFileName: Integer; bPrintBlockNumber: Integer; bPrintLineNumber: Integer; bCountsOnly: Integer; bNonMatching: Integer; pGI: PtagYGFileInfo); stdcall;
function FileOpen(strFileName: PChar; bFileModeText: Integer): Integer; stdcall;
function FileAGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileRGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileSGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileTextAGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileTextRGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileTextSGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileBinaryAGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileBinaryRGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileBinarySGrep(pGI: PtagYGFileInfo): PChar; stdcall;
function FileClose(pGI: PtagYGFileInfo): LongInt; stdcall;


implementation

{ Misc Functions }
function YGrepVersion; external 'YGREP32.DLL';
procedure YGrepMessages; external 'YGREP32.DLL';
procedure YGrepOptions; external 'YGREP32.DLL';

{ AGrep Functions }
function CompileAGrep; external 'YGREP32.DLL';
function AGrep; external 'YGREP32.DLL';
function AGrepInit; external 'YGREP32.DLL';
function AGrepEmpty; external 'YGREP32.DLL';
function AGrepSubsBuild; external 'YGREP32.DLL';
function AGrepSubstitute; external 'YGREP32.DLL';
procedure InitAWordCharTable; external 'YGREP32.DLL';
procedure ClearAWordCharTable; external 'YGREP32.DLL';
procedure FillAWordCharTable; external 'YGREP32.DLL';
procedure AddAWordCharTable; external 'YGREP32.DLL';
procedure RemoveAWordCharTable; external 'YGREP32.DLL';
function SCompileAGrep; external 'YGREP32.DLL';
function SAGrep; external 'YGREP32.DLL';
procedure SAGrepInit; external 'YGREP32.DLL';
procedure SAGrepEmpty; external 'YGREP32.DLL';
function SAGrepSubsBuild; external 'YGREP32.DLL';
function SAGrepSubstitute; external 'YGREP32.DLL';

{ RGrep Functions }
function CompileRGrep; external 'YGREP32.DLL';
function RGrep; external 'YGREP32.DLL';
function RGrepSubsBuild; external 'YGREP32.DLL';
function RGrepSubstitute; external 'YGREP32.DLL';
procedure InitRWordCharTable; external 'YGREP32.DLL';
procedure ClearRWordCharTable; external 'YGREP32.DLL';
procedure FillRWordCharTable; external 'YGREP32.DLL';
procedure AddRWordCharTable; external 'YGREP32.DLL';
procedure RemoveRWordCharTable; external 'YGREP32.DLL';
function SCompileRGrep; external 'YGREP32.DLL';
function SRGrep; external 'YGREP32.DLL';
function SRGrepSubsBuild; external 'YGREP32.DLL';
function SRGrepSubstitute; external 'YGREP32.DLL';

{ SGrep Functions }
function CompileSGrep; external 'YGREP32.DLL';
function SGrep; external 'YGREP32.DLL';
function SGrepSubsBuild; external 'YGREP32.DLL';
function SGrepSubstitute; external 'YGREP32.DLL';
procedure InitSWordCharTable; external 'YGREP32.DLL';
procedure ClearSWordCharTable; external 'YGREP32.DLL';
procedure FillSWordCharTable; external 'YGREP32.DLL';
procedure AddSWordCharTable; external 'YGREP32.DLL';
procedure RemoveSWordCharTable; external 'YGREP32.DLL';
function SCompileSGrep; external 'YGREP32.DLL';
function SSGrep; external 'YGREP32.DLL';
function SSGrepSubsBuild; external 'YGREP32.DLL';
function SSGrepSubstitute; external 'YGREP32.DLL';

{ SFile Function Declarations }
procedure SFileSetFlags; external 'YGREP32.DLL';
function SFileOpen; external 'YGREP32.DLL';
function SFileAGrep; external 'YGREP32.DLL';
function SFileRGrep; external 'YGREP32.DLL';
function SFileSGrep; external 'YGREP32.DLL';
function SFileTextAGrep; external 'YGREP32.DLL';
function SFileTextRGrep; external 'YGREP32.DLL';
function SFileTextSGrep; external 'YGREP32.DLL';
function SFileBinaryAGrep; external 'YGREP32.DLL';
function SFileBinaryRGrep; external 'YGREP32.DLL';
function SFileBinarySGrep; external 'YGREP32.DLL';
function SFileClose; external 'YGREP32.DLL';

{ File Function Declarations }
procedure FileSetFlags; external 'YGREP32.DLL';
function FileOpen; external 'YGREP32.DLL';
function FileAGrep; external 'YGREP32.DLL';
function FileRGrep; external 'YGREP32.DLL';
function FileSGrep; external 'YGREP32.DLL';
function FileTextAGrep; external 'YGREP32.DLL';
function FileTextRGrep; external 'YGREP32.DLL';
function FileTextSGrep; external 'YGREP32.DLL';
function FileBinaryAGrep; external 'YGREP32.DLL';
function FileBinaryRGrep; external 'YGREP32.DLL';
function FileBinarySGrep; external 'YGREP32.DLL';
function FileClose; external 'YGREP32.DLL';

end.
