/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
/******************************************************************************/
/* FILE           : Splash.c  -  Splash screen functions                      */
/* DESCRIPTION    : Functions for splash screen                               */
/* LANGUAGE       : "C"                                                       */
/* PLATFORM       : Windows 95/98/98SE/ME/NT4/2000                            */
/* AUTHOR         : Andrea Binello  <andrea.binello@tiscalinet.it>            */
/* LICENSE        : Freeware - Open Source                                    */
/* LAST UPDATE    : May 06, 2001                                              */
/******************************************************************************/

#define STRICT
#include <windows.h>
#ifdef ORIGINAL
#include <vfw.h>
#endif
#include "splash.h"

#define SPLASH_CLASS    "AbSplashScreenWndClass"

typedef struct
{
#ifdef ORIGINAL
   HDRAWDIB hdd;
   LPBYTE   lpBuffer;
#else
   HGLOBAL  bmp ;
#endif
   INT      iWidth;
   INT      iHeight;
} SPLASH2, FAR* LPSPLASH2;

/*****************************************************************************/
static HGLOBAL SplashScreen_LoadBmp (HINSTANCE hInstance, LPSTR lpszResource, LPINT lpiWidth, LPINT lpiHeight)
{
   DWORD                dwLen;
   HRSRC                hResource;
   HGLOBAL              hGlobal;
   HGLOBAL              hGlobalRet=NULL;
   LPVOID               lpBuffer;
   LPBITMAPFILEHEADER   lpbfh;
   LPBITMAPINFOHEADER   lpbih;

#ifdef ORIGINAL
   hResource = FindResource (hInstance, lpszResource, "SPLASH");

   if (hResource != NULL)
   {
      dwLen = SizeofResource (hInstance, hResource);

      if (dwLen != 0)
      {
         hGlobal = LoadResource (hInstance, hResource);

         if (hGlobal != NULL)
         {
            lpBuffer = LockResource (hGlobal);

            if (lpBuffer != NULL)
            {
               lpbfh = (LPBITMAPFILEHEADER) lpBuffer;
               lpbih = (LPBITMAPINFOHEADER) (((LPBYTE) lpBuffer) +
                       sizeof (BITMAPFILEHEADER));

               if (lpbfh->bfType == 0x4D42)
               {
                  hGlobalRet = hGlobal;

                  *lpiWidth = (INT) lpbih->biWidth >= 0 ?
                              lpbih->biWidth  : -lpbih->biWidth;
                  *lpiHeight = (INT) lpbih->biHeight >= 0 ?
                               lpbih->biHeight : -lpbih->biHeight;
               }
            }
         }
      }
   }
#else
   BITMAP bmp ;
   hGlobalRet = hGlobal = (HGLOBAL)LoadBitmap(hInstance,lpszResource) ;
   GetObject(hGlobal,sizeof(bmp),&bmp) ;
   *lpiWidth = (int) bmp.bmWidth ;
   *lpiHeight = (int) bmp.bmHeight ;
#endif

   return hGlobalRet;
}

/*****************************************************************************/
static VOID SplashScreen_Paint (HWND hWnd)
{
   LPSPLASH2            lpSplash2;
   HDC                  hdc;
   PAINTSTRUCT          ps;
   LPBITMAPINFOHEADER   lpbih;
   LPVOID               lpbits=NULL;

   lpSplash2 = (LPSPLASH2) GetWindowLong (hWnd, GWL_USERDATA);

   hdc = BeginPaint (hWnd, &ps);

#ifdef ORIGINAL
   if (lpSplash2 != NULL && lpSplash2->lpBuffer != NULL)
   {
      lpbih = (LPBITMAPINFOHEADER) (lpSplash2->lpBuffer + sizeof (BITMAPFILEHEADER));

      if (lpbih->biBitCount == 24)
         lpbits = ((LPBYTE) lpbih) + lpbih->biSize;
      else if (lpbih->biBitCount == 8)
         lpbits = ((LPBYTE) lpbih) + lpbih->biSize + sizeof (RGBQUAD)*256;
      else if (lpbih->biBitCount == 4)
         lpbits = ((LPBYTE) lpbih) + lpbih->biSize + sizeof (RGBQUAD)*16;
      else if (lpbih->biBitCount == 1)
         lpbits = ((LPBYTE) lpbih) + lpbih->biSize + sizeof (RGBQUAD)*2;

      if (lpbits != NULL)
         DrawDibDraw (lpSplash2->hdd, hdc, 0, 0,
                      lpSplash2->iWidth, lpSplash2->iHeight,
                      lpbih, lpbits, 0, 0,
                      lpSplash2->iWidth, lpSplash2->iHeight,
                      DDF_HALFTONE);
#else
   if (lpSplash2 != NULL && lpSplash2->bmp != NULL)
   {
      RECT r ;
      char buf[256], buf1[256] ;
      HDC hdcMem = CreateCompatibleDC(hdc) ;
      SelectObject(hdcMem, lpSplash2->bmp) ;
      BitBlt (hdc, 0, 0, lpSplash2->iWidth, lpSplash2->iHeight,
                      hdcMem, 0, 0, SRCCOPY);
      r.left = r.top = 3 ;
      r.right = lpSplash2->iWidth-6 ;
      r.bottom = lpSplash2->iHeight-6 ;
      VersionString(buf1,L"ProductVersion",L"040904E4") ;
      sprintf(buf,"Version %s",buf1) ;
      SetBkMode(hdc, TRANSPARENT) ;
      DrawText(hdc,buf,strlen(buf),&r,DT_NOCLIP|DT_SINGLELINE|DT_BOTTOM|DT_RIGHT) ;
      DeleteObject(hdcMem) ;
#endif
   }

   EndPaint (hWnd, &ps);
}

/*****************************************************************************/
static LRESULT CALLBACK SplashScreen_Proc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg)
   {
      case WM_PAINT:
         SplashScreen_Paint (hWnd);
         return 0L;

      case WM_ERASEBKGND:
         return 1L;

      case WM_TIMER:
         KillTimer (hWnd, (UINT) wParam);
         SendMessage (hWnd, WM_CLOSE, 0, 0L);
         return 0L;

      case WM_DESTROY:
         PostQuitMessage (0);
         return 0L;
   }

   return (DefWindowProc (hWnd, msg, wParam, lParam));
}

/******************************************************************************/
static VOID SplashScreen_Thread (LPSPLASH lpSplash)
{
#ifdef ORIGINAL
   HDRAWDIB    hdd;
#endif
   HGLOBAL     hGlobal;
   LPBYTE      lpBuffer;
   WNDCLASSEX  wcx;
   BOOL        bReg;
   DWORD       dwExStyles;
   INT         iWidth, iHeight, iScrWidth, iScrHeight, iPosX, iPosY;
   SPLASH2     splash2;
   HWND        hWnd;
   UINT        uTimerId;
   MSG         msg;
#ifdef ORIGINAL
   hdd = DrawDibOpen ();

   if (hdd != NULL)
#endif
   {
      hGlobal = SplashScreen_LoadBmp (lpSplash->hInstanceRes,
                                      lpSplash->lpszResource,
                                      &iWidth, &iHeight);

      if (hGlobal != NULL)
      {
         lpBuffer = (LPBYTE) LockResource (hGlobal);

         if (lpBuffer != NULL)
         {
            bReg = FALSE;

            if (GetClassInfoEx (lpSplash->hInstance, SPLASH_CLASS, &wcx))
               bReg = TRUE;
            else
            {
               wcx.cbSize        = sizeof (wcx);
               wcx.style         = 0;
               wcx.lpfnWndProc   = (WNDPROC) SplashScreen_Proc;
               wcx.cbClsExtra    = 0;
               wcx.cbWndExtra    = 0;
               wcx.hInstance     = lpSplash->hInstance;
               wcx.hIcon         = NULL;
               wcx.hIconSm       = NULL;
               wcx.hCursor       = LoadCursor (NULL, IDC_ARROW);
               wcx.hbrBackground = NULL;
               wcx.lpszMenuName  = NULL;
               wcx.lpszClassName = SPLASH_CLASS;

               if (RegisterClassEx (&wcx))
                  bReg = TRUE;
            }

            if (bReg)
            {
               if (lpSplash->bCentered)
               {
                  iScrWidth = GetSystemMetrics (SM_CXSCREEN);
                  iScrHeight = GetSystemMetrics (SM_CYSCREEN);

                  iPosX = (iScrWidth - iWidth) / 2;
                  iPosY = (iScrHeight - iHeight) / 2;
               }
               else
               {
                  iPosX = lpSplash->iPosX - iWidth / 2;
                  iPosY = lpSplash->iPosY - iHeight / 2;
               }

               dwExStyles = WS_EX_TOOLWINDOW;

               if (lpSplash->bTopmost)
                  dwExStyles |= WS_EX_TOPMOST;

               hWnd = CreateWindowEx (dwExStyles, SPLASH_CLASS, "",
                                      WS_POPUP, iPosX, iPosY, iWidth, iHeight,
                                      lpSplash->hWndOwner, NULL,
                                      lpSplash->hInstance, NULL);
#ifdef ORIGINAL
               splash2.hdd      = hdd;
               splash2.lpBuffer = lpBuffer;
#else
               splash2.bmp = hGlobal ;
#endif
               splash2.iWidth   = iWidth;
               splash2.iHeight  = iHeight;

               SetWindowLong (hWnd, GWL_USERDATA, (LONG) &splash2);

               uTimerId = SetTimer (hWnd, 1, (UINT) lpSplash->uTime, NULL);

               if (uTimerId != 0)
                  ShowWindow (hWnd, SW_SHOW);
               else
                  PostMessage (hWnd, WM_CLOSE, 0, 0L);

               while (GetMessage (&msg, NULL, 0, 0))
               {
                  TranslateMessage (&msg);
                  DispatchMessage (&msg);
               }
            }
         }
      }

#ifdef ORIGINAL
      DrawDibClose (hdd);
#endif
   }

   GlobalFree ((HGLOBAL) lpSplash);
}

/******************************************************************************/
VOID WINAPI SplashScreen (LPSPLASH lpSplash)
{
   HANDLE      hThread;
   DWORD       dwTid;
   LPSPLASH    lpSplash_t;

   lpSplash_t = (LPSPLASH) GlobalAlloc (GPTR, sizeof (SPLASH));

   if (lpSplash_t != NULL)
   {
#ifdef ORIGINAL
      CopyMemory (lpSplash_t, lpSplash, sizeof (SPLASH));
#else
      memcpy (lpSplash_t, lpSplash, sizeof (SPLASH));
#endif

      hThread = CreateThread (NULL, 0, (LPTHREAD_START_ROUTINE) SplashScreen_Thread,
                              (LPVOID) lpSplash_t, 0, &dwTid);

      if (lpSplash->bWait && hThread != NULL)
         WaitForSingleObject (hThread, INFINITE);
   }
}
