/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <dos.h>
#include <errno.h>

void       RTL_NORM _dos_getdate(struct dosdate_t *__datep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   __datep->day = timex.wDay ;
   __datep->month = timex.wMonth ;
   __datep->year = timex.wYear - 1980 ;
   __datep->dayofweek = timex.wDayOfWeek ;
}
void       RTL_NORM _dos_gettime(struct dostime_t *__timep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   __timep->hour = timex.wHour ;
   __timep->minute = timex.wMinute ;
   __timep->second = timex.wSecond ;
   __timep->hsecond = timex.wMilliseconds/10 ;
}
void       RTL_NORM getdate(struct date *__datep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   __datep->da_day = timex.wDay ;
   __datep->da_mon = timex.wMonth ;
   __datep->da_year = timex.wYear - 1980 ;
}
void       RTL_NORM gettime(struct time *__timep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   __timep->ti_hour = timex.wHour ;
   __timep->ti_min = timex.wMinute ;
   __timep->ti_sec = timex.wSecond ;
   __timep->ti_hund = timex.wMilliseconds/10 ;
}
unsigned   RTL_NORM _dos_setdate(struct dosdate_t *__datep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   timex.wDay = __datep->day ;
   timex.wMonth = __datep->month ;
   timex.wYear = __datep->year + 1980 ;
   if (!SetLocalTime(&timex)) {
      errno = EINVAL ;
		return 2;
   }
	return 0;
}
unsigned   RTL_NORM _dos_settime(struct dostime_t *__timep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   timex.wHour = __timep->hour ;
   timex.wMinute = __timep->minute ;
   timex.wSecond = __timep->second ;
   timex.wMilliseconds = __timep->hsecond * 10 ;
   if (!SetLocalTime(&timex)) {
      errno = EINVAL ;
		return 2;
   }
	return 0;
}
void       RTL_NORM setdate(struct date *__datep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   timex.wDay = __datep->da_day ;
   timex.wMonth = __datep->da_mon ;
   timex.wYear = __datep->da_year + 1980 ;
   SetLocalTime(&timex) ;
}
void       RTL_NORM settime( struct time *__timep)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;
   timex.wHour = __timep->ti_hour ;
   timex.wMinute = __timep->ti_min ;
   timex.wSecond = __timep->ti_sec ;
   timex.wMilliseconds = __timep->ti_hund * 10 ;
   SetLocalTime(&timex) ;
}