/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "libp.h"

long double __xstrtod(FILE *fil, int count, int *ch)
{
	int sign = 0;
	long double frac = 0;
	long double val = 0;
	int exp=0;

   if (*ch == '-') {
		sign++;
      *ch = fgetc(fil) ;
	  if (!--count)
	  	return val;
	}
   else if (*ch == '+') {
      *ch = fgetc(fil) ;

		if (!--count)
			return val;
	}

   if (*ch == '.') {
		frac = .1;
      *ch = fgetc(fil) ;                    
		if (!--count)
			return val;
	}
	if (!frac) {
      while(isdigit(*ch)) {
			val*= 10;
         val += (*ch-'0');
         *ch = fgetc(fil );
			if (!--count)
				return val;
		}
      if (*ch == '.') {
			frac = .1;
         *ch = fgetc(fil) ;
			if (!--count)
				return val;
		}
	}
	if (frac)
      while (isdigit(*ch)) {
         val += (*ch-'0')*frac;
         *ch = fgetc(fil) ;
			frac /=10;
			if (!--count)
				return val;
		}
	if (sign)
		val = - val;
	sign = 0;
   if (*ch == 'e' || *ch == 'E' || *ch == 'd' || *ch == 'E') {
		sign = 0;
      *ch = fgetc(fil) ;
      if (*ch == '-') {
			sign++;
         *ch = fgetc(fil) ;
			if (!--count)
				return val;
		}
      else if (*ch == '+') {
         *ch = fgetc(fil) ;
	  	if (!--count)
	  		return val;
		}
      while(isdigit(*ch)) {
			exp*= 10;
         exp += (*ch-'0');
         *ch = fgetc(fil) ;
         if (!--count)
            return val;
		}
		if (exp > 5200)
			exp = 5200;
		if (sign)
			val = val / _fpow(exp);
		else
			val = val * _fpow(exp);
	}
	return val;
}
static long double __strtod(const char *buf, char **endptr, int width)
{
   long double rv ;
   int ch ;
   FILE fil ;
   memset(&fil,0,sizeof(fil)) ;
   fil.level = strlen(buf)+1 ;
   fil.flags = _F_IN | _F_READ | _F_BUFFEREDSTRING ;
   fil.bsize = strlen(buf) ;
   fil.buffer = fil.curp = buf ;
   fil.token = FILTOK ;
   ch = fgetc(&fil) ;
   rv = __xstrtod(&fil,width,&ch) ;
   if (endptr)
      *endptr = fil.curp - 1;
   return rv ;
}
long double strtold(const char *string, char **endptr)
{
   return(__strtod(string,endptr,256));
}
double strtod(const char *string, char **endptr)
{
   return((double)__strtod(string,endptr,256));
}
double atof(const char *string)
{
   return((double)__strtod(string,0,256));
}
long double _atold(const char *string)
{
   return(__strtod(string,0,256));
}