/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <libp.h>


extern char **_environ;
int putenv(const char *name)
{
   char **q = _environ, **p ;
   int len = 0, has = 0,count = 0 ;
   _ll_enter_critical() ;
   if (!strchr(name,'='))
      return -1 ;
   while (name[len] && name[len] != '=') {
      if ((*q)[len] == '=') {
         if ((*q)[len] != 0)
            has = 1 ;
      }   
      len++ ;
   }
	while (*q) {
      count++ ;
      if (!strnicmp(name,*q,len)) {
         if (has) {
            *q = name ;
            _ll_exit_critical() ;
            return 0 ;
         } else {
            while (*q) {
               *q = *(q+1) ;
               q++ ;
            }
            _ll_exit_critical() ;
            return 0 ;
         }
      }
		q++;
	}
   p = (char **)realloc(_environ,(count+2)*sizeof(char **)) ;
   if (!p) {
      _ll_exit_critical() ;
      return -1 ;
   }
   p[count-1] = NULL ;
   p[count-2] = name ;
   _environ = p ;
   _ll_exit_critical() ;
	return 0;
}