// ncScrollbarDist.h: interface for the CncScrollbar class.
//
//////////////////////////////////////////////////////////////////////
#pragma pack(1)
typedef struct tagncScrollInfoPublic
{
public:
	LONG m_Min;
	LONG m_Max;
	LONG m_Pagesize;
	LONG m_Pos;
	LONG m_Indent;
	BYTE m_Radix; //level grouping provided by user
	BYTE m_Invert;
	/*
		0-m_Min
		1-m_Max
		2-m_Pagesize
		3-m_Pos
		4-m_Indent
		5-m_Radix
		6-m_Invert
	*/
	BYTE m_Mask;
} ncScrollInfoPublic,FAR *LPncScrollInfoPublic;

typedef struct tagncScrollBarStylesPublic
{
public:
	UINT ID;
	char m_Orientation;
	BYTE m_SuggestedTrackerSize;
	BYTE m_SuggestedTickInterval;
	CBitmap* m_pHORZBitmap;
	//user-programmer definable
	union
	{
		UINT m_State;
		UINT m_Style;
	};
	/*
		0-ID
		1-m_Orientation
		2-m_SuggestedTrackerSize
		3-m_SuggestedTickInterval
		4-m_pHORZBitmap
		5-m_State/m_Style
	*/
	BYTE m_Mask;
} ncScrollBarStylesPublic, FAR *LPncScrollBarStylesPublic;

#pragma pack()

//Messages
	//Only external message sent, the actual message is passed in the nmhdr.code in lparam structure
#define WMncSCROLLBAR					0xBFF0
	//tracklevel and other changes messages
#define WMncSB_TRACKLEVELCHANGE			0xBFF1
#define WMncSB_PROPTERTIESCHANGE		0xBFF2
	//NOTE:
	//drag messages are the same as their nondrag counterparts
	//except that they are sent while cursor is moving during track operations
	//or while in automatic repeat messages with continuous pressing during arrow operations
#define WMncSB_DRAGCOARSEPOSITION		0xBFF3
#define WMncSB_COARSEPOSITION			0xBFF9
#define WMncSB_DRAGFINEPOSITION			0xBFF4
#define WMncSB_FINEPOSITION				0xBFFA
	//available w/ dependent arrow operations
#define WMncSB_DRAGLINEUP				0xBFF5
#define WMncSB_LINEUP					0xBFFB
#define WMncSB_DRAGLINEDOWN				0xBFF6
#define WMncSB_LINEDOWN					0xBFFC
	//available w/ independent arrow operations
#define WMncSB_I_DRAGLINEUP				0xBFF7
#define WMncSB_I_LINEUP					0xBFFD
#define WMncSB_I_DRAGLINEDOWN			0xBFF8
#define WMncSB_I_LINEDOWN				0xBFFE
#define WMncSB_DRAGOLDPOSITION			0xBFFF
	static char* sbmessage[]=
	{
		"0xBFF0 WMncSCROLLBAR",
		"0xBFF1 TRACKLEVELCHANGE",
		"0xBFF2 PROPTERTIESCHANGE",
		"0xBFF3 DRAGCOARSEPOSITION",
		"0xBFF4 DRAGFINEPOSITION",
		"0xBFF5 DRAGLINEUP",
		"0xBFF6 DRAGLINEDOWN",
		"0xBFF7 I_DRAGLINEUP",
		"0xBFF8 I_DRAGLINEDOWN",
		"0xBFF9 COARSEPOSITION",
		"0xBFFA FINEPOSITION",
		"0xBFFB LINEUP",
		"0xBFFC LINEDOWN",
		"0xBFFD I_LINEUP",
		"0xBFFE I_LINEDOWN",
		"0xBFFF DRAGOLDPOSITION"
	};

//STYLES
//Orientation Styles
#define ncSB_HORZ -1
#define ncSB_NONE 0
#define ncSB_VERT 1

//Suppressives
#define ncSB_UNDEFINED						0xFFFFFFFF
#define ncSB_ALLELEMENTS_SUPPRESS			0x0003FFFF
#define ncSB_TRACK_SUPPRESS					0x0000003F				
#define ncSB_TRACKCOARSE_SUPPRESS			0x00000007
#define ncSB_TRACKFINE_SUPPRESS				0x00000038

#define ncSB_ARROW_SUPPRESS					0x00000FC0
#define ncSB_ARROWMIN_SUPPRESS				0x000001C0
#define ncSB_ARROWMAX_SUPPRESS				0x00000E00

#define ncSB_TRACKTRACKER_SUPPRESS			0x0003F000
#define ncSB_TRACKCOARSETRACKER_SUPPRESS	0x00007000
#define ncSB_TRACKFINETRACKER_SUPPRESS		0x00038000

//Styles 
#define ncSB_TRACK_SPLIT					0x00300000
#define ncSB_TRACKCOARSE_SPLIT				0x00100000
#define ncSB_TRACKFINE_SPLIT				0x00200000

#define ncSB_TRACKCOARSETRACKER_FAR			0x00400000
#define ncSB_TRACKFINETRACKER_NEAR			0x00400000
#define ncSB_SYNCTRACKERSIZE				0x00800000

#define ncSB_TICKDRAW						0x03000000
#define ncSB_TICKCOARSEDRAW					0x01000000
#define ncSB_TICKFINEDRAW					0x02000000

#define ncSB_TICKCENTRAL					0x0C000000
#define ncSB_TICKCOARSECENTRAL				0x04000000
#define ncSB_TICKFINECENTRAL				0x08000000

#define ncSB_INDEPENDENTARROWOPER			0x10000000 //operation
#define ncSB_RADIX							0x20000000

//STATES
//CoarseTrack States
#define ncSB_TRACK_NORMAL					0x0000003F				

#define ncSB_TRACKCOARSE_NORMAL				0x00000007
#define ncSB_TRACKCOARSE_PUSHED				0x00000001
#define ncSB_TRACKCOARSE_DISABLED			0x00000002
#define ncSB_TRACKCOARSE_INVISIBLE			0x00000004

//FineTrack States
#define ncSB_TRACKFINE_NORMAL				0x00000038
#define ncSB_TRACKFINE_PUSHED				0x00000008
#define ncSB_TRACKFINE_DISABLED				0x00000010
#define ncSB_TRACKFINE_INVISIBLE			0x00000020

//ArrowMin States
#define ncSB_ARROW_NORMAL					0x00000FC0

#define ncSB_ARROWMIN_NORMAL				0x000001C0
#define ncSB_ARROWMIN_PUSHED				0x00000040
#define ncSB_ARROWMIN_DISABLED				0x00000080
#define ncSB_ARROWMIN_INVISIBLE				0x00000100
 
//ArrowMax States
#define ncSB_ARROWMAX_NORMAL				0x00000E00
#define ncSB_ARROWMAX_PUSHED				0x00000200
#define ncSB_ARROWMAX_DISABLED				0x00000400
#define ncSB_ARROWMAX_INVISIBLE				0x00000800

//CoarseTracker States
#define ncSB_TRACKER_NORMAL					0x0003F000

#define ncSB_TRACKCOARSETRACKER_NORMAL		0x00007000
#define ncSB_TRACKCOARSETRACKER_PUSHED		0x00001000
#define ncSB_TRACKCOARSETRACKER_DISABLED	0x00002000
#define ncSB_TRACKCOARSETRACKER_INVISIBLE	0x00004000

//FineTracker States
#define ncSB_TRACKFINETRACKER_NORMAL		0x00038000
#define ncSB_TRACKFINETRACKER_PUSHED		0x00008000
#define ncSB_TRACKFINETRACKER_DISABLED		0x00010000
#define ncSB_TRACKFINETRACKER_INVISIBLE		0x00020000

//ncScrollBar States
#define ncSB_NORMAL							0x000FFFFF
#define ncSB_DISABLED						0x00040000
#define ncSB_INVISIBLE						0x00080000
