/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class Edge {
    public static int fromCbptoCompound = 1;
    public static int fromCbptoEnzyme = 2;
    public static int fromCompoundToEnzyme = 4;
    public static int Kvazi = 256;
    int from;
    int to;
    int Flags;
    double len;

    public Edge() {
        this(-1, -1, -1.0, 0);
    }

    public Edge(int _from, int _to, double _len) {
        this(_from, _to, _len, 0);
    }

    public Edge(int _from, int _to, double _len, int _flags) {
        this.Flags = _flags;
        this.from = _from;
        this.to = _to;
        this.len = (int)_len;
    }

    public void accept(Edge e) {
        this.from = e.from;
        this.to = e.to;
        this.len = e.len;
        this.Flags = e.Flags;
    }

    void arrow(Graphics g, scNode n1, scNode n2, int gap) {
        int x = (int)(n1.x + n2.x) / 2;
        int y = (int)(n1.y + n2.y) / 2;
        double arrs = 1.2;
        double xf = n1.x;
        double yf = n1.y;
        double xt = n2.x;
        double yt = n2.y;
        double hhh = (double)sf.X * arrs * 0.5;
        double lll = (double)sf.X * arrs;
        int[] tx = new int[3];
        int[] ty = new int[3];
        double rx = xt - xf;
        double ry = yt - yf;
        double r = Math.sqrt(rx * rx + ry * ry);
        double sina = rx / r;
        double cosa = ry / r;
        int dy = (int)(hhh * sina);
        int dx = (int)(hhh * cosa);
        int ddx = (int)(lll * sina);
        int ddy = (int)(lll * cosa);
        tx[0] = x - ddx;
        ty[0] = y - ddy;
        tx[1] = x - dx;
        ty[1] = y + dy;
        tx[2] = x + dx;
        ty[2] = y - dy;
        g.drawLine(tx[0], ty[0], tx[1], ty[1]);
        g.drawLine(tx[0], ty[0], tx[2], ty[2]);
    }

    public static void fromString(String x, seGraph g) {
        StringTokenizer s = new StringTokenizer(x, "&\n", false);
        if (!s.nextToken().startsWith("EDGE")) {
            return;
        }
        int flags = Edge.getInt(s);
        int s_from = Edge.getInt(s);
        int s_to = Edge.getInt(s);
        int len = Edge.getInt(s);
        g.Edges.add(new Edge(s_from, s_to, len, flags));
    }

    public int getHashCode() {
        return Edge.getHashCode(this);
    }

    public static int getHashCode(int from, int to) {
        long hc = from + 32000 * to;
        if (hc > Integer.MAX_VALUE) {
            hc %= Integer.MAX_VALUE;
        }
        return (int)hc;
    }

    public static int getHashCode(Edge ex) {
        return Edge.getHashCode(ex.from, ex.to);
    }

    public static int getInt(StringTokenizer s) {
        String x = null;
        try {
            if (s.hasMoreTokens()) {
                x = s.nextToken().trim();
                return Integer.parseInt(x);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("n.f.e. in Edge getInt '" + x + "'");
        }
        return -1;
    }

    public int hashCode() {
        return Edge.getHashCode(this.from, this.to);
    }

    void line(Graphics g, scNode n1, scNode n2) {
        g.drawLine((int)n1.x, (int)n1.y, (int)n2.x, (int)n2.y);
    }

    public void paint(Graphics g, scNode n1, scNode n2) {
        if (this.yr(Kvazi)) {
            return;
        }
        if (this.yr(fromCbptoCompound)) {
            g.setColor(Color.green.darker().darker());
            this.arrow(g, n1, n2, sf.X);
        } else if (this.yr(fromCbptoEnzyme)) {
            g.setColor(Color.blue.darker());
            this.substrate(g, n1, n2, sf.X);
        } else {
            g.setColor(Color.red.darker());
        }
        this.line(g, n1, n2);
    }

    void substrate(Graphics g, scNode n2, scNode n1, int gap) {
        int x = (int)(n1.x + n2.x) / 2;
        int y = (int)(n1.y + n2.y) / 2;
        double arrs = 1.2;
        double xf = n1.x;
        double yf = n1.y;
        double xt = n2.x;
        double yt = n2.y;
        double hhh = (double)sf.X * arrs * 0.5;
        double lll = (double)sf.X * arrs;
        int[] tx = new int[3];
        int[] ty = new int[3];
        double rx = xt - xf;
        double ry = yt - yf;
        double r = Math.sqrt(rx * rx + ry * ry);
        double sina = rx / r;
        double cosa = ry / r;
        int dy = (int)(hhh * sina);
        int dx = (int)(hhh * cosa);
        int ddx = (int)(lll * sina);
        int ddy = (int)(lll * cosa);
        tx[0] = x - ddx;
        ty[0] = y - ddy;
        tx[1] = x - dx;
        ty[1] = y + dy;
        tx[2] = x + dx;
        ty[2] = y - dy;
        g.fillPolygon(tx, ty, 3);
    }

    public String toString(seGraph g) {
        int ilen = (int)this.len;
        if (ilen <= 0) {
            ilen = g.Unit;
        }
        return "EDGE &" + this.Flags + "&" + this.from + "&" + this.to + "&" + ilen;
    }

    boolean yr(int flag) {
        return (this.Flags & flag) != 0;
    }
}

