
library RIPPlug;

uses
  Windows, SysUtils;

{
  --------------------------------
  PlugIn system for RIPcoder v1.00
  --------------------------------

  You can build your plugins for use it in RIPcoder.
  This example is "simple XOR-32" method which works with 32bits key.
  It's just a demo of "how to make plugin for RIPcoder".

  (!) DON'T USE THIS METHOD FOR DATA ENCRYPTION!
}

const
 PlugName 	  = 'Simple XOR-32';
 PlugVersion 	  = '1.0';

var
 key32	: integer;

function PlugIn_Name: pchar; stdcall;
begin
 result := PlugName;
end;

function PlugIn_Version: pchar; stdcall;
begin
 result := PlugVersion;
end;

{
  RIPcoder install plugin by calling "pg_InitPlugIn"
}
function pg_InitPlugIn: bool; stdcall;
begin
 { this is place for initialization }
 result := true;
end;

{
  RIPcoder uninstall plugin by calling "pg_ClosePlugIn"
}
procedure pg_ClosePlugIn; stdcall;
begin
 { this is place for finalization }
end;

{
  RIPcoder send password for plugin.
  Password sends each time before encryption/decryption.
}
procedure pg_GetPassword(ipwd: pchar); stdcall;
var
 i,j	: integer;
begin
 key32 := 0;
 for i := 0 to strlen(ipwd)-1 do
  begin
  key32 := (key32 shl 4)+pbytearray(ipwd)[i];
  j := key32 and $F0000000;
  if j<>0 then key32 := key32 xor (j shr 24);
  key32 := key32 and not j;
  end;
end;

{
  RIPcoder gives plugin to work with source data divided by
  many blocks, block size may differ
}

procedure pg_EncodeBlock(var bf: array of byte;count: dword); stdcall;
var
 i,j	: integer;
 sb	: byte;
begin
 j := 0;
 for i:=0 to count-1 do
  begin
  sb := bf[i];
  bf[i] := sb xor pbytearray(@key32)^[j];
  pbytearray(@key32)^[j] := pbytearray(@key32)^[j] xor sb;
  inc(j); if j=4 then j := 0;
  end;
end;

procedure pg_DecodeBlock(var bf: array of byte;count: dword); stdcall;
var
 i,j	: integer;
begin
 j := 0;
 for i:=0 to count-1 do
  begin
  bf[i] := bf[i] xor pbytearray(@key32)^[j];
  pbytearray(@key32)^[j] := pbytearray(@key32)^[j] xor bf[i];
  inc(j); if j=4 then j := 0;
  end;
end;

exports
 PlugIn_Name,
 PlugIn_Version,
 pg_InitPlugIn,
 pg_ClosePlugIn,
 pg_GetPassword,
 pg_EncodeBlock,
 pg_DecodeBlock;

end.