/*
 * Decompiled with CFR 0.152.
 */
package com.webforte.cid;

import com.webforte.cid.CIDCall;
import com.webforte.cid.CIDConfig;
import com.webforte.cid.CIDUserInterface;
import com.webforte.cid.CallerIDMonitor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TooManyListenersException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class CIDManager
implements Runnable,
SerialPortEventListener,
ActionListener {
    static CommPortIdentifier portId;
    static Enumeration portList;
    InputStream inputStream;
    OutputStream outputStream;
    SerialPort serialPort;
    Thread readThread;
    byte[] readBuffer = new byte[80];
    int waitInSeconds = 1;
    int ringCount = 0;
    int fieldsRead = 0;
    int off = 0;
    ArrayList calls = new ArrayList();
    CIDCall call = new CIDCall();
    CIDConfig config;
    byte[] answerCall = new byte[]{65, 84, 72, 49, 13};
    byte[] hangUp = new byte[]{65, 84, 72, 48, 13};
    byte[] resetModem = new byte[]{65, 84, 90, 13};
    byte[] cid1 = new byte[]{65, 84, 35, 67, 73, 68, 61, 49, 13};
    byte[] cid1b = new byte[]{65, 84, 35, 67, 76, 83, 61, 56, 35, 67, 73, 68, 61, 49, 13};
    byte[] cid2 = new byte[]{65, 84, 43, 86, 67, 73, 68, 61, 49, 13};
    byte[] cid3 = new byte[]{65, 84, 35, 67, 67, 49, 13};
    byte[] cid4 = new byte[]{65, 84, 42, 73, 68, 49, 13};
    byte[] cid5 = new byte[]{65, 84, 37, 67, 67, 73, 68, 61, 49, 13};
    byte[] cid6 = new byte[]{65, 84, 35, 67, 76, 83, 61, 56, 35, 67, 73, 68, 61, 49, 13};
    boolean okFlag = false;
    CIDUserInterface ui;
    int prevMinute = -1;
    int prevNumber = -2;
    boolean notInUse = false;

    public CIDManager(CommPortIdentifier commPortIdentifier, CIDUserInterface cIDUserInterface) {
        this.ui = cIDUserInterface;
        this.ui.getPopupMenu().addActionListener(this);
        portId = commPortIdentifier;
        this.config = CIDConfig.getInstance();
        this.config.installUI();
        this.readStoredCalls();
        this.ui.setManager(this);
        ((Component)this.ui).setSize(CIDUserInterface.sizeX, CIDUserInterface.sizeY);
        ((Component)CallerIDMonitor.s).setVisible(false);
        ((Component)this.ui).setVisible(true);
        this.startModem();
    }

    private void aboutCID() {
        CIDUserInterface.setLF();
        CIDUserInterface.aboutDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.compareTo("About VirtualCID") == 0) {
            this.aboutCID();
        } else if (string.compareTo("Stop Using Modem") == 0) {
            this.stopModem();
        } else if (string.compareTo("Start Using Modem") == 0) {
            this.startModem();
        } else if (string.compareTo("Save Calls") == 0) {
            this.saveCalls();
        } else if (string.compareTo("Delete All Calls") == 0) {
            this.deleteCalls();
        } else if (string.compareTo("Exit") == 0) {
            CIDUserInterface.setLF();
            int n = CIDUserInterface.confirmationDialog("Exit", "Are you sure you want to exit?");
            switch (n) {
                case 0: {
                    this.saveCalls();
                    System.exit(0);
                    break;
                }
                case 1: {
                    System.exit(0);
                    break;
                }
            }
        }
    }

    private void addCall(CIDCall cIDCall) {
        if (this.calls.size() == 999) {
            this.calls.remove(0);
        }
        this.calls.add(cIDCall);
        this.ui.newCall();
        this.ui.setCallNumber(this.calls.size());
        this.displayCall((CIDCall)this.calls.get(this.calls.size() - 1));
    }

    protected void deleteCall(int n) {
        if (n != 0 & n != -1) {
            if (n == this.calls.size()) {
                this.calls.remove(n - 1);
                if (this.calls.size() > 0) {
                    this.ui.setCallNumber(this.calls.size());
                    this.displayCall((CIDCall)this.calls.get(this.calls.size() - 1));
                } else {
                    this.ui.setCallNumber(-1);
                    this.ui.paint(this.ui.getGraphics());
                }
            } else {
                this.calls.remove(n - 1);
                this.displayCall((CIDCall)this.calls.get(n - 1));
            }
        }
    }

    private void deleteCalls() {
        this.calls = new ArrayList();
        this.ui.setCallNumber(-1);
        this.ui.paint(this.ui.getGraphics());
    }

    private void displayCall(CIDCall cIDCall) {
        this.ui.setDateText(cIDCall.getFormattedDate());
        this.ui.setTimeText(cIDCall.getFormattedTime());
        this.ui.setNumberText(cIDCall.getFormattedNumber());
        this.ui.setMeridianText(cIDCall.getMeridian());
        this.ui.setNameText(cIDCall.getName());
        this.ui.paint(this.ui.getGraphics());
    }

    private void hangUpCurrentCall() {
        block5: {
            if (!this.ui.getBoxIsOn()) break block5;
            try {
                this.outputStream.write(this.answerCall);
            }
            catch (IOException iOException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while communicationg with the modem.\nThis application will now exit.");
                System.exit(0);
            }
            int n = Calendar.getInstance().get(13);
            int n2 = Calendar.getInstance().get(13);
            while (n + this.waitInSeconds > n2) {
                n2 = Calendar.getInstance().get(13);
            }
            try {
                this.outputStream.write(this.hangUp);
            }
            catch (IOException iOException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while communicationg with the modem.\nThis application will now exit.");
                System.exit(0);
            }
        }
    }

    private void modemWrite(byte[] byArray) {
        try {
            this.outputStream.write(byArray);
            int n = Calendar.getInstance().get(13);
            int n2 = Calendar.getInstance().get(13);
            while (n + this.waitInSeconds > n2) {
                n2 = Calendar.getInstance().get(13);
            }
        }
        catch (IOException iOException) {
            CIDUserInterface.setLF();
            CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while communicationg with the modem.\nThis application will now exit.");
            System.exit(0);
        }
    }

    protected void nextCall(int n) {
        if (++n > this.calls.size()) {
            this.ui.setCallNumber(-1);
            this.ui.paint(this.ui.getGraphics());
        } else if (n == 0 & this.calls.size() > 0) {
            this.ui.setCallNumber(n + 1);
            this.displayCall((CIDCall)this.calls.get(n));
        } else if (n == 0) {
            this.ui.setCallNumber(-1);
            this.ui.paint(this.ui.getGraphics());
        } else {
            this.ui.setCallNumber(n);
            this.displayCall((CIDCall)this.calls.get(n - 1));
        }
    }

    protected void previousCall(int n) {
        if (--n < 1 & n != 0) {
            n = this.calls.size();
        }
        if (n != 0) {
            this.ui.setCallNumber(n);
            this.displayCall((CIDCall)this.calls.get(n - 1));
        } else {
            this.ui.setCallNumber(-1);
            this.ui.paint(this.ui.getGraphics());
        }
    }

    private void readStoredCalls() {
        block2: {
            if (!this.config.getStoreFile().exists()) break block2;
            try {
                ZipFile zipFile = new ZipFile(this.config.getStoreFile());
                ObjectInputStream objectInputStream = new ObjectInputStream(zipFile.getInputStream(zipFile.getEntry("vcid.cl")));
                this.calls = (ArrayList)objectInputStream.readObject();
            }
            catch (Exception exception) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while attempting to read call information from file " + this.config.getStoreFile().getName());
                this.calls = new ArrayList();
            }
        }
    }

    private void resetModem() {
        if (this.ui.getBoxIsOn()) {
            this.modemWrite(this.resetModem);
            this.okFlag = false;
            this.modemWrite(this.cid1);
            if (!this.okFlag) {
                this.modemWrite(this.cid2);
                if (!this.okFlag) {
                    this.modemWrite(this.cid3);
                    if (!this.okFlag) {
                        this.modemWrite(this.cid4);
                        if (!this.okFlag) {
                            this.modemWrite(this.cid5);
                            if (!this.okFlag) {
                                this.modemWrite(this.cid6);
                                if (!this.okFlag) {
                                    CIDUserInterface.setLF();
                                    CIDUserInterface.warningDialog("No Caller ID", "Your modem does not appear to be Caller ID capable.\nIf you believe this to be an error please email the make and model of your modem,\nplus the Caller ID command string that enables this feature on your modem to:\nbeta@webforte.com");
                                    this.stopModem();
                                    this.ui.getPopupMenu().remove(2);
                                }
                            }
                        }
                    }
                }
            } else {
                this.modemWrite(this.cid1b);
            }
        }
    }

    public void run() {
        this.setDateTime();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                    if (this.ui.getCallNumber() == this.prevNumber & (this.notInUse ^ true) & this.ui.getCallNumber() != 0) {
                        this.notInUse = true;
                        continue;
                    }
                    if (this.ui.getCallNumber() == this.prevNumber & this.notInUse & this.ui.getCallNumber() != 0) {
                        this.notInUse = false;
                        this.prevMinute = -1;
                        this.ui.setNameText("");
                        this.ui.setCallNumber(0);
                        this.ui.paint(this.ui.getGraphics());
                    } else if (this.ui.getCallNumber() != this.prevNumber) {
                        this.prevNumber = this.ui.getCallNumber();
                    }
                    if (this.ui.getCallNumber() >= 1) continue;
                    this.setDateTime();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void saveCalls() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.config.getStoreFile());
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("vcid.cl"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            objectOutputStream.writeObject(this.calls);
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            CIDUserInterface.setLF();
            CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while attempting to write call information to file " + this.config.getStoreFile().getName());
        }
    }

    private void screenCallFor(String string) {
        Iterator iterator = ((AbstractList)this.config.getForbiddenNumbers()).iterator();
        boolean bl = true;
        while (iterator.hasNext() & bl) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) == -1) continue;
            this.hangUpCurrentCall();
            bl = false;
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        int n = this.inputStream.read();
                        if (n == 13) {
                            String string = new String(this.readBuffer);
                            if ((string = string.trim()).compareTo("RING") == 0) {
                                ++this.ringCount;
                                if (this.ringCount == 2 & this.fieldsRead == 3) {
                                    this.addCall(this.call);
                                }
                            }
                            this.okFlag = string.compareTo("OK") == 0;
                            if (string.indexOf(61) != -1) {
                                if (this.fieldsRead == 0) {
                                    this.ringCount = 1;
                                    this.call = new CIDCall();
                                }
                                if (string.indexOf(68) == 0) {
                                    this.call.setDate(String.valueOf(string.substring(string.indexOf(61) + 1).trim()) + Calendar.getInstance().get(1));
                                    ++this.fieldsRead;
                                }
                                if (string.indexOf(84) == 0) {
                                    this.call.setTime(string.substring(string.indexOf(61) + 1).trim());
                                    ++this.fieldsRead;
                                }
                                if (string.indexOf(78) == 0) {
                                    if (string.indexOf(65) == 1) {
                                        this.call.setName(string.substring(string.indexOf(61) + 1).trim());
                                        ++this.fieldsRead;
                                    } else {
                                        this.call.setNumber(string.substring(string.indexOf(61) + 1).trim());
                                        ++this.fieldsRead;
                                    }
                                }
                            }
                            this.screenCallFor(this.call.getNumber());
                            this.off = 0;
                            this.readBuffer = new byte[80];
                            if (this.fieldsRead == 4) {
                                this.addCall(this.call);
                                this.fieldsRead = 0;
                            }
                        }
                        this.readBuffer[this.off] = (byte)n;
                        ++this.off;
                    }
                }
                catch (IOException iOException) {
                    CIDUserInterface.setLF();
                    CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while communicationg with the modem.\nThis application will now exit.");
                    System.exit(0);
                }
                break;
            }
        }
    }

    private void setDateTime() {
        int n = Calendar.getInstance().get(12);
        if (n != this.prevMinute) {
            int n2 = Calendar.getInstance().get(10);
            int n3 = Calendar.getInstance().get(5);
            int n4 = Calendar.getInstance().get(2) + 1;
            int n5 = Calendar.getInstance().get(1);
            if (n2 == 0) {
                n2 = 12;
            }
            String string = n < 10 ? "0" + n : String.valueOf(n);
            String string2 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
            String string3 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
            this.prevMinute = n;
            this.ui.setTimeText(String.valueOf(n2) + ":" + string);
            this.ui.setDateText(String.valueOf(string3) + "/" + string2 + "/" + n5);
            if (Calendar.getInstance().get(9) == 0) {
                this.ui.setMeridianText("AM");
            } else {
                this.ui.setMeridianText("PM");
            }
            this.ui.paint(this.ui.getGraphics());
        }
    }

    private void startModem() {
        boolean bl = false;
        try {
            this.serialPort = (SerialPort)portId.open("CIDMRead", 2000);
        }
        catch (PortInUseException portInUseException) {
            CIDUserInterface.setLF();
            CIDUserInterface.warningDialog("Modem in use", "The modem appears to be in use.\nPlease close any applications that are using the modem.");
            this.stopModem();
            bl = true;
        }
        if (!bl) {
            try {
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream = this.serialPort.getOutputStream();
            }
            catch (IOException iOException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while establishing a link with the modem.\nThis application will now exit.");
                System.exit(0);
            }
            try {
                this.serialPort.addEventListener((SerialPortEventListener)this);
            }
            catch (TooManyListenersException tooManyListenersException) {}
            this.serialPort.notifyOnDataAvailable(true);
            try {
                this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("I/O Error", "An I/O Error has occured while establishing a link with the modem.\nThis application will now exit.");
                System.exit(0);
            }
            this.ui.setBoxIsOn(true);
            this.ui.getPopupMenu().remove(2);
            this.ui.getPopupMenu().insert("Stop Using Modem", 2);
            this.ui.paint(this.ui.getGraphics());
            this.resetModem();
        }
        this.readThread = new Thread(this);
        this.readThread.start();
    }

    private void stopModem() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        this.ui.setBoxIsOn(false);
        this.ui.getPopupMenu().remove(2);
        this.ui.getPopupMenu().insert("Start Using Modem", 2);
        this.ui.paint(this.ui.getGraphics());
    }
}

