// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : pad.c
// Description  : A filter that pads whitespace to create a fixed
//                width record for each line in a stream.
//
//                Useful for padding-out a flatfile with trailing blanks.
//                Also truncates if record is too long...
//
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

#define BUF_MAX  8192
#define BUF_SIZE (BUF_MAX + 1)

char cbuf[BUF_SIZE] = "\0";

void pad(char *ptr, int len)
{
  int idx;

  // spacefill
  for (idx = 0; idx < len; idx++)ptr[idx] = ' ';
  // terminate
  ptr[len] = 0;
}

void main(int argc, char **argv)
{
    int c, cnt = 0, idx, padlen = 0;
    FILE *fp = NULL;

    if (argc > 1) {
      for (idx = 1; idx < argc; idx++) {
        if (NULL != fp) {
          if (padlen == 0)
            padlen = atoi(argv[idx]);
        }
        else {
          fp = fopen(argv[idx], "r");
          if (NULL == fp && padlen == 0)
            padlen = atoi(argv[idx]);
        }
      }
    }
    if (padlen < 1 || padlen > BUF_SIZE)
      padlen = 80;   // pad to 80 chars by default...

    pad(cbuf, padlen);

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;
      if (c=='\r')continue;

      if (c == '\n') {
        for (idx = 0; idx < padlen; idx++)
          putchar(cbuf[idx]);

        putchar('\n');
        cnt = 0;
        pad(cbuf, padlen); // setup for next pass...
        continue;
      }

      if (cnt < padlen)
        cbuf[cnt] = c;
      cnt++;
    }
    if (cnt > 0) {
        for (idx = 0; idx < padlen; idx++)
          putchar(cbuf[idx]);
        putchar('\n');
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
