// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : strip.c
// Description  : A filter that creates a comments only file from
//                c source code in a file or a stream.
//                Useful for stripping multiple files when used
//                in a stream created with the ffeed (filter feed) program.
//
// Written by   : Bill Buckels
// Date Written : 1989
// Revision     : 2.0 - March 2000
// Errata       : Does not handle nested comments.
//                Does not handle comments in quotes.
// ------------------------------------------------------------------------

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>

int mygetc(FILE *fp)
{
  if (NULL == fp)
    return getchar();
      else
  return fgetc(fp);
}

void main(int argc,char **argv)
{
    int c, d = 0;

    FILE *fp = NULL;

    if (argc > 1) {
      fp = fopen(argv[1],"r");
      if (NULL == fp) {
        puts("STRIP(C) CopyLeft Bill Buckels 1989-2000. All Rights Reversed.");
        puts("A simple C Comment Stripper...");
        puts("Usage is \"strip [myprog.c]\"");
        puts("- Or -   \"ffeed *.c | strip > myfiltered.txt\"");
        exit(1);
      }
    }

    NOWRITE:
      /* silent mode unless comments are found */
      c = mygetc(fp);
      if (c == EOF) goto ENDLOOP;

      /* check for c and c++ comments */
      if (d=='/' && c == '*')goto YESWRITE;
      if (d=='/' && c == '/')goto YESPLUS;
      d = c;
    goto NOWRITE;

    YESPLUS:
      /* c++ comments */
      putchar('/');
      putchar('/');
    PLUSLOOP :
      c = mygetc(fp);
      if (c == EOF) goto ENDLOOP;
      putchar(c);
      d = c;
      if (c == '\n') goto NOWRITE;   /* end of line - silent again */
    goto PLUSLOOP;

    YESWRITE:
      /* c comments */
      putchar('/');
      putchar('*');
    YESLOOP :
      c = mygetc(fp);
      if (c == EOF) goto ENDLOOP;
      putchar(c);
      if (d=='*' && c == '/') {
        putchar('\n');
        goto NOWRITE; /* silent again */
      }
      d = c;
    goto YESLOOP;

    ENDLOOP:
      if (NULL != fp) {
        fclose(fp);
        exit(0);
      }
}
