/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBLabelSupport;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.ImageFileFilter;
import com.borland.dbswing.ImagePreviewer;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.plaf.UIResource;

public class DBLabelDataBinder
implements PropertyChangeListener,
AccessListener,
DataChangeListener,
NavigationListener,
ColumnAware,
Designable,
MouseListener,
Serializable {
    private JLabel label;
    private JLabel oldLabel;
    private DBLabelSupport labelSupport = new DBLabelSupport(this);
    private boolean iconEditable = false;
    private JFileChooser fileChooser;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public DBLabelDataBinder() {
    }

    public DBLabelDataBinder(JLabel label) {
        this.setJLabel(label);
    }

    public void setJLabel(JLabel label) {
        if (this.label != null && this.label != label) {
            this.label.removePropertyChangeListener(this);
            this.label.removeMouseListener(this);
        }
        this.label = label;
        if (label != null) {
            label.addPropertyChangeListener(this);
        }
        this.bindColumnProperties();
    }

    public JLabel getJLabel() {
        return this.label;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.labelSupport.dataSet != null) {
            this.labelSupport.dataSet.removeNavigationListener(this);
        }
        this.labelSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.labelSupport.dataSet.addNavigationListener(this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.labelSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.labelSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.labelSupport.columnName;
    }

    public void setColumnNameIcon(String columnNameIcon) {
        this.labelSupport.setColumnNameIcon(columnNameIcon);
        this.bindColumnProperties();
    }

    public String getColumnNameIcon() {
        return this.labelSupport.columnNameIcon;
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
    }

    public void putIcon(InputStream inputStream) {
        try {
            if (this.canPutIcon()) {
                this.labelSupport.putIcon(inputStream);
            }
        }
        catch (DataSetException e2) {
            DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, e2);
        }
    }

    private boolean canPutIcon() throws DataSetException {
        return this.labelSupport.isValidDataSetState() && this.labelSupport.columnOrdinalIcon != -1 && this.labelSupport.dataSet.getColumn(this.labelSupport.columnNameIcon).isEditable();
    }

    private void updateLabelDisplay() {
        if (this.labelSupport.isValidDataSetState()) {
            if (this.labelSupport.columnOrdinal != -1) {
                this.label.setText(this.labelSupport.getFormattedString());
            }
            if (this.labelSupport.columnOrdinalIcon != -1) {
                this.label.setIcon(this.labelSupport.getIcon());
            }
        }
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateLabelDisplay();
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.labelSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateLabelDisplay();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldLabel != null) {
            DBRuntimeSupport.getInstance().removeComponent(this.oldLabel);
            this.oldLabel = null;
        }
        if (this.label != null && this.label.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.labelSupport.lazyOpen();
            this.updateLabelDisplay();
            if (this.labelSupport.isValidDataSetState()) {
                DBRuntimeSupport.getInstance().addComponent(this.label, this);
                this.oldLabel = this.label;
                if (this.labelSupport.columnOrdinal != -1) {
                    Column column = this.labelSupport.getColumn();
                    if (this.label.getHorizontalAlignment() == 2) {
                        this.label.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), true));
                    }
                    if (this.label.getVerticalAlignment() == 0) {
                        this.label.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), false));
                    }
                    if (this.isDefaultProperty(this.label.getBackground()) && column.getBackground() != null) {
                        this.label.setBackground(column.getBackground());
                    }
                    if (this.isDefaultProperty(this.label.getForeground()) && column.getForeground() != null) {
                        this.label.setForeground(column.getForeground());
                    }
                    if (this.isDefaultProperty(this.label.getFont()) && column.getFont() != null) {
                        this.label.setFont(column.getFont());
                    }
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            } else {
                this.updateLabelDisplay();
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }

    public void setIconEditable(boolean iconEditable) {
        if (this.iconEditable != iconEditable) {
            this.iconEditable = iconEditable;
            if (iconEditable) {
                if (this.label != null) {
                    this.label.addMouseListener(this);
                }
            } else if (this.label != null) {
                this.label.removeMouseListener(this);
            }
        }
    }

    public boolean isIconEditable() {
        return this.iconEditable;
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClicked(MouseEvent e2) {
        try {
            if (e2.getClickCount() != 2 || !this.iconEditable) return;
            if (this.fileChooser == null) {
                Frame frame = DBUtilities.getFrame(this.label);
                frame.setCursor(Cursor.getPredefinedCursor(3));
                this.fileChooser = new JFileChooser();
                this.fileChooser.setAccessory(new ImagePreviewer(this.fileChooser, frame));
                this.fileChooser.setMultiSelectionEnabled(false);
                this.fileChooser.resetChoosableFileFilters();
                ImageFileFilter fileFilter = new ImageFileFilter();
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setFileFilter(fileFilter);
                this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
                this.fileChooser.setApproveButtonText(Res.bundle.getString(0));
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.fileChooser.showOpenDialog(this.label) != 0) return;
            File file = this.fileChooser.getSelectedFile();
            if (file != null && file.exists()) {
                BufferedInputStream inputStream;
                Frame frame;
                block17: {
                    frame = DBUtilities.getFrame(this.label);
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    inputStream = null;
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    boolean bmpFile = DBUtilities.isBMPFile(inputStream);
                    if (bmpFile || DBUtilities.isGIForJPGFile(inputStream)) {
                        if (this.canPutIcon()) {
                            this.labelSupport.putIcon(inputStream);
                        } else if (bmpFile) {
                            this.label.setIcon(new ImageIcon(DBUtilities.makeBMPImage(inputStream)));
                        } else {
                            this.label.setIcon(new ImageIcon(file.getCanonicalPath()));
                        }
                        break block17;
                    }
                    JOptionPane.showMessageDialog(this.label, Res.bundle.getString(2), null, 1);
                }
                Object var7_8 = null;
                frame.setCursor(Cursor.getPredefinedCursor(0));
                if (inputStream == null) return;
                try {
                    ((InputStream)inputStream).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
                {
                    catch (Exception ex) {
                        DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, ex);
                        Object var7_9 = null;
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        if (inputStream == null) return;
                        try {
                            ((InputStream)inputStream).close();
                            return;
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    if (inputStream == null) throw throwable;
                    try {
                        ((InputStream)inputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            JOptionPane.showMessageDialog(this.label, Res.bundle.getString(75), "", 0);
            this.label.repaint();
            return;
        }
        catch (Exception ex) {
            DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, ex);
        }
    }
}

