/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

class TableScrollPaneLayout
extends ScrollPaneLayout {
    TableScrollPaneLayout() {
    }

    public void addLayoutComponent(String s2, Component c2) {
        if (s2.equals("VIEWPORT")) {
            this.viewport = (JViewport)this.addSingletonComponent(this.viewport, c2);
        } else if (s2.equals("VERTICAL_SCROLLBAR")) {
            this.vsb = (JScrollBar)this.addSingletonComponent(this.vsb, c2);
        } else if (s2.equals("HORIZONTAL_SCROLLBAR")) {
            this.hsb = (JScrollBar)this.addSingletonComponent(this.hsb, c2);
        } else if (s2.equals("ROW_HEADER")) {
            this.rowHead = (JViewport)this.addSingletonComponent(this.rowHead, c2);
        } else if (s2.equals("COLUMN_HEADER")) {
            this.colHead = (JViewport)this.addSingletonComponent(this.colHead, c2);
        } else if (s2.equals("LOWER_RIGHT_CORNER")) {
            this.lowerRight = this.addSingletonComponent(this.lowerRight, c2);
        } else if (s2.equals("UPPER_LEFT_CORNER")) {
            this.upperLeft = this.addSingletonComponent(this.upperLeft, c2);
        } else {
            throw new IllegalArgumentException("invalid layout key ".concat(String.valueOf(s2)));
        }
    }

    public void layoutContainer(Container parent) {
        boolean hsbNeeded;
        boolean vsbNeeded;
        Insets vpbInsets;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = new Rectangle(scrollPane.getSize());
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = this.colHead.getPreferredSize().height;
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(availR.x, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth;
            rowHeadR.width = rowHeadWidth = this.rowHead.getPreferredSize().width;
            availR.x += rowHeadWidth;
            availR.width -= rowHeadWidth;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        colHeadR.x = availR.x;
        rowHeadR.y = availR.y;
        Component view = this.viewport != null ? this.viewport.getView() : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        if (view instanceof Scrollable) {
            Scrollable sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        }
        Rectangle vsbR = new Rectangle(0, colHeadR.y, 0, 0);
        if (this.vsbPolicy == 22) {
            vsbNeeded = true;
        } else if (this.vsbPolicy == 21) {
            vsbNeeded = false;
        } else {
            boolean bl = vsbNeeded = !viewTracksViewportHeight && viewPrefSize.height > extentSize.height;
        }
        if (this.vsb != null && vsbNeeded) {
            int vsbWidth = this.vsb.getPreferredSize().width;
            availR.width -= vsbWidth;
            vsbR.x = availR.x + availR.width + vpbInsets.right;
            vsbR.width = vsbWidth;
        }
        Rectangle hsbR = new Rectangle(rowHeadR.x, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            hsbNeeded = true;
        } else if (this.hsbPolicy == 31) {
            hsbNeeded = false;
        } else {
            boolean bl = hsbNeeded = !viewTracksViewportWidth && viewPrefSize.width > extentSize.width;
        }
        if (this.hsb != null && hsbNeeded) {
            int hsbHeight = this.hsb.getPreferredSize().height;
            availR.height -= hsbHeight;
            hsbR.y = availR.y + availR.height + vpbInsets.bottom;
            hsbR.height = hsbHeight;
            if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean bl = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (vsbNeeded) {
                    int vsbWidth = this.vsb.getPreferredSize().width;
                    availR.width -= vsbWidth;
                    vsbR.x = availR.x + availR.width + vpbInsets.right;
                    vsbR.width = vsbWidth;
                }
            }
        }
        vsbR.height = availR.height + vpbInsets.top + vpbInsets.bottom + colHeadR.height;
        hsbR.width = availR.width + vpbInsets.left + vpbInsets.right + rowHeadR.width;
        rowHeadR.height = availR.height;
        colHeadR.width = availR.width;
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(rowHeadR);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(colHeadR);
        }
        if (this.vsb != null) {
            if (vsbNeeded) {
                this.vsb.setVisible(true);
                this.vsb.setBounds(vsbR);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (hsbNeeded) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(hsbR);
            } else {
                this.hsb.setVisible(false);
            }
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(0, 0, 0, 0);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(vsbR.x, hsbR.y, vsbR.width, hsbR.height);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(0, 0, 0, 0);
        }
    }
}

