// SnapshotDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Snapshot.h"
#include "SnapshotDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnapshotDlg dialog

CSnapshotDlg::CSnapshotDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSnapshotDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnapshotDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSnapshotDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnapshotDlg)
	DDX_Control(pDX, IDC_CBOVIDEOINPUT, m_CboVideoInput);
	DDX_Control(pDX, IDC_PICSTATIC, m_Pic);
	DDX_Control(pDX, IDC_COMBO1, m_CboVideoFormat);
	DDX_Control(pDX, IDC_VIDEOCAPCTRL1, m_VideoCap1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSnapshotDlg, CDialog)
	//{{AFX_MSG_MAP(CSnapshotDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNPREVIEW, OnBtnpreview)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnapshotDlg message handlers

BOOL CSnapshotDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	int iVideoInputCount= m_VideoCap1.GetVideoInputs().GetCount();
	CString strVideoInput;
	int i;

	for(i=0; i <iVideoInputCount;i++)
	{

		strVideoInput=m_VideoCap1.GetVideoInputs().FindVideoInputName(i);
		m_CboVideoInput.AddString(strVideoInput);
	}

	if(m_CboVideoInput.GetCount()>0)
		m_CboVideoInput.SetCurSel(0);

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSnapshotDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSnapshotDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSnapshotDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSnapshotDlg::OnBtnpreview() 
{
	// TODO: Add your control notification handler code here

	CString strVideoInput;
	m_CboVideoInput.GetLBText(m_CboVideoInput.GetCurSel(),strVideoInput);
	int iVideoInputIndex =m_VideoCap1.GetVideoInputs().FindVideoInput(strVideoInput);
	
	
	if(iVideoInputIndex != -1)
		m_VideoCap1.SetVideoInput(iVideoInputIndex);	


	//////////// videformat 
	int iVideoFormatCount= m_VideoCap1.GetVideoFormats().GetCount();


	for(int i=0;i < iVideoFormatCount;i++)
	{

		CString str=m_VideoCap1.GetVideoFormats().FindVideoFormatName(i);

		m_CboVideoFormat.AddString(str);
	}

	if(m_CboVideoFormat.GetCount()>0)
		m_CboVideoFormat.SetCurSel(0);

	m_VideoCap1.Start();


	//m_Pic.

}

void CSnapshotDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	TCHAR cAppPath[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, cAppPath);
	CString strPath=CString(cAppPath) ;

	CString strfile=strPath+"\\test.bmp";

	BOOL b=m_VideoCap1.SnapShot(strfile);

	m_Pic.SetImgFile(strfile);
	Invalidate();


	
}

void CSnapshotDlg::OnSelchangeCombo1() 
{
	// TODO: Add your control notification handler code here

	CString str;
	int iVideoFormat;
	int iSel=m_CboVideoFormat.GetCurSel();

	m_CboVideoFormat.GetLBText(iSel,str);
	iVideoFormat=m_VideoCap1.GetVideoFormats().FindVideoFormat(str);
	m_VideoCap1.SetVideoFormat(iVideoFormat);
	m_VideoCap1.Start();
	
	
}

BOOL CSnapshotDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rc;
	GetDlgItem(IDC_VIDEOCAPCTRL1)->GetWindowRect(rc);
	ScreenToClient(rc);

    pDC->ExcludeClipRect(&rc);


	return CDialog::OnEraseBkgnd(pDC);
}
