VERSION 5.00
Begin VB.Form fmMain 
   Caption         =   "PatternPro Scanner Demo"
   ClientHeight    =   6135
   ClientLeft      =   1635
   ClientTop       =   2310
   ClientWidth     =   8865
   Icon            =   "fmScanDemo.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6135
   ScaleWidth      =   8865
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   615
      Left            =   6840
      TabIndex        =   5
      Top             =   5400
      Width           =   1935
   End
   Begin VB.Frame frList 
      Caption         =   "List Input"
      Height          =   3135
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   8655
      Begin VB.TextBox txtList 
         Height          =   2775
         Left            =   120
         MultiLine       =   -1  'True
         TabIndex        =   2
         Text            =   "fmScanDemo.frx":0442
         Top             =   240
         Width           =   8415
      End
   End
   Begin VB.Frame frOut 
      Caption         =   "Output"
      Height          =   2775
      Left            =   120
      TabIndex        =   3
      Top             =   3240
      Width           =   6615
      Begin VB.TextBox txtOut 
         Height          =   2415
         Left            =   120
         MultiLine       =   -1  'True
         TabIndex        =   4
         Top             =   240
         Width           =   6375
      End
   End
   Begin VB.CommandButton cmdGo 
      Caption         =   "Generate Tokens"
      Height          =   615
      Left            =   6840
      TabIndex        =   0
      Top             =   3360
      Width           =   1935
   End
End
Attribute VB_Name = "fmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mScan As ListScanner
Private TokenType As Integer
Private TokenValue As Variant

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub cmdGo_Click()
    ' clear the output textbox
    txtOut.Text = ""
    
    On Error Resume Next
    
    ' call the main parser function
    Call ParseList(txtList.Text, "")

    If Err.Number <> 0 Then
        AddOutput Err.Description
    End If
    
End Sub

Private Sub ParseList(sList As String, Ident As String)
    Set mScan = New ListScanner
    mScan.ScanInput = sList
    Call ScanList(Ident)
End Sub

Function ScanList(Ident As String)
    Dim More As Boolean
    
    If Not ExpectType(TOK_CBRACEL, True) Then
        Err.Raise vbObjectError + 1, , "invalid list"
    End If
    
    AddOutput Ident & CStr(TokenValue)
    mScan.PushState "list"
    
    More = True
    While More
        If ScanNamedValue(Ident & "  ") Then
            More = ExpectText(",", False)
        Else
            More = False
        End If
    Wend
    
    If Not ExpectType(TOK_CBRACER, True) Then
        Err.Raise vbObjectError + 1, , "invalid list"
    End If
    
    AddOutput Ident & CStr(TokenValue)
    mScan.PopState
End Function

Function ScanNamedValue(Ident As String) As Boolean
    Dim Name As String

    If Not ExpectType(TOK_NAME, True) Then
        Err.Raise vbObjectError + 1, , "missing name"
    End If
    Name = CStr(TokenValue)
    
    If ExpectType(TOK_EQUAL, False) Then
        mScan.PushState "value"
        If Not ScanData(TokenType, TokenValue, Ident) Then
            mScan.PopState
            Err.Raise vbObjectError + 1, , "missing value"
        End If
        mScan.PopState
    Else
        TokenValue = ""
    End If

    If Not IsEmpty(TokenValue) Then
        AddOutput Ident & Name & " = " & CStr(TokenValue)
    End If
    ' everything is okay
    ScanNamedValue = True
End Function

Function ExpectText(Txt As String, IsFatal As Boolean) As Boolean
    If mScan.GetToken(TokenType, TokenValue) Then
        If CStr(TokenValue) = Txt Then
            ExpectText = True
            Exit Function
        End If
        mScan.UnGetToken CStr(TokenValue)
    End If
    ExpectText = False
End Function

Function ExpectType(Typ As Integer, IsFatal As Boolean) As Boolean
    If mScan.GetToken(TokenType, TokenValue) Then
        If TokenType = Typ Then
            ExpectType = True
            Exit Function
        End If
        mScan.UnGetToken CStr(TokenValue)
    End If
    ExpectType = False
End Function

Function ScanData(TokenType As Integer, TokenValue As Variant, Ident As String) As Boolean
    If mScan.GetToken(TokenType, TokenValue) Then
        Select Case TokenType
        Case TOK_DATE
            ScanData = True
        Case TOK_STRING
            ScanData = True
        Case TOK_NUMBER
            ScanData = True
        Case TOK_CBRACEL
            mScan.UnGetToken "{"
            ScanData = ScanList(Ident & "  ")
            TokenValue = ""
            ScanData = True
        Case Else
            ScanData = False
        End Select
    Else
        ScanData = False
    End If
End Function

Sub AddOutput(Txt As String)
    If txtOut.Text = "" Then
        txtOut.Text = Txt
    Else
        txtOut.Text = txtOut.Text & vbNewLine & Txt
    End If
End Sub
