VERSION 5.00
Object = "{3040B150-CC4C-4122-A5EC-0512605147B9}#66.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmCustomSort 
   Caption         =   "Custom Sorting"
   ClientHeight    =   5820
   ClientLeft      =   1860
   ClientTop       =   1650
   ClientWidth     =   7740
   Icon            =   "CustomSort.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   7740
   Begin VB.PictureBox picBackground 
      Height          =   915
      Left            =   5940
      Picture         =   "CustomSort.frx":0442
      ScaleHeight     =   855
      ScaleWidth      =   915
      TabIndex        =   4
      Top             =   3420
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.CheckBox chkFiltMem 
      Caption         =   "Show computers whose RAM is not less than 512Mb"
      Height          =   315
      Left            =   180
      TabIndex        =   1
      Top             =   5400
      Width           =   4755
   End
   Begin iGrid250_75B4A91C.iGrid iGrid1 
      Height          =   3135
      Left            =   120
      TabIndex        =   0
      Top             =   1740
      Width           =   4695
      _ExtentX        =   8281
      _ExtentY        =   5530
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label2 
      Caption         =   $"CustomSort.frx":0829
      Height          =   615
      Left            =   120
      TabIndex        =   2
      Top             =   1020
      Width           =   7515
   End
   Begin VB.Label Label1 
      Caption         =   $"CustomSort.frx":0910
      Height          =   795
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   7515
   End
End
Attribute VB_Name = "frmCustomSort"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub chkFiltMem_Click()
   Dim iRow As Long
   
   With iGrid1
      .Redraw = False
      
      For iRow = 1 To .RowCount
         If chkFiltMem Then
            .RowVisible(iRow) = (.CellValue(iRow, "mem") >= 512)
         Else
            .RowVisible(iRow) = True
         End If
      Next
      
      .SetCurCell 0, 0
      
      .Redraw = True
   End With
End Sub

Private Sub Form_Load()
   Dim iRow As Long
   Dim iCol As Long

   With iGrid1
      .Redraw = False
      
      .RowMode = True
      .FocusRectColor1 = RGB(224, 0, 0)
      .FocusRectColor2 = RGB(224, 0, 0)
      .Editable = False
      .GridLines = igGridLinesVertical
      .BackColor = vbWhite
      .ForeColor = vbBlack
      .BackColorOddRows = RGB(0, 192, 224)
      .BackColorEvenRows = RGB(&H99, &HCC, &HCC)
      .DefaultRowHeight = 18
      .HighlightBackColor = RGB(160, 160, 128)
      .HighlightForeColor = vbWhite
      Set .BackgroundPicture = picBackground
      
      With .Header
         .UseXPStyles = False
         .Flat = True
         .BackColor = RGB(225, 228, 229)
         .ForeColor = vbBlack
         .SortIconStyle = igSortIconSolid
         .SolidSortIconColor = RGB(225, 68, 0)
      End With
      
      With .AddCol(sKey:="group", sHeader:="Workgroup")
         .eTextFlags = igTextSingleLine Or igTextVCenter Or igTextEndEllipsis
         .iIndent = 4
      End With
      With .AddCol(sKey:="comp", sHeader:="Computer")
         .eTextFlags = igTextSingleLine Or igTextVCenter Or igTextEndEllipsis
         .iIndent = 4
         .iRightIndent = 2
      End With
      With .AddCol(sKey:="ip", sHeader:="IP Address", eSortType:=igSortByCustomer)
         .eTextFlags = igTextSingleLine Or igTextCenter Or igTextVCenter Or igTextEndEllipsis
         .iIndent = 4
         .iRightIndent = 2
      End With
      With .AddCol(sKey:="mem", sHeader:="RAM, Mb", eSortType:=igSortByCustomer, eHdrTextFlags:=igTextRight)
         .eTextFlags = igTextSingleLine Or igTextVCenter Or igTextRight
         .iIndent = 0
         .iRightIndent = 4
      End With
      
      .RowCount = 25
      
      For iRow = 1 To .RowCount
         .CellValue(iRow, "group") = Choose(iRow \ 10 + 1, "SALES", "SUPPORT", "DEV")
         .CellValue(iRow, "comp") = "Computer #" & Format$((iRow Mod 10) + 1, "00")
         .CellValue(iRow, "ip") = Int(Rnd * 255 + 1) & "." & Int(Rnd * 255 + 1) & "." & Int(Rnd * 255 + 1) & "." & Int(Rnd * 255 + 1)
         .CellValue(iRow, "mem") = Choose(Int(Rnd * 4 + 1), 128, 256, 512, 1024)
      Next
      
      For iCol = 1 To .ColCount
         .AutoWidthCol iCol
      Next
      
      .Redraw = True
   End With
End Sub

Private Sub Form_Resize()
   On Error Resume Next
   With chkFiltMem
      .Move 120, Me.ScaleHeight - .Height - 120
   End With
   With iGrid1
      .Move 120, .Top, Me.ScaleWidth - 240, chkFiltMem.Top - .Top - 120
   End With
End Sub

Private Sub iGrid1_CustomSort(v1 As Variant, v2 As Variant, bIsGreater As Boolean)
   bIsGreater = fsNormalizeIPAddress(v1) > fsNormalizeIPAddress(v2)
End Sub

' Converts "3.168.5.10" to "003.168.005.010"
Private Function fsNormalizeIPAddress(pAddr)
   Dim parts
   Dim res
   Dim i As Long
   
   parts = Split(pAddr, ".")
   
   For i = LBound(parts) To UBound(parts)
      res = res & "." & Right$("00" & parts(i), 3)
   Next
   
   fsNormalizeIPAddress = Mid$(res, 2)
End Function
