//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report4;

interface

procedure Report_4(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Printers;

procedure Report_4(show:Boolean);
var
   q :TQuery;
   Sp:TSprint;
   lastcompany,lastorder,lastitem:string;
   totalcompany,totalpaid:double;
begin
   q:=TQuery.Create(nil);
   q.Active:=False;
   q.DatabaseName:='DBDEMOS';
   q.SQL.Add('select * from customer a, orders b, items c');
   q.SQL.Add('where a.custno = b.custno');
   q.SQL.Add('  and b.orderno = c.orderno');
   q.SQL.Add('order by a.company, orderno');

   q.Active:=True;

   //1..initialize sprint
   Sp:=form1.SPrint1;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   //2..let's change defaults
   Sp.ShowHeader:=False;
   Sp.Style[tsSum].Font.Size:=-10;
   Sp.Style[tsSum].LineSpace:=2.7;
   //3..heading on the first page
   Sp.Style[tsDef1].Font.Name:='Arial';
   Sp.Style[tsDef1].Font.Size:=-32;
   Sp.Style[tsDef1].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef1].Font.Color:=clNavy;
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.Recalculate(0); {0 mm space between fields}
   Sp.SetStyle(tsDef1);
   Sp.PrintField(2,'Customer/Orders Listing');
   Sp.SetStyle(tsText);
   Sp.CurrY:=Sp.CurrY+200;

   //4..query processing
   lastcompany:=''; lastorder:=''; lastitem:='';
   totalcompany:=0.0; totalpaid:=0.0;
   q.First;
   while q.Eof=False do begin
      if lastcompany<>q.FieldByName('Company').AsString then begin
         lastcompany:=q.FieldByName('Company').AsString;
         //order summing
         if totalcompany<>0.0 then begin
            Sp.SetStyle(tsSum);
            Sp.Add(['','','','',
               '$'+floattostrf(totalcompany,ffFixed,15,2),
               '$'+floattostrf(totalpaid,ffFixed,15,2)
               ]);
            totalcompany:=0.0; totalpaid:=0.0;
            Sp.SetStyle(tsText);
         end;
         //field can be redefined and recalculated on the fly
         Sp.ClearFields;
         Sp.AddField('XXXXXXXXXXXXXXXXXXXXXXX','Company',taLeftJustify);
         Sp.AddField('XXXXXXXXXXXXXXXXXXXX','Contact',taLeftJustify);
         Sp.AddField('XXXXXXXXXXX','Phone',taLeftJustify);
         Sp.AddField('XXXXXXXXXXX','Fax',taLeftJustify);
         Sp.AddField('CustNo','Cust.no',taCenter);
         Sp.Style[tsHead].Font.Size:=-12;
         Sp.Style[tsText].Font.Size:=-12;
         Sp.Style[tsText].BackColor:=$00E0E0E0;
         Sp.Recalculate(-150); {15 mm from both paper edges}
         Sp.SetStyle(tsText);
         Sp.Add([
            q.FieldByName('Company').AsString,
            q.FieldByName('Contact').AsString,
            q.FieldByName('Phone').AsString,
            q.FieldByName('Fax').AsString,
            q.FieldByName('CustNo').AsString
            ]);
         //another fields redefinition
         Sp.ClearFields;
         Sp.AddField('00000000','Order No',taLeftJustify);
         Sp.AddField(' 00.00.0000 ','Sale Date',taCenter);
         Sp.AddField('XXXXXXXX','Ship VIA',taCenter);
         Sp.AddField('XXXXXXXX','Payment',taCenter);
         Sp.AddField('0000000000000','Price',taRightJustify);
         Sp.AddField('0000000000000','AmountPaid',taRightJustify);
         Sp.Style[tsHead].Font.Size:=-10;
         Sp.Style[tsText].Font.Size:=-10;
         Sp.Style[tsText].BackColor:=$00FFFFFF;
         Sp.Recalculate(50); {5 mm space between fields} 
         //detail head
         Sp.SetStyle(tsHead);
         Sp.Add(['Order No','Sale Date','Ship VIA','Payment','Price','Amount Paid']);
         //
         Sp.SetStyle(tsText);
      end;
      //detail printing
      if lastorder<>q.FieldByName('orderno').AsString then begin
         lastorder:=q.FieldByName('orderno').AsString;
         Sp.Add([
            q.FieldByName('orderno').AsString,
            q.FieldByName('saledate').AsString,
            q.FieldByName('shipvia').AsString,
            q.FieldByName('paymentmethod').AsString,
            '$'+floattostrf(q.FieldByName('itemstotal').Value,ffFixed,15,2),
            '$'+floattostrf(q.FieldByName('amountpaid').Value,ffFixed,15,2)
            ]);
         totalcompany:=totalcompany+q.FieldByName('itemstotal').Value;
         totalpaid:=totalpaid+q.FieldByName('amountpaid').Value;
      end;
      q.Next;
   end;
   //last order also needs to show some sum
   Sp.SetStyle(tsSum);
   Sp.Add(['','','','',
      '$'+floattostrf(totalcompany,ffFixed,15,2),
      '$'+floattostrf(totalpaid,ffFixed,15,2)
      ]);
   //preview or print?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
   q.Active:=False;
   q.Free;
end;

end.
