#ifndef _psock_hh_
#define _psock_hh_

#include "wins.h"

extern const char *psock_static_error;

class PSock {
 public:
   const enum stages_t { stInit, stReadHead, stSendHead, stClient, stServer, stClose, stNoErr };
 protected:
   shndl_t s;
   PSock(shndl_t _s);
   bool no_error;
   bool ws_e(bool isok, const char *e, const char *buf);
   const char *host;
   int port, fport;
   stages_t stage;
 public:
   PSock();
   ~PSock();
   bool Connect(const char *name, int port);
   bool Listen(int _port);
   PSock * PSock::Accept(bool AllowNonLocal);
   void Close();
   int Recv(void *buf, int size);
   bool Send(const void *buf, int size);
   bool SendStr(const char *str);
   PSock * Select(PSock *second);
   bool Alive();
   void SetStage(stages_t _stage);
};

#endif
