#include "parse.h"
#include <string.h>
#include <stdio.h>

bool ParseURI(char * (&ret), char *buf, bool strict, char * (&hostname), int &port, char * (&path), int &ofs)
{
   char *buf_s = buf;
   while (*buf && *buf == ' ')
     buf++;
   if (!strncmp(buf, "http://", 7))
     buf += 7;
   else if (strict)
     return false;
   ofs = buf - buf_s;   
   hostname = buf;
   // seek to end of hostname
   while (*buf && *buf != '/' && *buf != ':')
     buf++;
   // port specified
   if (*buf == ':') {
      *buf = 0;
      if (sscanf((buf+=1), "%i/", &port) != 1) {
	 if (strict)
	   return false;
	 else {
	    port = 80;
	    path = 0;
	    ret = buf;
	    return true;
	 }
      }
      while (*buf && *buf != '/')
	buf++;
   } else
     port = 80;
   if (!*buf) {
      if (strict)
	return false;
      else {
	 path = 0;
	 ret = buf;
	 return true;
      }
   }
   *(buf++) = 0;
   path = buf; // without /
   while (*buf && *buf != ' ')
     buf++;
   ret = buf;
   return true;
}
