<%
    /***************************************************************/
    /*****  Discussion Forum Thread List Page given Board ID.  *****/
    /***************************************************************/
%>

<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int board_id=1, from_thread=0, language=1;

    try {
      if (request.getParameter("BoardID") != null)
          board_id    = Integer.parseInt(request.getParameter("BoardID"));
      if (request.getParameter("FromThread") != null)
          from_thread = Integer.parseInt(request.getParameter("FromThread"));
      if (session.getValue("Language") != null)
          language    = Integer.parseInt((String) session.getValue("Language"));
    }
    catch (Exception e) {
      %>Sorry, the page you selected does not exist.<%
      return;
    }

    /* If PreviousThread = from_thread, no need to fetch a new page. */
    String s_from_thread = Integer.toString(from_thread);
    if (session.getValue("PreviousThread") == null ||
        ! session.getValue("PreviousThread").equals(s_from_thread))
    {
      MessageBean.refreshThreadList(board_id, from_thread, MAX_PER_PAGE);
    }

    session.removeValue("PreviousThread");
    session.putValue("PreviousThread", s_from_thread);

    /* Expand/collapse the selected thread. */
    if (request.getParameter("ToggleIndex") != null)
    {
      String s_toggle  = request.getParameter("ToggleIndex");
      try
      {
        int toggle_index = Integer.parseInt(s_toggle);
        MessageBean.toggleExpand(toggle_index);
      }
      catch (Exception e) {
        %>The page you selected does not exist.<%
        return;
      }
    }

    int    list_size  = MessageBean.getThreadListSize();
    String board_des  = MessageBean.getBoardDes(board_id, language);
    String s_board    = Integer.toString(board_id);
    String s_from     = Integer.toString(from_thread);
    String uri_create = new String("Forum.jsp?Parm=CREATE&BoardID=" + s_board);
%>



<form action="Forum.jsp" method="POST">
<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr>
    <td valign="top" align="left" colspan="<%= MAX_LEVEL + 1 %>"><font size="4" face="Arial">
    <strong><%= board_des %></strong></font></td>
  </tr>
  <tr>
    <td valign="top" align="left" colspan="<%= MAX_LEVEL + 1 %>"><a href=
        "<%= uri_create %>">[Create a new thread]</a></td>
  </tr>
  <tr><td valign="top" align="left"></td><tr>

<%
    if (list_size == 0)
    {
%>
  <tr>
    <td valign="top" align="left" colspan="<%= MAX_LEVEL %>">
      Sorry, there are no messages in this board.
    </td>
  </tr>
<%
    }


    /***************************************/
    /******* Display list of threads *******/
    /***************************************/

    String last_thread_id=null;
    for (int i=0; i<list_size; i++)
    {
      Message tr = MessageBean.getThreadAt(i);

      String thread_id   = Integer.toString(tr.getThreadID());
      String tr_msg_id   = Integer.toString(tr.getMessageID());
      String subject     = tr.getSubject();
      String tr_user_id  = tr.getUserID();
      String tr_date     = tr.getCreateDate();
      Member tr_user     = MemberBean.getMember(tr_user_id);
      boolean expanded   = tr.getExpand();
      String tr_title    = new String(subject + " (by " + tr_user.getFirstName() + 
                                      " on " + tr_date + ")");
      String toggle_link = new String("Forum.jsp?Parm=LIST&BoardID=" + board_id +
                                      "&FromThread=" + s_from + "&ToggleIndex=" + 
                                      Integer.toString(i));
      String msg_link    = new String("Forum.jsp?Parm=SHOW&ThreadID=" +
                                      thread_id + "&MessageID=" + tr_msg_id);
%>
  <tr>
<%
      if (tr.getNumChildren() > 0) {
%>
    <td valign="top" align="left" width="2%"><a href="<%= toggle_link %>"><img src=
        "../images/plus.gif"></a></td>
<%
      }
      else
      {
%>
    <td valign="top" align="left" width="2%"><img src="../images/bullet.gif"></td>
<%  
      }
%>
    <td valign="top" align="left" colspan="<%= MAX_LEVEL %>" width="2000"><a href=
        "<%= msg_link %>"><%= tr_title %></a></td>
  </tr>

<%
      /***************************************/
      /******* Display Expanded Thread *******/
      /***************************************/

      if (expanded)
      {
        MessageBean.refreshMessageList(tr.getThreadID(), MessageBean.THREAD_MODE);
        int num_of_message = MessageBean.getMessageListSize();

        for (int j=0; j<num_of_message; j++)
        {
          Message  msg = MessageBean.getMessageAt(j);
          String   message_id  = Integer.toString(msg.getMessageID());
          String   user_id     = msg.getUserID();
          String   date        = msg.getCreateDate();
          int      level       = msg.getLevel();
          String   span_column = Integer.toString(MAX_LEVEL - level);
          Member   user        = MemberBean.getMember(user_id);
          String   title       = new String(user.getFirstName() + " on " + date);
          String   hyperlink   = new String("Forum.jsp?Parm=SHOW&ThreadID=" +
                                            thread_id + "&MessageID=" + message_id);
%>
  <tr>
<%
            for (int k=0; k<level; k++) { %><td>&nbsp;</td><% }
%>
    <td align="left" valign="top" width="2%"><img src="../images/bullet.gif"></td>
    <td align="left" valign="top" colspan="<%= span_column %>" width="2000"><a href=
        "<%= hyperlink %>"><%= title %></a></td>
  </tr>
<%
        }        
      }
      last_thread_id = thread_id;
    }
%>

<%
    /***********************************/
    /******* Button to next page *******/
    /***********************************/

    if (MessageBean.getMoreThread())
    {
%>
  <tr>
    <td valign="top" align="left"></td>
    <td valign="top" align="left" colspan="<%= MAX_LEVEL - 1 %>"><input type="submit"
        value="Next Page"></p></td>
  </tr>

  <tr><td><input type="hidden" name="Parm" value="LIST"></td></tr>
  <tr><td><input type="hidden" name="BoardID" value="<%= s_board %>"></td></tr>
  <tr><td><input type="hidden" name="FromThread" value="<%= last_thread_id %>"></td></tr>
<%
    }
%>

</table>
</form>
