/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Perl5Pattern;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import jfr.awt.MessageDialog;
import jfr.html.Parser;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.SuckerFrame;
import jfr.pagesucker.SuckerFrameOwner;
import jfr.util.StringUtils;

public class ExpertSettingsFrame
extends SuckerFrame {
    Button button_set_logfilespec;
    TextField textfield_default_page_names;
    TextField textfield_max_threads;
    TextField textfield_max_parsing_threads;
    TextField textfield_logfilespec;
    TextField textfield_regexp_filter;
    Checkbox checkbox_regexp_filter;
    Checkbox checkbox_dont_allow_gt_in_strings;
    Checkbox checkbox_accept_single_line_comments;
    Checkbox checkbox_log_history;
    Checkbox checkbox_treat_urls_case_insensitive;
    private FileDialog filedialog_logfile;

    public ExpertSettingsFrame(SuckerFrameOwner in_owner) {
        super(in_owner, "Settings: Expert");
        this.filedialog_logfile = new FileDialog((Frame)Main.sucker.frame_control, "Choose a log file name:", 1);
    }

    protected void setUpFrameContents() {
        int row = 0;
        Label label = new Label("Default Page Names:");
        this.addToGridBag(label, row, 1, 17);
        String names_string = StringUtils.arrayToString(Main.sucker.editing_settings.default_page_names, ", ");
        this.textfield_default_page_names = new TextField(names_string == null ? "" : names_string, 30);
        this.textfield_default_page_names.setEditable(true);
        ((Component)this.textfield_default_page_names).setBackground(Color.white);
        this.addToGridBag(this.textfield_default_page_names, row, 0, 17);
        label = new Label("Log File Spec:");
        this.addToGridBag(label, ++row, 1, 17);
        String compressed_logfilespec = StringUtils.compressString(StringUtils.decodeEncodedCharacters(Main.sucker.editing_settings.logfilespec, false), 25);
        this.textfield_logfilespec = new TextField(compressed_logfilespec, 25);
        this.textfield_logfilespec.setEditable(false);
        this.addToGridBag(this.textfield_logfilespec, row, -1, 17);
        this.button_set_logfilespec = new Button("Set");
        this.button_set_logfilespec.setBackground(Color.white);
        this.button_set_logfilespec.addActionListener(this);
        this.addToGridBag(this.button_set_logfilespec, row, 0, 13);
        this.checkbox_log_history = new Checkbox("Log Download History (All Downloaded URLs Will Be Written To The Log File)", null, Main.sucker.editing_settings.log_history);
        this.addToGridBag(this.checkbox_log_history, ++row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        label = new Label("Max. Concurrent Threads:");
        this.addToGridBag(label, row, 1, 17);
        this.textfield_max_threads = new TextField(String.valueOf(Main.sucker.editing_settings.max_threads), 3);
        this.textfield_max_threads.setEditable(true);
        ((Component)this.textfield_max_threads).setBackground(Color.white);
        this.addToGridBag(this.textfield_max_threads, row, 0, 17);
        label = new Label("Max. Threads For Parsing HTML:");
        this.addToGridBag(label, ++row, 1, 17);
        this.textfield_max_parsing_threads = new TextField(String.valueOf(Main.sucker.editing_settings.max_parsing_threads), 3);
        this.textfield_max_parsing_threads.setEditable(true);
        ((Component)this.textfield_max_parsing_threads).setBackground(Color.white);
        this.addToGridBag(this.textfield_max_parsing_threads, row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        this.checkbox_regexp_filter = new Checkbox("Global Save Filter - URL Must Match Regexp:", null, Main.sucker.editing_settings.pattern_regexp_filter != null);
        this.checkbox_regexp_filter.addItemListener(this);
        this.addToGridBag(this.checkbox_regexp_filter, row, 1, 17);
        this.textfield_regexp_filter = new TextField(Main.sucker.editing_settings.string_regexp_filter, 30);
        this.textfield_regexp_filter.setEditable(true);
        ((Component)this.textfield_regexp_filter).setBackground(Color.white);
        this.addToGridBag(this.textfield_regexp_filter, row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        this.checkbox_dont_allow_gt_in_strings = new Checkbox("Don't allow '>' Characters in HTML Strings (use to recover broken HTML code)", null, Main.sucker.editing_settings.dont_allow_gt_in_strings);
        this.addToGridBag(this.checkbox_dont_allow_gt_in_strings, row, 0, 17);
        this.checkbox_accept_single_line_comments = new Checkbox("Unterminated HTML Comments Are Single Line Comments (for broken HTML code)", null, Main.sucker.editing_settings.accept_single_line_comments);
        this.addToGridBag(this.checkbox_accept_single_line_comments, ++row, 0, 17);
        this.checkbox_treat_urls_case_insensitive = new Checkbox("Treat URLs As Case Insensitive", null, Main.sucker.editing_settings.treat_urls_case_insensitive);
        this.addToGridBag(this.checkbox_treat_urls_case_insensitive, ++row, 0, 17);
        ++row;
    }

    public boolean saveContentsValues() {
        String regexp_filter_text;
        int v;
        try {
            v = Integer.parseInt(this.textfield_max_threads.getText());
            if (v < 1) {
                Main.sucker.editing_settings.max_threads = 1;
                ((TextComponent)this.textfield_max_threads).setText("1");
            } else {
                Main.sucker.editing_settings.max_threads = v;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Main.sucker.editing_settings.max_threads = 10;
            ((TextComponent)this.textfield_max_threads).setText("10");
        }
        try {
            v = Integer.parseInt(this.textfield_max_parsing_threads.getText());
            if (v > Main.sucker.editing_settings.max_threads) {
                Main.sucker.editing_settings.max_parsing_threads = Main.sucker.editing_settings.max_threads;
                ((TextComponent)this.textfield_max_parsing_threads).setText(String.valueOf(Main.sucker.editing_settings.max_parsing_threads));
            } else if (v < 1) {
                Main.sucker.editing_settings.max_parsing_threads = 1;
                ((TextComponent)this.textfield_max_parsing_threads).setText("1");
            } else {
                Main.sucker.editing_settings.max_parsing_threads = v;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Main.sucker.editing_settings.max_parsing_threads = Main.sucker.editing_settings.max_threads;
            ((TextComponent)this.textfield_max_parsing_threads).setText(String.valueOf(Main.sucker.editing_settings.max_parsing_threads));
        }
        Main.sucker.editing_settings.string_regexp_filter = regexp_filter_text = this.textfield_regexp_filter.getText();
        if (this.checkbox_regexp_filter.getState() && regexp_filter_text.length() != 0) {
            try {
                Main.sucker.editing_settings.pattern_regexp_filter = (Perl5Pattern)Main.sucker.compiler_regexp_filter.compile(regexp_filter_text);
            }
            catch (MalformedPatternException malformedPatternException) {
                new MessageDialog((Frame)this, "Invalid Regular Expression Filter Pattern\n(must conform to the Perl5 regexp syntax).", 3).handle();
                ((Component)this).setVisible(true);
                this.textfield_regexp_filter.requestFocus();
                this.textfield_regexp_filter.selectAll();
                return false;
            }
        } else {
            Main.sucker.editing_settings.pattern_regexp_filter = null;
        }
        String default_names_string = this.textfield_default_page_names.getText();
        if (default_names_string.length() != 0) {
            String[] default_page_names = StringUtils.tokenizeString(default_names_string, ',', false, Parser.alphabet_whitespace, false);
            int i = 0;
            while (i < default_page_names.length) {
                String lower_default_name = default_page_names[i].toLowerCase();
                if (!(Main.sucker.settings_html.isOfHTMLType(lower_default_name) || lower_default_name.indexOf(46) == -1 && Main.sucker.settings_html.isUntypedObjectHTML())) {
                    new MessageDialog((Frame)this, "Invalid parameter: Default page names must denote HTML files.", 3).handle();
                    ((Component)this).setVisible(true);
                    this.textfield_default_page_names.requestFocus();
                    this.textfield_default_page_names.selectAll();
                    return false;
                }
                ++i;
            }
            Main.sucker.editing_settings.default_page_names = default_page_names;
        } else {
            Main.sucker.editing_settings.default_page_names = null;
        }
        Main.sucker.editing_settings.treat_urls_case_insensitive = this.checkbox_treat_urls_case_insensitive.getState();
        Main.sucker.editing_settings.log_history = this.checkbox_log_history.getState();
        Main.sucker.editing_settings.dont_allow_gt_in_strings = this.checkbox_dont_allow_gt_in_strings.getState();
        Main.sucker.editing_settings.accept_single_line_comments = this.checkbox_accept_single_line_comments.getState();
        return true;
    }

    public void updateFromEditingSettings() {
        String compressed_logfilespec = StringUtils.compressString(StringUtils.decodeEncodedCharacters(Main.sucker.editing_settings.logfilespec, false), 25);
        ((TextComponent)this.textfield_logfilespec).setText(compressed_logfilespec);
        ((TextComponent)this.textfield_max_threads).setText(String.valueOf(Main.sucker.editing_settings.max_threads));
        ((TextComponent)this.textfield_max_parsing_threads).setText(String.valueOf(Main.sucker.editing_settings.max_parsing_threads));
        ((TextComponent)this.textfield_regexp_filter).setText(Main.sucker.editing_settings.string_regexp_filter);
        this.checkbox_regexp_filter.setState(Main.sucker.editing_settings.pattern_regexp_filter != null);
        String s = StringUtils.arrayToString(Main.sucker.editing_settings.default_page_names, ", ");
        ((TextComponent)this.textfield_default_page_names).setText(s);
        this.checkbox_treat_urls_case_insensitive.setState(Main.sucker.editing_settings.treat_urls_case_insensitive);
        this.checkbox_log_history.setState(Main.sucker.editing_settings.log_history);
        this.checkbox_dont_allow_gt_in_strings.setState(Main.sucker.editing_settings.dont_allow_gt_in_strings);
        this.checkbox_accept_single_line_comments.setState(Main.sucker.editing_settings.accept_single_line_comments);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.button_set_logfilespec) {
            this.setLogFileSpec();
        } else {
            super.actionPerformed(evt);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.checkbox_regexp_filter) {
            if (PageSucker.registration_checksum1 + 485 != PageSucker.registration_checksum2) {
                new MessageDialog((Frame)this, "Sorry, this option can be enabled in registered copies of PageSucker only. Select \"Register...\" from the \"File\" menu to enter your registration information.", 3).handle();
                ((Checkbox)source).setState(false);
            }
        } else {
            super.itemStateChanged(evt);
        }
    }

    private void setLogFileSpec() {
        int slash_index = Main.sucker.editing_settings.logfilespec.lastIndexOf(File.separatorChar);
        String file = slash_index >= 0 ? Main.sucker.editing_settings.logfilespec.substring(slash_index + 1) : Main.sucker.editing_settings.logfilespec;
        this.filedialog_logfile.setFile(file);
        ((Component)this.filedialog_logfile).setVisible(true);
        String dir = this.filedialog_logfile.getDirectory();
        file = this.filedialog_logfile.getFile();
        if (dir != null && file != null) {
            String fspec;
            Main.sucker.editing_settings.logfilespec = fspec = String.valueOf(dir) + file;
            String compressed_logfilespec = StringUtils.compressString(StringUtils.decodeEncodedCharacters(fspec, false), 25);
            ((TextComponent)this.textfield_logfilespec).setText(compressed_logfilespec);
        }
    }
}

