/* MAIN.C - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "resource.h"
#include "resolv.h"
#include "list.h"

extern int already_read;
extern unsigned char* query_rep;
HINSTANCE inst;
BOOL idle;

void rev_query(HWND hwnd, char* asked_host, SOCKADDR_IN dns_addr,SOCKADDR_IN host_addr){
	int length=0,result,i,line,timeout=20,err;
	char *query,message[256],*name,*answer, host[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,anstype;
	SOCKET sock;
	BOOL alias;
	LV_ITEM linea;
	sprintf(host,"%u.%u.%u.%u.in-addr.arpa",host_addr.sin_addr.S_un.S_un_b.s_b4
	,host_addr.sin_addr.S_un.S_un_b.s_b3
	,host_addr.sin_addr.S_un.S_un_b.s_b2
	,host_addr.sin_addr.S_un.S_un_b.s_b1);
	while(1){
		length++;
		query=(char*)malloc(length);
		result=res_mkquery(0,host,1,12,0,0,0,query,length);
		if (result!=-1) break;
		free(query);
	}
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection revfailed");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	send(sock,((char*)(&result))+1,1,0);
	send(sock,((char*)(&result))+0,1,0);
	send(sock,query,result,0);
	already_read=-2;
	length=GetShortInt(sock);
	query_rep=(char*)malloc(length);
	GetShortInt(sock);//id
	GetByte(sock);//type
	errors=GetByte(sock);
	if (errors&15){
		switch(errors&15){
		case 1:
			strcpy(message,"Format error");
			break;
		case 2:
			strcpy(message,"Server failure");
			break;
		case 3:
			sprintf(message,"The host or domain %s does not exist",host);
			break;
		case 4:
			strcpy(message,"Not implemented");
			break;
		case 5:
			strcpy(message,"Refused");
			break;
		default:
			strcpy(message,"Unknown error");
		}
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	qdcount=GetShortInt(sock);
	ancount=GetShortInt(sock);
	nscount=GetShortInt(sock);
	arcount=GetShortInt(sock);
	if (ancount==0){
			sprintf(message,"%s is a valid domain name, but not a valid hostname",host);
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
			closesocket(sock);
			return;
	}
	name=(char*)malloc(256);
	answer=(char*)malloc(256);
	for(i=0;i<qdcount;i++){
		GetLabel(sock,name,already_read);
		GetTypeAndClass(sock);
	}
	alias=FALSE;
	line=0;
	for(i=0;i<ancount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		linea.mask=LVIF_TEXT;
		linea.iItem=line++;
		linea.iSubItem=0;
		linea.pszText=answer;
		ListView_InsertItem(GetDlgItem(hwnd,IDC_LIST4),&linea);
		linea.iSubItem=1;
		linea.pszText=name;
		SendDlgItemMessage(hwnd,IDC_LIST4,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
	}
	sprintf(message,"Hostname of %s",asked_host);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	for(i=0;i<nscount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,name);
	}
	for(i=0;i<arcount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
	}
	closesocket(sock);
	free(query_rep);
}

void direct_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int length=0,result,i,line,timeout=20,err;
	char *query,message[256],*name,*answer;
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,anstype;
	SOCKET sock;
	BOOL alias;
	LV_ITEM linea;
	while(1){
		length++;
		query=(char*)malloc(length);
		result=res_mkquery(0,host,1,1,0,0,0,query,length);
		if (result!=-1) break;
		free(query);
	}
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection frailed");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	send(sock,((char*)(&result))+1,1,0);
	send(sock,((char*)(&result))+0,1,0);
	send(sock,query,result,0);
	already_read=-2;
	length=GetShortInt(sock);
	query_rep=(char*)malloc(length);
	GetShortInt(sock);//id
	GetByte(sock);//type
	errors=GetByte(sock);
	if (errors&15){
		switch(errors&15){
		case 1:
			strcpy(message,"Format error");
			break;
		case 2:
			strcpy(message,"Server failure");
			break;
		case 3:
			sprintf(message,"The host or domain %s does not exist",host);
			break;
		case 4:
			strcpy(message,"Not implemented");
			break;
		case 5:
			strcpy(message,"Refused");
			break;
		default:
			strcpy(message,"Unknown error");
		}
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	qdcount=GetShortInt(sock);
	ancount=GetShortInt(sock);
	nscount=GetShortInt(sock);
	arcount=GetShortInt(sock);
	if (ancount==0){
			sprintf(message,"%s is a valid domain name, but not a valid hostname",host);
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
			closesocket(sock);
			return;
	}
	name=(char*)malloc(256);
	answer=(char*)malloc(256);
	for(i=0;i<qdcount;i++){
		GetLabel(sock,name,already_read);
		GetTypeAndClass(sock);
	}
	alias=FALSE;
	line=0;
	for(i=0;i<ancount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		if (anstype==5){
			sprintf(message,"%s is an alias for %s",name,answer);
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
			alias=TRUE;
		}
		else{
			linea.mask=LVIF_TEXT;
			linea.iItem=line++;
			linea.iSubItem=0;
			linea.pszText=name;
			ListView_InsertItem(GetDlgItem(hwnd,IDC_LIST4),&linea);
			linea.iSubItem=1;
			linea.pszText=answer;
			SendDlgItemMessage(hwnd,IDC_LIST4,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		}
	}
	if (!alias){
			sprintf(message,"IP address of %s",name);
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
			alias=TRUE;
		}
	for(i=0;i<nscount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,name);
	}
	for(i=0;i<arcount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
	}
	closesocket(sock);
	free(query_rep);
}

void mx_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int length=0,result,i,timeout=20,err;
	char *query,message[256],*name,*answer;
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,anstype;
	SOCKET sock;
	BOOL alias;
	LV_ITEM linea;
	while(1){
		length++;
		query=(char*)malloc(length);
		result=res_mkquery(0,host,1,15,0,0,0,query,length);
		if (result!=-1) break;
		free(query);
	}
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection frevailed");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
	send(sock,((char*)(&result))+1,1,0);
	send(sock,((char*)(&result))+0,1,0);
	send(sock,query,result,0);
	already_read=-2;
	length=GetShortInt(sock);
	query_rep=(char*)malloc(length);
	GetShortInt(sock);//id
	GetByte(sock);//type
	errors=GetByte(sock);
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	}
	qdcount=GetShortInt(sock);
	ancount=GetShortInt(sock);
	nscount=GetShortInt(sock);
	arcount=GetShortInt(sock);
	if (ancount==0){
			sprintf(message,"%s is a valid domain name, but not a valid mail address",host);
			SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
			closesocket(sock);
			return;
	}
	name=(char*)malloc(256);
	answer=(char*)malloc(256);
	for(i=0;i<qdcount;i++){
		GetLabel(sock,name,already_read);
		GetTypeAndClass(sock);
	}
	for(i=0;i<ancount;i++){
		char pref[6];
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		linea.mask=LVIF_TEXT;
		linea.iItem=i;
		linea.iSubItem=0;
		linea.pszText=name;
		ListView_InsertItem(GetDlgItem(hwnd,IDC_MX),&linea);
		linea.iSubItem=2;
		linea.pszText=answer+2;
		SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		linea.iSubItem=1;
		sprintf(pref,"%u",answer[0]*256+answer[1]);
		linea.pszText=pref;
		SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
	}
	sprintf(message,"Mail exchanger for %s",name);
	SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
	alias=TRUE;
	for(i=0;i<nscount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,name);
	}
	for(i=0;i<arcount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		if (anstype==1){
			int j;
			char comp[256];
			LV_ITEM linea;
			for(j=0;j<ancount;j++){
				linea.iItem=j;
				linea.iSubItem=2;
				linea.mask=LVIF_TEXT;
				linea.pszText=comp;
				linea.cchTextMax=256;
				ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&linea);
				if (!strcmp(comp,name)){
					linea.pszText=answer;
					linea.iSubItem=3;
					SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,
						(WPARAM) 0,(LPARAM) &linea);
				}
			}
		}
	}
	closesocket(sock);
	free(query_rep);
}

void ns_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int length=0,result,i,timeout=20,err;
	char *query,message[256],*name,*answer,comp[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,anstype;
	SOCKET sock;
	LV_ITEM linea;
	while(1){
		length++;
		query=(char*)malloc(length);
		result=res_mkquery(0,host,1,2,0,0,0,query,length);
		if (result!=-1) break;
		free(query);
	}
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection nsfailed");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
	send(sock,((char*)(&result))+1,1,0);
	send(sock,((char*)(&result))+0,1,0);
	send(sock,query,result,0);
	already_read=-2;
	length=GetShortInt(sock);
	query_rep=(char*)malloc(length);
	GetShortInt(sock);//id
	GetByte(sock);//type
	errors=GetByte(sock);
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	}
	qdcount=GetShortInt(sock);
	ancount=GetShortInt(sock);
	nscount=GetShortInt(sock);
	arcount=GetShortInt(sock);
	if (ancount==0){
			sprintf(message,"%s is not a domain name. It could be a host name or a mail address",host);
			SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
			closesocket(sock);
			return;
	}
	name=(char*)malloc(256);
	answer=(char*)malloc(256);
	for(i=0;i<qdcount;i++){
		GetLabel(sock,name,already_read);
		GetTypeAndClass(sock);
	}
	for(i=0;i<ancount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		linea.mask=LVIF_TEXT;
		linea.iItem=i;
		linea.iSubItem=0;
		linea.pszText=name;
		ListView_InsertItem(GetDlgItem(hwnd,IDC_NS),&linea);
		linea.iSubItem=1;
		linea.pszText=answer;
		SendDlgItemMessage(hwnd,IDC_NS,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
	}
	sprintf(message,"Name server for %s",name);
	SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
	for(i=0;i<nscount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,name);
	}
	for(i=0;i<arcount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		if (anstype==1){
			int j;
			LV_ITEM linea;
			for(j=0;j<ancount;j++){
				linea.iItem=j;
				linea.iSubItem=1;
				linea.mask=LVIF_TEXT;
				linea.pszText=comp;
				linea.cchTextMax=256;
				ListView_GetItem(GetDlgItem(hwnd,IDC_NS),&linea);
				if (!strcmp(comp,name)){
					linea.pszText=answer;
					linea.iSubItem=2;
					SendDlgItemMessage(hwnd,IDC_NS,LVM_SETITEM,
						(WPARAM) 0,(LPARAM) &linea);
				}
			}
		}
	}
	closesocket(sock);
	free(query_rep);
}

void Query(HWND hwnd){
	int length;
	char *host, *dns, message[256];
	SOCKADDR_IN dns_addr,host_addr;
	length=(WORD) SendDlgItemMessage(hwnd,
                        IDC_DNS,
                        EM_LINELENGTH,
                        (WPARAM) 0,
                        (LPARAM) 0);
	if (length==0){
		MessageBox(hwnd,"No DNS specified","Error",MB_OK|MB_ICONERROR);
		return;
	}
	dns=(char*)malloc(length+1);
	*((WORD*)dns)=length;
	SendDlgItemMessage(hwnd,
                        IDC_DNS,
                        EM_GETLINE,
                        (WPARAM) 0,       /* line 0 */
                        (LPARAM) dns);
	dns[length]=0;
	dns_addr.sin_port=htons(53);
	dns_addr.sin_family=AF_INET;
	dns_addr.sin_addr.S_un.S_addr=inet_addr(dns);
	if (dns_addr.sin_addr.S_un.S_addr==INADDR_NONE){
		struct hostent* hostgot=gethostbyname(dns);
		if (hostgot==NULL){
			sprintf(message,"Could not resolve %s",dns);
			MessageBox(hwnd,message,"Error",MB_OK|MB_ICONERROR);
			return;
		}
		dns_addr.sin_addr.S_un.S_un_b.s_b1=hostgot->h_addr_list[0][0];
		dns_addr.sin_addr.S_un.S_un_b.s_b2=hostgot->h_addr_list[0][1];
		dns_addr.sin_addr.S_un.S_un_b.s_b3=hostgot->h_addr_list[0][2];
		dns_addr.sin_addr.S_un.S_un_b.s_b4=hostgot->h_addr_list[0][3];
	}
	memset(dns_addr.sin_zero,0,8);
	length=(WORD) SendDlgItemMessage(hwnd,
                        IDC_HOSTNAME,
                        EM_LINELENGTH,
                        (WPARAM) 0,
                        (LPARAM) 0);
	if (length==0){
		MessageBox(hwnd,"No host specified","Error",MB_OK|MB_ICONERROR);
		return;
	}
	host=(char*)malloc(length+1);
	*((WORD*)host)=length;
	SendDlgItemMessage(hwnd,
                        IDC_HOSTNAME,
                        EM_GETLINE,
                        (WPARAM) 0,       /* line 0 */
                        (LPARAM) host);
	host[length]=0;
	host_addr.sin_addr.S_un.S_addr=inet_addr(host);
	if (IsDlgButtonChecked(hwnd,IDC_ADDC)==BST_CHECKED){
		SendDlgItemMessage(hwnd,
                        IDC_LIST4,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		if (host_addr.sin_addr.S_un.S_addr==INADDR_NONE)
			direct_query(hwnd,host,dns_addr);
		else
			rev_query(hwnd,host,dns_addr,host_addr);
		UpdateWindow(hwnd);
	}
	if (IsDlgButtonChecked(hwnd,IDC_MXC)==BST_CHECKED){
	SendDlgItemMessage(hwnd,
                        IDC_MX,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		mx_query(hwnd,host,dns_addr);
		UpdateWindow(hwnd);
	}
	if (IsDlgButtonChecked(hwnd,IDC_NSC)==BST_CHECKED){
		SendDlgItemMessage(hwnd,
                        IDC_NS,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		ns_query(hwnd,host,dns_addr);
		UpdateWindow(hwnd);
	}
}

LRESULT CALLBACK Funzione(HWND hwnd, // handle of window
UINT uMsg, // message identifier
WPARAM wParam, // first message parameter
LPARAM lParam // second message parameter
){
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
			LV_COLUMN colonna;
			char testo[64]="Hostname";
			colonna.mask=LVCF_TEXT|LVCF_WIDTH;
			colonna.pszText=testo;
			colonna.cx=170;
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_LIST4),0,&colonna);
			colonna.cx=100;
			strcpy(testo,"IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_LIST4),1,&colonna);
			colonna.cx=170;
			strcpy(testo,"Host");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),0,&colonna);
			strcpy(testo,"Authoritative name server");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),1,&colonna);
			colonna.cx=100;
			strcpy(testo,"Name server IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),2,&colonna);
			colonna.cx=170;
			strcpy(testo,"Mail address");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),0,&colonna);
			colonna.cx=30;
			strcpy(testo,"Preference");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),1,&colonna);
			colonna.cx=170;
			strcpy(testo,"Mail exchanger");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),2,&colonna);
			colonna.cx=100;
			strcpy(testo,"Mail exchanger IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),3,&colonna);
			CheckDlgButton(hwnd,IDC_ADDC,BST_CHECKED);
			SetWindowText(GetDlgItem(hwnd,IDC_HOSTNAME),"");
			SetWindowText(GetDlgItem(hwnd,IDC_DNS),"");
			return TRUE;
			}
		case WM_COMMAND:
			if(LOWORD(wParam)==IDC_OK)
			{
			Query(hwnd);
			}
/*			if(LOWORD(wParam)==IDOK)
			{
			DestroyWindow(GetParent((HWND)lParam));
			}*/
			return TRUE;
			break;
		case WM_NOTIFY:
			if((wParam==IDC_NS)&&(((LPNMHDR)lParam)->code)==NM_DBLCLK){
				if(ListView_GetSelectedCount(GetDlgItem(hwnd,IDC_NS))==1)
					DialogBox(inst,MAKEINTRESOURCE(IDD_LIST),hwnd,list_callback);
			}
			return TRUE;
			break;
		case WM_CLOSE:
			DestroyWindow(hwnd);
			return TRUE;
			break;
		case WM_DESTROY:
			/* The window is being destroyed, close the application
			 * (the child button gets destroyed automatically). */
			PostQuitMessage (0);
			return 1;
			break;
		case WM_ENTERIDLE:
			if (!idle){
				idle=1;
				ListDomains();
			}
		default:
			return 0;
	}
};

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow ){
	HWND hwnd;
	MSG msg;
	WSADATA dati;
	HICON icona;
	inst=hInstance;
	InitCommonControls();
	WSAStartup(MAKEWORD(2,0),&dati);
	hwnd=CreateDialog(hInstance,MAKEINTRESOURCE(IDD_MAINWINDOW),NULL,Funzione);
	icona=LoadIcon(inst,MAKEINTRESOURCE(IDI_ICON1));
	SendMessage(hwnd,WM_SETICON,ICON_BIG,(LPARAM)icona);
	ShowWindow(hwnd,nCmdShow);
	UpdateWindow(hwnd);
	while (GetMessage (&msg, 0, 0, 0))
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}
	WSACleanup();
	return msg.wParam;
}