__perl__ 

use lib '__install__';
$::db_dir = "__db_dir__";
use Time::Local;

# Bring in webcalng modules.
use webcalng_io;
use webcalng_subs;

# This is required in case error handling is done.
use CGI;
$::q = new CGI;

# Variables.
my ($webcal_libdir,$fromcal,$tocal);
my ($webcal3items,$index,%data,$startdate_default);
$::username = "";

# Since webcal3 did not have the concept of a startdate on repeating
# items, define it here to be Jan 1 2000. 
$startdate_default = 946746000;  

# Get command line input.
for (@ARGV) {
	($key,$value)  = split /=/, $_, 2;
	$webcal_libdir = $value if ($key eq "webcal3");
	$fromcal       = $value if ($key eq "from");
	$tocal         = $value if ($key eq "to");
}
help("All options are required.") unless (($webcal_libdir) && ($fromcal) && ($tocal));
help("Invalid webcal3 directory: $webcal_libdir") unless (-f "$webcal_libdir/webcal_io.pm");

# Bring in webcal3 modules.
$::calendar = $fromcal;
require "$webcal_libdir/webcal_conf.pm" or die "Error including webcal_conf.pm module: $!\n";
require "$webcal_libdir/webcal_io.pm"   or die "Error including webcal_conf.pm module: $!\n";

# Read in webcalng config file.
webcalng_subs::read_webcalng_conf();

# Bring in the webcalng rdbms module if needed.
require webcalng_rdbms if ($::webcalng_conf{'DB'});

# First, read in the data from webcal3.
print STDERR "Reading information from webcal3 calendar $fromcal.\n";
webcal_io::dbh_setup();
$::DATABASE = "$webcal_conf::DB_DIR/$fromcal/cal.dat";
(undef,undef,$webcal3items) = webcal_io::setup_items_hash('all',undef);
webcal_io::dbh_close();

# Now, format data for webcalng.
print STDERR "Formatting data for webcalng.\n";
for $index (keys %$webcal3items) {
	my ($olddate,$year,$month,$day,$dow,$time,$subindex,$lastdate,$daily);
	my ($dateregexp,$startdate,$enddate,$repeat,$repeatdays,$repeatend);

	# Skip items that may have come from blank lines.
	next if ($webcal3items->{$index}{'1'}{'string'} eq "");

	# Special handling of items that have subindexes.  These were either
	# overnight items, or they repeated for multiple days in a row.
	$lastdate = $daily = 0;
	if ($webcal3items->{$index}{'2'}) {
		if (($webcal3items->{$index}{'1'}{'ehour'} == 2400) && ($webcal3items->{$index}{'2'}{'shour'} == 0)) {
			$webcal3items->{$index}{'1'}{'ehour'} = $webcal3items->{$index}{'2'}{'ehour'};
		} else {
			$daily = 1;
		}
		$daily = 1 if (defined $webcal3items->{$index}{'3'});
		for $subindex (sort {$a <=> $b} keys %{ $webcal3items->{$index} }) {
			$lastdate = $webcal3items->{$index}{$subindex}{'idate'};
		}
	}

	# Calculate start/end times and repeat characteristics.
	$olddate = $webcal3items->{$index}{'1'}{'idate'};
	if ($olddate =~ /^(\d{4})(\d{2})(\d{2})/) {
		# Simple day items, or items that repeated on simple consecutive days.
		$year       = $1;
		$month      = $2;
		$day        = $3;
		$time       = timelocal "0","0","12",$day,($month-1),($year-1900);
		$dow        = (split /\s+/, localtime($time))[0];
		$startdate  = $time;
		if ($lastdate) {
			if (! $daily) {
				# Simple overnight item.
				$enddate    = $startdate + 86400;
				$dateregexp = "$month,$day,$dow";
				$repeat     = 0;
				$repeatdays = 0;
				$repeatend  = 0;
			} else {
				if ($lastdate =~ /^(\d{4})(\d{2})(\d{2})/) {
					# Simple daily repeating item.
					my ($lastyear,$lastmonth,$lastday,$lasttime);
					$lastyear   = $1;
					$lastmonth  = $2;
					$lastday    = $3;
					$lasttime   = timelocal "0","0","12",$lastday,($lastmonth-1),($lastyear-1900);
					$enddate    = $lasttime;
					$dateregexp = ".*,.*,.*";
					$repeat     = "daily";
					$repeatdays = 0;
					$repeatend  = 1;
				} else {
					die "I should never get here!\n";
				}
			}
		} else {
			# Simple single day item.
			$enddate    = $startdate;
			$dateregexp = "$month,$day,$dow";
			$repeat     = 0;
			$repeatdays = 0;
			$repeatend  = 0;
		}
	} else {
		($year,$month,$day,$dow) = split /,/, $olddate;
		$startdate   = $startdate_default;
		$repeat      = "";
		$dateregexp  = "";
		$repeatend   = 1;
		$repeat      = "yearlybydate" if (($year eq ".*") && ($month ne ".*") && ($day =~ /\d{2}/) && ($dow eq ".*"));
		$repeat      = "yearlybyday" if (($year eq ".*") && ($month ne ".*") && ($day !~ /\d{2}/) && ($dow ne ".*"));
		$repeat      = "monthlybydate" if (($month eq ".*") && ($dow eq ".*"));
		$repeat      = "monthlybyday" if (($month eq ".*") && ($dow ne ".*"));
		$repeat      = "weekly" if (($day eq ".*"));
		if ($repeat eq "yearlybydate") {
			$dateregexp = "$month,$day,$dow";
			$repeatdays = "";
			$repeatend  = 0;
			$enddate    = 9999999999;
		} elsif ($repeat eq "yearlybyday") {
			$dateregexp = "$month,$day,$dow";
			$repeatdays = "";
			$repeatend  = 0;
			$enddate    = 9999999999;
		} elsif ($repeat eq "monthlybydate") {
			$dateregexp = "$month,$day,$dow";
			$repeatdays = "";
			if ($year eq ".*") {
				$enddate   = 9999999999;
				$repeatend = 0;
			} else {
				if ($lastdate =~ /^(\d{4})(\d{2})(\d{2})/) {
					$year  = $1;
					$month = $2;
					$day   = $3;
				}
				$enddate   = timelocal "0","0","12","1","11",($year - 1900);
				$enddate   = $enddate - 86400;
				$repeatend = 1;
			}
		} elsif ($repeat eq "monthlybyday") {
			$dateregexp = "$month,$day,$dow";
			$repeatdays = "";
			if ($year eq ".*") {
				$enddate   = 9999999999;
				$repeatend = 0;
			} else {
				if ($lastdate =~ /^(\d{4})(\d{2})(\d{2})/) {
					$year  = $1;
					$month = $2;
					$day   = $3;
				}
				$enddate   = timelocal "0","0","12","1",11,($year - 1900);
				$enddate   = $enddate - 86400;
				$repeatend = 1;
			}
		} elsif ($repeat eq "weekly") {
			my %days    = qw(Sun 1 Mon 2 Tue 3 Wed 4 Thu 5 Fri 6 Sat 7);
			$dateregexp = ".*,.*,$dow";
			$repeatdays = $days{$dow};
			if ($year eq ".*") {
				$enddate   = 9999999999;
				$repeatend = 0;
			} elsif ($month eq ".*") {
				if ($lastdate =~ /^(\d{4})(\d{2})(\d{2})/) {
					$year  = $1;
					$month = $2;
					$day   = $3;
				}
				$enddate   = timelocal "0","0","12","31","11",($year - 1900);
				$repeatend = 1;
			} else {
				if ($lastdate =~ /^(\d{4})(\d{2})(\d{2})/) {
					$year  = $1;
					$month = $2;
					$day   = $3;
				}
				$enddate   = timelocal "0","0","12","1",$month,($year - 1900);
				$enddate   = $enddate - 86400;
				$repeatend = 1;
			}
		} else {
			print "  Invalid date expression for item \"$webcal3items->{$index}{'1'}{'string'}\"\n";
			print "  Skipping this item.\n";
			next;
		}
	}
	$data{$index}{'dateregexp'} = $dateregexp;
	$data{$index}{'startdate'}  = $startdate;
	$data{$index}{'enddate'}    = $enddate;
	$data{$index}{'repeat'}     = $repeat;
	$data{$index}{'repeatdays'} = $repeatdays;
	$data{$index}{'repeatend'}  = $repeatend;
	$data{$index}{'modified'}    = 1;
	$data{$index}{'description'} = $webcal3items->{$index}{'1'}{'string'};
	$data{$index}{'starttime'}   = $webcal3items->{$index}{'1'}{'shour'};
	$data{$index}{'endtime'}     = $webcal3items->{$index}{'1'}{'ehour'};
	$data{$index}{'visibility'}  = 0;
	$data{$index}{'meetingid'}   = 0;
	$data{$index}{'hyperlink'}   = $webcal3items->{$index}{'1'}{'link'}  || "";
	$data{$index}{'notes'}       = $webcal3items->{$index}{'1'}{'notes'} || "";
	if (($webcal3items->{$index}{'1'}{'rsec'}) && ($webcal_conf::EMAIL_ADDR)) {
		$data{$index}{'remindwho'}    = $webcal_conf::EMAIL_ADDR;
		$data{$index}{'remindwhen'}   = $webcal3items->{$index}{'1'}{'rsec'};
		$data{$index}{'remindersent'} = "0";
	} else {
		$data{$index}{'remindwho'}    = "";
		$data{$index}{'remindwhen'}   = "";
		$data{$index}{'remindersent'} = "";
	}
}

# Finally, write it to webcalng.
print STDERR "Adding items to webcalng.\n";
webcalng_rdbms::dbh_setup() if ($::webcalng_conf{'DB'});
for $index (keys %data) {
	webcalng_io::additem_io(\%{ $data{$index} },undef,undef,undef,$tocal);
}
$::dbh->commit()     if ($::webcalng_conf{'DB'});
$::dbh->disconnect() if ($::webcalng_conf{'DB'});
print STDERR "Copy from webcal3:$fromcal to webcalng:$tocal complete.\n";

# Print usage.
sub help {
	my ($error) = (@_);
	print "Error: $error\n";
	die "Usage: $0 webcal3=/path/to/webcal3/install from=webcal3_calendar_name to=webcalng_calendar_name\n";
}
