
<%
Dim strMessageText, textLength, textStart, textEnd

Sub displayAppointment(inMessage)

  On Error Resume Next

  writeTitle DATETEXT & "/" & TIMETEXT & COLONSPACETEXT
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongDate)
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongTime)
  writeTitle DURATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8213")) & " " & MINTEXT
  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle LOCATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8208"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub displayContact(inMessage)

  On Error Resume Next

  writeTitle NAMETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle TITLETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A17001F))
  writeTitle COMPANYTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A16001F))
  writeTitle DEPARTMENTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A18001F))
  writeTitle EMAILTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8084", "0420060000000000C000000000000046"))
  writeTitle BUSINESSPHONETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A08001F))
  writeTitle MOBILETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A1C001F))
  writeTitle BUSINESSFAXTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A24001F))
  writeTitle BUSINESSADDRESSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8045", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8046", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8047", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8048", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8049", "0420060000000000C000000000000046"))

End Sub

Sub displayMessage(inMessage)

  Set objMessages = objSession.GetFolder(inMessage.FolderID).Messages

  objMessages.Sort 2

  For n = 1 To objMessages.Count
    If objMessages.Item(n).ID = inMessage.ID Then
      o = n
      Exit For
    End If
  Next

  If o < objMessages.Count Then
    oldmi = mi
    mi = objMessages.Item(o + 1).ID
    writeLinkWParams "MSR.asp", PREVIOUSMESSAGETEXT, "MI,NOBR"
    mi = oldmi
  End If

  If o > 1 Then
    oldmi = mi
    mi = objMessages.Item(o - 1).ID
    writeLinkWParams "MSR.asp", NEXTMESSAGETEXT, "MI,NOBR"
    mi = oldmi
  End If

  oldHb = hb
  If Not((oldHb And 1) <> 0) Then
    hb = oldHb Or 1
    If (HTMLBODYCONTROL And 1) = 0 Then
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLinkWParams "MSR.asp", "HTML", "HB,NOBR"
      blnShowHTML = False
    Else
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLinkWParams "MSR.asp", "TXT", "HB,NOBR"
      blnShowHTML = True
    End If
  Else
    hb = oldHb And Not 1
    If (HTMLBODYCONTROL And 1) = 0 Then
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLinkWParams "MSR.asp", "TXT", "HB,NOBR"
      blnShowHTML = True
    Else
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLinkWParams "MSR.asp", "HTML", "HB,NOBR"
      blnShowHTML = False
    End If
  End If
  hb = oldHb

  rwbc ""

  ' Are we in Sent Items?
  If checkTopFolder(inMessage.FolderID, 3) Then
    writeTitle TO1TEXT & COLONSPACETEXT
    display = getMessageRecipient(inMessage)
  Else
    writeTitle FROMTEXT & COLONSPACETEXT
    display = getMessageSender(inMessage)
  End If

  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  If inMessage.Importance = 2 Then rwbc IMPORTANCETEXT & COLONSPACETEXT & HIGHTEXT

  writeLinkWParams "MSRA.asp", ACTIONSTEXT, ""
  writeUnderline

  If Not blnShowHTML Then
    strMessageText = getMessageText(inMessage)
    textLength = Len(strMessageText) : textEnd = 0
    getTextStartAndEnd
    display = Mid(strMessageText, textStart, (textEnd - textStart) + 1)
    display = displayEncode(display)
  Else
    display = getMessageHTMLBody(inMessage)
  End If

  rwbc display

  If Not blnShowHTML Then
    If textEnd < textLength Then
      pg = pg + 1
      writeLinkWParams "MSR.asp", NEXTTEXT, "PG"
    End If
  End If

End Sub

Sub displayNote(inMessage)

  writeTitle NOTETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H1000001F))

End Sub

Sub displayPost(inMessage)

  writeTitle FROMTEXT & COLONSPACETEXT
  display = getMessageSender(inMessage)
  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  writeUnderline

  strMessageText = getMessageText(inMessage)
  textLength = Len(strMessageText) : textEnd = 0
  getTextStartAndEnd
  display = Mid(strMessageText, textStart, (textEnd - textStart) + 1)

  rwbc displayEncode(display)

  If textEnd < textLength Then
    pg = pg + 1
    writeLinkWParams "PSR.asp", NEXTTEXT, "PG"
  End If

End Sub

Sub displayTask(inMessage)

  On Error Resume Next

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle IMPORTANCETEXT & COLONSPACETEXT
  lImportance = inMessage.Fields(&H00170003)
  Select Case lImportance
    Case 0
      rwbc displayEncode(LOWTEXT)
    Case 1
      rwbc displayEncode(NORMALTEXT)
    Case 2
      rwbc displayEncode(HIGHTEXT)
  End Select

  writeTitle STATUSTEXT & COLONSPACETEXT
  lStatus = inMessage.Fields("0x8101", "0320060000000000C000000000000046")
  Select Case lStatus
    Case 0
      rwbc displayEncode(OPENTEXT)
    Case 1
      rwbc displayEncode(INPROGRESSTEXT)
    Case 2
      rwbc displayEncode(COMPLETEDTEXT)
    Case 3
      rwbc displayEncode(WAITINGONSOMEONEELSETEXT)
    Case 4
      rwbc displayEncode(DEFERREDTEXT)
  End Select

  writeTitle PERCENTCOMPLETETEXT & COLONSPACETEXT
  lPercentComplete = inMessage.Fields("0x8102", "0320060000000000C000000000000046")
  rwbc 100 * lPercentComplete & "%"
  writeTitle STARTDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8104", "0320060000000000C000000000000046"))
  writeTitle DUEDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8105", "0320060000000000C000000000000046"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub doAttachments(inMessage)

  If OPENATTACHMENTS Then

    If USEADOATTACHMENTURLS Then

      loginE2K

      locUsername = Request.ServerVariables("REMOTE_USER")
      locP = Instr(locUsername, "\")
      If locP <> 0 Then locUsername = Right(locUsername, Len(locUsername) - locP)

      locMsgURL = "/Exchange/" & locUsername & inMessage.Fields(&H6707001E)

      Set locConn = Server.CreateObject("ADODB.Connection")
      locConn.Provider = "ExOLEDB.DataSource"
      locConn.Open strMailboxURL
      Set locObjMessage = Server.CreateObject("CDO.Message")
      locObjMessage.DataSource.Open locMsgURL, locConn

      Set locCollAtts = locObjMessage.Attachments
      locArrAttURLs = locObjMessage.Fields("http://schemas.microsoft.com/exchange/attachlist")

      For locN = 1 To locCollAtts.Count
        writeTitle ATTACHMENTTEXT & COLONSPACETEXT
        locDisplay = locCollAtts(locN).Fields("urn:schemas:httpmail:attachmentfilename")
        locURL = locArrAttURLs(locN - 1)
        locP = InstrRev(locURL, "/")
        If locP <> 0 Then locURL = Right(locURL, Len(locURL) - locP)
        writeLinkWParams locMsgURL & "/" & locURL, locDisplay, ""
      Next

      Set locCollAtts = Nothing
      Set locObjMessage = Nothing
      locConn.Close
      Set locConn = Nothing

    Else

      For n = 1 To inMessage.Attachments.Count

        writeTitle ATTACHMENTTEXT & COLONSPACETEXT
        Set objAttachment = inMessage.Attachments(n)
        If objAttachment.Type = 1 Then
          display = objAttachment.Name
        Else
          display = objAttachment.Source
        End If
        ai = objAttachment.Index

        writeLinkWParams "AT1.asp", display, "AI,NOBR"

        rwbc " (" & Int(objAttachment.Fields(&H0E200003) / 1024) & KILOBYTESTEXT & ")"

      Next

    End If

  End If

End Sub

Sub getTextStartAndEnd

  For locN = 1 To pg
    textStart = textEnd + 1
    If textEnd + (MAXPAGESIZE - 1) < textLength Then
      textEnd = textStart + (MAXPAGESIZE - 1)
      locSpaceFound = False
      For locO = textEnd To (textStart + 1) Step - 1
        locChar = Mid(strMessageText, locO, 1)
        If (locChar = " ") Or (locChar = vbCrLf) Or (locChar = vbTab) Then
          locSpaceFound = True
          Exit For
        End If
      Next
      If locSpaceFound Then textEnd = locO
    Else
      textEnd = textLength
    End If
  Next

End Sub
%>
