<%
Sub displayAppointment(inMessage)

  On Error Resume Next

  writeTitle DATETEXT & "/" & TIMETEXT & COLONSPACETEXT
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongDate)
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongTime)
  writeTitle DURATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8213")) & " " & MINTEXT
  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle LOCATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8208"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub displayContact(inMessage)

  On Error Resume Next

  writeTitle NAMETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle TITLETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A17001F))

  writeTitle COMPANYTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A16001F))

  writeTitle EMAILTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8084", "0420060000000000C000000000000046"))

  writeTitle BUSINESSPHONETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A08001F))

  writeTitle MOBILETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A1C001F))

  writeTitle BUSINESSADDRESSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8045", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8046", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8047", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8048", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8049", "0420060000000000C000000000000046"))

End Sub

Sub displayMessage(inMessage)

  oldMT = mt
  If SHOWREPLYLINK Then
    mt = OPWCMR + OPWFRMR
    writeLink "MSE.asp", REPLYTEXT, OPWFN + OPWMN + OPWMI + OPWMT + OPWMP
  End If
  If SHOWFWDLINK Then
    mt = OPWCMF + OPWFRMR
    writeLink "MSE.asp", FORWARDTEXT, OPWFN + OPWMN + OPWMI + OPWMT + OPWMP
  End If
  mt = oldMT

  ' Are we in Sent Items?
  If checkTopFolder(objSession.GetFolder(inMessage.FolderID), 3) Then
    display = TOTEXT & COLONSPACETEXT & getMessageRecipient(inMessage)
  Else
    display = FROMTEXT & COLONSPACETEXT & getMessageSender(inMessage)
  End If

  display = displayEncode(display)
  rwbc display

  display = SUBJECTTEXT & COLONSPACETEXT & inMessage.Subject
  display = displayEncode(display)
  rwbc display

  writeUnderline

  msgStart = ((pg - 1) * MAXPAGESIZE) + 1

  strMessageText = getMessageText(inMessage)
  display = Mid(strMessageText, msgStart, MAXPAGESIZE)
  rwbc displayEncode(display)

  If (msgStart + MAXPAGESIZE) <= Len(strMessageText) Then
    pg = pg + 1
    writeLink "MSR.asp", NEXTTEXT, OPWFN + OPWMN + OPWMI + OPWPG
  End If

  pg = 0

  If SHOWFOLLOWUPLINK Then
    oldMp = mp
    If (oldmp And 6) = 2 Then inMessage.Fields(&H10900003) = 2
    If (oldmp And 6) = 4 Then inMessage.Fields(&H10900003) = 1
    If (oldmp And 6) = 6 Then inMessage.Fields(&H10900003) = 0
    ' Check Follow-up flag CdoPR_FLAG_STATUS
    ' 0 = No flag
    ' 1 = White flag
    ' 2 = Red flag 
    locMsgFlagStatus = 0
    If SHOWERRORS Then On Error Resume Next
    locMsgFlagStatus = inMessage.Fields(&H10900003)
    If SHOWERRORS Then On Error Goto 0
    Select Case locMsgFlagStatus
      Case 0
        mp = (oldMp And Not 6) Or 2
        locCaption = "Follow Up"
      Case 1
        mp = (oldMp And Not 6) Or 6
        locCaption = "Clear Flag"
      Case 2
        mp = (oldMp And Not 6) Or 4
        locCaption = "Flag Complete"
    End Select
    writeLink "MSR.asp", locCaption, OPWFN + OPWMN + OPWMI + OPWMP
    mp = oldMp
  End If

End Sub

Sub displayNote(inMessage)

  writeTitle NOTETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H1000001F))

End Sub

Sub displayPost(inMessage)

  writeTitle FROMTEXT & COLONSPACETEXT
  display = getMessageSender(inMessage)
  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  writeUnderline

  msgStart = ((pg - 1) * MAXPAGESIZE) + 1

  strMessageText = getMessageText(inMessage)
  display = Mid(strMessageText, msgStart, MAXPAGESIZE)
  rwbc displayEncode(display)

  If (msgStart + MAXPAGESIZE) <= Len(strMessageText) Then
    pg = pg + 1
    writeLink "PSR.asp", NEXTTEXT, OPWFN + OPWMN + OPWMI + OPWPG
  End If

End Sub

Sub displayTask(inMessage)

  On Error Resume Next

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle IMPORTANCETEXT & COLONSPACETEXT
  lImportance = inMessage.Fields(&H00170003)
  Select Case lImportance
    Case 0
      rwbc displayEncode(LOWTEXT)
    Case 1
      rwbc displayEncode(NORMALTEXT)
    Case 2
      rwbc displayEncode(HIGHTEXT)
  End Select

  writeTitle STATUSTEXT & COLONSPACETEXT
  lStatus = inMessage.Fields("0x8101", "0320060000000000C000000000000046")
  Select Case lStatus
    Case 0
      rwbc displayEncode(OPENTEXT)
    Case 1
      rwbc displayEncode(INPROGRESSTEXT)
    Case 2
      rwbc displayEncode(COMPLETEDTEXT)
    Case 3
      rwbc displayEncode(WAITINGONSOMEONEELSETEXT)
    Case 4
      rwbc displayEncode(DEFERREDTEXT)
  End Select

  writeTitle PERCENTCOMPLETETEXT & COLONSPACETEXT
  lPercentComplete = inMessage.Fields("0x8102", "0320060000000000C000000000000046")
  rwbc 100 * lPercentComplete & "%"

  writeTitle STARTDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8104", "0320060000000000C000000000000046"))

  writeTitle DUEDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8105", "0320060000000000C000000000000046"))

  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub
%>
