/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.identity.XPathException;

public class XPath {
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_XPATH_PARSE = false;
    private static final boolean DEBUG_ANY = false;
    protected String fExpression;
    protected LocationPath fLocationPath;
    protected StringPool fStringPool;

    public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope) throws XPathException {
        this.fExpression = string;
        this.fStringPool = stringPool;
        this.parseExpression(namespacesScope);
    }

    public LocationPath getLocationPath() {
        return (LocationPath)this.fLocationPath.clone();
    }

    public String toString() {
        return this.fLocationPath.toString();
    }

    private void parseExpression(NamespacesScope namespacesScope) throws XPathException {
        int n;
        Tokens tokens = new Tokens(this.fStringPool);
        Scanner scanner = new Scanner(this.fStringPool){

            protected void addToken(Tokens tokens, int n) throws XPathException {
                if (n == -1006 || n == -1035 || n == -1036 || n == -1008 || n == -1011 || n == -1021 || n == -1004) {
                    super.addToken(tokens, n);
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("token not supported: ");
                String string = tokens.getTokenName(n);
                if (string != null) {
                    stringBuffer.append('\"');
                    stringBuffer.append(string);
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append('(');
                    stringBuffer.append(n);
                    stringBuffer.append(')');
                }
                String string2 = stringBuffer.toString();
                throw new XPathException(string2);
            }
        };
        int n2 = this.fExpression.length();
        boolean bl = scanner.scanExpr(this.fStringPool, tokens, this.fExpression, 0, n2);
        Vector<Step> vector = new Vector<Step>();
        int n3 = tokens.getTokenCount();
        int n4 = 0;
        while (n4 < n3) {
            n = tokens.getToken(n4);
            switch (n) {
                case -1035: {
                    ++n4;
                }
                case -1006: {
                    if (n4 == n3 - 1) {
                        throw new XPathException("missing attribute name");
                    }
                    if ((n = tokens.getToken(++n4)) != -1011) {
                        throw new XPathException("expected " + tokens.getTokenName(-1011) + ", found " + tokens.getTokenName(n));
                    }
                    n = tokens.getToken(++n4);
                    int n5 = tokens.getTokenString(n);
                    int n6 = 0;
                    if (namespacesScope != null && n5 != -1) {
                        n6 = namespacesScope.getNamespaceForPrefix(n5);
                    }
                    if (n5 != -1 && namespacesScope != null && n6 == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(n5) + " not bound to namespace URI");
                    }
                    n = tokens.getToken(++n4);
                    int n7 = tokens.getTokenString(n);
                    int n8 = n5 != -1 ? this.fStringPool.addSymbol(this.fStringPool.toString(n5) + ':' + this.fStringPool.toString(n7)) : n7;
                    Axis axis = new Axis(2);
                    NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(n5, n7, n8, n6));
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1008: {
                    throw new XPathException("Not allowed to have double colon here");
                }
                case -1036: {
                    ++n4;
                }
                case -1011: {
                    n = tokens.getToken(++n4);
                    int n9 = tokens.getTokenString(n);
                    int n10 = 0;
                    if (namespacesScope != null && n9 != -1) {
                        n10 = namespacesScope.getNamespaceForPrefix(n9);
                    }
                    if (n9 != -1 && namespacesScope != null && n10 == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(n9) + " not bound to namespace URI");
                    }
                    n = tokens.getToken(++n4);
                    int n11 = tokens.getTokenString(n);
                    int n8 = n9 != -1 ? this.fStringPool.addSymbol(this.fStringPool.toString(n9) + ':' + this.fStringPool.toString(n11)) : n11;
                    Axis axis = new Axis(1);
                    NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(n9, n11, n8, n10));
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1004: {
                    Axis axis = new Axis(3);
                    NodeTest nodeTest = new NodeTest(3);
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1021: {
                    if (n4 == 0) {
                        throw new XPathException("not allowed to select the root");
                    }
                    if (n4 != n3 - 1) break;
                    throw new XPathException("expected step following '/'");
                }
            }
            ++n4;
        }
        n = vector.size();
        if (n == 0) {
            throw new XPathException("empty xpath expression");
        }
        Object[] objectArray = new Step[n];
        vector.copyInto(objectArray);
        this.fLocationPath = new LocationPath((Step[])objectArray);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("# XPath expression: \"" + string + '\"');
            try {
                StringPool stringPool = new StringPool();
                XPath xPath = new XPath(string, stringPool, null);
                System.out.println("expanded xpath: \"" + xPath.toString() + '\"');
            }
            catch (XPathException xPathException) {
                System.out.println("error: " + xPathException.getMessage());
            }
            ++n;
        }
    }

    private static class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_EXCLAMATION = 3;
        private static final byte CHARTYPE_QUOTE = 4;
        private static final byte CHARTYPE_DOLLAR = 5;
        private static final byte CHARTYPE_OPEN_PAREN = 6;
        private static final byte CHARTYPE_CLOSE_PAREN = 7;
        private static final byte CHARTYPE_STAR = 8;
        private static final byte CHARTYPE_PLUS = 9;
        private static final byte CHARTYPE_COMMA = 10;
        private static final byte CHARTYPE_MINUS = 11;
        private static final byte CHARTYPE_PERIOD = 12;
        private static final byte CHARTYPE_SLASH = 13;
        private static final byte CHARTYPE_DIGIT = 14;
        private static final byte CHARTYPE_COLON = 15;
        private static final byte CHARTYPE_LESS = 16;
        private static final byte CHARTYPE_EQUAL = 17;
        private static final byte CHARTYPE_GREATER = 18;
        private static final byte CHARTYPE_ATSIGN = 19;
        private static final byte CHARTYPE_LETTER = 20;
        private static final byte CHARTYPE_OPEN_BRACKET = 21;
        private static final byte CHARTYPE_CLOSE_BRACKET = 22;
        private static final byte CHARTYPE_UNDERSCORE = 23;
        private static final byte CHARTYPE_UNION = 24;
        private static final byte CHARTYPE_NONASCII = 25;
        private static byte[] fASCIICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 1, 5, 1, 1, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 1, 16, 17, 18, 1, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 1, 22, 1, 23, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 24, 1, 1, 1};
        private StringPool fStringPool;
        private int fAndSymbol;
        private int fOrSymbol;
        private int fModSymbol;
        private int fDivSymbol;
        private int fCommentSymbol;
        private int fTextSymbol;
        private int fPISymbol;
        private int fNodeSymbol;
        private int fAncestorSymbol;
        private int fAncestorOrSelfSymbol;
        private int fAttributeSymbol;
        private int fChildSymbol;
        private int fDescendantSymbol;
        private int fDescendantOrSelfSymbol;
        private int fFollowingSymbol;
        private int fFollowingSiblingSymbol;
        private int fNamespaceSymbol;
        private int fParentSymbol;
        private int fPrecedingSymbol;
        private int fPrecedingSiblingSymbol;
        private int fSelfSymbol;

        public Scanner(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fAndSymbol = this.fStringPool.addSymbol("and");
            this.fOrSymbol = this.fStringPool.addSymbol("or");
            this.fModSymbol = this.fStringPool.addSymbol("mod");
            this.fDivSymbol = this.fStringPool.addSymbol("div");
            this.fCommentSymbol = this.fStringPool.addSymbol("comment");
            this.fTextSymbol = this.fStringPool.addSymbol("text");
            this.fPISymbol = this.fStringPool.addSymbol("processing-instruction");
            this.fNodeSymbol = this.fStringPool.addSymbol("node");
            this.fAncestorSymbol = this.fStringPool.addSymbol("ancestor");
            this.fAncestorOrSelfSymbol = this.fStringPool.addSymbol("ancestor-or-self");
            this.fAttributeSymbol = this.fStringPool.addSymbol("attribute");
            this.fChildSymbol = this.fStringPool.addSymbol("child");
            this.fDescendantSymbol = this.fStringPool.addSymbol("descendant");
            this.fDescendantOrSelfSymbol = this.fStringPool.addSymbol("descendant-or-self");
            this.fFollowingSymbol = this.fStringPool.addSymbol("following");
            this.fFollowingSiblingSymbol = this.fStringPool.addSymbol("following-sibling");
            this.fNamespaceSymbol = this.fStringPool.addSymbol("namespace");
            this.fParentSymbol = this.fStringPool.addSymbol("parent");
            this.fPrecedingSymbol = this.fStringPool.addSymbol("preceding");
            this.fPrecedingSiblingSymbol = this.fStringPool.addSymbol("preceding-sibling");
            this.fSelfSymbol = this.fStringPool.addSymbol("self");
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean scanExpr(StringPool stringPool, Tokens tokens, String string, int n, int n2) throws XPathException {
            boolean bl = false;
            block24: while (n != n2) {
                char c = string.charAt(n);
                while (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                    if (++n == n2) break;
                    c = string.charAt(n);
                }
                if (n == n2) {
                    return true;
                }
                int n3 = c >= '\u0080' ? 25 : fASCIICharMap[c];
                block0 : switch (n3) {
                    case 6: {
                        this.addToken(tokens, -1000);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 7: {
                        this.addToken(tokens, -1001);
                        bl = true;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 21: {
                        this.addToken(tokens, -1002);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 22: {
                        this.addToken(tokens, -1003);
                        bl = true;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 12: {
                        if (n + 1 == n2) {
                            this.addToken(tokens, -1004);
                            bl = true;
                            ++n;
                            break;
                        }
                        c = string.charAt(n + 1);
                        if (c == '.') {
                            this.addToken(tokens, -1005);
                            bl = true;
                            n += 2;
                        } else if (c >= '0' && c <= '9') {
                            this.addToken(tokens, -1047);
                            bl = true;
                            n = this.scanNumber(tokens, string, n2, n);
                        } else {
                            this.addToken(tokens, -1004);
                            bl = true;
                            ++n;
                        }
                        if (n != n2) continue block24;
                        break;
                    }
                    case 19: {
                        this.addToken(tokens, -1006);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 10: {
                        this.addToken(tokens, -1007);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 15: {
                        if (++n == n2) {
                            System.out.println("abort 1a");
                            return false;
                        }
                        c = string.charAt(n);
                        if (c != ':') {
                            System.out.println("abort 1b");
                            return false;
                        }
                        this.addToken(tokens, -1008);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 13: {
                        if (++n == n2) {
                            this.addToken(tokens, -1021);
                            bl = false;
                            break;
                        }
                        c = string.charAt(n);
                        if (c == '/') {
                            this.addToken(tokens, -1022);
                            bl = false;
                            if (++n != n2) continue block24;
                            break;
                        }
                        this.addToken(tokens, -1021);
                        bl = false;
                        break;
                    }
                    case 24: {
                        this.addToken(tokens, -1023);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 9: {
                        this.addToken(tokens, -1024);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 11: {
                        this.addToken(tokens, -1025);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 17: {
                        this.addToken(tokens, -1026);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 3: {
                        if (++n == n2) {
                            System.out.println("abort 2a");
                            return false;
                        }
                        c = string.charAt(n);
                        if (c != '=') {
                            System.out.println("abort 2b");
                            return false;
                        }
                        this.addToken(tokens, -1027);
                        bl = false;
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 16: {
                        if (++n == n2) {
                            this.addToken(tokens, -1028);
                            bl = false;
                            break;
                        }
                        c = string.charAt(n);
                        if (c == '=') {
                            this.addToken(tokens, -1029);
                            bl = false;
                            if (++n != n2) continue block24;
                            break;
                        }
                        this.addToken(tokens, -1028);
                        bl = false;
                        break;
                    }
                    case 18: {
                        if (++n == n2) {
                            this.addToken(tokens, -1030);
                            bl = false;
                            break;
                        }
                        c = string.charAt(n);
                        if (c == '=') {
                            this.addToken(tokens, -1031);
                            bl = false;
                            if (++n != n2) continue block24;
                            break;
                        }
                        this.addToken(tokens, -1030);
                        bl = false;
                        break;
                    }
                    case 4: {
                        char c2 = c;
                        if (++n == n2) {
                            System.out.println("abort 2c");
                            return false;
                        }
                        c = string.charAt(n);
                        int n4 = n;
                        while (true) {
                            if (c == c2) {
                                int n5 = n - n4;
                                this.addToken(tokens, -1046);
                                bl = true;
                                tokens.addToken(stringPool.addSymbol(string.substring(n4, n4 + n5)));
                                if (++n != n2) continue block24;
                                break block0;
                            }
                            if (++n == n2) {
                                System.out.println("abort 2d");
                                return false;
                            }
                            c = string.charAt(n);
                        }
                    }
                    case 14: {
                        this.addToken(tokens, -1047);
                        bl = true;
                        n = this.scanNumber(tokens, string, n2, n);
                        break;
                    }
                    case 5: {
                        int n6;
                        if (++n == n2) {
                            System.out.println("abort 3a");
                            return false;
                        }
                        c = string.charAt(n);
                        int n7 = n;
                        if (c >= '\u0080') {
                            throw new RuntimeException("need encoding support");
                        }
                        n3 = fASCIICharMap[c];
                        if (n3 != 20 && n3 != 23) {
                            System.out.println("abort 3b");
                            return false;
                        }
                        while (++n < n2) {
                            c = string.charAt(n);
                            if (c >= '\u0080') {
                                throw new RuntimeException("need encoding support");
                            }
                            n3 = fASCIICharMap[c];
                            if (n3 == 20 || n3 == 14 || n3 == 12 || n3 == 11 || n3 == 23) continue;
                        }
                        int n8 = stringPool.addSymbol(string.substring(n7, n));
                        if (c != ':') {
                            n6 = -1;
                        } else {
                            n6 = n8;
                            if (++n == n2) {
                                System.out.println("abort 4a");
                                return false;
                            }
                            c = string.charAt(n);
                            n7 = n;
                            if (c >= '\u0080') {
                                throw new RuntimeException("need encoding support");
                            }
                            n3 = fASCIICharMap[c];
                            if (n3 != 20 && n3 != 23) {
                                System.out.println("abort 4b");
                                return false;
                            }
                            while (++n < n2) {
                                c = string.charAt(n);
                                if (c >= '\u0080') {
                                    throw new RuntimeException("need encoding support");
                                }
                                n3 = fASCIICharMap[c];
                                if (n3 == 20 || n3 == 14 || n3 == 12 || n3 == 11 || n3 == 23) continue;
                            }
                            n8 = stringPool.addSymbol(string.substring(n7, n));
                        }
                        this.addToken(tokens, -1048);
                        bl = true;
                        tokens.addToken(n6);
                        tokens.addToken(n8);
                        break;
                    }
                    case 8: {
                        if (bl) {
                            this.addToken(tokens, -1020);
                            bl = false;
                        } else {
                            this.addToken(tokens, -1009);
                            bl = true;
                        }
                        if (++n != n2) continue block24;
                        break;
                    }
                    case 25: {
                        throw new RuntimeException("need encoding support");
                    }
                    case 20: 
                    case 23: {
                        int n7 = n;
                        while (++n != n2) {
                            c = string.charAt(n);
                            if (c >= '\u0080') {
                                throw new RuntimeException("need encoding support");
                            }
                            n3 = fASCIICharMap[c];
                            if (n3 == 20 || n3 == 14 || n3 == 12 || n3 == 11 || n3 == 23) continue;
                        }
                        int n8 = stringPool.addSymbol(string.substring(n7, n));
                        boolean bl2 = false;
                        boolean bl3 = false;
                        int n6 = -1;
                        if (c == ':') {
                            if (++n == n2) {
                                System.out.println("abort 5");
                                return false;
                            }
                            c = string.charAt(n);
                            if (c == '*') {
                                if (++n < n2) {
                                    c = string.charAt(n);
                                }
                                bl2 = true;
                            } else if (c == ':') {
                                if (++n < n2) {
                                    c = string.charAt(n);
                                }
                                bl3 = true;
                            } else {
                                n6 = n8;
                                n7 = n;
                                if (c >= '\u0080') {
                                    throw new RuntimeException("need encoding support");
                                }
                                n3 = fASCIICharMap[c];
                                if (n3 != 20 && n3 != 23) {
                                    System.out.println("abort 5b");
                                    return false;
                                }
                                while (++n < n2) {
                                    c = string.charAt(n);
                                    if (c >= '\u0080') {
                                        throw new RuntimeException("need encoding support");
                                    }
                                    n3 = fASCIICharMap[c];
                                    if (n3 == 20 || n3 == 14 || n3 == 12 || n3 == 11 || n3 == 23) continue;
                                }
                                n8 = stringPool.addSymbol(string.substring(n7, n));
                            }
                        }
                        while ((c == ' ' || c == '\n' || c == '\t' || c == '\r') && ++n != n2) {
                            c = string.charAt(n);
                        }
                        if (bl) {
                            if (n8 == this.fAndSymbol) {
                                this.addToken(tokens, -1016);
                                bl = false;
                            } else if (n8 == this.fOrSymbol) {
                                this.addToken(tokens, -1017);
                                bl = false;
                            } else if (n8 == this.fModSymbol) {
                                this.addToken(tokens, -1018);
                                bl = false;
                            } else {
                                if (n8 != this.fDivSymbol) {
                                    System.out.println("abort 6");
                                    return false;
                                }
                                this.addToken(tokens, -1019);
                                bl = false;
                            }
                            if (bl2) {
                                System.out.println("abort 7");
                                return false;
                            }
                            if (!bl3) continue block24;
                            System.out.println("abort 8");
                            return false;
                        }
                        if (c == '(' && !bl2 && !bl3) {
                            if (n8 == this.fCommentSymbol) {
                                this.addToken(tokens, -1012);
                            } else if (n8 == this.fTextSymbol) {
                                this.addToken(tokens, -1013);
                            } else if (n8 == this.fPISymbol) {
                                this.addToken(tokens, -1014);
                            } else if (n8 == this.fNodeSymbol) {
                                this.addToken(tokens, -1015);
                            } else {
                                this.addToken(tokens, -1032);
                                tokens.addToken(n6);
                                tokens.addToken(n8);
                            }
                            this.addToken(tokens, -1000);
                            bl = false;
                            if (++n != n2) continue block24;
                            break;
                        }
                        if (bl3 || c == ':' && n + 1 < n2 && string.charAt(n + 1) == ':') {
                            if (n8 == this.fAncestorSymbol) {
                                this.addToken(tokens, -1033);
                            } else if (n8 == this.fAncestorOrSelfSymbol) {
                                this.addToken(tokens, -1034);
                            } else if (n8 == this.fAttributeSymbol) {
                                this.addToken(tokens, -1035);
                            } else if (n8 == this.fChildSymbol) {
                                this.addToken(tokens, -1036);
                            } else if (n8 == this.fDescendantSymbol) {
                                this.addToken(tokens, -1037);
                            } else if (n8 == this.fDescendantOrSelfSymbol) {
                                this.addToken(tokens, -1038);
                            } else if (n8 == this.fFollowingSymbol) {
                                this.addToken(tokens, -1039);
                            } else if (n8 == this.fFollowingSiblingSymbol) {
                                this.addToken(tokens, -1040);
                            } else if (n8 == this.fNamespaceSymbol) {
                                this.addToken(tokens, -1041);
                            } else if (n8 == this.fParentSymbol) {
                                this.addToken(tokens, -1042);
                            } else if (n8 == this.fPrecedingSymbol) {
                                this.addToken(tokens, -1043);
                            } else if (n8 == this.fPrecedingSiblingSymbol) {
                                this.addToken(tokens, -1044);
                            } else {
                                if (n8 != this.fSelfSymbol) {
                                    System.out.println("abort 9");
                                    return false;
                                }
                                this.addToken(tokens, -1045);
                            }
                            if (bl2) {
                                System.out.println("abort 10");
                                return false;
                            }
                            this.addToken(tokens, -1008);
                            bl = false;
                            if (bl3) continue block24;
                            ++n;
                            if (++n != n2) continue block24;
                            break;
                        }
                        if (bl2) {
                            this.addToken(tokens, -1010);
                            bl = true;
                            tokens.addToken(n8);
                            break;
                        }
                        this.addToken(tokens, -1011);
                        bl = true;
                        tokens.addToken(n6);
                        tokens.addToken(n8);
                        continue block24;
                    }
                }
            }
            return true;
        }

        private int scanNumber(Tokens tokens, String string, int n, int n2) {
            char c = string.charAt(n2);
            int n3 = 0;
            int n4 = 0;
            while (c >= '0' && c <= '9') {
                n3 = n3 * 10 + (c - 48);
                if (++n2 == n) break;
                c = string.charAt(n2);
            }
            if (c == '.' && ++n2 < n) {
                int n5 = n2;
                c = string.charAt(n2);
                while (c >= '0' && c <= '9') {
                    n4 = n4 * 10 + (c - 48);
                    if (++n2 == n) break;
                    c = string.charAt(n2);
                }
                if (n4 != 0) {
                    throw new RuntimeException("find a solution!");
                }
            }
            tokens.addToken(n3);
            tokens.addToken(n4);
            return n2;
        }

        protected void addToken(Tokens tokens, int n) throws XPathException {
            tokens.addToken(n);
        }
    }

    private static final class Tokens {
        static final boolean DUMP_TOKENS = false;
        public static final int EXPRTOKEN_OPEN_PAREN = -1000;
        public static final int EXPRTOKEN_CLOSE_PAREN = -1001;
        public static final int EXPRTOKEN_OPEN_BRACKET = -1002;
        public static final int EXPRTOKEN_CLOSE_BRACKET = -1003;
        public static final int EXPRTOKEN_PERIOD = -1004;
        public static final int EXPRTOKEN_DOUBLE_PERIOD = -1005;
        public static final int EXPRTOKEN_ATSIGN = -1006;
        public static final int EXPRTOKEN_COMMA = -1007;
        public static final int EXPRTOKEN_DOUBLE_COLON = -1008;
        public static final int EXPRTOKEN_NAMETEST_ANY = -1009;
        public static final int EXPRTOKEN_NAMETEST_NAMESPACE = -1010;
        public static final int EXPRTOKEN_NAMETEST_QNAME = -1011;
        public static final int EXPRTOKEN_NODETYPE_COMMENT = -1012;
        public static final int EXPRTOKEN_NODETYPE_TEXT = -1013;
        public static final int EXPRTOKEN_NODETYPE_PI = -1014;
        public static final int EXPRTOKEN_NODETYPE_NODE = -1015;
        public static final int EXPRTOKEN_OPERATOR_AND = -1016;
        public static final int EXPRTOKEN_OPERATOR_OR = -1017;
        public static final int EXPRTOKEN_OPERATOR_MOD = -1018;
        public static final int EXPRTOKEN_OPERATOR_DIV = -1019;
        public static final int EXPRTOKEN_OPERATOR_MULT = -1020;
        public static final int EXPRTOKEN_OPERATOR_SLASH = -1021;
        public static final int EXPRTOKEN_OPERATOR_DOUBLE_SLASH = -1022;
        public static final int EXPRTOKEN_OPERATOR_UNION = -1023;
        public static final int EXPRTOKEN_OPERATOR_PLUS = -1024;
        public static final int EXPRTOKEN_OPERATOR_MINUS = -1025;
        public static final int EXPRTOKEN_OPERATOR_EQUAL = -1026;
        public static final int EXPRTOKEN_OPERATOR_NOT_EQUAL = -1027;
        public static final int EXPRTOKEN_OPERATOR_LESS = -1028;
        public static final int EXPRTOKEN_OPERATOR_LESS_EQUAL = -1029;
        public static final int EXPRTOKEN_OPERATOR_GREATER = -1030;
        public static final int EXPRTOKEN_OPERATOR_GREATER_EQUAL = -1031;
        public static final int EXPRTOKEN_FIRST_OPERATOR = -1016;
        public static final int EXPRTOKEN_LAST_OPERATOR = -1031;
        public static final int EXPRTOKEN_FUNCTION_NAME = -1032;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR = -1033;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF = -1034;
        public static final int EXPRTOKEN_AXISNAME_ATTRIBUTE = -1035;
        public static final int EXPRTOKEN_AXISNAME_CHILD = -1036;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT = -1037;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF = -1038;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING = -1039;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING = -1040;
        public static final int EXPRTOKEN_AXISNAME_NAMESPACE = -1041;
        public static final int EXPRTOKEN_AXISNAME_PARENT = -1042;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING = -1043;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING_SIBLING = -1044;
        public static final int EXPRTOKEN_AXISNAME_SELF = -1045;
        public static final int EXPRTOKEN_LITERAL = -1046;
        public static final int EXPRTOKEN_NUMBER = -1047;
        public static final int EXPRTOKEN_VARIABLE_REFERENCE = -1048;
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private StringPool fStringPool;
        private Hashtable fSymbolMapping = new Hashtable();
        private Hashtable fTokenNames = new Hashtable();

        public Tokens(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fTokenNames.put(new Integer(-1000), "EXPRTOKEN_OPEN_PAREN");
            this.fTokenNames.put(new Integer(-1001), "EXPRTOKEN_CLOSE_PAREN");
            this.fTokenNames.put(new Integer(-1002), "EXPRTOKEN_OPEN_BRACKET");
            this.fTokenNames.put(new Integer(-1003), "EXPRTOKEN_CLOSE_BRACKET");
            this.fTokenNames.put(new Integer(-1004), "EXPRTOKEN_PERIOD");
            this.fTokenNames.put(new Integer(-1005), "EXPRTOKEN_DOUBLE_PERIOD");
            this.fTokenNames.put(new Integer(-1006), "EXPRTOKEN_ATSIGN");
            this.fTokenNames.put(new Integer(-1007), "EXPRTOKEN_COMMA");
            this.fTokenNames.put(new Integer(-1008), "EXPRTOKEN_DOUBLE_COLON");
            this.fTokenNames.put(new Integer(-1009), "EXPRTOKEN_NAMETEST_ANY");
            this.fTokenNames.put(new Integer(-1010), "EXPRTOKEN_NAMETEST_NAMESPACE");
            this.fTokenNames.put(new Integer(-1011), "EXPRTOKEN_NAMETEST_QNAME");
            this.fTokenNames.put(new Integer(-1012), "EXPRTOKEN_NODETYPE_COMMENT");
            this.fTokenNames.put(new Integer(-1013), "EXPRTOKEN_NODETYPE_TEXT");
            this.fTokenNames.put(new Integer(-1014), "EXPRTOKEN_NODETYPE_PI");
            this.fTokenNames.put(new Integer(-1015), "EXPRTOKEN_NODETYPE_NODE");
            this.fTokenNames.put(new Integer(-1016), "EXPRTOKEN_OPERATOR_AND");
            this.fTokenNames.put(new Integer(-1017), "EXPRTOKEN_OPERATOR_OR");
            this.fTokenNames.put(new Integer(-1018), "EXPRTOKEN_OPERATOR_MOD");
            this.fTokenNames.put(new Integer(-1019), "EXPRTOKEN_OPERATOR_DIV");
            this.fTokenNames.put(new Integer(-1020), "EXPRTOKEN_OPERATOR_MULT");
            this.fTokenNames.put(new Integer(-1021), "EXPRTOKEN_OPERATOR_SLASH");
            this.fTokenNames.put(new Integer(-1022), "EXPRTOKEN_OPERATOR_DOUBLE_SLASH");
            this.fTokenNames.put(new Integer(-1023), "EXPRTOKEN_OPERATOR_UNION");
            this.fTokenNames.put(new Integer(-1024), "EXPRTOKEN_OPERATOR_PLUS");
            this.fTokenNames.put(new Integer(-1025), "EXPRTOKEN_OPERATOR_MINUS");
            this.fTokenNames.put(new Integer(-1026), "EXPRTOKEN_OPERATOR_EQUAL");
            this.fTokenNames.put(new Integer(-1027), "EXPRTOKEN_OPERATOR_NOT_EQUAL");
            this.fTokenNames.put(new Integer(-1028), "EXPRTOKEN_OPERATOR_LESS");
            this.fTokenNames.put(new Integer(-1029), "EXPRTOKEN_OPERATOR_LESS_EQUAL");
            this.fTokenNames.put(new Integer(-1030), "EXPRTOKEN_OPERATOR_GREATER");
            this.fTokenNames.put(new Integer(-1031), "EXPRTOKEN_OPERATOR_GREATER_EQUAL");
            this.fTokenNames.put(new Integer(-1032), "EXPRTOKEN_FUNCTION_NAME");
            this.fTokenNames.put(new Integer(-1033), "EXPRTOKEN_AXISNAME_ANCESTOR");
            this.fTokenNames.put(new Integer(-1034), "EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF");
            this.fTokenNames.put(new Integer(-1035), "EXPRTOKEN_AXISNAME_ATTRIBUTE");
            this.fTokenNames.put(new Integer(-1036), "EXPRTOKEN_AXISNAME_CHILD");
            this.fTokenNames.put(new Integer(-1037), "EXPRTOKEN_AXISNAME_DESCENDANT");
            this.fTokenNames.put(new Integer(-1038), "EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF");
            this.fTokenNames.put(new Integer(-1039), "EXPRTOKEN_AXISNAME_FOLLOWING");
            this.fTokenNames.put(new Integer(-1040), "EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING");
            this.fTokenNames.put(new Integer(-1041), "EXPRTOKEN_AXISNAME_NAMESPACE");
            this.fTokenNames.put(new Integer(-1042), "EXPRTOKEN_AXISNAME_PARENT");
            this.fTokenNames.put(new Integer(-1043), "EXPRTOKEN_AXISNAME_PRECEDING");
            this.fTokenNames.put(new Integer(-1044), "EXPRTOKEN_AXISNAME_PRECEDING_SIBLING");
            this.fTokenNames.put(new Integer(-1045), "EXPRTOKEN_AXISNAME_SELF");
            this.fTokenNames.put(new Integer(-1046), "EXPRTOKEN_LITERAL");
            this.fTokenNames.put(new Integer(-1047), "EXPRTOKEN_NUMBER");
            this.fTokenNames.put(new Integer(-1048), "EXPRTOKEN_VARIABLE_REFERENCE");
        }

        public String getTokenName(int n) {
            return (String)this.fTokenNames.get(new Integer(n));
        }

        public int getTokenString(int n) {
            return n;
        }

        public void addToken(int n) {
            try {
                this.fTokens[this.fTokenCount] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(nArray, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = n;
            }
            ++this.fTokenCount;
        }

        public int getTokenCount() {
            return this.fTokenCount;
        }

        public int getToken(int n) {
            return this.fTokens[n];
        }

        public void dumpTokens() {
            int n = 0;
            while (n < this.fTokenCount) {
                switch (this.fTokens[n]) {
                    case -1000: {
                        System.out.print("<OPEN_PAREN/>");
                        break;
                    }
                    case -1001: {
                        System.out.print("<CLOSE_PAREN/>");
                        break;
                    }
                    case -1002: {
                        System.out.print("<OPEN_BRACKET/>");
                        break;
                    }
                    case -1003: {
                        System.out.print("<CLOSE_BRACKET/>");
                        break;
                    }
                    case -1004: {
                        System.out.print("<PERIOD/>");
                        break;
                    }
                    case -1005: {
                        System.out.print("<DOUBLE_PERIOD/>");
                        break;
                    }
                    case -1006: {
                        System.out.print("<ATSIGN/>");
                        break;
                    }
                    case -1007: {
                        System.out.print("<COMMA/>");
                        break;
                    }
                    case -1008: {
                        System.out.print("<DOUBLE_COLON/>");
                        break;
                    }
                    case -1009: {
                        System.out.print("<NAMETEST_ANY/>");
                        break;
                    }
                    case -1010: {
                        System.out.print("<NAMETEST_NAMESPACE");
                        System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1011: {
                        System.out.print("<NAMETEST_QNAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1012: {
                        System.out.print("<NODETYPE_COMMENT/>");
                        break;
                    }
                    case -1013: {
                        System.out.print("<NODETYPE_TEXT/>");
                        break;
                    }
                    case -1014: {
                        System.out.print("<NODETYPE_PI/>");
                        break;
                    }
                    case -1015: {
                        System.out.print("<NODETYPE_NODE/>");
                        break;
                    }
                    case -1016: {
                        System.out.print("<OPERATOR_AND/>");
                        break;
                    }
                    case -1017: {
                        System.out.print("<OPERATOR_OR/>");
                        break;
                    }
                    case -1018: {
                        System.out.print("<OPERATOR_MOD/>");
                        break;
                    }
                    case -1019: {
                        System.out.print("<OPERATOR_DIV/>");
                        break;
                    }
                    case -1020: {
                        System.out.print("<OPERATOR_MULT/>");
                        break;
                    }
                    case -1021: {
                        System.out.print("<OPERATOR_SLASH/>");
                        if (n + 1 >= this.fTokenCount) break;
                        System.out.println();
                        System.out.print("  ");
                        break;
                    }
                    case -1022: {
                        System.out.print("<OPERATOR_DOUBLE_SLASH/>");
                        break;
                    }
                    case -1023: {
                        System.out.print("<OPERATOR_UNION/>");
                        break;
                    }
                    case -1024: {
                        System.out.print("<OPERATOR_PLUS/>");
                        break;
                    }
                    case -1025: {
                        System.out.print("<OPERATOR_MINUS/>");
                        break;
                    }
                    case -1026: {
                        System.out.print("<OPERATOR_EQUAL/>");
                        break;
                    }
                    case -1027: {
                        System.out.print("<OPERATOR_NOT_EQUAL/>");
                        break;
                    }
                    case -1028: {
                        System.out.print("<OPERATOR_LESS/>");
                        break;
                    }
                    case -1029: {
                        System.out.print("<OPERATOR_LESS_EQUAL/>");
                        break;
                    }
                    case -1030: {
                        System.out.print("<OPERATOR_GREATER/>");
                        break;
                    }
                    case -1031: {
                        System.out.print("<OPERATOR_GREATER_EQUAL/>");
                        break;
                    }
                    case -1032: {
                        System.out.print("<FUNCTION_NAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1033: {
                        System.out.print("<AXISNAME_ANCESTOR/>");
                        break;
                    }
                    case -1034: {
                        System.out.print("<AXISNAME_ANCESTOR_OR_SELF/>");
                        break;
                    }
                    case -1035: {
                        System.out.print("<AXISNAME_ATTRIBUTE/>");
                        break;
                    }
                    case -1036: {
                        System.out.print("<AXISNAME_CHILD/>");
                        break;
                    }
                    case -1037: {
                        System.out.print("<AXISNAME_DESCENDANT/>");
                        break;
                    }
                    case -1038: {
                        System.out.print("<AXISNAME_DESCENDANT_OR_SELF/>");
                        break;
                    }
                    case -1039: {
                        System.out.print("<AXISNAME_FOLLOWING/>");
                        break;
                    }
                    case -1040: {
                        System.out.print("<AXISNAME_FOLLOWING_SIBLING/>");
                        break;
                    }
                    case -1041: {
                        System.out.print("<AXISNAME_NAMESPACE/>");
                        break;
                    }
                    case -1042: {
                        System.out.print("<AXISNAME_PARENT/>");
                        break;
                    }
                    case -1043: {
                        System.out.print("<AXISNAME_PRECEDING/>");
                        break;
                    }
                    case -1044: {
                        System.out.print("<AXISNAME_PRECEDING_SIBLING/>");
                        break;
                    }
                    case -1045: {
                        System.out.print("<AXISNAME_SELF/>");
                        break;
                    }
                    case -1046: {
                        System.out.print("<LITERAL");
                        System.out.print(" value=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1047: {
                        System.out.print("<NUMBER");
                        System.out.print(" whole=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print(" part=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1048: {
                        System.out.print("<VARIABLE_REFERENCE");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    default: {
                        System.out.println("<???/>");
                    }
                }
                ++n;
            }
            System.out.println();
        }
    }

    public static class NodeTest
    implements Cloneable {
        public static final short QNAME = 1;
        public static final short WILDCARD = 2;
        public static final short NODE = 3;
        protected StringPool fStringPool;
        public short type;
        public final QName name = new QName();

        public NodeTest(short s) {
            this.type = s;
        }

        public NodeTest(StringPool stringPool, QName qName) {
            this.fStringPool = stringPool;
            this.type = 1;
            this.name.setValues(qName);
        }

        public NodeTest(NodeTest nodeTest) {
            this.fStringPool = nodeTest.fStringPool;
            this.type = nodeTest.type;
            this.name.setValues(nodeTest.name);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return this.fStringPool.toString(this.name.prefix) + ':' + this.fStringPool.toString(this.name.localpart);
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ':' + this.fStringPool.toString(this.name.localpart);
                    }
                    return this.fStringPool.toString(this.name.localpart);
                }
                case 2: {
                    return "*";
                }
                case 3: {
                    return "node()";
                }
            }
            return "???";
        }

        public Object clone() {
            return new NodeTest(this);
        }
    }

    public static class Axis
    implements Cloneable {
        public static final short CHILD = 1;
        public static final short ATTRIBUTE = 2;
        public static final short SELF = 3;
        public short type;

        public Axis(short s) {
            this.type = s;
        }

        protected Axis(Axis axis) {
            this.type = axis.type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "child";
                }
                case 2: {
                    return "attribute";
                }
                case 3: {
                    return "self";
                }
            }
            return "???";
        }

        public Object clone() {
            return new Axis(this);
        }
    }

    public static class Step
    implements Cloneable {
        public Axis axis;
        public NodeTest nodeTest;

        public Step(Axis axis, NodeTest nodeTest) {
            this.axis = axis;
            this.nodeTest = nodeTest;
        }

        protected Step(Step step) {
            this.axis = (Axis)step.axis.clone();
            this.nodeTest = (NodeTest)step.nodeTest.clone();
        }

        public String toString() {
            if (this.axis.type == 3) {
                return ".";
            }
            if (this.axis.type == 2) {
                return "@" + this.nodeTest.toString();
            }
            if (this.axis.type == 1) {
                return this.nodeTest.toString();
            }
            return "??? (" + this.axis.type + ')';
        }

        public Object clone() {
            return new Step(this);
        }
    }

    public static class LocationPath
    implements Cloneable {
        public Step[] steps;

        public LocationPath(Step[] stepArray) {
            this.steps = stepArray;
        }

        protected LocationPath(LocationPath locationPath) {
            this.steps = new Step[locationPath.steps.length];
            int n = 0;
            while (n < this.steps.length) {
                this.steps[n] = (Step)locationPath.steps[n].clone();
                ++n;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.steps.length) {
                if (n > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(this.steps[n].toString());
                ++n;
            }
            return stringBuffer.toString();
        }

        public Object clone() {
            return new LocationPath(this);
        }
    }
}

