// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-rulout.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : external transition methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================



// =========
void TuringMachine::build_outside_tact1_transitions ()
{

typedef map<CurOutsideSituation, NextOutsideSituation>::value_type value_type;
pair<map<CurOutsideSituation, NextOutsideSituation>::iterator, bool>	couple;

  // ----------- 1.1 -----------
  couple = outside_tact1_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				PASSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);

  // ----------- 1.2 -----------
  couple = outside_tact1_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_emergency_states_s.front(),
				PASSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_emergency_states_s.front(),
				false
				)
			));
  assert (couple.second);


  // ----------- 1.3 -----------
  couple = outside_tact1_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_stabilizing_states_s.front(),
				apparatus_emergency_states_s.front(),
				PASSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_stabilizing_states_s.front(),
				apparatus_emergency_states_s.front(),
				false
				)
			));
  assert (couple.second);




  // ----------- 2 -----------
  couple = outside_tact1_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				ACTIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE
				), 
			NextOutsideSituation (
				daemon_active_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);


  // ----------- 3 -----------
  couple = outside_tact1_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				AGGRESSIVE_NON_DETERMINISTIC_OUTSIDE_RULE_TYPE
				), 
			NextOutsideSituation (
				daemon_aggressive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);


} // build_outside_tact1_transitions   



// =========
void TuringMachine::build_outside_tact2_transitions ()
{

typedef map<CurOutsideSituation, NextOutsideSituation>::value_type value_type;
pair<map<CurOutsideSituation, NextOutsideSituation>::iterator, bool>	couple;

  // ----------- 1 -----------
  couple = outside_tact2_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front()
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);


  // ----------- 2 -----------
  couple = outside_tact2_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_active_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front()
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);


  // ----------- 3 -----------
  couple = outside_tact2_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_aggressive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front()
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_emergency_states_s.front(),
				false
				)
			));
  assert (couple.second);


  // ----------- 4 -----------
  couple = outside_tact2_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_emergency_states_s.front()
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_stabilizing_states_s.front(),
				apparatus_emergency_states_s.front(),
				false
				)
			));
  assert (couple.second);



  // ----------- 5 -----------
  couple = outside_tact2_transitions_.insert (value_type (
			CurOutsideSituation (
				daemon_passive_states_s.front(),
				tester_stabilizing_states_s.front(),
				apparatus_emergency_states_s.front()
				), 
			NextOutsideSituation (
				daemon_passive_states_s.front(),
				tester_tracking_states_s.front(),
				apparatus_normal_states_s.front(),
				true
				)
			));
  assert (couple.second);


} // build_outside_tact2_transitions   

