/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.playlist;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javazoom.Util.Config;
import javazoom.Util.Debug;
import javazoom.jlGui.playlist.Playlist;
import javazoom.jlGui.playlist.PlaylistItem;

public class BasePlaylist
implements Playlist {
    protected Vector _playlist = new Vector();
    protected int _cursorPos = -1;
    public boolean isModified;

    public boolean isModified() {
        return this.isModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String string) {
        this.setModified(true);
        Config config = Config.getInstance();
        this._playlist = new Vector();
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = string.toLowerCase().startsWith("http") ? new BufferedReader(new InputStreamReader(new URL(string).openStream())) : new BufferedReader(new FileReader(string));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Object var8_11 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.startsWith("#")) {
                    n = string2.indexOf(",", 0);
                    if (n == -1) continue;
                    string3 = string2.substring(n + 1, string2.length());
                    continue;
                }
                n = 1;
                string4 = string2;
                if (string4.startsWith("http://")) {
                    n = 0;
                    if (string3 == null) {
                        string3 = string4;
                    }
                }
                if (string3 == null) {
                    string3 = string4;
                    string3 = string3.substring(string3.lastIndexOf(System.getProperty("file.separator")) + 1, string3.length());
                }
                PlaylistItem playlistItem = new PlaylistItem(string3, string4, -1L, n != 0);
                if (n != 0) {
                    File file = new File(playlistItem.getLocation());
                    if (file.exists()) {
                        this.appendItem(playlistItem);
                    } else {
                        file = new File(config.getLastDir() + playlistItem.getLocation());
                        if (file.exists()) {
                            playlistItem.setLocation(config.getLastDir() + playlistItem.getLocation());
                            this.appendItem(playlistItem);
                        }
                    }
                } else {
                    this.appendItem(playlistItem);
                }
                string4 = null;
                string3 = null;
                var8_11 = null;
            }
            bl = true;
        }
        catch (Exception exception) {
            this.trace(2, this.getClass().getName(), "Can't load playlist : " + exception.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                this.trace(1, this.getClass().getName(), "Can't close playlist : " + exception.getMessage());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String string) {
        if (this._playlist != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                Iterator iterator = this._playlist.iterator();
                while (iterator.hasNext()) {
                    PlaylistItem playlistItem = (PlaylistItem)iterator.next();
                    bufferedWriter.write("#EXTINF:-1," + playlistItem.getM3UExtInf());
                    bufferedWriter.newLine();
                    bufferedWriter.write(playlistItem.getLocation());
                    bufferedWriter.newLine();
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                this.trace(1, this.getClass().getName(), "Can't save playlist : " + iOException.getMessage());
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    this.trace(1, this.getClass().getName(), "Can't close playlist : " + iOException.getMessage());
                }
            }
        }
        return false;
    }

    public void addItemAt(PlaylistItem playlistItem, int n) {
        this._playlist.insertElementAt(playlistItem, n);
        this.setModified(true);
    }

    public void removeItem(PlaylistItem playlistItem) {
        this._playlist.remove(playlistItem);
        this.setModified(true);
    }

    public void removeItemAt(int n) {
        this._playlist.removeElementAt(n);
        this.setModified(true);
    }

    public void removeAllItems() {
        this._playlist.removeAllElements();
        this._cursorPos = -1;
        this.setModified(true);
    }

    public void appendItem(PlaylistItem playlistItem) {
        this._playlist.addElement(playlistItem);
        this.setModified(true);
    }

    public void sortItems(int n) {
    }

    public void shuffle() {
        int n = this._playlist.size();
        if (n < 2) {
            return;
        }
        Vector vector = this._playlist;
        this._playlist = new Vector(n);
        while ((n = vector.size()) > 0) {
            this._playlist.addElement(vector.remove((int)(Math.random() * (double)n)));
        }
        this.begin();
    }

    public void begin() {
        this._cursorPos = -1;
        if (this.getPlaylistSize() > 0) {
            this._cursorPos = 0;
        }
        this.setModified(true);
    }

    public PlaylistItem getItemAt(int n) {
        PlaylistItem playlistItem = null;
        playlistItem = (PlaylistItem)this._playlist.elementAt(n);
        return playlistItem;
    }

    public Collection getAllItems() {
        return null;
    }

    public int getPlaylistSize() {
        return this._playlist.size();
    }

    public PlaylistItem getCursor() {
        if (this._cursorPos < 0 || this._cursorPos >= this._playlist.size()) {
            return null;
        }
        return this.getItemAt(this._cursorPos);
    }

    public void nextCursor() {
        ++this._cursorPos;
        if (this._cursorPos >= this._playlist.size()) {
            this._cursorPos = this._playlist.size() - 1;
        }
    }

    public void previousCursor() {
        --this._cursorPos;
        if (this._cursorPos < 0) {
            this._cursorPos = 0;
        }
    }

    public boolean setModified(boolean bl) {
        this.isModified = bl;
        return this.isModified;
    }

    public void setCursor(int n) {
        this._cursorPos = n;
    }

    public int getSelectedIndex() {
        return this._cursorPos;
    }

    public int getIndex(PlaylistItem playlistItem) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._playlist.size()) {
            n = n2;
            PlaylistItem playlistItem2 = (PlaylistItem)this._playlist.elementAt(n2);
            if (playlistItem2.equals(playlistItem)) break;
            ++n2;
        }
        return n;
    }

    private void trace(int n, String string, String string2) {
        Debug debug = Debug.getInstance();
        debug.log(n, string + ":" + string2);
    }
}

