// #########################################################
// === File #9 of 14 : adapt.h =============================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : adapt.h
//
//  DESCRIPTION :
//         Definition of performeter's user-related classes
//
// ##############################################################


/////////////////
#ifndef _ADAPT_H
#define _ADAPT_H
/////////////////


//==================
#include "pfmeter2.h"

#include <unistd.h>
#include <utime.h>
#include <sys/resource.h>



//=================
//=== clock
//=================
// Nothing


//=================
//=== uclock
//=================
// Nothing


//=================
//=== timeval, double 
//=================

bool	 operator==  (const timeval& inst1_i, const timeval& inst2_i);
bool	 operator<  (const timeval& inst1_i, const timeval& inst2_i);
bool	 operator<=  (const timeval& inst1_i, const timeval& inst2_i);
ostream& operator<< (ostream& o, const timeval& instance_i);



//=================
//=== AAA, BBB 
//=================


//###################################################
//############## "State-Resource" Test Class ########
//###################################################
class AAA
{
friend ostream& operator<< (ostream& o, const AAA& instance_i);
friend bool     operator< (const AAA& inst1_i, const AAA& inst2_i);
friend bool     operator== (const AAA& inst1_i, const AAA& inst2_i);
friend bool     operator<= (const AAA& inst1_i, const AAA& inst2_i);
friend AAA      operator- (const AAA& inst1_i, const AAA& inst2_i);

  private :
    int				a_value_;

  public :
    AAA ();
    ~AAA ();
    AAA (int a_value_i);

    int		get_a_value () const;
};

//=========================
ostream&	operator<< (ostream& o, const AAA& instance_i);
bool		operator< (const AAA& inst1_i, const AAA& inst2_i);
bool		operator== (const AAA& inst1_i, const AAA& inst2_i);
bool		operator<= (const AAA& inst1_i, const AAA& inst2_i);
AAA		operator- (const AAA& inst1_i, const AAA& inst2_i);


//###################################################
//############## "Cost-Resource" Test Class #########
//###################################################
class BBB
{
friend ostream& operator<< (ostream& o, const BBB& instance_i);
friend bool     operator< (const BBB& inst1_i, const BBB& inst2_i);
friend bool     operator== (const BBB& inst1_i, const BBB& inst2_i);
friend bool     operator<= (const BBB& inst1_i, const BBB& inst2_i);
friend BBB      operator- (const BBB& inst1_i, const BBB& inst2_i);
friend BBB      operator/ (const BBB& inst1_i, unsigned int int_value_i);

  private :
    int				b_value_;

  public :
    BBB ();
    BBB (int b_value_i);
    ~BBB ();

    int		get_b_value () const;
    BBB&	operator+= (const BBB& inst_i);

};

//=========================
ostream&	operator<< (ostream& o, const BBB& instance_i);
bool		operator< (const BBB& inst1_i, const BBB& inst2_i);
bool		operator== (const BBB& inst1_i, const BBB& inst2_i);
bool		operator<= (const BBB& inst1_i, const BBB& inst2_i);
BBB		operator- (const BBB& inst1_i, const BBB& inst2_i);
BBB		operator/ (const BBB& inst1_i, unsigned int int_value_i);




//###################
#endif	// _ADAPT_H
//###################


//#######################################
//############# END OF FILE #############
//#######################################

// ------------------- C++ code : END ----------------------
// === File #9 of 14 : adapt.h =============================

