// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : help.cpp
//
//  DESCRIPTION :
//         Help functions
//
// #################################################################


// ==============
#include "main.h"
// ==============

// ----------------------------
void show_info ()
{

const string info_CNS ("INFO :");

  cout << info_CNS
       << endl
       << string (info_CNS.size(), '=')
       << endl;


  // -----------------------
const string pref1 ("\t");

const string head (string(product_name) + " (" + string(sw_version) + ")");

  cout << pref1 << head << endl
       << pref1 << string (head.size(), '-') << endl
       << pref1 << "The program implements the wrappers that can be used " << endl
       << pref1 << "  as a iostream-compatible TCP/IP sockets." << endl
       << pref1 << "The wrappers have been written by " << ms_author_name << ":" << endl
       << pref1 << "    " << ms_author_url << endl
       << endl
       << pref1 << "The program also contains two demo applications." << endl
       << pref1 << "Demo1 application has been written by " << ms_author_name << "." << endl
       << pref1 << "Demo2 application has been written by " << av_author_name << ":" << endl
       << pref1 << "    " << av_author_url << endl
       << endl
       << pref1 << "For conditions of distribution and use," << endl
       << pref1 << "  see copyright notice in common.h." << endl
       << endl
       << endl
       << endl;


} // show_info


// ----------------------------
void show_demo1_descr ()
{

const string descr_CNS ("DEMO1 :");

  cout << descr_CNS
       << endl
       << string (descr_CNS.size(), '=')
       << endl;


  // -----------------------
const string pref1 ("\t");


const string header ("Demo1 Application Protocol (in general outline)");


  cout << pref1 << header << endl
       << pref1 << string (header.size(), '-') << endl
       << pref1 << "Client send a request type to server :" << endl
       << pref1 << "1 - Request for a string," << endl
       << pref1 << "2 - Request for a number," << endl
       << pref1 << "3 - Request for a complex numbe,r" << endl
       << pref1 << "Other - for ending session." << endl
       << endl
       << pref1 << "Server sends to server :" << endl
       << pref1 << "* some string (if request type == 1)," << endl
       << pref1 << "* some number (if request type == 2)," << endl
       << pref1 << "* some complex number (if request type == 3)." << endl
       << endl
       << endl
       << endl;

} // show_demo1_descr


// ----------------------------
void show_demo2_descr ()
{

const string descr_CNS ("DEMO2 :");

  cout << descr_CNS
       << endl
       << string (descr_CNS.size(), '=')
       << endl;


  // -----------------------
const string pref1 ("\t");


const string header ("Demo2 Application Protocol (in general outline)");

  cout << pref1 << header << endl
       << pref1 << string (header.size(), '-') << endl
       << pref1 << "Client's request is a packet which contains :" << endl
       << pref1 << " * request-id," << endl
       << pref1 << " * data type (typeid(T).name())," << endl
       << pref1 << " * data size (number of items)," << endl
       << pref1 << " * data which is a vector of items;" << endl
       << pref1 << "   size of vector == number of items" << endl
       << pref1 << "The packet may contain data of any type, for instance," << endl
       << pref1 << "vector<int>, vector<string>, vector<User-Defined-Type>." << endl
       << pref1 << "To create the request the client analyses the reply" << endl
       << pref1 << "(on its previous request) received from the server." << endl
       << endl
       << pref1 << "Server's reply consists of several packets of" << endl
       << pref1 << "different types (subreplies)." << endl
       << pref1 << "To create the reply the server analyses the request" << endl
       << pref1 << "received from the client." << endl
       << endl
       << endl
       << endl;

} // show_demo2_descr


// ----------------------------
void show_help (const char argv0[])
{
  // ---------
  show_info();
  show_demo1_descr();
  show_demo2_descr();
  // ---------

const string pref11 (7, ' ');
const string pref12 (9, ' ');

ostringstream oss_client_process, 
              oss_server_process;

const string defaults_CNS                ("Defaults : ");
const string ip_server_address_value_CNS ("ip server address");
const string ip_port_number_value_CNS    ("ip port number");
const string test_requests_value_CNS     ("number of test requests");

size_t setw_defaults = 0;
  setw_defaults = MAX_VALUE (setw_defaults, ip_server_address_value_CNS.size());
  setw_defaults = MAX_VALUE (setw_defaults, ip_port_number_value_CNS.size());
  setw_defaults = MAX_VALUE (setw_defaults, test_requests_value_CNS.size());
  setw_defaults++;

  oss_client_process << ""
                     << isClient_CNS
                     << " "
                     << "<demo# : 1 or 2>"
              
                     << " "
                     << "["
                     << isIpAddressOption_CNS
                     << " "
                     << "<"
                     << ip_server_address_value_CNS
                     << ">"
                     << "]"
              
                     << " "
                     << "["
                     << isPortNumberOption_CNS
                     << " "
                     << "<"
                     << ip_port_number_value_CNS
                     << ">"
                     << "]"
              
                     << " "
                     << "["
                     << isNumberOfRequestOption_CNS
                     << " "
                     << "<"
                     << test_requests_value_CNS
                     << ">"
                     << "]";


  oss_server_process << ""
                     << isServer_CNS
                     << " "
                     << "<demo# : 1 or 2>"
              
                     << " "
                     << "["
                     << isPortNumberOption_CNS
                     << " "
                     << "<"
                     << ip_port_number_value_CNS
                     << ">"
                     << "]";


const string usage_CNS ("USAGE :");      
const string client_process_CNS ("Calling client process");      
const string server_process_CNS ("Calling server process");      

  cout << usage_CNS
       << endl
       << string (usage_CNS.size(), '=')
       << endl


       // ---------------------
       << pref11	<< client_process_CNS << endl
       << pref11	<< string (client_process_CNS.size(), '-') << endl
    
       << pref11	<< argv0  << " " << oss_client_process.str()  << endl

       << pref11	<< defaults_CNS << endl
       << pref12	<< setw (setw_defaults) 
                << left
                << ip_server_address_value_CNS.c_str() 
                << ": " 
                << DEFAULT_IP_SERVER_ADDRESS
                << endl
       << pref12	<< setw (setw_defaults) 
                << left
                << ip_port_number_value_CNS.c_str() 
                << ": "
                << DEFAULT_IP_PORT_NUMBER
                << endl
       << pref12	<< setw (setw_defaults) 
                << left
                << test_requests_value_CNS.c_str() 
                << ": "
                << DEFAULT_NUMBER_OF_TEST_REQUESTS
                << endl
       << endl


       // ---------------------
       << pref11	<< server_process_CNS << endl
       << pref11 << string (server_process_CNS.size(), '-') << endl

       << pref11	<< argv0 << " " << oss_server_process.str() << endl
       << pref11	<< defaults_CNS << endl
       << pref12	<< setw (setw_defaults) 
                << left
                << ip_port_number_value_CNS.c_str() 
                << ": "
                << DEFAULT_IP_PORT_NUMBER
                << endl
       << endl;


} // show_help


// ----------------------------
bool parse_command_line (
		int		argc, 
		char		*argv[],
		bool&		is_client_o,	// true - client, false - server
		size_t&		demo_sample_no_o,
		string&		ip_server_address_o,
		int&		ip_port_no,
		size_t&		number_of_test_requests_o
		)
{

const int min_allowed_argc = 3;
  assert (argc >= min_allowed_argc);

  if (!((argv[1] == isClient_CNS) || (argv[1] == isServer_CNS))) return false;


  // ---------------
  assert ((argv[1] == isClient_CNS) || (argv[1] == isServer_CNS));
  is_client_o = (argv[1] == isClient_CNS);

  // ---------------
  demo_sample_no_o = atoi(argv[2]);
  switch (demo_sample_no_o)
  {
    case RUN_DEMO_SAMPLE_1 :
    case RUN_DEMO_SAMPLE_2 :
      // Do nothing
      break;

    default :
      return false;
      break; // unused
  }


  // ---------------
  // ---------------

  ip_server_address_o.erase();
  assert (ip_server_address_o.empty());

  ip_port_no = 0;
  number_of_test_requests_o = 0; 


  for (int i = min_allowed_argc; i < argc; i++)
  {

    // ---------------------------------
    if (argv[i] == isPortNumberOption_CNS)
    {
      if (argc == (i + 1))	return false;

      assert (argc > (i + 1));
      ip_port_no = atoi (argv[++i]);
      continue;
    }
    if (!is_client_o) return false;

    // ---------------------------------
    if (argv[i] == isIpAddressOption_CNS)
    {
      if (argc == (i + 1)) return false;

      assert (argc > (i + 1));
      ip_server_address_o = argv[++i];
      continue;
    }

    // ---------------------------------
    if (argv[i] == isNumberOfRequestOption_CNS)
    {
      if (argc == (i + 1))	return false;

      assert (argc > (i + 1));
      number_of_test_requests_o = atoi (argv[++i]);
      continue;
    }

    return false;

  } // for (int i = min_allowed_argc; i < argc; i++)


  if (ip_server_address_o.empty())	ip_server_address_o = DEFAULT_IP_SERVER_ADDRESS;
  if (ip_port_no == 0)			ip_port_no = DEFAULT_IP_PORT_NUMBER;
  if (number_of_test_requests_o == 0)	number_of_test_requests_o = DEFAULT_NUMBER_OF_TEST_REQUESTS;
  
  return true;

} // parse_command_line


