// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : main.cpp
//
//  DESCRIPTION :
//         Main program
//
// #################################################################


// ==============
#include "main.h"
// ==============


// ----------------------------
int main(int argc, char *argv[])
{
ApplicationRun application;

  cout << endl;
  cout << "\tYOUR COMMAND LINE : ";

  for (int i = 0; i < argc; i++) cout << argv[i] << " ";

  cout << endl;

  cout << "\tCOMPILATION OPTIONS : " << endl;


#ifdef SCREEN_LOG
  cout << "\t   SCREEN_LOG    = " << SCREEN_LOG << " (";
  #if (SCREEN_LOG)
    cout << "Screen messages are redirected to logfile";
  #else
    cout << "Screen messages are not redirected to screen"; 
  #endif
  cout << ")" << endl;
#endif

#ifdef MILESTONE_LOG
  cout << "\t   MILESTONE_LOG = " << MILESTONE_LOG << " (";
  #if (MILESTONE_LOG)
    cout << "Milestone messages are written to logfile";
  #else
    cout << "Milestone messages are not generated"; 
  #endif
  cout << ")" << endl;
#endif

#ifdef TRACE_LOG
  cout << "\t   TRACE_LOG     = " << TRACE_LOG << " (";
  #if (TRACE_LOG)
    cout << "Trace messages are written to logfile";
  #else
    cout << "Trace messages are not generated"; 
  #endif
  cout << ")" << endl;
#endif

  cout << endl;
  cout << endl;


  if (!(argc > 2))
  {
    show_help (argv[0]);
    return 1;
  }

// -------------------------
bool	is_client_otherwise_server;
size_t	demo_sample_no;
string	ip_server_address;
int	ip_port_no;
size_t	number_of_test_requests;

  if (!parse_command_line (
		argc, 
		argv,
		is_client_otherwise_server,
		demo_sample_no,
		ip_server_address,
		ip_port_no,
		number_of_test_requests
		)
		)
  {
    show_help (argv[0]);
    return 1;
  }


// -------------------------
  if (!socketsInit())
  {
    ostringstream oss;
    oss << "Cannot initialize sockets";

    cout << "\t" << string (oss.str().size(), '#') << endl;
    cout << "\t" << oss.str() << endl;
    cout << "\t" << string (oss.str().size(), '#') << endl;

    MOUT ( oss.str() << endl);
    return 1;
  }



  // -------------------------------
  if (is_client_otherwise_server)
  {
    switch (demo_sample_no)
    {
      case RUN_DEMO_SAMPLE_1 :
          application.demo1_run_client (ip_server_address, ip_port_no);
        break;

      case RUN_DEMO_SAMPLE_2 :
          application.demo2_run_client (ip_server_address, ip_port_no, number_of_test_requests);
        break;

      default :
        assert (0);
        break;
    }
  }
  else
  {
    switch (demo_sample_no)
    {
      case RUN_DEMO_SAMPLE_1 :
          application.demo1_run_server (ip_port_no);
        break;

      case RUN_DEMO_SAMPLE_2 :
          application.demo2_run_server (ip_port_no);
        break;

      default :
        assert (0);
        break;
    }
  }

  // ---------
  socketsEnd();

  return 0;
}
