// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : packet2.h
//
//  DESCRIPTION :
//         Packet related class implementation (template methods)
//
// #################################################################


//////////////////////////
#ifndef INCLUDED_PACKET2_H
#define INCLUDED_PACKET2_H
//////////////////////////


// ================
#include "packet.h"
// ================


// ---------------
template <typename T>
string AuxGetTypeName (const string& typeid_name_i)
{
  if (typeid_name_i == typeid(T).name()) return GetTypeName<T>();
  return string();
}



// ---------------------
// ---------------------
// Constructor-1
template <typename T>
PacketType<T>::PacketType (
		const vector<T>& data_items_i,
		const string& file_i,
		const ulong line_no_i
		)
		:
		BasicDataType (typeid(T).name(), file_i, line_no_i),
		data_items_ (data_items_i)
{
SET_DETAILED_TRACE ("(Ctor) typeid_data_type = " << typeid_data_type_);
  assert (typeid(T).name() == typeid_data_type_);
}


// ---------------------
// Destructor
template <typename T>
PacketType<T>::~PacketType()
{
SET_DETAILED_TRACE ("(Dtor) typeid_data_type = " << typeid_data_type_);
}

// ---------------------
template <typename T>
vector<T> PacketType<T>::get_data_items () const
{
SET_TRACE;
  return data_items_;
}



// ---------------------
template <typename T>
size_t PacketType<T>::get_packet_transmission_len () const
{
SET_TRACE;

#define DELIM_SIZE_IN_SOCKETS	2

ostringstream oss;
size_t ret_value = 0;


  // --- Prefix (?) in SOCKETS ---
  ret_value += sizeof (ulong);
  ret_value += DELIM_SIZE_IN_SOCKETS;

  // --- Packet Head ---
  ret_value += sizeof (ulong);			// Request-ID size
  ret_value += DELIM_SIZE_IN_SOCKETS;

  ret_value += string(typeid(T).name()).size();	// typeid(T).name()
  ret_value += DELIM_SIZE_IN_SOCKETS;

  oss << data_items_.size();
  ret_value += oss.str().size(); 		// "Number of items" size
  ret_value += DELIM_SIZE_IN_SOCKETS;


  // --- Packet Body ---
  for (size_t i = 0; i < data_items_.size(); i++)
  {
    oss.str(string());
    oss << data_items_[i];
    ret_value += oss.str().size();
    ret_value += DELIM_SIZE_IN_SOCKETS;
  }

  return ret_value;
}


// ---------------------
template <typename T>
void PacketType<T>::show_packet (const vector<string>& msg_i, char ch_i) const
{
SET_TRACE;

const string pref1 ("\t");
const string pref2 (pref1 + "  ");

vector<size_t> sizes;
  for (size_t i = 0; i < msg_i.size(); i++)
  {
    sizes.push_back(msg_i[i].size());
  }
size_t max_size = *max_element (sizes.begin(), sizes.end());

  cout << endl;
  cout << pref1 << string (max_size, ch_i) << endl;
  for (size_t i = 0; i < msg_i.size(); i++)
  {
    cout << pref1 << msg_i[i] << endl;
  }
  cout << pref1 << string (max_size, ch_i) << endl;

ostringstream osdata;
  copy (data_items_.begin(), data_items_.end(), ostream_iterator<T> (osdata, ""));

ostringstream oss;
  oss << "" 
      << "Packet Type - " 
      << GetTypeName<T> () 
      << "; Contains " 
      << data_items_.size()
      << " items"
      << "; Data Size = "
      << osdata.str().size()
      << " bytes";

  cout << pref1 << oss.str() << endl;
  cout << pref1 << string (oss.str().size(), '.') << endl;

  assert (!data_items_.empty());

  for (size_t i = 0; i < data_items_.size(); i++)
  {
    cout << pref2 << data_items_[i] << endl;
  } 
  cout << endl;
  cout << endl;
  cout << endl;

}

//////
#endif
//////
