#!/usr/bin/perl

###############################################################################
#
# _AClassCreate.cgi - Create a new class
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/10 22:01:44 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AClassCreate.cgi,v 1.82.2.9 2001/09/10 22:01:44 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";
require "NewClass_Init.pl";

$sendmail = &lookupSendMail;

$adminpass = $CGIQuery->cookie('panForaAdmin');
if ($adminpass eq "") {
	$adminpass = $CGIQuery->param('panForaAdmin');
	$writeCookie = 1;
}

$what = $CGIQuery->param('what');
$func = $CGIQuery->param('func');
$mode = $CGIQuery->param('mode');
$show = $CGIQuery->param('show');
$Classtodel = $CGIQuery->param('classtodel');
$newwin = $CGIQuery->param('newwin');
$nexturl = $CGIQuery->param('nexturl');
$switchMode = $CGIQuery->param('switchMode');

$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');

##### Support old cgi parameters
if ($Class eq "" ) {
	$oldparm = $CGIQuery->param('class');
	if ($oldparm ne "") {
		$Class = $oldparm;
	}
}

if ($Class ne "") {
	&lookupClass;
	&lookupUser($CGIEnvUser);
} else {
	$ColorQueryString = &lookupColors("1");
}

# Load up color variables
&loadColors($ColorQueryString);

if ($show eq "nothing") {
	$func = "nothing";
}

if ($func ne "menu") {
	$BodyTag = &makeBodyTag("Content");
} else {
	$BodyTag = &makeBodyTag("Threads");
}

###############################################################################
#
# Process submitted data

if ($func eq "newpass") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doNewPass();
	exit();
}

if ($what eq "logout") {
	&doLogout();
	exit();
} elsif ($forumadmin != 1) {
	# build nexturl
	if ($nexturl eq "") {
		#$nexturl = &buildNextURL;
		$nexturl = escape(&buildNextURL);
	}

	$badPass = 0;
	if ($adminpass ne "" && $forumadmin != -1) {
		$badPass = 1;
	}
	&showLogin($badPass);
	exit();
} elsif ($forumadmin == 1 && $what eq "login") {
	# User has just logged in, but is not creating a class
	&showConfLogin();
	exit();
}

if ($forumadmin == 1 && $nexturl ne "" && $writeCookie) {
	#$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
	#							-value=>"$cryptAdminPass",
	#							-path=>'/',
	#							-expires=>'+15m');
	
	# Change to session cookie. expiration is handled internally
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	$nexturl = unescape($nexturl);
	&showConfLogin();
	#print $CGIQuery->redirect(-location=>$nexturl, -cookie=>$cookie);
	exit();
}

# Kick the user out if they have the wrong permissions
# if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
if ($forumadmin != 1) {
	&showErrorBackHTML("You do not have permission to access this resource, or have not logged on properly.", 0);
	exit();
}

##### Set up the panForaURL variable in the .conf file (if it's not there)
$panForaURL = &lookuppanForaURL;
if ($panForaURL eq "" && $Class eq "") {
	# Class must be null to get the right URL.
	$panForaURL = $ENV{'SCRIPT_NAME'};
	@full = split(/\//, $panForaURL);
	$len = @full;
	$replace = @full[$len - 1];
	$panForaURL =~ s/\/$replace$//;
	
	if (-e ".conf") {
		open (f, ".conf");
		@file = <f>;
		close(f);
		push (@file, "panForaURL\t" . $panForaURL . "\n");
	} else {
		@file[0] = "panForaURL\t" . $panForaURL . "\n";
	}
	
	if (open(conf, ">.conf")) {
		for ($j = 0; $j < @file; $j++) {
			print conf @file[$j];
			if (@file[$j] !~ /\n$/) {
				print conf "\n";
			}
		}
		close(conf);
	} else {
		&showErrorBackHTML("Unable to write to the file " . &pwd . "/.conf. Please check file permissions on the " . &pwd . " directory and try again.", 0);
		exit();
	}
}
#####

if ($func =~ /dirTest/) {
	require "dirTest.pl";

	&printDirTest($CGIQuery);
	exit();
}

if ($func eq "docreate" && ! $switchMode) {
	&doclasscreate;
	exit();
} 

if ($func eq "delclass" && $Classtodel ne "(NULL)") {
	&doclassdel;
	exit();
} elsif ($func eq "delclass") {
	$func = "nothing";
}

if ($func eq "newclass" || ($func eq "docreate" && $switchMode)) {
	# print out class editing page.
	
	# First read in the submitted variables
	$newclass = $CGIQuery->param('newclass');

	if ($newclass eq "" || $newclass =~ /[^a-zA-Z0-9_\-]/) {
		&showErrorBackHTML("You must choose a $corf id with no white space, and with no characters other than letters, numbers underscore (_) and dash (-).");
		exit();
	}
	
	# Filter the class id
	$newclass =~ s/\./_/g;
	$newclass =~ s/\&/and/g;
	$newclass = &realClean($newclass);
	
	# Does the chosen class ID already exist?
	if (&lookupClass($newclass)) {
		&showErrorBackHTML("The $corf ID you have chosen, $newclass, already exists. Please choose another.",0);
		exit();
	}
	
	$helplink = "file=ForumNewCORP_Admin.html";
	$Classdefaults = $CGIQuery->param('classdefaults');
	if ($Classdefaults ne "(NULL)") {
		$helplink .= "&anchor=CreateForumLoadEdtFSummary";
	} else {
		$helplink .= "&anchor=CreateForumNoneEdtFSummary";
	}
	$helplink .= "&helptitle=Entering%20$CorF%20Data";
	
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
	&showHeaderBackHTML("Creating $CorF - $newclass",
		"<br>", 0, 0, 0, $helplink, $cookie);
	
	&printJavascript;
	
	&printclassinput;

} elsif ($func eq "done") {
	# Finished with class creation and user addition!
		
	# Now add the Anonymous and Guest users.
	# These must come here, or the admin won't get access to needed resources
	&addanon($newclass);
	&addguest($newclass);
	
	$Class = $newclass;
	&lookupClass;
	
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
	&showHeaderBackHTML("Finished!", "The new $corf has been created sucessfully.<br><br>", 0, 0, 0, "", $cookie);
	
	if ($isWin) {
		print "You may now continue on to <a href=$DIR_CGI/$CGI_ForumAdminMenu?fid=$newclass target=_top>";
	} else {
		print "You may now continue on to <a href=$C_rooturl/$DIR_CGI/$CGI_ForumAdminMenu?fid=$newclass target=_top>";
	}
	print "edit the $corf attributes.</a>";

} elsif ($func eq "menu") {
	# Show class creation menu
	
	if (-e $DBFILE_CLASSID) {
		@classlist = &lookupClassList;
	}

	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
								
	if ($mode eq "delete") {
		$helplink = "file=ForumDeleteCORP_Admin.html";
		$helplink .= "&anchor=DeleteForumTskFSummary";
		$helplink .= "&helptitle=Deleting%20$CorFs";
	
		&showHeaderBackHTML("Delete $CorFs", "", 0, 1, 0, $helplink, $cookie);
	} else {
		$helplink = "file=ForumNewCORP_Admin.html";
		$helplink .= "&anchor=CreateForumTskFSummary";
		$helplink .= "&helptitle=Creating%20a%20New%20$CorF";
		
		&showHeaderBackHTML("Create $CorFs", "", 0, 1, 0, $helplink, $cookie);
	}
	
	&printResetJavascript;

	$colspan = 3;
	
	print "<table border=0 cellpadding=0 cellspacing=2>\n";
	print "<tr>";
	if ($mode ne "delete") {
		print "<form action=$CGIEnvScript method=GET target=classadd>\n";
	
		print "<td valign=bottom nowrap>",$FontFace, $FontSize;
		print "New $CorF ID";
		print "</td>\n";
		print "<td valign=bottom nowrap>",$FontFace, $FontSize;
		print "Load Defaults from $CorF &nbsp;";
		print "</td>\n";
		print "<td valign=bottom nowrap>",$FontFace, $FontSize;
		print "&nbsp;<!-- For submit button -->";
		print "</td>\n";
	}
	
	#### Area for deletion of classes
	if ($mode eq "delete") {
		$colspan = 2;
		print "<td valign=bottom nowrap>",$FontFace, $FontSize;
		print "Delete $CorF";
		print "</td>\n";
		print "<td valign=bottom nowrap>",$FontFace, $FontSize;
		print $ImgIndent, "</td>"; # For submit button
	}
	####
	
	print "</tr>\n";
	
	# Input fields for adding class
	
	print "<tr>";
	
	if ($mode ne "delete") {
		print "<td valign=top nowrap>",$FontFace, $FontSize;
		print "<input type=text name=newclass size=12 maxlength=24>&nbsp;";

		print "</td>\n<td valign=top nowrap>",$FontFace, $FontSize;
		print "<select name=classdefaults>";
		print "<option value=\"(NULL)\"> None\n";
		for ($j=0; $j < @classlist; $j++) {
			print "<option value=", @classlist[$j], "> ", @classlist[$j];
		}
		print "</select><br>\n";
		print "</td>\n";
		
		print "<td valign=middle nowrap>",$FontFace, $FontSize;
		print $BtnFormSubmit;
		print "</td>\n";

		print "<input type=hidden name=fid value=$Class>\n";
		print "<input type=hidden name=func value=newclass>\n";
		print "</form>\n\n\n";
	}
	
	#### More deletion stuff
	if ($mode eq "delete") {
		if (@classlist > 0) {
			print "<form action=$CGIEnvScript method=GET target=classadd>\n";

			print "<td valign=top nowrap>",$FontFace, $FontSize;

			print "<select name=classtodel>";
			print "<option value=\"(NULL)\"> None\n";
			for ($j=0; $j < @classlist; $j++) {
				print "<option value=", @classlist[$j], "> ", @classlist[$j];
			}
			print "</select>";
			print "</td>\n";
			print "<td valign=middle nowrap>",$FontFace, $FontSize;
			print $BtnFormDel;
			print "</td>\n";
			
			print "<input type=hidden name=fid value=$Class>\n";
			print "<input type=hidden name=func value=delclass>\n";
	
			print "</form>";
		} else {
			print "<td valign=top nowrap colspan=2>",$FontFace, $FontSize;
			print "No $corfs to delete.";
			print "</td>\n";
		}
	}
	
	####
	
	print "</tr>\n";
	
	# Row for notes
	
	if ($mode ne "delete") {
		print "<tr>";
		print "<td colspan=$colspan>", $FontFace, $FontSize;
		print "Note: $CorF ID is case sensitive.";
		print "</td>\n</tr>\n";
	}
	
	print "</table>\n\n";
	
} elsif ($func eq "nothing") {
	# Show the lower frame, no user selected.

	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');

	if ($mode eq "delete") {
		&printEmptyTaskFrame("Choose a $CorF to delete in the frame above.",
				"", 0, 0, 0, "", $cookie);
	} else {
		&printEmptyTaskFrame("Enter a new $CorF ID in the frame above.",
				"", 0, 0, 0, "", $cookie);
	}

} elsif ($func eq "cancel") {
	# Show the lower frame, no user selected.

	&showHeaderBackHTML("$CorF Creation Cancelled");
	print "The $corf has not been created. No changes have been made to the system.";

} else {
	# Print frameset
	if ($writeCookie) {
		# Write a cookie
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
		print $CGIQuery->header(-cookie=>$cookie);
	} else {
		# print $CGIQuery->header(-expires=>'-1d');
		print $CGIQuery->header;
	}
	print "<html><head><title>$CorF Creation</title>\n";
	&printJavascript;
	print "</head>\n";
	print "<frameset rows='120,*' border=1>\n";
	print "	<frame name=classmenu ";
	print "src=$CGIEnvScript?fid=$Class&func=menu&mode=$mode ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=classadd ";
	print "src=$CGIEnvScript?fid=$Class&func=nothing&mode=$mode ";
	print "frameborder=0 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

#########################
#
# Subroutines
#
#########################

# Login and Logout Stuff

sub doLogout {
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"",
								-expires=>'-1s',
								-path=>'/');
	print $CGIQuery->header(-cookie=>$cookie, -expires=>'-1d', -cache-control=>$CacheControl);
	
	print "<html><head><title>Successful Logout</title></head>\n";
	print $BodyTag, $FontFace, $FontSize;
	print "<table border=0 cellpadding=1 cellspacing=0 width=100%>\n";
	print "<tr><td bgcolor=$FCheaderback>";
	print $FontFace,$FontSize2,"<font color=$FCheadertext><b>";
	print "Successful Logout";
	print "</b></font></font></td></tr>\n\n";
	print "</table><br>";
	print "You have successfully logged out as panFora System Administrator.<p>";
	if ($newwin eq "true") {
		print "<script language=javascript>\n";
		print "<!--\n";
		print "	var winref = null;\n";
		print "	if (window.opener) {\n";
		print "		winref = window.opener;\n";
		print "		if (winref.frames.length == 0) {\n";
		print "			winref.document.location.reload();\n";
		print "		} else {\n";
		print "			for (var i = 0; i < winref.frames.length; i++) {\n";
		print "				winref.frames[i].document.location.reload();\n";
		print "			}\n";
		print "		}\n";
		print "	} else {\n";
		print "		document.writeln(\"Please reload the Admin pages to reflect your login status.<p>\");\n";
		print "	}\n";
		print "// -->\n";
		print "</script>\n";
	
		print "<a href=javascript:window.close()>";
		print $BtnClose;
		print "</a>";
	}
	print "</body></html>";
}

sub showLogin {
	local($badPass) = @_;
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"",
								-expires=>'-1s',
								-path=>'/');
	print $CGIQuery->header(-cookie=>$cookie, -expires=>'-1d', -cache-control=>$CacheControl);
	
	print "<html><head><title>Login as panFora System Administrator</title></head>\n";
	print $BodyTag, $FontFace, $FontSize;
	print "<table border=0 cellpadding=1 cellspacing=0 width=100%>\n";
	print "<tr><td bgcolor=$FCheaderback>";
	print $FontFace,$FontSize2,"<font color=$FCheadertext><b>";
	print "Login as panFora System Administrator";
	print "</b></font></font></td></tr>\n\n";
	print "</table><br>";
	
	print "<table border=0 callpadding=1 cellspacing=0>\n";
	print "<tr><td>$ImgClear88</td>\n";
	print "<td>", $FontFace, $FontSize;
	print $FontSize2, "panFora System Administrator Password<br></td></tr>";
	
	if ($Demo) {
		print "<tr><td>$ImgClear88</td><td><br>", $FontFace, $FontSize;
		print "<b>Demo Mode:</b> Password is Demo. It has been ";
		print "pre-entered for you.<br></td></tr>\n";
	}
	
	if ($badPass == 1) {
		print "<tr><td>$ImgClear88</td><td><br>", $FontFace, $FontSize;
		print $FontRed, "The password you entered was incorrect ";
		print "or your login cookie has expired.<br></font>";
		print "</td></tr>\n";
		#print "<tr><td>$ImgClear88</td>\n";
		#print "<td>", $FontFace, $FontSize;
	}
	print "<tr><td>$ImgClear88</td>\n";
	print "<td>", $FontFace, $FontSize;
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=password size=12 name=\"panForaAdmin\"";
	if ($Demo) {
		print " value=\"Demo\"";
	}
	print ">\n";
	print "<input type=hidden name=what value=\"$what\">\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=newwin value=\"$newwin\">\n";
	print "<input type=hidden name=nexturl value=\"$nexturl\">\n";
	print "<input type=hidden name=mode value=\"$mode\">\n";
	print $BtnFormSubmit;
	print "</form></td></tr>\n";
	print "</table>";
	
	print "<table border=0 callpadding=1 cellspacing=0 width=100%>\n";
	print "<tr><td bgcolor=$FCheaderback>$ImgClearDot</td>\n";
	print "</table>\n";
	
	print "<br>\n";
	
	print "<table border=0 callpadding=1 cellspacing=0>\n";
	print "<tr><td>$ImgClear88</td><td colspan=2>", $FontFace, $FontSize;

	print $FontSize2, "Change panFora System Administrator Password<br>";
	print "<form action=$CGIEnvScript method=POST></td></tr>\n";
	
	if ($badPass == 2) {
		print "<tr><td>$ImgClear88</td><td colspan=2>", $FontFace, $FontSize;
		print $FontRed, "The Original password you entered was incorrect.<br></font>";
		print "</td></tr>\n";
		print "<tr><td>$ImgClear88</td>\n";
		print "<td>", $FontFace, $FontSize;
	} elsif ($badPass == 3) {
		print "<tr><td>$ImgClear88</td><td colspan=2>", $FontFace, $FontSize;
		print $FontRed, "The new passwords do not match.<br></font>";
		print "</td></tr>\n";
		print "<tr><td>$ImgClear88</td>\n";
		print "<td>", $FontFace, $FontSize;
	} elsif ($badPass == 4) {
		print "<tr><td>$ImgClear88</td><td colspan=2>", $FontFace, $FontSize;
		print $FontRed, "The new password must be at least 5 characters long.<br></font>";
		print "</td></tr>\n";
		print "<tr><td>$ImgClear88</td>\n";
		print "<td>", $FontFace, $FontSize;
	}
	
	print "<tr><td>$ImgClear88</td><td align=right>", $FontFace, $FontSize;
	print "Original Password:</td>\n";
	print "<td>", $FontFace, $FontSize2;
	print "<input type=password size=12 name=panForaAdmin></td></tr>\n";
	
	print "<tr><td>$ImgClear88</td><td align=right>", $FontFace, $FontSize;
	print "New Password:</td>\n";
	print "<td>", $FontFace, $FontSize2;
	print "<input type=password size=12 name=newpass></td></tr>\n";
	
	print "<tr><td>$ImgClear88</td><td align=right>", $FontFace, $FontSize;
	print "Verify New Password:</td>\n";
	print "<td>", $FontFace, $FontSize2;
	print "<input type=password size=12 name=verifynewpass></td></tr>\n";
	
	print "<tr><td>$ImgClear88</td><td>&nbsp;</td><td>";
	print "<input type=hidden name=func value=newpass>\n";
	print "<input type=hidden name=newwin value=$newwin>\n";
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</form></td></tr>\n";
	print "</table>";
	
	print "</body></html>";
}

sub showConfLogin {
	local($msg) = @_;
	# Write a cookie, if one does not exist
	#if ($forumadmin && $writeCookie) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
		print $CGIQuery->header(-cookie=>$cookie);
	#} else {
	#	print $CGIQuery->header(-expires=>'-1d');
	#}
	
	print "<html><head><title>Successful Login</title></head>\n";
	print $BodyTag, $FontFace, $FontSize;
	print "<table border=0 cellpadding=1 cellspacing=0 width=100%>\n";
	print "<tr><td bgcolor=$FCheaderback>";
	print $FontFace,$FontSize2,"<font color=$FCheadertext><b>";
	print "Successful Login";
	print "</b></font></font></td></tr>\n\n";
	print "</table><br>";
	if ($msg ne "" ) {
		print $msg;
	} else {
		print "You have successfully logged in as panFora System Administrator.";
	}
	print "<p>\n";
	
	if ($newwin eq "true") {
		print "<script language=javascript>\n";
		print "<!--\n";
		print "	var winref = null;\n";
		print "	if (window.opener) {\n";
		print "		winref = window.opener;\n";
		print "		if (winref.frames.length == 0) {\n";
		print "			winref.document.location.reload();\n";
		print "		} else {\n";
		print "			for (var i = 0; i < winref.frames.length; i++) {\n";
		print "				winref.frames[i].document.location.reload();\n";
		print "			}\n";
		print "		}\n";
		print "	} else {\n";
		print "		document.writeln(\"Please reload the Admin pages to reflect your login status.<p>\");\n";
		print "	}\n";
		print "// -->\n";
		print "</script>\n";
	
		print "<a href=javascript:window.close()>";
		print $BtnClose;
		print "</a>\n";
	} elsif ($nexturl ne "") {
		print "<a href=$nexturl>Continue</a>.\n";
	} else {
		print "You may now continue to ";
		print "<a href=$CGIEnvScript?fid=$Class>Add and Delete $CorFs</a>.\n";
	}
	print "</body></html>";
}

# Printing Stuff

sub printclassinput {
	$Classdefaults = $CGIQuery->param('classdefaults');
	#$suggest = $CGIQuery->param('suggest');
	$isAdvanced = $CGIQuery->param('isAdvanced');
	
	if ($isAdvanced eq "") {
		if ($Classdefaults ne "(NULL)" && $Classdefaults ne "") {
			$isAdvanced = 0;
		} else {
			$isAdvanced = 1;
		}
	}
	
	# Checking for existence of class ID was already handled...
	
	# Get class defaults, if necessary
	if ($Classdefaults ne "(NULL)") {
		&clearclassvars;
		&lookupClass($Classdefaults);
		$C_title =~ s/$Classdefaults/$newclass/;
		$C_rootpath =~ s/$Classdefaults/$newclass/;
		$C_rooturl =~ s/$Classdefaults/$newclass/;
		$C_photodir =~ s/$Classdefaults/$newclass/;
		$C_photourl =~ s/$Classdefaults/$newclass/;
		$C_listdir =~ s/$Classdefaults/$newclass/;
		
		if ($C_FirstAdmin ne "") {
			&lookupUser($C_FirstAdmin);
		}
	} else {
		# Always suggest defaults
		$rooturl = $C_rooturl;
		$thisclass = $Class;
		&clearclassvars;
		&makedefaults($rooturl, $thisclass);
	}
	
	# Need to read these in for switching from advanced to non-advanced mode.
	if ($CGIQuery->param('C_title') ne "") {
		$C_title = $CGIQuery->param('C_title');
	}
	if ($CGIQuery->param('rootpath') ne "") {
		$C_rootpath = $CGIQuery->param('rootpath');
	}
	if ($CGIQuery->param('rooturl') ne "") {
		$C_rooturl = $CGIQuery->param('rooturl');
	}
	if ($CGIQuery->param('C_photodir') ne "") {
		$C_photodir = $CGIQuery->param('C_photodir');
	}
	if ($CGIQuery->param('C_photourl') ne "") {
		$C_photourl = $CGIQuery->param('C_photourl');
	}
	if ($CGIQuery->param('C_listdir') ne "") {
		$C_listdir = $CGIQuery->param('C_listdir');
	}
	if ($CGIQuery->param('C_authtype') ne "") {
		$C_authtype = $CGIQuery->param('C_authtype');
	}
	
	# Table borders
	$border = 0;
	if ($isAdvanced) {
		$border = 0;
	}
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=func value=docreate>\n";
	print "<input type=hidden name=newclass value=$newclass>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	
	print "<table cellpadding=0 cellspacing=3 border=$border>\n";
	
	# Note about paths
	print "<tr><td colspan=3>", $FontFace, $FontSize2;
	print $FontRed, "Note: </font>It is <b>extremely</b> important that ";
	print "you enter the correct values for the directories and URLs below.<br>\n";
	print "If you are unsure, contact your system administrator for advice.";
	print "</td></tr>\n";
	
	print "<tr><td colspan=3>&nbsp;</td></tr>\n\n";
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";

	# Start first row
	print "<tr><td colspan=3 valign=bottom>";
	# First row of headings
	print $FontFace, $FontSize;
	print $FontRed, "$CorF Title&nbsp;";
	print "</td>\n</tr>\n";

	# First row of input fields
	print "<tr><td valign=top colspan=3>",$FontFace, $FontSize;
	print "<input type=text name=C_title value=\"$C_title\" size=24>&nbsp;";
	print "</td>\n";
	print "</tr>\n";
	
	# Start second row
	# Separator
	print "<tr><td height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td>\n";
	print "<td rowspan=3>$ImgIndent</td>\n";
	print "<td height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $FontRed, "$CorF Directory (absolute)&nbsp;";
	print "</td>\n<td valign=bottom>",$FontFace, $FontSize;
	print $FontRed, "Top Level URL (absolute)&nbsp;";
	print "</td>\n</tr>\n";
	
	# second row of input fields
	print "<tr><td valign=top>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<input type=text name=rootpath value=\"$C_rootpath\" size=24>";
	} else {
		print "<input type=hidden name=rootpath value=\"$C_rootpath\">";
		print "&nbsp;&nbsp;&nbsp;&nbsp; $C_rootpath &nbsp;<br>";
	}
	print "&nbsp;</td>\n<td valign=top>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<input type=text name=rooturl value=\"$C_rooturl\" size=24>";
	} else {
		print "<input type=hidden name=rooturl value=\"$C_rooturl\">";
		print "&nbsp;&nbsp;&nbsp;&nbsp; $C_rooturl &nbsp;<br>";
	}
	print "&nbsp;</td>\n</tr>\n";

	# Start third row
	# Separator
	print "<tr><td height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td>\n";
	print "<td rowspan=3>$ImgIndent</td>\n";
	print "<td height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";

	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $FontRed, "Photo Directory (absolute)&nbsp;";
	print "</td>\n<td valign=bottom>",$FontFace, $FontSize;
	print $FontRed, "Photo URL (absolute)&nbsp;";
	print "</td>\n</tr>\n";
	
	# third row of input fields
	print "<tr><td valign=top>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<input type=text name=C_photodir value=\"$C_photodir\" size=24>";
	} else {
		print "<input type=hidden name=C_photodir value=\"$C_photodir\">";
		print "&nbsp;&nbsp;&nbsp;&nbsp; $C_photodir &nbsp;<br>";
	}
	print "&nbsp;</td>\n<td valign=top>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<input type=text name=C_photourl value=\"$C_photourl\" size=24>";
	} else {
		print "<input type=hidden name=C_photourl value=\"$C_photourl\">";
		print "&nbsp;&nbsp;&nbsp;&nbsp; $C_photourl &nbsp;<br>";
	}
	print "&nbsp;</td>\n</tr>\n";
	# End third Row
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	# Mailing List Directory
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	print $FontRed, "Mailing List Directory (absolute)&nbsp;";
	print "</td>\n</tr>\n";
	
	# fourth row of input fields
	print "<tr><td valign=top colspan=3>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<input type=text name=C_listdir value=\"$C_listdir\" size=36>\n";
	} else {
		print "<input type=hidden name=C_listdir value=\"$C_listdir\">\n";
		print "&nbsp;&nbsp;&nbsp;&nbsp; $C_listdir &nbsp;<br>";
	}
	
	print "&nbsp;</td>\n</tr>\n";
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	# Directory test Javascript
	print "<script language=javascript>\n<!--\n";
	print "	var F = document.forms[0];\n";
	print "	function dirTest() {\n";
	print "		var Q = \"", $ENV{"SCRIPT_NAME"}, "?fid=", $Class, "\";\n";
	print "		Q += \"&func=dirTest\";\n";
	print "		Q += \"&newfid=$newclass\";\n";
	print "		Q += \"&C_rootpath=\" + escape(F.elements[\"rootpath\"].value);\n";
	print "		Q += \"&C_rooturl=\" + escape(F.elements[\"rooturl\"].value);\n";
	print "		Q += \"&C_photodir=\" + escape(F.elements[\"C_photodir\"].value);\n";
	print "		Q += \"&C_photourl=\" + escape(F.elements[\"C_photourl\"].value);\n";
	print "		Q += \"&C_listdir=\" + escape(F.elements[\"C_listdir\"].value);\n";
	print "		openwin(Q, 400, 400);\n";
	print "	}\n";
	print "// -->\n</script>\n\n";
	
	# Test Directories
	print "<tr><td colspan=3 align=center><br>", $FontFace, $FontSize2;
	print "<b><input type=button value=\"Test Above Directory and URL Settings\" ";
	print "onClick=\"dirTest()\"></b><br>";
	print "&nbsp;</td>\n</tr>\n";
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	# Choose the type of authentication
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	print $FontRed, "User Authentication Method&nbsp;";
	print "</td>\n</tr>\n";
	
	# fifth row of input fields
	print "<tr><td valign=top colspan=3>",$FontFace, $FontSize;
	if ($isAdvanced) {
		print "<select name=C_authtype>\n";
		print "<option value=cookies> Cookies\n";
		if ($ENV{'SERVER_SOFTWARE'} !~ /Microsoft-IIS/) {
			print "<option value=apache";
			if ($C_authtype eq "apache") {
				print " selected";
			}
			print "> Apache/NCSA (Basic)\n";
	
			if ($ENV{'SERVER_NAME'} =~ /stanford.edu/i || $ENV{'HTTP_HOST'} =~ /stanford.edu/i) {
				print "<option value=webauth";
				if ($C_authtype eq "webauth") {
					print " selected";
				}
				print "> Stanford University WebAuth\n";
				print "<option value=\"webauth and apache\"";
				if ($C_authtype eq "webauth and apache") {
					print " selected";
				}
				print "> SU WebAuth and Apache Backdoor\n";
			}
		}
		
		#print "<option value=external";
		#if ($C_authtype eq "external") {
		#	print " selected";
		#}
		#print "> External\n";
		print "</select>\n";
	} else {
		if ($C_authtype ne "") {
			print "<input type=hidden name=C_authtype value=$C_authtype>\n";
			if ($C_authtype eq "apache") {
				print "&nbsp;&nbsp;&nbsp;&nbsp; Apache/NCSA\n";
			}
			if ($C_authtype eq "webauth") {
				print "&nbsp;&nbsp;&nbsp;&nbsp; Stanford University WebAuth\n";
			}
			if ($C_authtype eq "webauth and apache") {
				print "&nbsp;&nbsp;&nbsp;&nbsp; SU WebAuth and Apache Backdoor\n";
			}
			if ($C_authtype eq "cookies") {
				print "&nbsp;&nbsp;&nbsp;&nbsp; Cookies\n";
			}
			#if ($C_authtype eq "external") {
			#	print "&nbsp;&nbsp;&nbsp;&nbsp; External\n";
			#}
		} else {
			print "<input type=hidden name=C_authtype value=cookies>\n";
			print "&nbsp;&nbsp;&nbsp;&nbsp; Cookies&nbsp;<br>\n";
		}
	}
	
	print "&nbsp;<br>&nbsp;</td>\n</tr>\n";
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	# Defaults for forum settings (Forum type)
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize, $FontRed;
	print "$CorF Default Type&nbsp;";
	print "</td>\n</tr>\n";
	
	# Get template listing
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	&printTemplateList;
	print "</td>\n</tr>\n";
	
	# Separator
	print "<tr><td colspan=3 height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	# Submission row
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	
	print "<input type=hidden name=switchMode value=''>\n";
	print "<input type=checkbox name=isAdvanced value=";
	if ($isAdvanced) {
		print "1 checked ";
	} else {
		print "1 ";
	}
	print "onClick=\"this.form.switchMode.value='1';this.form.submit()\">";
	print " Advanced Mode<br>&nbsp;\n";
	print "</td></tr>\n";
		
	print "</table>\n";
	
	# &clearUserData;
	$U_Perms = 15;
	$U_Classify = 0;

	if ($CGIEnvUser ne "Guest" && $CGIEnvUser ne "") {
		$adduser = $CGIEnvUser;
	} elsif ($C_FirstAdmin ne "") {
		$adduser = $C_FirstAdmin;
	}
	$U_Pass = $U_NamePref = "";
	
	if ($CGIQuery->param('adduser') ne "") {
		$adduser = $CGIQuery->param('adduser');
	}
	if ($CGIQuery->param('U_Pass') ne "") {
		$U_Pass = $CGIQuery->param('U_Pass');
	}
	if ($CGIQuery->param('email') ne "") {
		$U_Email = $CGIQuery->param('email');
	}
	if ($CGIQuery->param('firstname') ne "") {
		$U_NameFirst = $CGIQuery->param('firstname');
	}
	if ($CGIQuery->param('lastname') ne "") {
		$U_NameLast = $CGIQuery->param('lastname');
	}
	
	print "<table cellpadding=0 cellspacing=3 border=0>\n";
	
	# Separator
	print "<tr><td height=2 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	
	print "<tr><td>",$FontFace, $FontSize;
	# Admin user addition
	print "As part of the $CorF setup, you must enter information for a ";
	print "$CorF Administrator here.<br>\n";
	
	&printUserAddSelf(1);
	
	print "</td></tr>\n";
		
	print "</table>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	
	# Cancel button
	print "<a href=$CGIEnvScript?fid=$Class&func=cancel>";
	print $BtnCancel;
	print "</a>\n";
	
	print "</form>";
	
	print "</body></html>";
}

sub doclasscreate {
	$origclass = $CGIQuery->param('fid');

	# We already did a class lookup (maybe). Need to clear the variables
	&clearclassvars;

	# Read in all submitted variables
	$newclass = $CGIQuery->param('newclass');
	$C_title = $CGIQuery->param('C_title');
	$C_name = $C_title;
	$C_rootpath = $CGIQuery->param('rootpath');
	$C_rooturl = $CGIQuery->param('rooturl');
	$C_photodir = $CGIQuery->param('C_photodir');
	$C_photourl = $CGIQuery->param('C_photourl');
	$C_listdir = $CGIQuery->param('C_listdir');
	
	$C_authtype = $CGIQuery->param('C_authtype');
	
	$C_FirstAdmin = $CGIQuery->param('adduser');
	
	$defaults = $CGIQuery->param('template');
	
	# Remove any trailing slashes
	$C_rootpath =~ s/\/$//;
	$C_rooturl =~ s/\/$//;
	$C_photodir =~ s/\/$//;
	$C_photourl =~ s/\/$//;
	$C_listdir =~ s/\/$//;
	
	# Paths have to be handled differently for Windows
	# Allow : in path for windows
	# Allow ~ in URL
	# Swap \ with / in URL
	if ($isWin) {
		$C_rootpath = &cleanWinPath($C_rootpath);
		$C_photodir = &cleanWinPath($C_photodir);
		$C_listdir = &cleanWinPath($C_listdir);
	} else {
		$C_rootpath = &replaceNonAlpha($C_rootpath);
		$C_photodir = &replaceNonAlpha($C_photodir);
		$C_listdir = &replaceNonAlpha($C_listdir);
	}
	# For urls. swap slashes, then URL escape any other weird characters
	$C_rooturl = &escapeAllButSlashesAndTilde(&swapSlashes($C_rooturl));
	$C_photourl = &escapeAllButSlashesAndTilde(&swapSlashes($C_photourl));
	
	$C_title = &cleanTabs($C_title);
	$C_name = $C_title;
	
	$adduser = $CGIQuery->param('adduser');
	$U_SUID = "";
	$U_Pass = $CGIQuery->param('U_Pass');
	$U_NameFirst = $CGIQuery->param('firstname');
	$U_NameLast = $CGIQuery->param('lastname');
	$U_Email = $CGIQuery->param('email');
	$U_Phone = "";
	
	$U_Perms = $CGIQuery->param('U_Perms');
	$U_C_Sect = $CGIQuery->param('classsection');
	$U_Classify = 0;
	$U_ProfileText = "No Personal Information Provided";
	$U_Sig = "";
	$U_HideEmail = 0;
	
	$U_Photo = $adduser . ".gif";
	$U_PhotoLarge = $adduser . ".jpg";
	
	if ($C_title eq "" || $C_name eq "") {
		&showErrorBackHTML("$CorF title is required. Please fill it in.<p>",0);
		&printclassinput;
		exit();
	}
	
	if ($adduser eq "") {
		&showErrorBackHTML("$FontRed You must provide a User ID.</font><p>");
		&printclassinput;
		exit();
	}
	
	if ($U_Pass eq "") {
		&showErrorBackHTML("$FontRed You must provide a Password.</font><p>");
		&printclassinput;
		exit();
	}
	
	if ($U_Email !~ /.*\@.*\..*/) {
		# Check that email has something@something.something
		&showErrorBackHTML("$FontRed You must enter a VALID email address.</font><p>");
		&printclassinput;
		exit();
	}
	
	
	if ($U_NameFirst eq "" || $U_NameLast eq "") {
		&showErrorBackHTML("$FontRed You must provide a first and last name.</font><p>");
		&printclassinput;
		exit();
	}
	
	# Check some variables
	if ($isWin) {
		if ($C_rootpath !~ /^\\|\/|^\w\:/ || $C_rooturl !~ /^\// || $C_photodir !~ /^\\|\/|^\w\:/ || $C_photourl !~ /^\// || $C_listdir !~ /^\\|\/|^\w\:/) {
			# These variables must have a preceding /, \ or \w:
			&showErrorBackHTML("The $CorF Directory, Top Level URL, Photo Directory, Photo URL and Mailing List Directory must all be absolute, starting with a \"/\", \"\\\", or drive letter specification.", 1);
			exit();
		}	
	} else {
		if ($C_rootpath !~ /^\// || $C_rooturl !~ /^\// || $C_photodir !~ /^\// || $C_photourl !~ /^\// || $C_listdir !~ /^\//) {
			# These variables must have a preceding /
			&showErrorBackHTML("The $CorF Directory, Top Level URL, Photo Directory, Photo URL and Mailing List Directory must all be absolute, starting with a \"/\".", 1);
			exit();
		}
	}
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Before making any database changes, make sure the directories
	# specified either exist or can be created
	
	&confmakedir($C_rootpath);
	
	# Add this class to the classes.db
	
	# Make sure first that we can write to or create this file
	if ($isWin) {
		# $dir = &pwd;
		$dir = ".";
		$dbfile = $dir . "/" . $DBFILE_CLASSID;
	} else {
		$dir = ".";
		$dbfile = $dir . "/" . $DBFILE_CLASSID;
	}

	if ((!-e $dbfile && !-w $dir) || (-e $dbfile && !-w $dbfile) ) {
		&showErrorBackHTML("Unable to write to $dbfile. Please check file permissions and try again.",1);
		exit();
	}
	
	@retval = `$setDB $dbfile -thash -k \"$newclass\" -d \"$C_rootpath\"`;
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&classDBError($status);
	}
	
	#===================================================================
	# VERSION FOR WINDOWS SHOULD SETUP HTML LINKS TO CORE PANFORA DIRECTORY
	# INSTEAD OF COPYING ENTIRE PANFORA DIRECTORY AS CGI-BIN
	#===================================================================
	#if ($isWin) {
	#	&copy($dbfile, $C_rootpath . "/$DIR_CGI/$DBFILE_CLASSID");
	#}
	
	
	# If we got here, the root class directory was successfully created
	# Now do the same for the photo dir
	
	&confmakedir($C_photodir);
	
	# Now the Forum dir	
	&confmakedir($C_rootpath . "/" . $DIR_CLASSFORUM);
	
	# The cgi-bin
	$cgidir = &pwd;
	if (-l $cgidir) {
		$cgidir = readlink($cgidir);
	}
	if ($isWin) {
		#&confmakedir($C_rootpath . "/" . $DIR_CGI);
		#&copydir(".",$C_rootpath . "/" . $DIR_CGI);
	} else {
		symlink($cgidir, $C_rootpath . "/" . $DIR_CGI);
	}
	
	# More directories
	&confmakedir($C_rootpath . "/" . $DIR_CONFIG);
	&confmakedir($C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMREPLIES);
	&confmakedir($C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMUPLOADS);
	
	&confmakedir($C_rootpath . "/" . $DIR_BGIMAGES);
	
	if ($C_listdir ne "") {
		&confmakedir($C_listdir);
	}
	
	# All directories have been created successfully at this point
	
	# Copy files into new space
	if ($Edu) {
		if (-e "./$DIR_NEWCLASS/$FILE_FNOTIF" . ".edu") {
			&copy("./$DIR_NEWCLASS/$FILE_FNOTIF" . ".edu", $C_rootpath . "/$DIR_CONFIG/$FILE_FNOTIF");
		} else {
			&copy("./$DIR_NEWCLASS/$FILE_FNOTIF", $C_rootpath . "/$DIR_CONFIG/$FILE_FNOTIF");
		}
	} else {
		&copy("./$DIR_NEWCLASS/$FILE_FNOTIF", $C_rootpath . "/$DIR_CONFIG/$FILE_FNOTIF");
	}
	
	&copy("./$DIR_NEWCLASS/$FILE_TYPEMAP", $C_rootpath . "/$DIR_CONFIG/$FILE_TYPEMAP");
	
	#&copy("./$DIR_NEWCLASS/home.html", $C_rootpath . "/home.html");
	$template =  "./" . $DIR_NEWCLASS . "/" . "home.html";
	$file = $C_rootpath . "/" . "home.html";
	if (-e $template) {
		&genFile($template, $file);
	}
	
	# index.html and nav.html must be generated from templates
	$Class = $newclass;
	$template =  "./" . $DIR_NEWCLASS . "/" . "index.html";
	$file = $C_rootpath . "/" . "index.html";
	if (-e $template) {
		&genFile($template, $file);
	}
	
	$template =  "./" . $DIR_NEWCLASS . "/" . "nav.html";
	$file = $C_rootpath . "/" . "nav.html";
	if (-e $template) {
		&genFile($template, $file);
	}
	
	# Copy Photos
	@photos = glob("./$DIR_NEWCLASS/Photo/*");
	for ($i=0; $i < @photos; $i++) {
		@getname = split(/\//, @photos[$i]);
		$targ = $C_photodir . "/" . @getname[$#getname];
		&copy(@photos[$i], $targ);
	}
	
	# Copy background images
	@bgs = glob("./$DIR_IMAGES/$DIR_BGIMAGES/*.jpg");
	for ($i=0; $i < @bgs; $i++) {
		@getname = split(/\//, @bgs[$i]);
		$targ = $C_rootpath . "/" . $DIR_BGIMAGES . "/" . @getname[$#getname];
		&copy(@bgs[$i], $targ);
	}
	
	# Copy the colors.db into the .Admin directory
	&copy("./" . $DBFILE_COLORS, $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS);
	
	# Copy the Branding Include File into the .Admin directory
	if (-e "./.BrandTopics") {
		&copy("./.BrandTopics", $C_rootpath . "/" . $DIR_CONFIG . "/.BrandTopics");
	}
	
	# Create the class.db
	$C_colors = &lookupColors("1");
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
	
	$C_photodir .= "/";
	$C_photourl .= "/";
	
	# Hard defaults and submitted data
	$putstring = "";
	$putstring .= "C_id\t" . $newclass . "\n";
	$putstring .= "C_name\t" . $C_name . "\n";
	$putstring .= "C_title\t" . $C_title . "\n";
	$putstring .= "C_rootpath\t" . $C_rootpath . "\n";
	$putstring .= "C_rooturl\t" . $C_rooturl . "\n";
	$putstring .= "C_photodir\t" . $C_photodir . "\n";
	$putstring .= "C_photourl\t" . $C_photourl . "\n";
	$putstring .= "C_listdir\t" . $C_listdir . "\n";
	$putstring .= "C_authtype\t" . $C_authtype . "\n";
	$putstring .= "C_Sect_n\t2\n";
	$putstring .= "C_Fac_n\t0\n";
	$putstring .= "C_colors\t" . $C_colors . "\n";
	$putstring .= "C_FirstAdmin\t" . $C_FirstAdmin . "\n";
	$putstring .= "C_FirstAdminEmail\t" . $U_Email . "\n";
	$putstring .= "C_EncryptUserPass\t0\n";

	# Set up defaults, before reading template
	$c{"ForumPostGuest"} = "0";
	$c{"ForumAllowGuest"} = "0";
	$c{"ForumReadGuest"} = "0";
	$c{"ForumPostAnon"} = "1";
	$c{"C_ShowStats"} = "1";
	$c{"C_UserProfile"} = "1";
	$c{"C_UserEdit"} = "1";
	$c{"C_UserEditTime"} = "0";
	$c{"C_UserPhotoUp"} = "1";
	$c{"C_UserAttach"} = "1";
	$c{"C_UserPostHTML"} = "1";
	
	$c{"C_ModEdit"} = "1";
	$c{"C_ModEditAll"} = "0";
	$c{"C_ModDelete"} = "1";
	$c{"C_ModDeleteAll"} = "0";
	
	$c{"C_TopicsPage"} = "0";
	$c{"C_TopicsPageNov"} = "20";
	$c{"C_ThreadsPage"} = "10";
	$c{"C_ThreadsPageNov"} = "20";
	$c{"C_ContentPage"} = "0";
	$c{"C_NewPage"} = "10";
	$c{"C_AuthorsPage"} = "10";

	# Read from template
	if ($defaults ne "" && -e $defaults) {
		if (open(f, $defaults)) {
			while(<f>) {
				$line = $_;
				chomp($line);
				if ($line !~ /^#/ && $line =~ /\S/ && $line !~ /^C_title/
							&& $line !~ /C_id/) {
					($name, $val) = split(/\t+/, $line);
					$c{$name} = $val;
				}
			}
			close(f);
		}
	}
	
	# Add variables to putstring
	foreach $key (keys %c) {
		$putstring .= $key . "\t" . $c{$key} . "\n";
	}

	$newclass = $CGIQuery->param('newclass');
	
	if ($Edu) {
		# Create default sections
		$putstring .= "C_Sect_1\t1\\tStudent (Unassigned)\\tNobody\\t\\t\\t$newclass-Sect1\n";
		$putstring .= "C_Sect_2\t2\\tNon-Student\\tNobody\\t\\t\\t$newclass-Sect2\n";
	} else {
		# Create default sections
		$putstring .= "C_Sect_1\t1\\tGroup 1\\tNobody\\t\\t\\t$newclass-Sect1\n";
		$putstring .= "C_Sect_2\t2\\tGroup 2\\tNobody\\t\\t\\t$newclass-Sect2\n";
	}

	# Create a unique name for an error file
	$ccerrfile = "./." . $adduser . "." . time();
	if (! open (p, "| $setDB $dbfile -thash -a -q -o $ccerrfile")) {
		&showErrorBackHTML("Unable to update/create $dbfile. Check file permissions and try again.",1);
	}	
	print p $putstring;
	close(p);
	
	if (-e  $ccerrfile) {
		open(errf, $ccerrfile);
		@errFileCont = <errf>;
		close(errf);
		unlink($ccerrfile);
		
		if (@errFileCont[0] =~ /^ERROR/) {
			&classDBError(@errFileCont[0]);
		}
	}
	
	# Make the auth files
	# Note that now webauth and apache share a common htgroup and htpasswd file
	if ($C_authtype =~ /webauth/) {
		open (wf, "./$DIR_NEWCLASS/webauth");
		@wfd = <wf>;
		close (wf);
		
		for ($i=0; $i < @wfd; $i++) {
			@wfd[$i] =~ s/GROUPS_FILE/$C_rootpath\/\.htgroup/;
		}
		
		open (wf, ">$C_rootpath/.htaccess");
		print wf @wfd;
		close (wf);
		
		if ($C_authtype =~ /apache/) {
			&makeapacheauth($newclass, ".baaccess", ".htgroup", ".htpasswd");
		}

		# To allow public access
		&copy("./$DIR_NEWCLASS/webauth.pub", $C_rootpath . "/.webauth.pub");
		
	} elsif ($C_authtype =~ /apache/) {
		&makeapacheauth($newclass, ".htaccess", ".htgroup", ".htpasswd");
	} elsif ($C_authtype =~ /cookie/) {
		&copy("./$DIR_NEWCLASS/htcookies", $C_rootpath . "/.htaccess");
	}
	
	# Add the admin user
	##########################################################
	# Add user to database
	$retval = &addtodb($adduser);
	if ($retval) {
		&userDBError($retval);
	}
	#
	##########################################################
	
	##########################################################
	# Add user to htgroup
	&addtoht($adduser, $U_C_Sect);
	#
	##########################################################
	
	##########################################################
	# Add user photos
	&addphoto($adduser);
	#
	##########################################################
	
	# Make this user the section leader for the default sections
	# First read the info for C_Sect_1 from the class database
	# If the section leader is "Nobody" replace Nobody with new user name.
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
	
	($key, @value) = split(/\t/, `$prtDB $dbfile -thash -k \"C_Sect_1\"`);
	
	$success = 1;
	if (@value > 0 && $? == 0) {
		$success = 0;
	}

	if ($success == 0) {
		if (@value[2] eq "Nobody") {
			@value[2] = $adduser;
			$value = join("\\t", @value);
			
			@retval = `$setDB $dbfile -thash -q -k \"C_Sect_1\" -d \"$value\"`;

			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
				exit();
			}
		}
	} else {
		$value = "1\\tNon-Student\\t$adduser\\t\\t\\t$newclass-Sect1";
		@retval = `$setDB $dbfile -thash -q -k \"C_Sect_1\" -d \"$value\"`;
	
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
			exit();
		}
	}
	
	($key, @value) = split(/\t/, `$prtDB $dbfile -thash -k \"C_Sect_2\"`);
	
	$success = 1;
	if (@value > 0 && $? == 0) {
		$success = 0;
	}
	
	if ($success == 0) {
		if (@value[2] eq "Nobody") {
			@value[2] = $adduser;
			$value = join("\\t", @value);
			
			@retval = `$setDB $dbfile -thash -q -k \"C_Sect_2\" -d \"$value\"`;
			
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
				exit();
			}
		}
	} else {
		$value = "2\\tStudent (Unassigned)\\t$adduser\\t\\t\\t$newclass-Sect2";
		@retval = `$setDB $dbfile -thash -q -k \"C_Sect_2\" -d \"$value\"`;
		
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
			exit();
		}
	}
	
	# Add Anonymous and Guest Users
	&addanon($newclass);
	&addguest($newclass);
	
	# Class creation finished. Now the user needs to go in and add an admin
	# Show success page
	
	$newclass = $CGIQuery->param('newclass');
	
	$Class = $newclass;
	&lookupClass;
	&lookupUser($adduser);
	# Send an email to the new class admin
	&sendAdminNotif;
		
	# Rebuild htfiles and mailing lists - Must be done after the class lookup
	&rebuildAllMailAndHT();
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
	&showHeaderBackHTML("Finished!",
			"The new $corf has been created sucessfully.<br><br>",
			0, 0, 0, "", $cookie);
	
	print "An email has been sent to the $corf administrator, notifying ";
	print "him/her that the $corf has been created.<br><br>\n";

	if ($isWin) {
		print "You may now continue on to <a href=$DIR_CGI/$CGI_ClassEdit?fid=$Class&AdminLogout=1 target=_top>";
	} else {
		print "You may now continue on to <a href=$C_rooturl/$DIR_CGI/$CGI_ClassEdit?fid=$Class&AdminLogout=1 target=_top>";
	}
	print "edit the $corf attributes.</a>";
	
	print "<script language=javascript>\n<!--\n";
	print "parent.classmenu.document.location.reload();\n";
	if ($origclass ne "") {
		print "top.AdminMenu.document.location.reload();\n";
	}
	print "// -->\n</script>\n";
	
	#print "Now you must add an administrative user for the new class. ";
	#print "Please enter a user id below to continue.<p>\n\n";
	
	#print "<form action=$CGI_ForumEditUserSingle method=POST>\n";
	#print "<input type=hidden name=fid value=$newclass>\n";
	#print "<input type=hidden name=func value=chooseuser>\n";
	#print "<input type=hidden name=usertype value=firstadmin>\n";
	#print "<input type=hidden name=newperms value=";
	#print $BIT_WRITE + $BIT_READ + $BIT_ADMIN;
	#print ">\n";
	#print "<input type=hidden name=returnto value=\"$CGIEnvScript";
	#print "?fid=$newclass", "&func=done\">\n";
	#print "<input type=text name=adduser size=10>\n";
	#print $BtnFormSubmit;
	#print "</form>\n";
	#print "</body></html>";
}

sub doclassdel {
	&lookupClass($Classtodel);
	$confirm = $CGIQuery->param('confirm');
	
	if ($confirm eq "") {
		&confirmdel;
		exit();
	} elsif ($confirm ne "YES") {
		&showHeaderBackHTML("Deletion Cancelled", "$CorF, $Classtodel, deletion cancelled", 0);
		exit();
	}

	# Do deletion of class
	
	# Get a list of all files and directories to delete
	$thedir = $C_rootpath . "/*";
	@tmp = ("$C_rootpath");
	@todel = <$C_rootpath/$DIR_CONFIG/*>;
	push(@todel, <$C_rootpath/$DIR_CONFIG/*/*>);
	for (1; @tmp > 0; $thedir .= "/*") {
		@tmp = glob $thedir;
		for ($i=0; $i < @tmp; $i++) {
			if (-l @tmp[$i]) {
				push(@filters, @tmp[$i]);
				# push(@todel, @tmp[$i]);
			}
		}
		
		for ($i=0; $i < @tmp; $i++) {
			$dontadd = 0;
			for ($j=0; $j < @filters; $j++) {
				$tf = @filters[$j];
				if (@tmp[$i] =~ /$tf\//) {
					$dontadd = 1;
				}
			}
			
			if ($dontadd == 0) {
				push (@todel, @tmp[$i]);
			}
		}
	}
	
	# Handle .files
	@htfiles = glob $C_rootpath . "/.*";
	for ($i=0; $i < @htfiles; $i++) {
		if (@htfiles[$i] ne "$C_rootpath/.." && @htfiles[$i] ne "$C_rootpath/." && @htfiles[$i] ne "$C_rootpath/$DIR_CONFIG") {
			push(@todel, @htfiles[$i]);
		}
	}
	
	push(@todel, $C_rootpath . "/$DIR_CLASSFORUM/$FILE_NEXTID");
	push(@todel, $C_rootpath . "/$DIR_CLASSFORUM/$FILE_NEXTID" . ".lock");
	
	@todel = reverse(@todel);
	
	push (@todel, "$C_rootpath/$DIR_CONFIG");
	push (@todel, "$C_rootpath");
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	for ($i=0; $i < @todel; $i++) {
		if (@todel[$i] !~ /$Classtodel\/$DIR_CGI\//) {
			if (-e @todel[$i] && ! unlink(@todel[$i])) {
				# File was not deleted
				if (-d @todel[$i]) {
					if ($isWin) {
						if (-e @todel[$i] && ! &deletedir(@todel[$i])) {
							&showErrorBackHTML("Unable to delete directory: @todel[$i]. Please check file permissions and try again, or manually delete the directory.", 1);
							exit();
						}
					} else {
						if (-e @todel[$i] && ! rmdir(@todel[$i])) {
							&showErrorBackHTML("Unable to delete directory: @todel[$i]. Please check file permissions and try again, or manually delete the directory.", 1);
							exit();
						}
					}
				} else {
					&showErrorBackHTML("Unable to delete file: @todel[$i]. Please check file permissions and try again, or manually delete the file.", 1);
					exit();
				}
			}
		}
	}
	
	# Remove the class from the database
	$dbfile = $DBFILE_CLASSID;
	
	@retval = `$delDB $dbfile -thash -k \"$Classtodel\"`;
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to delete $Classtodel from $dbfile. Check file permissions and try again.", 1);
		exit();
	}

	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');

	&showHeaderBackHTML("$CorF $Classtodel Deleted", "<br>",
			0, 0, 0, "", $cookie);
	
	print "<script language=javascript>\n";
	print "parent.classmenu.document.location.reload();\n";
	print "</script>\n";
	print "$CorF $Classtodel Deleted<br>\n";
}

sub confirmdel {
	# Print class deletion confirmation page.
	$helplink = "file=ForumDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteForumEdtFSummary";
	$helplink .= "&helptitle=Deleting%20$CorFs";
	
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
	&showHeaderBackHTML("Are you Sure?", "", 0, 0, 0, $helplink, $cookie);

	print $FontSize2, "$FontRed<b>Are you sure you want to ";
	print "permanently delete the $corf titled \"$C_title\" (id=$Classtodel)?</font></font><p>\n";
	
	print "<form action=$CGIEnvScript method=POST>";
	print "<input type=hidden name=fid value=$Class>";
	print "<input type=hidden name=classtodel value=$Classtodel>";
	print "<input type=hidden name=func value=delclass>";
	print "<input type=radio name=confirm value=\"YES\"> Yes\n";
	print "<input type=radio name=confirm value=\"NO\" checked> No<br>\n";
	if ($Demo) {
		print $BtnFormDelDemo;
	} else {
		print $BtnFormDel;
	}
	print "</form>";
}

sub addanon {
	local($newclass) = @_;
	local($retval);
	
	$DB_Key = "Anonymous";
	$U_SUID = "";
	$U_Pass = "";
	$U_NameLast = "";
	$U_NameFirst = "Anonymous";
	$U_NamePref = "Anonymous";
	$U_Perms = 1;
	$U_C_Sect = $newclass . ":1";
	$U_Photo = "Anonymous.gif";
	$U_PhotoLarge = "Anonymous.jpg";
	$U_Classify = "0";
	$U_ProfileText = "Anonymous";
	$U_Email = "";
	$U_Sig = "";
	$U_HideEmail = 1;
	
	$retval = &addtodb($DB_Key);
	if ($retval) {
		&userDBError($retval);
	}
}

sub addguest {
	local($newclass) = @_;
	local($retval);
	
	$DB_Key = "Guest";
	$U_SUID = "";
	$U_Pass = "Guest";
	$U_NameLast = "";
	$U_NameFirst = "Guest";
	$U_NamePref = "Guest";
	$U_Perms = 3;
	$U_C_Sect = $newclass . ":1";
	$U_Photo = "Guest.gif";
	$U_PhotoLarge = "Guest.jpg";
	$U_Classify = "0";
	$U_ProfileText = "Guest";
	$U_Email = "";
	$U_Sig = "";
	$U_HideEmail = 1;
	
	$retval = &addtodb($DB_Key);
	if ($retval) {
		&userDBError($retval);
	}
	
	&addtoht($DB_Key, $U_C_Sect);
}

sub printTemplateList {
	local($dir, @tmps, $i, $line, $junk, $title);

	$dir = "./" . $DIR_NEWCLASS . "/" . $DIR_NEWTEMPLATE;
	@tmps = glob("$dir/*.tmp");
	
	print "\n<select name=template>\n";
	for ($i=0; $i < @tmps; $i++) {
		open (f, @tmps[$i]) || &fileErr(@tmps[$i], "r");
		while(<f>) {
			$line = $_;
			chomp($line);
			if ($line =~ /^C_title/) {
				($junk, $title) = split(/\t+/, $line);
			}
		}
		close(f);
	
		print "<option value=\"", @tmps[$i], "\"> ";
		if ($title ne "") {
			print $title, "\n";
		} else {
			print @tmps[$i], "\n";
		}
	}
	print "</select>\n";
}

sub copy {
	local($src, $target) = @_;
	if (!open(sf, $src)) {
		&showErrorBackHTML("Couldn't open the file, $src, for reading. Does it exist?",1);
		exit();
	}
	binmode(sf);
	@sd = <sf>;
	close(sf);
	
	if (!open(tf, ">$target")) {
		&showErrorBackHTML("Couldn't write to file, $target. Check file permissions and try again.",1);
		exit();
	}
	binmode(tf);
	print tf @sd;
	close(tf);
}

sub copydir {
	local($fd, $fdo) = @_;
	local($f,$fi,$fo);
	local(@files);

	if (-d $fd) {
		if (!-d $fdo && -e $fdo) {
			&showErrorBackHTML("unable to create dest dir $fdo");
		} elsif (!-e $fdo) {
			mkdir($fdo,0777);
		}

		opendir(XD,$fd);
		@files = readdir(XD);
		closedir(XD);

		foreach $f (@files) {
 			if ($f ne "." && $f ne "..") {
				$fo = $fdo . "/" . $f;
				$fi = $fd . "/" . $f;
				&copydir($fi, $fo);
			} 
		}
	} else {
		&copy($fd, $fdo);
	}

}

sub deletedir {
	local($fd) = @_;
	local($f,$fi,$fo);
	local(@files);

	if (-d $fd) {

		opendir(XD,$fd);
		@files = readdir(XD);
		closedir(XD);

		foreach $f (@files) {
 			if ($f ne "." && $f ne "..") {
				$fi = $fd . "/" . $f;
				if (!-d $fi) {
					unlink($fi);
				} else {
					&deletedir($fi);
				}
			}
		}

		rmdir($fd);
	} else {
		&unlink($fd);
	}

}

sub makedefaults {
	local($rooturl, $thisclass) = @_;
	local($sugdir);
	local($thisdir) = &pwd;
	@getdir = split(/\//, $thisdir);
	local($len) = @getdir - 1;
	for (local($ko)=0; $ko < $len; $ko++) {
		if ($getdir[$ko] ne "" && $getdir[$ko] ne $Class) {
			if ($ko <= 1) {
				if ($isWin && @getdir[$ko] =~ /^\w\:/) {
					# Do nothing
				} else {
					$sugdir .= "/";
				}
			} else {
				$sugdir .= "/";
			}
			$sugdir .= @getdir[$ko];
		}
	}
	
	$C_authtype = "cookies";
	$C_title = $newclass . " Forum";
	$C_rootpath = "$sugdir/$newclass";
	if ($rooturl ne "" && $thisclass ne "") {
		$C_rooturl = $rooturl;
		$C_rooturl =~ s/$thisclass/$newclass/;
	} else {				
		$panforaurl = $ENV{"SCRIPT_NAME"};
		# Remove preceding and trailing slashes
		$panforaurl =~ s/^\///;
		$panforaurl =~ s/\/$//;
		@tmp = split(/\//, $panforaurl);
		$panforaroot = "";
		if ($CGIQuery->param('fid') ne "") {
			while ((($d = shift(@tmp)) ne $CGIQuery->param('fid')) && $#tmp >= 0) {
				$panforaroot .= "/" . $d;
			}
		} else {
			while ((($d = shift(@tmp)) !~ /panFora/i) && $#tmp >= 0) {
				$panforaroot .= "/" . $d;
			}
		}
		
		if ($panforaroot ne "") {
			$C_rooturl = $panforaroot . "/" . $newclass;
		} else {
			$C_rooturl = "/" . $newclass;
		}
	}
	$C_rootdir = $C_rootpath;
	$C_photodir = "$C_rootpath/Photo";
	$C_photourl = "$C_rooturl/Photo";
	# $C_listdir = $C_rootpath . "/" . $DIR_CONFIG . "/MailingLists";
	$C_listdir = $C_rootpath . "/MailingLists";
}

sub clearclassvars {
	$C_rootpath = "";
	$C_title = "";
	$C_name = "";
	$ColorQueryString = "";
	$C_rooturl = "";
	$C_rootpath = "";
	for ($k=1; $k <= $C_Sect_n; $k++) {
		$C_Sects{$k}{"num"}  = "";
		$C_Sects{$k}{"name"}  = "";
		$C_Sects{$k}{"fac"}  = "";
		$C_Sects{$k}{"time"}  = "";
		$C_Sects{$k}{"location"}  = "";
		$C_Sects{$k}{"email"}  = "";
	}
	$C_Sect_n = "";
	for ($k=1; $k <= $C_Fac_n; $k++) {
		$C_Sects{$k}{"login"}  = "";
		$C_Sects{$k}{"firstname"} = "";
		$C_Sects{$k}{"lastname"} = "";
		$C_Sects{$k}{"prefname"} = "";
		$C_Sects{$k}{"officehours"} = "";
	}
	$C_Fac_n = "";
	$ForumAllowGuest = "0";
	$ForumPostGuest = "0";
	$ForumReadGuest = "0";
	$ForumPostAnon = "1";
	$C_Public = "0";
	$C_ShowStats = "1";
	$C_UserEdit = "1";
	$C_photodir = "";
	$C_photourl = "";
	$C_listdir = "";
}

sub doNewPass {
	local($pw, $adminpass, $newpass, $verifynewpass);
	$adminpass = $CGIQuery->param('panForaAdmin');
	$newpass = $CGIQuery->param('newpass');
	$verifynewpass = $CGIQuery->param('verifynewpass');
	
	if ($forumadmin != 1) {
		&showLogin(2);
		exit();
	} elsif ($newpass ne $verifynewpass) {
		&showLogin(3);
		exit();
	} elsif (length($newpass) < 5) {
		&showLogin(4);
		exit();
	}
	
	# If we got here, everything checks out.
	$pw = &cryptPass($newpass);
	
	if (open(f, ">./.forumadmin")) {
		print f $pw;
		close(f);
	} else {
		&showErrorBackHTML("Couldn't open the password file for writing. Please check permissions on the password file (.forumadmin) and try again.", 1);
		exit();
	}
	
	$cryptAdminPass = $pw;
	$writeCookie = 1;
	&showConfLogin("The password has been changed, and you are now logged in.");
	exit();
}

sub sendAdminNotif {
	local($FURLHOME);
	
	$FURL = "http://" . $ENV{'SERVER_NAME'};
	if ($ENV{'SERVER_PORT'} ne "" && $ENV{'SERVER_PORT'} != 80) {
		$FURL .= ":" . $ENV{'SERVER_PORT'};
	}
	if (!$isWin) {
		$FURL .= $C_rooturl . "/";
		$FURLHOME = $FURL;
		$FURL .= $DIR_CGI . "/";
		$AURL = $FURL;
		$FURL .= $CGI_Forum . "?fid=" . $Class;
		$AURL .= $CGI_ForumAdminMenu . "?fid=" . $Class;
	} else {
		$FURLHOME = $FURL . $C_rooturl . "/";
		$FURL .= $DIR_CGI . "/";
		$AURL = $FURL;
		$FURL .= $CGI_Forum . "?fid=" . $Class;
		$AURL .= $CGI_ForumAdminMenu . "?fid=" . $Class;
	}

	open (M, "| $sendmail ");
	print M <<end_print;
To: $U_NameFirst $U_NameLast <$U_Email>
From: panFora Administrator <$U_Email>
Subject: Your $Class Forum has been Created
MIME-Version: 1.0
X-Mailer: panFora $Version
Content-Type: multipart/alternative; boundary="------------1234567890987654321"

This is a multi-part message in MIME format.

--------------1234567890987654321
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 7bit

Your login information for accessing the $Class Forum is:
Login: $adduser
Password: $U_Pass

Note that your username and password are both case sensitive.

You can access the Forum Home Page using Netscape 4.0 or greater,
or Microsoft Internet Explorer 4.0 or greater at:	

   $FURLHOME

and the Forum, directly, at:


   $FURL

The Administrative Interface is at:

   $AURL

You will need create Topics and add users through the Administration Menu
before the Forum can be used.

BE SURE TO READ THE HELP FILES!
There are buttons for the Help files in the Forum and in the Administrative
interface. Please use them!

________________________________
panFora - http://www.withinc.com

--------------1234567890987654321
Content-Type: text/html; charset=us-ascii
Content-Transfer-Encoding: 7bit

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
Your login information for accessing the $Class Forum is:<p>
Login: <b>$adduser</b><br>
Password: <b>$U_Pass</b><br>

Note that your username and password are both case sensitive.<p>

You can access the Forum Home Page using Netscape 4.0 or greater,
or Microsoft Internet Explorer 4.0 or greater at:<p>

&nbsp;&nbsp;&nbsp; <a href=\"$FURLHOME\">$FURLHOME</a><p>

and the Forum, directly, at:<p>

&nbsp;&nbsp;&nbsp; <a href=\"$FURL\">$FURL</a><p>

The Administrative Interface is at:<p>

&nbsp;&nbsp;&nbsp; <a href=\"$AURL\">$AURL</a><p>

You will need create Topics and add users through the Administration Menu
before the Forum can be used.<p>

BE SURE TO READ THE HELP FILES!<br>
There are buttons for the Help files in the Forum and in the 
Administrative interface. Please use them to take best advantage 
of all the available features!<p>

________________________________<br>
panFora - <a href=\"http://www.withinc.com/\">http://www.withinc.com/</a><br>
</html>

--------------1234567890987654321--

end_print
	
	close(M);
}
