;========================================================================

; Copyright (C) 1991-95 by Jan.Engvald@ldc.lu.se, see file COPYING.



;************************************************************************
;*		TblDisplay 
;************************************************************************

TblDisplay	proc	near
		assume	ds:code_s
		push	cs
		pop	es
		mov	ah,2Ch			; get time
		int	21h
		mov	di,offset TblTime
		mov	si,di
		cld
		mov	al,ch
		cbw
		stosw
		mov	al,cl
		cbw
		stosw
		mov	al,dh
		cbw

		cmp	ax,[di] 		; new second yet?
		jne	TblNewTime
		ret

  TblNewTime:
		stosw

		mov	ch,':'
		mov	cl,3
		mov	di,offset MsgTblTime
		call	PutNumsD2F0 		; put time of day

		mov	ax,TblSeen
		mov	dx,TblSeen+2
		mov	di,offset MsgTblSeen
		mov	PutNumFiller,' '
		mov	PutMinDigits,10
		call	PutBigNum		; put ARP broadcasts seen

		mov	dx,offset MsgTblDispl
		call	DosPr$
		ret
TblDisplay	endp
 



if HOPCHK

;************************************************************************
;*		HopDisplay
;************************************************************************

HopIcmpCode	db	'N'	; 0 = net unr
		db	'H'	; 1 = host unr
		db	'P'	; 2 = prot unr
		db	'p'	; 3 = port unr
		db	'F'	; 4 = fragm needed
		db	'S'	; 5 = source route failed
		db	'U'	; 6 = dest net unknown
		db	'u'	; 7 = dest host unknown
		db	's'	; 8 = source host isolated
		db	'A'	; 9 = Net adm prohib
		db	'a'	; 10 = host adm prohib
		db	'T'	; 11 = dest net tos unr
		db	't'	; 12 = dest host tos unr
HopIcmpCodes	equ	$-HopIcmpCode


HopDisplay	proc	near
		mov	HopReplies,0
		mov	bx,HopBx

  HopDspNewLine:
		or	bx,bx
		jns	HopDspNL2

		mov	bp,offset MsgEchoHead+2
		cmp	bx,-2*4
		je	HopDspNL1
		mov	bp,offset MsgEchoHead+2+DSPLINLEN
  HopDspNL1:
		jmp	HopDspThis

  HopDspNL2:
		mov	ax,bx
		mul	k20
		mov	di,offset HopTabDsp
		add	di,ax
		push	di			; save beg of line

		mov	ax,bx
		shr	ax,1
		shr	ax,1
		mov	PutMinDigits,2
		call	PutNumFb		; put hop count
		mov	al,':'
		stosb

		test	word ptr HopTabStat[bx],08 ; already handled line nr?
		jnz	HopDspLinDone
		cmp	bx,HopBxMax
		ja	HopDspLinDone
		or	MoreFlags,UPPD_LINE
		or	word ptr HopTabStat[bx],08
  HopDspLinDone:

  HopDspNext:
		mov	PutMinDigits,5
		mov	ax,word ptr HopTabOth[bx] ; get delay
		push	ax
if 1
		mul	k512			; adjust to 1 ms unit
		add	ax,TimerResolution/2
		adc	dx,0
		div	kTimerScale
endif
		call	PutNumFb		; put delay

		mov	al,' '
		mov	dx,word ptr HopTabOth+2[bx]
		or	dx,dx			; got anything?
		jz	HopDspPutCode

		cmp	dx,0011			; ttl exceeded?
		je	HopDspPutCode

		mov	al,'?'			; other err
		cmp	dl,03			; unreachables?
		jne	HopDspPutCode

		cmp	dh,HopIcmpCodes		; within known range?
		jae	HopDspPutCode

		mov	dl,dh
		xor	dh,dh
		mov	si,dx
		mov	al,HopIcmpCode[si]

  HopDspPutCode:
		stosb				; put type of ICMP code

		pop	ax
		test	word ptr HopTabStat[bx],01 ; already handled delay?
		jnz	HopDspDlyDone
		or	ax,ax			; got it yet?
		jz	HopDspDlyDone
		or	MoreFlags,UPPD_LINE+GOT_HOP_REPLY
		or	word ptr HopTabStat[bx],01
  HopDspDlyDone:
		add	bx,4*MAXHOP
		cmp	bx,12*MAXHOP
		jb	HopDspNext		; loop for all 3 turns
		sub	bx,12*MAXHOP

		test	MoreFlags,GOT_HOP_REPLY	; got a reply this turn?
		jz	HopDspNoreply

		or	word ptr HopTabStat[bx],010h
		and	MoreFlags,not GOT_HOP_REPLY
  HopDspNoReply:
		test	word ptr HopTabStat[bx],010h ; got a reply any turn?
		jz	HopDspNoRouter
		add	HopReplies,4
  HopDspNoRouter:
		xor	ax,ax			; clear last IP #
		xor	dx,dx
		lea	bp,HopTabIp[bx]		; init first IP #

  HopDspNextIP:
		lea	si,HopTabIp[bx]
		cmp	dx,[si]			; equal to last nr or zero?
		jne	HopDspNE
		cmp	ax,[si+2]
		je	HopDspZ
  HopDspNE:
		cmp	word ptr [bp],0		; found first IP # yet?
		jnz	HopDspHavIp
		mov	bp,si
  HopDspHavIp:
		mov	dx,[si]
		mov	ax,[si+2]
		or	dx,dx			; zero IP # ?
		jz	HopDspZ
		cmp	si,bp			; this turn is first nz IP nr?
		je	HopDspNZ
		cmp	dx,[bp]			; equal to first IP # ?
		jne	HopDspNZ
		cmp	ax,[bp+2]
		je	HopDspZ
  HopDspNZ:
		push	dx
		push	ax
		mov	al,' '
		stosb
		call	PutIpNum		; put IP nr
		pop	ax
		pop	dx
		or	word ptr HopTabStat[bx],02 ; dsp name for this IP nr
  HopDspZ:
		add	bx,4*MAXHOP
		cmp	bx,12*MAXHOP
		jb	HopDspNextIP		; loop for all 3 turns
		sub	bx,12*MAXHOP

HopDspNextNam:
		test	word ptr HopTabStat[bx],02 ; dsp name for this IP nr?
		jz	HopDspNamDone
		and	word ptr HopTabStat[bx],not 02

		pop	dx			; blankfill to col 37
		push	dx
		add	dx,37
		mov	al,' '
  HopDspFill:
		stosb
		cmp	di,dx
		jbe	HopDspFill
  
		add	dx,DSPLINLEN-37		; max 80 columns

		lea	si,HopTabIp[bx]
		push	bx
		mov	es,SegIpHwTbl
		mov	bx,TblSize
		mov	ax,4
		call	FindIn16Table		; this IP got a name?
		mov	al,es:[bx].SlotPend
		push	cs
		pop	es
		jnz	HopDspNotYet
		cmp	al,'0'
		je	HopDspYet
		cmp	al,'N'
		je	HopDspYet
		cmp	al,'A'
		jne	HopDspNotYet
  HopDspYet:
		call	TabPutName		; put name
		push	cs
		pop	ds
		pop	bx

		test	word ptr HopTabStat[bx],04 ; already handled name?
		jnz	HopDspNamDone
		SHOW_EVENT	'Y'
		or	MoreFlags,UPPD_LINE
		or	word ptr HopTabStat[bx],04
		push	bx
  HopDspNotYet:
		pop	bx
  HopDspNamDone:		

		add	bx,4*MAXHOP
		cmp	bx,12*MAXHOP
		jb	HopDspNextNam		; loop for all 3 turns
		sub	bx,12*MAXHOP

		mov	ax,HopBxMax		; compute DspBxMax
		add	ax,2*4
		shr	ax,1
		shr	ax,1
		mov	DspBxMax,ax

		pop	bp
  HopDspThis:
		push	bx
		shr	bx,1
		shr	bx,1
		add	bx,2			; room for 2 hdr lines
		call	EchoDspThis		; display scrollable info
		pop	bx

		add	bx,4			; repeat for next hop row
		cmp	bx,HopBxMax
		jg	HopDspEnd
		jmp	HopDspNewLine

  HopDspEnd:
		mov	HopBx,-2*4
		ret
HopDisplay	endp




;************************************************************************
;*		HopWrPath
;************************************************************************


HopWrPath	proc	near
		mov	dx,offset NameHopPath
		xor	cx,cx
		mov	ah,3ch
		int	21h			; create/truncate file
		mov	Handle,ax
		jnc	HopWrite
		jmp	HopOpenErr

  HopWrite:
		mov	bx,4
		mov	di,offset FileBuf
		mov	ax,':e'
		stosw

  HopWrNewLine:
		xor	ax,ax			; clear last IP #
		xor	dx,dx
		lea	bp,HopTabIp[bx]		; init first IP #

  HopWrNextIP:
		lea	si,HopTabIp[bx]
		cmp	dx,[si]			; equal to last nr or zero?
		jne	HopWrNE
		cmp	ax,[si+2]
		je	HopWrZ
  HopWrNE:
		cmp	word ptr [bp],0		; found first IP # yet?
		jnz	HopWrHavIp
		mov	bp,si
  HopWrHavIp:
		mov	dx,[si]
		mov	ax,[si+2]
		or	dx,dx			; zero IP # ?
		jz	HopWrZ
		cmp	si,bp			; this turn is first nz IP nr?
		jne	HopWrZ
if 0
		push	dx
		push	ax
		mov	al,' '
		stosb
		call	PutIpNum		; put IP nr
		mov	ax,'& '
		stosw
		mov	ax,CR+256*LF
		stosw
		pop	ax
		pop	dx
endif
		or	word ptr HopTabStat[bx],02 ; dsp name for this IP nr
  HopWrZ:
		add	bx,4*MAXHOP
		cmp	bx,12*MAXHOP
		jb	HopWrNextIP		; loop for all 3 turns
		sub	bx,12*MAXHOP
if 1
HopWrNextNam:
		test	word ptr HopTabStat[bx],02 ; dsp name for this IP nr?
		jz	HopWrNamDone
		and	word ptr HopTabStat[bx],not 02

		lea	si,HopTabIp[bx]
		push	bx
		mov	es,SegIpHwTbl
		mov	bx,TblSize
		mov	ax,4
		call	FindIn16Table		; this IP got a name?
		mov	al,es:[bx].SlotPend
		push	cs
		pop	es
		jnz	HopWrNotYet
		cmp	al,'0'
		je	HopWrIpNr
		cmp	al,'N'
		je	HopWrYet
		cmp	al,'A'
		jne	HopWrNotYet
  HopWrYet:
                mov     al,'{'
                stosb
		mov	dx,offset FileBuf+ARGFILESIZE
		call	TabPutName		; put name
		push	cs
		pop	ds
                mov     ax,' }'
                stosw

  HopWrIpNr:
		pop	bx
		lea	si,HopTabIp[bx]
		call	PutIpNum		; put IP nr

  HopWrNamePut:
		mov	ax,'& '
		stosw
		mov	ax,CR+256*LF
		stosw

		test	word ptr HopTabStat[bx],04 ; already handled name?
		jnz	HopWrNamDone
		SHOW_EVENT	'Y'
		or	MoreFlags,UPPD_LINE
		or	word ptr HopTabStat[bx],04
		push	bx
  HopWrNotYet:
		pop	bx
  HopWrNamDone:		

		add	bx,4*MAXHOP
		cmp	bx,12*MAXHOP
		jb	HopWrNextNam		; loop for all 3 turns
		sub	bx,12*MAXHOP
endif 
		add	bx,4
		cmp	bx,4*MAXHOP
		jae	HopWrEndNames
		jmp	HopWrNewLine

  HopWrEndnames:
		mov	bx,Handle
		mov	dx,offset FileBuf
		lea	cx,[di-4]
		sub	cx,dx
		mov	ah,40h
		int	21h

  HopOpenErr:
		mov	ah,3eh
		int	21h
		ret
HopWrPath	endp

endif ; HOPCHK



;************************************************************************
;*		FindIn16Table
;*
;*	Input:	     DS:SI = address of search string key (saved)
;*			AX = string length (saved)
;*			ES = table segment (saved)
;*			BX = table size in bytes
;*	Output:      ES:BX = table slot address of entry less or equal to key
;*			Zero flag if equal to key
;*	Destroys:	BX, flags
;*
;* Before use, the table must be filled with all ones bits, except slot 0 which
;* must be filled with zeros. Slot 0 key must not be changed.
;************************************************************************

FindIn16Table	proc	near
		assume	ds:nothing
		push	cx
		push	dx
		push	di
		push	bp
		mov	bp,si
		mov	cx,bx
		xor	bx,bx
		mov	dx,8000h		; find proper 2**x size
  FindLenLoop:
		cmp	dx,cx
		jb	FindHalfChk		; start binary search
		shr	dx,1
		jmp	short FindLenLoop

  FindLess:
		sub	bx,dx
  FindGreater:
		shr	dx,1			; divide step by two
  FindHalfChk:
		cmp	dx,16			; step < slot size?
		jb	FindDone
		add	bx,dx			; position halfway

		mov	di,bx
		mov	si,bp
		mov	cx,ax
		repe	cmpsb			; compare strings
		ja	FindGreater
		jb	FindLess
  FindDone:
		mov	si,bp
		pop	bp
		pop	di
		pop	dx
		pop	cx
		ret
FindIn16Table	endp



;************************************************************************
;*		GetHexNums
;************************************************************************

GetHexNums	proc	near
		assume	ds:nothing
  GetHexNum:
		xor	dx,dx
  GetHexDig:
		lodsb
		cmp	al,'0'
		jb	GetHexEnd
		cmp	al,'9'
		ja	GetHexTst
		sub	al,'0'
		jmp	short GetHexConv
  GetHexTst:
		cmp	al,'a'
		jb	GetHexEnd
		cmp	al,'f'
		ja	GetHexEnd
		sub	al,'a'-10
  GetHexConv:
		cbw
		add	ax,dx
		mov	cx,ax
		mul	k16
		mov	dx,ax
		jmp	short GetHexDig
  GetHexEnd:
		cmp	al,'-'
		mov	ax,cx
		stosb
		je	GetHexNum
		ret
GetHexNums	endp



;************************************************************************
;*		Ins16ByteSlot
;************************************************************************

Ins16ByteSlot	proc	near
		SHOW_EVENT	'a'
		assume	ds:nothing
		push	ds
		mov	cx,cs:TblSize
		push	es
		pop	ds
		sub	cx,bx
		mov	si,bx
		sub	si,2
		add	si,cx
		mov	di,si
		add	di,16
		std
		shr	cx,1
		rep	movsw
		cld
		pop	ds
		ret
Ins16ByteSlot	endp



;************************************************************************
;*		FindHostInTbls
;************************************************************************

FindHostInTbls	proc	near
		assume	ds:nothing
		push	dx
		push	ax

		mov	es,cs:SegHwIpTbl
		mov	bx,cs:TblSize
		mov	ax,11
		mov	si,bp
		push	[si+10]
		mov	byte ptr [si+10],' '
		call	FindIn16Table
		pop	[si+10]
		jz	InitHwMatch

		add	bx,16
		call	Ins16byteSlot
		mov	si,bp
		mov	cx,10/2
		mov	di,bx
		rep	movsw			; (SlotHw SlotIp)

		mov	ax,'  '
		stosw				; SlotDupl SlotPend
		mov	ax,TblSize
		mov	cl,3
		shr	ax,cl
		stosw				; SlotNamPtr
  InitHwMatch:
		mov	es,SegIpHwTbl
		mov	bx,cs:TblSize
		mov	ax,11
		mov	si,bp
		sub	si,4
		push	[si+10]
		mov	byte ptr [si+10],' '
		call	FindIn16Table
		pop	[si+10]
		jz	InitIpMatch

		add	bx,16
		call	Ins16byteSlot
		mov	si,bp
		sub	si,4
		mov	cx,10/2
		mov	di,bx
		rep	movsw			; SlotIp SlotHw

		mov	ax,'  '
		stosw				; SlotDupl SlotPend
		mov	ax,cs:TblSize
		mov	cl,3
		shr	ax,cl
		stosw				; SlotNamPtr
		xor	ax,ax
		stosw				; SlotSeen
		SHOW_EVENT	'b'
		add	cs:TblSize,16		; non-zero
  InitIpMatch:
		pushf
		test	cs:GenFlags,PROBE_REPLY
		jnz	FindHostProbe

		inc	es:[bx].SlotSeen
		add	cs:TblSeen,1
		adc	cs:TblSeen+2,0
  FindHostProbe:
		popf
		pop	ax
		pop	dx
		ret
FindHostInTbls	endp



;************************************************************************
;*		TableInit
;************************************************************************

TableInit	proc	near
		assume	ds:code_s
if HOPCHK
		test	MoreFlags,HOP_CHK
		jnz	TableInit2
endif ; HOPCHK
		test	Argflags,MAKE_TABLE
		jnz	TableInit2
		ret
  TableInit2:
		mov	bx,(TableSegs-1)*2
		mov	dx,cs
		add	dx,1000h
		mov	ax,'  ' 		; NamTbl2 must be blanked
  TableFF:
		mov	word ptr SegmData[bx],dx
		mov	es,dx
		add	dx,1000h
		cmp	dx,PspTopMem		; end of free memory?
		jbe	TableFits

		mov	al,'M'-'0'
		call	Terminate
  TableFits:
		mov	cx,08000h		; prefill all 64 kb
		xor	di,di
		rep	stosw

		sub	bx,2
		mov	ax,0ffffh		; IpHwTbl prefill
		jns	TableFF

		xor	ax,ax			; zerofill first slot
		mov	es,SegIpHwTbl
		mov	cx,16/2
		xor	di,di
		rep	stosw

		mov	es,SegHwIpTbl
		mov	cx,16/2
		xor	di,di
		rep	stosw

		push	cs
		pop	es

if HOPCHK
		test	MoreFlags,HOP_CHK
		jz	TableInNoHop

		or	GenFlags,TBL_READY
		ret

  TableInNoHop:
endif ; HOPCHK

		mov	dx,offset NameHwTbl
		mov	ax,3d02h
		int	21h
		jc	TabInitHw

		mov	bx,ax
		mov	ah,3eh
		int	21h
		jmp	short TabTstIp
  TabInitHw:
		mov	dx,offset NameHwTbl
		xor	cx,cx
		mov	ah,3ch
		int	21h
		jc	TabOpenErr
  TabTstIP:
		mov	dx,offset NameIpTbl
		mov	ax,3d02h
		int	21h
		mov	Handle,ax
		jnc	TabRdNext

		mov	dx,offset NameIpTbl
		xor	cx,cx
		mov	ah,3ch
		int	21h
		jc	TabOpenErr
		mov	Handle,ax
		jmp	TabRdClOK
  TabOpenErr:
		mov	al,'O'-'0'
		call	Terminate

  
  TabRdLong:
		mov	TblLineLen,81
		mov	cx,9
		mov	dx,offset FileBuf+72
		jmp	short TabRdMore
  
  TabRdNext:
		push	cs
		pop	es
		mov	cx,TblLineLen
		mov	dx,offset FileBuf
  TabRdMore:		    
		mov	bx,Handle
		mov	ah,3fh
		int	21h
		jc	TabRdErr

		mov	si,offset FileBuf
		cmp	byte ptr [si],'Z'-040h
		je	TabRdEof
	        
		or	ax,ax
		jz	TabRdEof

		cmp	TblLineLen,72
		jne	TabOkLen

		cmp	byte ptr FileBuf+71,LF
		jne	TabRdLong
  TabOkLen:
		mov	di,offset TmpTbl
		mov	bp,di
		call	GetIpNr
		jnz	TabRdErr

		mov	si,offset FileBuf+53
		call	GetHexNums

		push	si
		mov	si,bp
		movsw
		movsw

		add	bp,4
		call	FindHostInTbls
		je	InitDup

		push	es
		mov	si,offset FileBuf+16
		call	NamePut
		pop	es
  InitDup:
		pop	si
		cmp	byte ptr [si],LF
		je	TabRdOld

		call	Skip_Blanks
		call	GetNum
		or	ax,ax
		jns	InitSmallArp
		mov	ax,07fffh
  InitSmallArp:
		test	ArgFlags,TBL_ARP_CLR
		jz	InitKeepArp
		xor	ax,ax
  InitKeepArp:
		dec	ax
		cwd
		add	es:[bx].SlotSeen,ax
		add	TblSeen,ax
		adc	TblSeen+2,dx
		inc	si
  TabRdOld:
		push	cs
		pop	es
	        
		cmp	byte ptr [si],LF
		jne	TabRdErr

		mov	byte ptr [si+1],'$'

		mov	dx,offset FileBuf
		call	DosPr$
		jmp	TabRdNext

  TabRdErr:
		mov	al,'R'-'0'
		call	Terminate

  TabRdEof:
		mov	bx,Handle
		mov	ah,3eh
		int	21h
		jnc	TabRdClOK

		mov	al,'C'-'0'
		call	Terminate
  TabRdClOK:
if DEBUG eq 0
		call	ProbeIpInit
endif ; not DEBUG
		mov	cx,SavedTicks
		mov	TblProbeNext,cx
		mov	TblWrNext,cx
		cmp	EchoTarget,0
		jnz	TableInitRet

TableReady:
		test	ArgFlags,MAKE_TABLE
		jz	TableInitRet

		or	GenFlags,TBL_READY
		mov	si,offset DefGwyNum
		lodsw
		mov	cx,ax
		jcxz	TableInitRet
  TableGwyLoop:
		push	cx
		lodsw
		mov	dx,ax
		lodsw
		push	si
		push	ds
		push	es
		call	BufAlloc
		mov	[bx].dTimOutMsg,0	; we don't require an answer
		mov	[bx].dTickTimeout,0	; don't wait
		call	SendArpReq		; send arp
		call	BufRelease
		pop	es
		pop	ds
		pop	si
		pop	cx
		loop	TableGwyLoop

  TableInitRet:
		ret
TableInit	endp



ProbeIpInit	proc	near
		mov	dx,MyNet
		mov	ax,Mynet+2
		mov	TblIpProbe,dx
		inc	ah
		mov	TblIpProbe+2,ax
		ret
ProbeIpInit	endp



;************************************************************************
;*		TblProbe
;************************************************************************

MsgNeedMask	db	"Need to know network mask", CR, LF, '$'

TblProbe	proc	near
		assume	ds:nothing
		mov	ds,cs:MySegm
		assume	ds:code_s
		cmp	InSendAndW,0
		jnz	TblProbeRet

		test	GenFlags,TBL_READY
		jz	TblProbeRet

		mov	cx,SavedTicks
		mov	ax,cx
		sub	ax,TblProbIntvl 	; 2 - 9 probes a second
		sub	ax,TblProbeNext
		js	TblProbeRet

		mov	TblProbeNext,cx

		mov	ax,cx
		sub	ax,TblWrNext
		js	TblWrLater

		add	cx,182*20		; limit write to once in 200 s
		mov	TblWrNext,cx

		mov	ax,TblSize
		mov	dx,TblActive
		cmp	dx,TblActLast
		ja	TblProbeWr

		cmp	ax,TblSizeLast
		jbe	TblWrLater
  TblProbeWr:
		mov	TblActLast,dx
		mov	TblSizeLast,ax
		call	TableWr
  TblWrLater:
		test	ArgFlags,TBL_PROBE
		jnz	TblDoProbe
  TblProbeRet:
		ret

  TblDoProbe:
		cmp	MyMask,0
		jne	TblProbeChkIntvl
		mov	dx,offset MsgNeedMask
		mov	al,'P'-'0'
		call	PrTerminate
  TblProbeChkIntvl:
if DEBUG
		cmp	TblProbIntvl,1
else
		cmp	TblProbIntvl,2
endif ; DEBUG
		jbe	TblProbMin
		dec	TblProbIntvl
  TblProbMin:

		mov	dx,TblIpProbe
		mov	ax,TblIpProbe+2
		cmp	ax,ArpTabIp2+2		; end of subnet numbers?
		jne	TblProbeMore
		cmp	dx,ArpTabIp1+2
		jne	TblProbeMore
		call	ProbeIpInit
  TblProbeMore:
		push	ds
		push	es
		call	BufAlloc
		mov	[bx].dTimOutMsg,0	; we don't require an answer
		mov	[bx].dTickTimeout,0	; don't wait
		call	SendArpReq		; send arp
		call	BufRelease
		pop	es
		pop	ds

		add	ah,1			; increment IP #
		adc	al,0
		adc	dh,0
		adc	dl,0
		mov	TblIpProbe,dx
		mov	TblIpProbe+2,ax

		mov	si,offset TblIpProbe
		mov	di,offset MsgTblDispl
		call	PutIpNum
		call	BlankUntil16
		ret
TblProbe	endp



;************************************************************************
;*		InvNsReq
;************************************************************************

InvNsReq 	proc	near
		assume	ds:nothing
		SHOW_EVENT	'c'
		mov	cs:TblProbIntvl,9	; slow down probe to
		mov	es,cs:SegIpHwTbl	;   twice a second
		mov	di,es:[bx].SlotNamPtr
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jz	InvNsNotHop
		mov	cl,es:[bx].SlotPend
		shr	cl,1
		shr	cl,1
		shl	di,1
		shl	di,1
		shr	cl,1
		rcr	di,1
		shr	cl,1
		rcr	di,1
  InvNsNotHop:
endif ; HOPCHK
		push	di			; save name tbl idx

		push	cs
		pop	es

		xor	ch,ch			; reverse IP nr
		mov	cl,dh
		xor	dh,dh
		push	dx
		push	cx
		mov	cl,ah
		xor	ah,ah
		push	ax
		push	cx

		mov	di,offset FileBuf	; generate request string
		mov	bl,4
		mov	cs:PutMinDigits,1
  TableNumLoop:
		mov	si,di
		inc	di
		pop	ax
		call	PutNum
		mov	es:[si],dl
		dec	bl
		jnz	TableNumLoop

		mov	si,offset InAdrArpa
		mov	cx,InAdrArpaLen
  TableNumL2:
		movs	byte ptr es:[FileBuf],cs:[InAdrArpa]
		loop	TableNumL2

		mov	dx,1234h		; tblbuild udp src port
		pop	ax			; NsId = name table index
		mov	si,offset FileBuf	; Ns question string

		call	NsResolve		; ask name for this #
		SHOW_EVENT	'd'
		ret
InvNsReq	endp



;************************************************************************
;*		NsResend
;************************************************************************

NsResend 	proc	near
		assume	ds:nothing
		test	cs:MoreFlags,HOP_CHK
		jnz	NsReseDo
		test	cs:ArgFlags,MAKE_TABLE
		jz	NsReseRet
  NsReseDo:
		test	cs:GenFlags,TBL_READY
		jz	NsReseRet
;		SHOW_TRACE	'A'
		mov	ds,cs:SegIpHwTbl
		mov	bx,16
  NsResNext:
		push	bx
		mov	al,[bx].SlotPend
		cmp	al,'p'			; Ns request pending?
		jb	NsReseEnd

		inc	al
		cmp	al,'p'+16		; time to resend?
		jbe	NsResInc
		mov	al,'p'+3
  NsResInc:
		mov	[bx].SlotPend,al
		and	al,3
		jnz	NsReseEnd
		mov	dx,[bx].SlotIp
		mov	ax,[bx].SlotIp+2
;		SHOW_TRACE	'b'
		call	InvNsReq		; resend Ns request
  NsReseEnd:
		pop	bx
		add	bx,16			; check next slot
		cmp	bx,cs:TblSize
		jb	NsResNext
  NsReseRet:
		push	cs
		pop	ds
		push	cs
		pop	es
		ret
NsResend	endp



;************************************************************************
;*		DoTable
;************************************************************************

DoTable 	proc	near
		assume	ds:nothing
		test	cs:GenFlags,TBL_READY
		jz	TableRetRel0
		cmp	cs:TblSize,0fff0h
		jb	$+5
  TableRetRel0:
		jmp	TableRetRel

		mov	ax,[bx].dPtrPhys
		call	ArpFindHw
		mov	[bx].dIdxHwDst,di

		mov	di,[bx].dPtrIp
		cmp	word ptr [di-2],0008h	; is this an IP pkt?
		jne	DoTabArp

		mov	dx,[di].iIpSrc
		mov	ax,[di].iIpSrc+2
		or	dx,dx
		jz	TableRetRel0		; ignore bootp requests
		mov	di,[bx].dPtrPhys
		add	di,cs:Hlen
		mov	bp,di
		add	di,cs:Hlen
		mov	[di],dx
		mov	[di+2],ax
		mov	cx,0200h		; fake an ARP reply
		mov	[bx].dIdxHwDst,ARPMYIDX
		jmp	short DoTabCommon
  DoTabArp:
		mov	cx,[di].iArpOp
		add	di,iArpMyHwAd
		mov	bp,di
		add	di,cs:Hlen
		mov	dx,[di]
		mov	ax,[di+2]
  DoTabCommon:
		mov	byte ptr [di+4],' '
		mov	ds:[bp-4],dx
		mov	ds:[bp-4+2],ax
		push	bx

		and	cs:GenFlags,not PROBE_REPLY
		cmp	cx,0200h		; ignore arp REPLIES from hosts
		jne	DoTabUpdate		; already known (probably a
		cmp	[bx].dIdxHwDst,ARPMYIDX ; proxy arp gateway)
		jne	DoTabUpdate

if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	DoTabUpdate
endif ; HOPCHK
		or	cs:GenFlags,PROBE_REPLY
		push	ax
		mov	es,cs:SegHwIpTbl
		mov	si,bp
		mov	ax,11
		mov	bx,cs:TblSize
		call	FindIn16Table		; this Hw+IP addr already known?
		pop	ax
		je	DoTabUpdate		; -yes, lets update name

		push	ax
		mov	si,bp
		mov	ax,cs:Hlen
		mov	bx,cs:TblSize
		call	FindIn16Table		; this Hw addr already known?
		pop	ax
		jne	DoTabUpdate		; -no, must be a new one
		or	bx,bx			; does he use hw addr zero?
		jz	DoTabUpdate		; -yes, put him in the tables
		cmp	bx,cs:TblSize		; he believes HE is broadcast?
		jb	TableAnswered		; -no
  DoTabUpdate:					; put this addr in the tables
		call	FindHostInTbls

		cmp	byte ptr es:[bx].SlotPend,' '
		jne	TableAnswered

		mov	byte ptr es:[bx].SlotPend,'p'
		inc	cs:TblActive
		call	InvNsReq

  TableAnswered:
		pop	bx
  TableRetRel:
		call	BufRelease
  TableRet:
		ret
DoTable 	endp



;************************************************************************
;*		BlankUntil16 byte boundry
;************************************************************************

BlankUntil16	proc	near
		assume	ds:nothing
		mov	al,' '
  BlankMore:
		test	di,0fh
		jz	BlankRet
		stosb
		jmp	short BlankMore
  BlankRet:
		ret
BlankUntil16	endp



;************************************************************************
;*		NamePut from DS:SI to TblName[next]
;************************************************************************

NamePut 	proc	near
		assume	ds:nothing

		push	si
		mov	di,es:[bx].SlotNamPtr
		mov	es,cs:SegmNamTbl
		mov	di,es:[di]
		cmp	di,0ffffh		; name already exists?
		je	NamePutNone

		shl	di,1			; compute addr to name
		jnc	NamPut1st
  NamPut2nd:
		mov	es,cs:SegmNamTbl2
  NamPut1st:
		add	di,48
		jc	NamPut2nd
		sub	di,48

  NamPutNamL:
		mov	al,[si]
		cmp	al,' '
		je	NamePutRet
		cmpsb				; new name equal to old?
		je	NamPutNamL
  NamePutNone:
		pop	si
		push	si


		mov	es,cs:SegIpHwTbl	; -no, use the new name
		mov	ax,cs:TblNamPtr
		mov	di,es:[bx].SlotNamPtr
		mov	es,cs:SegmNamTbl
		stosw				; store link addr

		mov	di,ax			; compute addr to new name
		shl	di,1
		jnc	NamePut1st
  NamePut2nd:
		mov	es,cs:SegmNamTbl2
  NamePut1st:
		mov	cx,48
		add	di,cx
		jc	NamePut1st
		sub	di,cx
  NamePutLoop:
		lodsb
		cmp	al,' '
		je	NamePutEnd
		stosb				; put new name
		loop	NamePutLoop
  NamePutEnd:
		mov	al,' '
		stosb

		inc	di			; save next name addr
		shr	di,1
		mov	ax,es
		cmp	ax,cs:SegmNamTbl2
		jne	NamePutFirst
		or	di,8000h
  NamePutFirst:
		mov	cs:TblNamPtr,di
  
NamePutRet:
		pop	ax
		push	cs
		pop	es
		ret
NamePut 	endp



;************************************************************************
;*		DoName
;************************************************************************

DoName		proc	near
		assume	ds:nothing
		test	cs:GenFlags,TBL_READY
		jnz	NameInited

		ret
  NameInited:
		SHOW_EVENT	'e'
		push	ds
		pop	es
		lea	si,[di].uNsQuest
		mov	bp,[di].uNsId
		lea	di,[di].uNsNscount	; used for scratch
		mov	dx,si
		inc	dx

  BS		equ	'H'-040h
		call	NameDecode
		mov	word ptr [si],'  '
		mov	word ptr [si+2],BS+256*BS
		add	si,4

		push	dx
		push	si
		mov	si,dx
		call	GetIpNr
		pop	si
		pop	dx

		mov	di,[bx].dPtrUdp
		cmp	[di].uNsAncount,0
		jne	NameHaveAns
		push	dx
		jmp	short NameNoAnswer
  NameHaveAns:
		mov	di,si
		call	NameDecode
		jnz	NameDcCompr
		mov	dx,di
		inc	dx
  NameDcCompr:
  TAB		equ	'I'-040h
		push	dx
		mov	word ptr [si],TAB+256*'N'
		mov	word ptr [si+2],'ma'
		mov	word ptr [si+4],'0e'
		mov	word ptr [si+6],'00'
		mov	word ptr [si+8],'=0'
		lea	di,[si+5]
		add	si,10
		mov	ax,bp
		shr	ax,1
		call	PutNumD4Fb
		mov	cs:PutMinDigits,2

		mov	di,si
		call	NameDecode
		dec	si
  NameNoAnswer:
		mov	word ptr [si],' '+256*CR
		mov	word ptr [si+2],LF+256*'$'

		mov	si,[bx].dPtrUdp
		mov	ax,[si].uNsNScount
		mov	dx,[si].uNsNscount+2
		xchg	ah,al
		xchg	dh,dl
		mov	[si].uNsNScount,dx
		mov	[si].uNsNScount+2,ax
		lea	si,[si].uNsNScount
		push	bx
		mov	bx,cs:TblSize
		mov	es,cs:SegIpHwTbl
		push	ax
		mov	ax,4
		call	FindIn16Table
		pop	ax
		mov	si,bx
		pop	bx
		je	NameFound
  NameNotFound:
		pop	dx
if DEBUG ge 3
		call	DosPr$
		mov	al,'A'-'0'
		call	Terminate
else
		jmp	NameRet
endif ; DEBUG ge 3
  NameFound:					; find question to this answer
		mov	cx,si
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jz	NameFindNxtHi

		and	bp,3fffh
endif ; HOPCHK
  NameFindNxtHi:
		cmp	bp,es:[si].SlotNamPtr
		je	NameFoundThis
		add	si,16
		cmp	dx,es:[si]
		jne	NameFindLower
		cmp	ax,es:[si+2]
		je	NameFindNxtHi
  NameFindLower:
		mov	si,cx
  NameFindNxtLo:
		sub	si,16
		cmp	bp,es:[si].SlotNamPtr
		je	NameFoundThis
		cmp	dx,es:[si]
		jne	NameNotFound
		cmp	ax,es:[si+2]
		jne	NameNotFound
		jmp	short NameFindNxtLo
  NameFoundThis:
		mov	bp,[bx].dPtrUdp
		mov	dx,ds:[bp].uNsAncount
		mov	ax,ds:[bp].uNsOpwd
		and	ah,0fh
		cmp	ah,1			; format error?
		jne	NameFmtOK

		mov	al,'F'-'0'
		call	Terminate
  NameFmtOK:
		cmp	ah,2			; temporary server problem?
		je	NameSkipUpd

		test	al,4			; authorative answer?
		jz	NameTryLater

		mov	byte ptr es:[si].SlotPend,'0' ; we ask no more about this #
  NameTryLater:
		or	ah,ah			; any other error?
		jnz	NameSkipUpd

		or	dx,dx			; any answer?
		jz	NameSkipUpd

		mov	byte ptr es:[si].SlotPend,'N' ; we ask no more about this #
		test	al,4			; authorititive answer?
		jz	NameNotAuth

		mov	byte ptr es:[si].SlotPend,'A' ; we ask no more about this #
  NameNotAuth:
		push	bx
		mov	bx,si
		mov	si,di
		inc	si
		call	NamePut			; put real name into nametable
		pop	bx
		SHOW_EVENT	'f'
  NameSkipUpd:
		or	cs:Events,GOT_NSREPLY
		mov	di,offset DefNsNum
		call	ThisIpFirst		; stick to this nameserver
		push	cs
		pop	es
		pop	dx
if DEBUG ge 99
else
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	NameRet
endif ; HOPCHK
endif ; DEBUG
		call	DosPr$

  NameRet:
		ret
DoName		endp



;************************************************************************
;*		TabMarkGw
;************************************************************************

TabMarkGw	proc	near
		SHOW_EVENT	'g'
		assume	ds:code_s
		mov	bx,TblSize
		mov	ds,SegIpHwTbl
		assume	ds:nothing
  TabMarkLoop:
		mov	si,bx
		mov	dx,[si].SlotIp
		mov	ax,[si].SlotIp+2
		mov	cx,cs:DefGwyNum
		mov	si,offset DefGwys
		jcxz	TabGwyDone
  TabGwyLoop:
		cmp	ax,cs:[si].SlotIp+2
		jne	TabGwyNext
		cmp	dx,cs:[si].SlotIp
		jne	TabGwyNext
		mov	byte ptr [bx].SlotDupl,'+'
		jmp	short TabGwyDone
  TabGwyNext:
		add	si,4
		loop	TabGwyLoop
  TabGwyDone:
		sub	bx,16
		jns	TabMarkLoop

		mov	bx,cs:TblSize
  TabDupLoop:
		mov	si,bx
  TabMarkHwLoop:
		sub	si,16
		js	TabDupNext

		mov	ax,[si].SlotHw+4
		cmp	ax,[bx].SlotHw+4
		jne	TabMarkHwLoop
		mov	ax,[si].SlotHw+2
		cmp	ax,[bx].SlotHw+2
		jne	TabMarkHwLoop
		mov	ax,[si].SlotHw
		cmp	ax,[bx].SlotHw
		jne	TabMarkHwLoop

		cmp	byte ptr [si].SlotDupl,'+'
		je	TabMarkHwDup

		mov	byte ptr [si].SlotDupl,'>'
		cmp	byte ptr [bx].SlotDupl,'>'
		je	TabMarkHwDup

		cmp	byte ptr [bx].SlotDupl,'+'
		je	TabMarkHwLoop

		mov	byte ptr [bx].SlotDupl,'='
		jmp	short TabMarkHwLoop

  TabMarkHwDup:
		cmp	byte ptr [bx].SlotDupl,'+'
		je	TabMarkHwLoop

		mov	byte ptr [bx].SlotDupl,'>'
		jmp	short TabMarkHwLoop
  TabDupNext:
		sub	bx,16
		jns	TabDupLoop

		push	cs
		pop	ds
		ret
TabMarkGw	endp


;************************************************************************
;*		TabOpen
;************************************************************************

TabOpen 	proc	near
		assume	ds:code_s
		mov	ax,3d02h
		int	21h
		mov	Handle,ax
		jnc	TabOpenRet
		mov	al,'B'-'0'
		call	Terminate
  TabOpenRet:
		ret
TabOpen 	endp



;************************************************************************
;*		TabPutHw
;************************************************************************

TabPutHw	proc	near
		assume	ds:nothing
		mov	ds,cs:SegIpHwTbl
		lea	si,[bx].SlotHw
		call	PutHwNum

		mov	ds,cs:SegIpHwTbl
		cmp	byte ptr [bx].SlotDupl,'>'
		clc
		jne	TabPutHwRet

		stc

  TabPutHwRet:
		ret
TabPutHw	endp



;************************************************************************
;*		TabPutName
;************************************************************************

TabPutName	proc	near
		assume	ds:nothing
		push	bx
		mov	ds,cs:SegIpHwTbl
		mov	cx,32
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jz	TabPutNam2

		mov	cx,dx			; end of cur line
		sub	cx,di			; current dsp buf ptr
		js	TabPutNamRet2
		inc	cx
		mov	ah,[bx].SlotPend
		cmp	ah,'0'
		jne	TabPutNam3
		mov	al,'-'
		stosb
  TabPutNam3:
		cmp	ah,'N'
		je	TabPutNam2
		cmp	ah,'A'
		je	TabPutNam2
  TabPutNamRet2:
		pop	bx
		ret

  TabPutNam2:
endif ; HOPCHK
		mov	si,[bx].SlotNamPtr
		mov	ds,cs:SegmNamTbl
		mov	si,[si]
		cmp	si,0ffffh		; any name yet?
		jne	TabPutNamGot

		mov	ds,cs:SegIpHwTbl	; use IP nr as name
		mov	si,bx
		push	cx
		push	di
		call	PutIpNum
		pop	dx
		pop	cx
		add	cx,dx
		sub	cx,di
		jmp	short TabPutNamFill

  TabPutNamGot:
		shl	si,1			; compute addr to name
		jnc	TabPut1st
  TabPut2nd:
		mov	ds,cs:SegmNamTbl2
  TabPut1st:
		add	si,48
		jc	TabPut2nd
		sub	si,48

		jcxz	TabPutNamEnd
  TabPutNamL:
		lodsb
		cmp	al,' '
		je	TabPutNamEnd
		stosb				; move name
		loop	TabPutNamL
  TabPutNamEnd:
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	TabPutRet
endif ; HOPCHK
  TabPutNamFill:
		mov	al,' '
		rep	stosb
		mov	ax,'# '
		stosw

		pop	bx
		push	bx
		mov	ds,cs:SegIpHwTbl
		mov	si,bx
		mov	ah,[si].SlotPend
		cmp	ah,'0'
		jne	TabPutKnown
		mov	al,'-'
  TabPutKnown:
		mov	dx,[si].SlotIp
		mov	cx,[si].SlotIp+2
		cmp	dx,[si].SlotIp+16
		jne	TabPutNeN
		cmp	cx,[si].SlotIp+16+2
		jne	TabPutNeN
		mov	al,'='
  TabPutNeN:
		cmp	dx,[si].SlotIp-16
		jne	TabPutNeP
		cmp	cx,[si].SlotIp-16+2
		jne	TabPutNeP
		mov	al,'<'
  TabPutNeP:
		stosw
		mov	al,[bx].SlotDupl
		stosb
  TabPutRet:
		pop	bx
		ret
TabPutName	endp



;************************************************************************
;*		TabPutIp
;************************************************************************

TabPutIp	proc	near
		assume	ds:nothing
		mov	ds,cs:SegIpHwTbl
		mov	si,bx
		call	PutIpNum
		ret
TabPutIp	endp



;************************************************************************
;*		TabWrLine
;************************************************************************

TabWrLine	proc	near
		push	cs
		pop	ds
		assume	ds:code_s
		push	bx
		mov	cx,di
		mov	dx,offset FileBuf
		sub	cx,dx
		mov	bx,Handle
		mov	ah,40h
		int	21h
		jnc	TabWrOK
  TabWrErr:
		mov	al,'W'-'0'
		call	Terminate
  TabWrOK:
		pop	bx
		ret
TabWrLine	endp



;************************************************************************
;*		TabClose
;************************************************************************

TabClose	proc	near
		assume	ds:code_s
		mov	byte ptr FileBuf,'Z'-40h
		mov	dx,offset FileBuf
		mov	cx,1
		mov	bx,Handle
		mov	ah,40h
		int	21h
		jc	TabWrErr

		mov	bx,Handle
		mov	ah,3eh
		int	21h
		jnc	TabHwClOK

		mov	al,'C'-'0'
		call	Terminate
  TabHwClOK:
		ret
TabClose	endp



;************************************************************************
;*		TabWrSeen
;************************************************************************

TabWrSeen	proc	near
		assume	ds:nothing
		mov	ax,[bx].SlotSeen
		push	cs
		pop	ds
		assume	ds:code_s
		mov	PutMinDigits,9
		call	PutNumFb
		mov	PutMinDigits,1
		ret
TabWrSeen	endp



;************************************************************************
;*		TableWr
;************************************************************************

TableWr 	proc	near
		assume	ds:code_s
		test	MoreFlags,HOP_CHK
		jz	TableWrChk
		jmp	HopWrPath
  TableWrChk:
		cmp	TblSize,16
		ja	TableExist
  TableWrRet:
		ret

  TableExist:
		push	bx

		call	TabMarkGw

		mov	dx,offset NameIpTbl
		call	TabOpen
		mov	bx,16
  TabIpNext:
		mov	di,offset FileBuf

		call	TabPutIp
		assume	ds:nothing

		call	BlankUntil16

		call	TabPutName

		push	cs:ArgFlags
		and	cs:ArgFlags, not LANW_TABLE
		call	TabPutHw
		pop	cs:ArgFlags

		call	TabWrSeen

		mov	ax,CR+256*LF
		stosw

		call	TabWrLine
		assume	ds:code_s

		add	bx,16
		cmp	bx,TblSize
		jb	TabIpNext

		call	TabClose

		mov	dx,offset NameHwTbl
		call	TabOpen
		mov	bx,16
  TabHwNext:
		mov	di,offset FileBuf
		call	TabPutHw
		assume	ds:nothing
		pushf

		mov	al,' '
		stosb
		call	TabPutName

		call	TabPutIp

		call	BlankUntil16
		sub	di,10

		call	TabWrSeen

		mov	ax,CR+256*LF
		stosw

		popf

		call	TabWrLine
		assume	ds:code_s
  TabPutHwSkip:
		add	bx,16
		cmp	bx,TblSize
		jb	TabHwNext

		mov	bx,16
		mov	es,SegIpHwTbl
  TabPutRestore:
		mov	es:[bx].SlotDupl,' '
		add	bx,16
		cmp	bx,TblSize
		jb	TabPutRestore
		push	cs
		pop	es

		call	TabClose

		pop	bx

		mov	di,offset MsgTblSize+6
		mov	ax,TblSize
		mov	cl,4
		shr	ax,cl
		dec	ax
		call	PutNumD4Fb
		mov	di,offset MsgTblAct
		mov	ax,TblActive
		call	PutNum
		mov	dx,offset MsgTblSize
		call	DosPr$
		ret
TableWr 	endp

;========================================================================

