{$DEFINE NEWEOL}

Unit ABI_JP;

Interface

Uses DOS, CRT, XSTRING, ABI, ABI_DOM, JP_UNIT;

{$I TCP.INC}


CONST
      MAXLINESIZE = 512;

TYPE
    MsgREC = RECORD                  { status msgs are related to NNTP }
              Pro:Char;     { Progress  1 = Information Message
                                           2 = Command OK
                                           3 = Command OK So far, send rest
                                           4 = Command correct, but undoable
                                           5 = Command unimplemented/incorrect
                                               or program error occurred}
              Cat:Char;     { Catagory  0 = Connection/Setup/Misc
                                           1 = Newsgroup Selection
                                           2 = Article Selection
                                           3 = Distribution Functions
                                           4 = Posting
                                           8 = Nonstandard (private extensions)
                                           9 = Debugging output}
              Ext:Char;     { used for multiple message types of above }
              Res:Word;
             END;
    CurLineBUFREC = RECORD
              Length : Integer;
              ReadCRLF : Boolean;
              Buffer : Array[1..512] of Char;
             END;
    CurLineREC    = RECORD
              Length : Integer;
              First  : String[255];  {255x2=510}
              Second : String[255];
              Third  : String[2];    {would probably be CRLF if 512 packet max}
             END;

var
    Msg : MsgREC;
    CurLineBUF : CurLineBUFREC;
    CurLine    : CurLineREC;
    InvalidChar : String[10];

Function ShowBuffer(var Buffer:BufferREC; Opts:Byte): String;
{ Options are AND1=display to screen, AND2=get ### response (Msg.Res) }
{             AND4=strip InvalidChar.                                 }

Function ReadlnBuff(var S:tcpSessionREC;  var Buffer:BufferREC):Boolean;
Function WritelnBuff(var S:tcpSessionREC):Boolean;
Function Inbuff (Objct : Char;  Target : BufferREC;  StartPos : Word):Word;
Function CopyBuff(Buffer:BufferREC;  StartPos:Word;  CopyLength:Word):String;
Procedure DeleteBuffer(var Buffer:BufferREC; DelStart, DelLength:Word);

Procedure tcp_readln(var S:tcpSessionREC; var tCL:CurLineREC; timeout:Word);
Function tcp_IsConnected(var S:tcpSessionREC):Boolean;

Procedure CLBtoCL(var CLB:CurLineBUFREC; var CL:CurLineREC);

Procedure TelnetSend(var S:tcpSessionREC; ToSend:String);
Function TelnetRecv(var S:tcpSessionREC):String;
Function ip_lookup(tStr:String; var tIP:IPAddr):Boolean;
Function BPARSENFN (cb : BufferREC) : Integer;
Function BPARSERFN( cb:BufferREC; PartNumber : Word) : String;
Function BPARSERREST (cb :BufferREC;  PartNumber:Word) : string;

(****************************** Implementation ******************************)
implementation

var
  TmpStr:String;
  Result:Word;
  LineValid:Boolean;

Function BPARSENFN (CB : BufferREC) : Integer;
var i, n, p : Integer;
begin
  p := CB.length;
  n := 0;
  i := 1;
  repeat
    while (cb.Buffer[i] = #32) and (i <= p) do Inc(i);
    if i > p then begin Bparsenfn := n; exit; end;
    while (cb.Buffer[i] <>#32) and (i <= p) do Inc(i);
    Inc(n);
    if i>p then begin Bparsenfn := n; exit; end;
  until false;
end;

Function BPARSERFN( cb:BufferREC; PartNumber : Word) : String;
var i, j, n, p :Integer;
    stash : String;
Begin
  if (PartNumber < 1) or (PartNumber > BPARSENFN(cb)) then
       begin BPARSERFN := ''; exit; end;
  p := CB.Length;
  n := 0;
  i := 1;
  repeat
     while (cb.Buffer[I] = #32) and (i <= p) do Inc(i);
     Inc(n);
     If n = PartNumber then
       begin
          j:=0;
          while (cb.Buffer[i] <> #32) and (i<=p) do
            Begin
               Inc(j);
               stash[0] := chr(j);
               stash[j] := cb.Buffer[i];
               Inc(i);
            End;
         BPARSERFN := Stash;
         exit;
       end
     else
       while (cb.Buffer[i] <> #32) and (i <= p) do Inc(i);
  until false;
end;

Function BPARSERREST (cb :BufferREC;  PartNumber:Word) : string;
var  TmpStr:String;
     I,J : Integer;
begin
  TmpStr:='';
  J:=BPARSENFN(cb);
  For I:=PartNumber to J do
     begin
       TmpStr:=TmpStr+BPARSERFN(cb, I);
       If I<>J then TmpStr:=TmpStr+' ';
     end;
  If Copy(TmpStr,1,1)=':' then Delete(TmpStr,1,1);
  BPARSERREST:=TmpStr;
end;


Function WritelnBuff(var S:tcpSessionREC):Boolean;
var W:Word;
    Online:Boolean;
Begin
  WritelnBuff:=False;
  Online:=tcp_IsConnected(S);
  If (not Online) or (S.Buffer.Length=0) then
      begin
        S.Buffer.Length:=0;
        WritelnBuff:=True;
        exit;
      end;
  W:=S.Buffer.Length;

  Result:= tcp_Put(S, 1+2 {+4}, 0);

  If W<>S.Buffer.Length then Writeln('Found Error Type One in WritelnBuffer!');

  If (S.BytesTransd<>W) and (S.BytesTransd<>0) then
    begin
      If S.BytesTransd <= W then
           begin
             DeleteBuffer(S.Buffer, 1, S.BytesTransd);
           end;
    end;

  If S.Buffer.Length=0 then WritelnBuff:=True;
End;



Function ReadlnBuff(var S:tcpSessionREC;  var Buffer:BufferREC):Boolean;
var W:Word;
    Online:Boolean;
Begin
  Online:=tcp_IsConnected(S);
  If not Online then exit;
  If S.DAT.ReadCRLF then
    begin
      Buffer.Length:=0;
    end;
  S.Buffer.Length:=0;

{$IFDEF NEWEOL}
   If Online then Result:=tcp_get(S, 3, 0);
{$ELSE}
   If Online then Result:=tcp_get(S, 3, 0);
{$ENDIF}
  LineValid:=False;
  If (S.Buffer.Length=0)  then
        begin
          S.DAT.ReadCRLF:=False;
          ReadlnBuff:=LineValid;
          exit;
        end;
  if (S.Buffer.Length+Buffer.Length+1 > SizeOf(Buffer.Buffer)) then
        begin
         Writeln('BUFFER OVERFLOW in ReadlnBuffer!');
          ReadlnBuff:=LineValid;
         exit;
        end;

  Move(S.Buffer.Buffer, Buffer.Buffer[Buffer.Length +1 ], S.Buffer.Length);
  Buffer.Length:=Buffer.Length + S.Buffer.Length;

  If (S.DAT.ReadCRLF) then
    Begin
       LineValid:=True;
       S.Buffer.Length:=0;
    End;
  ReadlnBuff:=LineValid;
End;

Function Inbuff (Objct : Char;  Target : BufferREC;  StartPos : Word):Word;
var W:Word;
Begin
 Inbuff:=0;
 For W:= StartPos to Target.Length do
   begin
     If Target.Buffer[W]=Objct then
            begin
              Inbuff:=W;
              break;
            end;
   end;
End;

Function CopyBuff(Buffer:BufferREC;  StartPos:Word;  CopyLength:Word):String;
var W:Word;
    tStr:String;
Begin
  CopyBuff:='';
  If (StartPos=0) or (CopyLength=0) or (CopyLength > 255) then exit;
  If (StartPos + CopyLength > Buffer.Length) or (Buffer.Length > SizeOf(Buffer.Buffer)) then exit;
  Move(Buffer.Buffer[StartPos], tStr[1], CopyLength);
  tStr[0]:=Chr( CopyLength );
  CopyBuff:=tStr;
End;

Procedure DeleteBuffer(var Buffer:BufferREC; DelStart, DelLength:Word);
var TmpBuffer:BufferREC;
Begin
  If (DelStart+DelLength>Buffer.Length) or (DelStart=0) then exit;

  If Buffer.Length>SizeOf(Buffer.Buffer) then
      begin
        Buffer.Length:=SizeOf(Buffer.Buffer)-1;
      end;
  TmpBuffer.Length:=DelStart-1;
  While TmpBuffer.Length < Buffer.Length-DelLength  do
    begin
      Inc(TmpBuffer.Length);
      TmpBuffer.Buffer[TmpBuffer.Length] := Buffer.Buffer[TmpBuffer.Length+DelLength];
    end;
  Move(TmpBuffer, Buffer, SizeOf(Buffer));

End;


Function ip_lookup(tStr:String; var tIP:IPAddr):Boolean;
var TmpLong : LongInt;
    TmpB    : Boolean;
    Result  : Word;
Begin
  ip_lookup:=false;
  aton(tStr,tIP);
  TmpLong:=0;
{  Move(TmpLong, tIP, 4); }
  Move(tIP,TmpLong,4);
  If TmpLong=0 then
     begin
 {      If Verbose then Writeln('Resolving ',tStr); }
       TmpB:=Verbose;
       Verbose:=False;
       Result:=resolve(tStr, tIP, 0);
       Verbose:=TmpB;
       TmpLong:=0;
       Move(tIP,TmpLong,4);
       If Result=0 then
         begin
            Writeln('DNS lookup Failure: ',tStr);
            exit;
         end;
     end;
  If TmpLong=0 then
    Begin
      Writeln;
      Writeln('Invalid Address was specified: '+#34,tStr,#34);
      Move(TmpLong,tIP,4);
      exit;
    End;
  ip_lookup:=True;
End;

Function tcp_IsConnected(var S:tcpSessionREC):Boolean;
var W:Word;
BEGIN
  If not S.Openned then
    begin
      tcp_IsConnected:=False;
      exit;
    end;
  W:=tcp_State(S);
  tcp_IsConnected:=False;
  If (W>3) and (W<7) then tcp_IsConnected:=True;
  If (S.Status.BytesReady>0) { or (S.Status.BytesGoing>0) } then tcp_IsConnected:=True;
END;

{     TelnetSend - Processes IAC escapes for sending $FF, etc                }
Procedure TelnetSend(var S:tcpSessionREC; ToSend:String);
var W:Word;
    I:Integer;
begin
  S.Buffer.Length:=0;
  W:=1;
  For I:=1 to Length(ToSend) do
    begin
     Case ToSend[I] of
       #$FF : Begin
                S.Buffer.Buffer[W]:=#$FF;
                S.Buffer.Buffer[W+1]:=#$FF;
                Inc(W,2);
              End;
        else  begin
                S.Buffer.Buffer[W]:=ToSend[I];
                Inc(W);
              end;
     End;
    end;
    tcp_Put(S, 4, $0000);   {Maybe use 0 or something}

end;

{     TelnetRecv - Processes IAC escapes when Receiving data                 }
Function TelnetRecv(var S:tcpSessionREC):String;
var
  tRegs: Registers;
begin
  tRegs.AX:=$1201;  tRegs.BX:=S.Handle;  tRegs.CX:=255;   tRegs.DX:=0;
  tRegs.ES:=Seg(S.Buffer.Buffer);
  tRegs.DI:=Ofs(S.Buffer.Buffer);
  TcpDrvCALL(tRegs);   S.Result:=tRegs.DL;
  ShowTcpError('TelnetRecv');
  S.BytesTransd:=tRegs.AX;   S.Buffer.Length:=tRegs.AX;
  If (tRegs.DH AND 2)=2 then S.DAT.ReadCRLF:=true
                        else S.DAT.ReadCRLF:=false;
  If (tRegs.DH AND 8)=8 then S.DAT.Urgent:=true
                        else S.DAT.Urgent:=false;
  TmpStr:='';
  If tRegs.AX>0 then Move(S.Buffer.Buffer[1], TmpStr[1], tRegs.AX);
  Move(tRegs.AL, TmpStr[0], 1);
  TelnetRecv:=TmpStr;              {*CONSTRUCTION*}
end;


Procedure CLBtoCL(var CLB:CurLineBUFREC; var CL:CurLineREC);
 var
  tL:Integer;
 begin
  CL.Length:=-1;
  If CLB.ReadCRLF then CL.Length:=CLB.Length;
  CL.First:=''; CL.Second:=''; CL.Third:='';
  If CLB.Length<256 then
    begin
       Move(CLB.Buffer[1], CL.First, CLB.Length);
       CL.First[0]:=Chr(CLB.Length);
       exit;
    end;
  If (CLB.Length>255) and (CLB.Length<511) then
    begin
       Move(CLB.Buffer[1], CL.First, 255);
       CL.First[0]:=#255;
       Move(CLB.Buffer[256], CL.Second, CLB.Length-255);
       CL.Second[0]:=CHR(CLB.Length-255);
       exit;
    end;
  If (CLB.Length>510) and (CLB.Length<512) then
    begin
       Move(CLB.Buffer[1], CL.First, 255);
       CL.First[0]:=#255;
       Move(CLB.Buffer[256], CL.Second, 255);
       CL.Second[0]:=#255;
       Move(CLB.Buffer[511], CL.Third, 2);  {..2=512}
       CL.Third[0]:=Chr(CLB.Length-510);
       exit;
    end;
  CL.Length:=-1; Writeln('CLBtoCL error');
 end;

Function ShowBuffer(var Buffer:BufferREC; Opts:Byte): String;
 var
  Index:Word;
  TmpRes:String;
  Result:Integer;
  TmpLength:Word;
  TmpBuffer:BufferREC;
 begin
   TmpRes:='';

   If ((Opts AND 4)=4) and (Buffer.Length>0) then
     begin
       TmpLength:=Buffer.Length;
       TmpBuffer.Length:=0;
       For Index:=1 to TmpLength do
         begin
           If (Pos(Buffer.Buffer[Index], InvalidChar)=0)  and
              (TmpBuffer.Length < 513) then
               Begin
                Inc(TmpBuffer.Length);
                TmpBuffer.Buffer[TmpBuffer.Length] := Buffer.Buffer[Index];
               End;
         end;
       {If TmpBuffer.length>0 then Inc(TmpBuffer.Length);}
       Move(TmpBuffer, Buffer, SizeOf(Buffer));
     end;

   If (Opts AND 1)=1 then For Index:=1 to Buffer.Length do
                                Write(Buffer.Buffer[Index]);
   If Buffer.Length<256 then Index:=Buffer.Length   else  Index:=255;
   Move(Buffer.Buffer, TmpRes[1], Index);
   TmpRes[0]:=CHR(Lo(Index));
   If (Opts AND 2)=2 then
     begin
       Val(Copy(TmpRes,1,3), Msg.Res, Result);
       If Result<>0 then Msg.Res:=0;
       Move(Buffer.Buffer, Msg.Pro, 3);
     end;
   InvalidChar:=#0+#13+#10;
   ShowBuffer:=TmpRes;
 end;

Function tcp_input(var S:tcpSessionREC; MaxLength:Integer):String;
 var                                        {no timeout}
  ISUB:tcpSessionREC;
  CLen:Integer;
  TmpRes:String;
 begin
   Move(S,ISUB,SizeOf(ISUB));
   tcp_input:='';
   If MaxLength>255 then exit;
   Regs.AH:=$12; Regs.AL:=1;
   Regs.BX:=ISUB.Handle; Regs.CX:=MaxLength;
   Regs.ES:=Seg(ISUB.Buffer);
   Regs.DI:=Ofs(ISUB.Buffer);
   Regs.DX:=$0000;
   TcpDrvCALL(Regs);
   ISUB.Result:=Regs.DL;
   S.Result:=Regs.DL;
    ShowTcpError('Tcp_input');
    {ax = no. bytes transferred}
    ISUB.BytesTransd:=Regs.AX;
    ISUB.Buffer.Length:=Regs.AX;
    {dh = returned flags:  2 = <cr><lf> read in option 2,  8 = urgent data present}
    If (Regs.DH AND 2)=2 then ISUB.DAT.ReadCRLF:=true
                          else ISUB.DAT.ReadCRLF:=false;
    If (Regs.DH AND 8)=8 then ISUB.DAT.Urgent:=true
                          else ISUB.DAT.Urgent:=false;
   Move(ISUB.Buffer,TmpRes[1], Regs.AL);
   TmpRes[0]:=Chr(Regs.AL);
   tcp_input:=TmpRes;
 end;


Procedure tcp_readln(var S:tcpSessionREC; var tCL:CurLineREC; timeout:Word);
 var
  TmpChr:String;
  LastChar:Char;
  tCLB:CurLineBUFREC;
  tTO:Boolean; {timeout flag}
 begin
   tCLB.Length:=0;   tCLB.ReadCRLF:=False;
   Repeat
     TmpChr:=tcp_input(S, 1);
     If Length(TmpChr)=1 then
      begin
       Write(TmpChr);          {*******}
       Inc(tCLB.Length);
       tCLB.Buffer[tCLB.Length]:=TmpChr[1];
      end;
     If TmpChr=#10 then tCLB.ReadCRLF:=True;
     If IsScrLock then tTO:=True;
   Until (tCLB.Length=512) or tCLB.ReadCRLF or tTO;
   Move(tCLB,CurLineBuf,SizeOf(CurLineBuf));
   CLBtoCL(tCLB, tCL);
 end;

BEGIN
   InvalidChar:=#0+#13+#10;

END.


