TANDY DESKMATE .SND FORMAT NOTES (old .snd file format)

Tandy .snd files are created by Sound.pdm, a program that came with the 
proprietary DeskMate environment.  They are used by Music.pdm to create 
music modules (.sng files).  DeskMate Sound and Music require the Tandy 
sound chip.

Tandy used two incompatible .snd file formats.  The first format, described 
in this file, was used by the 1988 and 1989 versions of DeskMate Sound and 
Music - the version bundled with the 1000SL and 1000TL.  The second format, 
described in file Newsnd.for, was used by the 1990 versions of these 
programs - the version bundled with the 2500-series.  The 1990 version of 
Sound.pdm can read but not write the old file format and can be used to 
convert to the new format; the 1988 version of Sound.pdm does not 
understand the new format.

There are two types of DeskMate .snd files, "sound" files and "instrument" 
files.  Both contain 8-bit unsigned PCM samples.

Sound files are garden-variety sample files with a fixed-length header 
giving the name of the sound, the recording frequency, and the length of 
the sound.  Sound files may be recorded at 5500Hz, 11kHz or 22kHz.

Instrument files contain samples as well as frequency and looping 
information used by Music.pdm to represent an instrument.  Instrument files 
provide for attack, sustain, and decay (I'm not sure whether the decay 
section is ever actually played) with several samples having different 
implied frequencies and being used by Music.pdm to represent the instrument 
in different pitch ranges.  Up to 16 different notes (with 16 different 
samples) can be contained in one instrument file.  Instrument files are 
always recorded at 11kHz.

Frank Durda notes that if the sound was recorded on a Tandy 1000SL or 
1000TL, the actual sampling rate will be slightly different from the rate 
specified in the file.  The adjustment required does not appear to be a 
simple function, though.  The old format does not describe the recording 
hardware anyway.

Both sound files and instrument files may be compressed in one of two ways, 
"music" compression or "speech" compression, or they may be uncompressed.  
Music compression uses a combination of run length encoding and non- 
adaptive differential PCM.  Speech compression adds a silence suppression 
step before the run length encoding.  Both compression types are lossy, 
speech compression more so.  The Tandy Digital Sound Toolkit, now in the 
public domain in binary form, can be used for decompression.  Frank Durda's 
PSSJ Digital Sound Toolkit also contains decompression code.  It is 
available in both source and binary forms but is restricted to 
noncommercial use.  Sound.pdm can also be used to decompress an .snd file.

There is a program to convert RIFF WAVE and other 8-bit PCM formats to 
.snd, Conv2snd, by Kenneth Udut.  Conv2snd v2.01 comes with Snd2wav, which 
converts .snd to .wav.  Conv2snd converts to the old format; Snd2wav 
understands both formats.  John Ball has written three programs, Playsnd, 
Sbplay, and Ab, which can play Tandy .snd files.  Playsnd plays on either 
the Tandy DAC or the PC speaker.  Sbplay plays on the SoundBlaster, PC 
speaker, or any of 20 or so other soundcards using John W. Ratcliffe's 
Digpak driver set.  Playsnd and Sbplay are interactive, menu-oriented 
programs.  Ab is a command-line player for the SoundBlaster, SB Pro, and SB 
16.  Finally, I have written a sound player, Dmsound, that plays on the 
speaker, SoundBlaster, SB Pro, SB 16, and Tandy DAC; it, too, is 
interactive.  Dmsound can convert .snd to and from .wav (it also writes the 
old format).  All of the players play both new and old formats.  Dmsound 
can play or convert compressed .snd files; the others can only deal with 
uncompressed files.

Some of the above are at my ftp/WWW site:

    ftp://ftp.agate.net/users/01935/
    http://www.agate.net/~tvdog/

Email me for the PDST; Frank Durda doesn't want it on the site.  My email 
address is tvdog@agate.net.

The old DeskMate .snd file header consists of 16 bytes of fixed header 
information followed by one or more 28-byte note records.  The sample 
information, which may be compressed, follows the header.

DeskMate .snd File Format - Fixed Header
----------------------------------------

  offset    size      what
  ------    ----      ----

  0         byte      1Ah (<control>-Z, prevents DOS TYPE from trying to
                      put the file on the screen).

  1         byte      Compression code:  0 = no compression; 1 = music
                      compression; 2 = speech compression.

  2         byte      Number of notes in the instrument file.  1 if sound
                      file.  There can be a maximum of 16 notes in an
                      instrument file.  Note:  when an instrument file is
                      created, it automatically has one unset note placed
                      in it.

  3         byte      Instrument number.  0 if sound file; 0FFh if instrument
                      file with no number set.  Valid instrument numbers in
                      an instrument file are 1 to 32.  Use this field to
                      distinguish a sound file from an instrument file.

  4         10 bytes  Sound or instrument name.  The name is null-terminated,
                      so the name may be at most 9 characters long.

  0Eh       word      Sampling rate in samples per second.  Note that although
                      a sampling rate other than 5500, 11000 and 22000 can be
                      entered here, Sound.pdm will not actually play at other
                      rates.

  10h       variable  Note records begin, 28 bytes each.  Number of records
                      given in byte 2 above.


DeskMate .snd File Format - Note Record
---------------------------------------

  0         byte      Pitch of the note:  1 = A1 in American Standard Pitch;
                      2 = A#1; etc.  A1 is lowest note allowed; highest note
                      allowed is B6 (3Fh).  Sound files have 0FFh here; so do
                      instrument files with no note set.
                          Note that Sound.pdm does not designate notes in the
                      standard manner to the user.  Although A1 and B6 in
                      Sound.pdm are the same as A1 and B6 in standard pitch,
                      Sound.pdm starts octaves at A rather than at C (as is
                      standard).  Thus, middle C, C4 in standard pitch, is C3
                      in Sound.pdm.

  1         byte      Sound files, and instrument files with no pitch set,
                      have 0 here.  If the pitch is set, this byte is 0FFh.

  2         2 bytes   Range of the note, first byte is lower limit, second
                      is higher limit.  Byte encoding as for offset 0 (i.e.,
                      01h to 3Fh).  Sound files have FF FF here; so do
                      instrument files with no range set.

  4         dword     Offset in the file where samples for this note begin
                      (zero-relative), after compression if that was done.

  8         dword     If compressed, the length of the compressed data in the
                      file for this note.  Uncompressed files have 0 here.

  0Ch       dword     Set to zero.

  10h       dword     Number of samples in the note, after decompression if
                      necessary.

  14h       dword     Number of sample at start of sustain region for the
                      note, relative to the first (zeroth) sample of the note.
                      For sound files, or if sustain is not set, this field is
                      0.

  18h       dword     Number of sample at end of sustain region for the note,
                      relative to the first (zeroth) sample of the note.  For
                      sound files, or if sustain is not set, this field is 0.
