; COMPAT.ASM
;
; This is a little program that turns the compatibility mode flag on and
; off in the expanded memory manager EMS41.BIN.  "COMPAT ON" turns
; compatibility mode on, "COMPAT OFF" turns compatibility mode off.
; "COMPAT" with no arguments displays the flag status without changing
; it.
;

	JMP	START

;
; Data.
;
; On and off strings, for comparison.
;
ONSTRING	DB	"ON"
OFFSTRING	DB	"OFF"
		;
		; Name of device, for Open File or Device function.
		;
DEVICENAME	DB	"EMMXXXX0",0
		;
		; Error message, no EMM found.
		;
NOEMMMSG	DB	"Expanded memory manager not found.",0Dh,0Ah,"$"
		;
		; File handle for EMMXXXX0 device.
		;
FILEHANDLE	DW	0
		;
		; Buffer for data read from the device.
		;
DATABUF		EQU	$
DRIVERSEG	DW	0
COMPATOFFS	DW	0
		DW	2 DUP (0)
BWWORD		DW	0
		;
		; Error message, read failed on device.
		;
READFAILMSG	DB	"Read failed on EMMXXXX0 device.",0Dh,0Ah,"$"
		;
		; Error message, wrong EMM version.
		;
WRONGVERMSG	DB	"Expanded memory manager version not 4.1.",0Dh,0Ah,"$"
		;
		; Error message, EMM status indicates failure.
		;
EMMFAILMSG	DB	"Expanded memory manager not working.",0Dh,0Ah,"$" 
		;
		; Strings to display what happened.
		;
COMPATONMSG	DB	"Compatibility mode on.",0Dh,0Ah,"$"
COMPATOFFMSG	DB	"Compatibility mode off.",0Dh,0Ah,"$"
		;
		; For display function, to tell the user how to set the flag.
		;
USAGEMSG	DB	"Use COMPAT ON or COMPAT OFF to change the flag."
		DB	0Dh,0Ah,"$"

;
; Code.
;
; Subroutine, takes a pointer to a string in ES:DI, skips over blanks,
; and sets DI to point to the first nonblank character in the string.
; Sets carry if a carriage return is encountered.
;
SKIPBLANKS:
	PUSH	AX
	PUSH	CX
	CLD
	MOV	AL,' '
	MOV	CX,80
	REPE	SCASB
	JE	SKIPBLANKS_EOL
	DEC	DI
	CMP	BYTE PTR ES:[DI],0Dh
	JE	SKIPBLANKS_EOL
	;
	; Nonblank character found.
	;
	CLC
	JMP	SKIPBLANKS_END
	;
	; End of line, or 80 blanks read.
	;
SKIPBLANKS_EOL:
	STC
SKIPBLANKS_END:
	POP	CX
	POP	AX
	RET
;
; Subroutine, takes a pointer to a string in ES:DI.  Returns 0 in AL if
; the string is "OFF".  Returns 1 in AL if the string is "ON".  Returns
; 0FFh in AL otherwise.
;
GETOFFON:
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	CLD
	MOV	BX,DI		; save pointer to string
	;
	; Convert the first 3 characters of the input string to uppercase.
	;
	MOV	CX,3
GETOFFON_UPCASELP:
	AND	BYTE PTR ES:[DI],0DFh
	INC	DI
	LOOP	GETOFFON_UPCASELP
	;
	; Check if the input string is "OFF".
	;
	MOV	SI,OFFSET OFFSTRING
	MOV	DI,BX
	MOV	CX,3
	REPE	CMPSB
	JE	GETOFFON_OFF
	;
	; Check if the input string is "ON".
	;
	MOV	SI,OFFSET ONSTRING
	MOV	DI,BX
	MOV	CX,2
	REPE	CMPSB
	JE	GETOFFON_ON
	;
	; Input string is neither "OFF" nor "ON".
	;
	MOV	AL,0FFh
	JMP	GETOFFON_END
	;
	; Input string is "OFF".
	;
GETOFFON_OFF:
	MOV	AL,0
	JMP	GETOFFON_END
	;
	; Input string is "ON".
	;
GETOFFON_ON:
	MOV	AL,1
GETOFFON_END:
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	RET
;
; Main program.
;
; Open the EMMXXXX0 device.
;
START:
	MOV	AX,3D02h		; open the device
	MOV	DX,OFFSET DEVICENAME
	INT	21h	
	IF C 	JMP NOEMM
	MOV	FILEHANDLE,AX
	;
	; Verify that this is a character device and not a file.
	;
	MOV	BX,FILEHANDLE
	MOV	AX,4400h
	INT	21h
	TEST	DL,80h
	IF Z	JMP NOEMM2
	;
	; Check that the EMM is working and is version 4.1.
	;
	MOV	AH,40h
	INT	67h
	OR	AH,AH
	IF NZ	JMP EMMFAIL
	MOV	AH,46h
	INT	67h
	CMP	AL,41h
	IF NE	JMP WRONGVER
	;
	; Read from the device to get pointer to compatibility flag.
	;
	MOV	BX,FILEHANDLE		; write to device to reset read pointer
	MOV	CX,1
	MOV	AH,40h
	INT	21h
	IF C	JMP READFAIL
	MOV	CX,10			; read 10 bytes from the device
	MOV	AH,3Fh
	MOV	DX,DATABUF
	INT	21h
	IF C	JMP READFAIL
	CMP	AX,10
	IF NE	JMP READFAIL
	CMP	BWWORD,5742h
	IF NE	JMP READFAIL
	DEC	COMPATOFFS
	;
	; Check the command line.
	;
	MOV	DI,81h
	CALL	SKIPBLANKS
	JC	DISPLAYFLAG
	CALL	GETOFFON
	CMP	AL,0FFh
	JE	DISPLAYFLAG
	CMP	AL,1
	JE	COMPATON
	;
	; Turn compatibility mode off.
	;
	MOV	ES,DRIVERSEG
	MOV	DI,COMPATOFFS
	MOV	BYTE PTR ES:[DI],0
	MOV	DX,OFFSET COMPATOFFMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Turn compatibility mode on.
	;
COMPATON:
	MOV	ES,DRIVERSEG
	MOV	DI,COMPATOFFS
	MOV	BYTE PTR ES:[DI],0FFh
	MOV	DX,OFFSET COMPATONMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Display the flag setting.
	;
DISPLAYFLAG:
	MOV	ES,DRIVERSEG
	MOV	DI,COMPATOFFS
	MOV	AL,ES:[DI]
	OR	AL,AL
	JNZ	DISPLAY_COMPATON
	MOV	DX,OFFSET COMPATOFFMSG
	JMP	DISPLAY_SHOWSTATUS
DISPLAY_COMPATON:
	MOV	DX,OFFSET COMPATONMSG
DISPLAY_SHOWSTATUS:
	MOV	AH,9
	INT	21h
	MOV	DX,OFFSET USAGEMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Error:  expanded memory manager not found.
	;
NOEMM:
	MOV	DX,OFFSET NOEMMMSG
	MOV	AH,9
	INT	21h
	JMP	EXIT
	;
	; Error:  EMMXXXX0 is a file and not a device.
	;
NOEMM2:
	MOV	DX,OFFSET NOEMMMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Error:  EMM not working.
	;
EMMFAIL:
	MOV	DX,OFFSET EMMFAILMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Error:  wrong EMM version.
	;
WRONGVER:
	MOV	DX,OFFSET WRONGVERMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Error:  failed to read data from device.
	;
READFAIL:
	MOV	DX,OFFSET READFAILMSG
	MOV	AH,9
	INT	21h
	JMP	CLOSEDEVICE
	;
	; Close the device handle.
	;
CLOSEDEVICE:
	MOV	AH,3Eh
	MOV	BX,FILEHANDLE
	INT	21h
	;
	; Exit.
	;
EXIT:
	MOV	AX,4C00h
	INT	21h
