; GETCLOCK.ASM
;
; This program reads the timer channel 0 count repeatedly, attempting to
; determine what it is.
;

		ORG	100h
		JMP	START
;
; Data.
;
DISPLAY		DB	"Timer channel 0 count is "
COUNTSTR	DB	4 DUP (' ')
		DB	"h.",0Dh,0Ah,"$"
MAXCOUNT	DW	0

;
; Code. CS=DS=SS=ES.
;
START:
	MOV	CX,10
OUTERLOOP:
	PUSH	CX
	XOR	CX,CX
MAINLOOP:
	MOV	AL,0
	OUT	43h,AL
	JMP	$+2
	IN	AL,40h
	JMP	$+2
	MOV	AH,AL
	IN	AL,40h
	XCHG	AL,AH
	CMP	AX,MAXCOUNT
	JBE	CONTINUE
	MOV	MAXCOUNT,AX
CONTINUE:
	LOOP	MAINLOOP
	POP	CX
	LOOP	OUTERLOOP
	MOV	AX,MAXCOUNT
	CALL	CONVERT
	LEA	DX,DISPLAY
	MOV	AH,9
	INT	21h
	MOV	AX,4C00h
	INT	21h

;
; Convert value in AX to hexadecimal and save in COUNTSTR.
;
CONVERT:
	LEA	DI,COUNTSTR
	CLD
	MOV	BX,AX
	MOV	AL,BH
	MOV	CL,4
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BH
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	SHR	AL,CL
	CALL	HEXCHAR
	STOSB
	MOV	AL,BL
	AND	AL,0Fh
	CALL	HEXCHAR
	STOSB
	RET

;
; On entry, AL=value 0-15.  On exit, AL=hex character.
;
HEXCHAR:
	CMP	AL,10
	JAE	HEXCHAR_LTR
	ADD	AL,30h
	JMP	HEXCHAR_END
HEXCHAR_LTR:
	ADD	AL,41h-10
HEXCHAR_END:
	RET
